/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsAvailability;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="configure-jms-cluster")
@Scoped(value=PerLookup.class)
@I18n(value="configure.jms.cluster")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
public class ConfigureJMSCluster
implements AdminCommand {
    private static final String SUPPORTED_DB_VENDORS = "oracle|postgressql|mysql|derby|db2";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigureJMSCluster.class);
    private static final String MASTER_BROKER = "masterbroker";
    private static final String SHARED_DB = "shareddb";
    private static final String FILE = "file";
    private static final String JDBC = "jdbc";
    private static final String CONVENTIONAL = "conventional";
    private static final String ENHANCED = "enhanced";
    private static final String LOCAL = "local";
    private static final String REMOTE = "remote";
    private static final String EMBEDDED = "embedded";
    private static final String PASSWORD_KEY = "AS_ADMIN_JMSDBPASSWORD";
    @Param(name="configstoretype", optional=true, alias="cs")
    String configStoreType;
    @Param(name="messagestoretype", optional=true, alias="ms")
    String messageStoreType;
    @Param(name="clustertype", alias="ct", optional=false)
    String clusterType;
    @Param(name="dbvendor", alias="db", optional=true)
    String dbvendor;
    @Param(name="dbuser", alias="user", optional=true)
    String dbuser;
    @Param(name="jmsDbPassword", optional=true, password=true)
    String jmsDbPassword;
    @Param(name="dburl", alias="url", optional=true)
    String dburl;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(primary=true)
    String clusterName;
    @Inject
    Domain domain;
    Config config;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        if (cluster == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.invalidClusterName", "No Cluster by this name has been configured"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List instances = cluster.getInstances();
        Config config = this.domain.getConfigNamed(cluster.getConfigRef());
        JmsService jmsService = config.getJmsService();
        if (jmsService == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.nojmsservice", "No JMS Service element in config"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!CONVENTIONAL.equalsIgnoreCase(this.clusterType) && !ENHANCED.equalsIgnoreCase(this.clusterType)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongClusterType", "Invalid option sepecified for clustertype. Valid options are conventional and enhanced"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (CONVENTIONAL.equalsIgnoreCase(this.clusterType) && !MASTER_BROKER.equalsIgnoreCase(this.configStoreType) && !SHARED_DB.equalsIgnoreCase(this.configStoreType)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongConfigStoreType", "Invalid option sepecified for configstoretype. Valid options are masterbroker and shareddb"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (ENHANCED.equalsIgnoreCase(this.clusterType) && this.configStoreType != null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongStoreType", "configstoretype option is not configurable for Enhanced clusters."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (CONVENTIONAL.equalsIgnoreCase(this.clusterType) && !MASTER_BROKER.equalsIgnoreCase(this.configStoreType) && !FILE.equalsIgnoreCase(this.messageStoreType) && !JDBC.equalsIgnoreCase(this.messageStoreType)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongMessageStoreType", "Invalid option sepecified for messagestoretype. Valid options are file and jdbc"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (ENHANCED.equalsIgnoreCase(this.clusterType) && this.messageStoreType != null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongmsgStoreType", "messagestoretype option is not configurable for Enhanced clusters."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String integrationMode = jmsService.getType();
        if (REMOTE.equalsIgnoreCase(integrationMode)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.remoteMode", "JMS integration mode should be either EMBEDDED or LOCAL to run this command. Please use the asadmin.set command to change the integration mode"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (EMBEDDED.equalsIgnoreCase(integrationMode) && ENHANCED.equalsIgnoreCase(this.clusterType)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.noEmbeddedModeForEnhancedClusters", "EMBEDDED JMS integration mode is not supported for Enhanced clusters. Please use the asadmin.set command to change the JMS integration mode"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (MASTER_BROKER.equalsIgnoreCase(this.configStoreType) && FILE.equals(this.messageStoreType) && (this.dbvendor != null || this.dburl != null || this.dbuser != null)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.invalidDboptions", "Database options should not be specified for this configuration"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!MASTER_BROKER.equalsIgnoreCase(this.configStoreType) || ENHANCED.equalsIgnoreCase(this.clusterType) || JDBC.equalsIgnoreCase(this.messageStoreType)) {
            if (this.dbvendor == null) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.nodbvendor", "No DataBase vendor specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.dburl == null) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.nojdbcurl", "No JDBC URL specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!this.isSupportedDbVendor()) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.invaliddbvendor", "Invalid DB Vednor specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (CONVENTIONAL.equalsIgnoreCase(this.clusterType) && this.configStoreType == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.noConfigStoreType", "No configstoretype specified. Using the default value - masterbroker"));
            this.configStoreType = MASTER_BROKER;
        }
        if (CONVENTIONAL.equalsIgnoreCase(this.clusterType) && this.messageStoreType == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.noMessagetoreType", "No messagestoretype specified. Using the default value - file"));
            this.messageStoreType = FILE;
        }
        config = this.domain.getConfigNamed(cluster.getConfigRef());
        JmsAvailability jmsAvailability = config.getAvailabilityService().getJmsAvailability();
        JmsService jmsservice = config.getJmsService();
        final Boolean availabilityEnabled = new Boolean(ENHANCED.equalsIgnoreCase(this.clusterType));
        Boolean useMasterBroker = new Boolean(MASTER_BROKER.equalsIgnoreCase(this.configStoreType));
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsAvailability>(){

                public Object run(JmsAvailability param) throws PropertyVetoException, TransactionFailure {
                    param.setAvailabilityEnabled(availabilityEnabled.toString());
                    if (availabilityEnabled.booleanValue()) {
                        param.setMessageStoreType(ConfigureJMSCluster.JDBC);
                    } else {
                        param.setConfigStoreType(ConfigureJMSCluster.this.configStoreType.toLowerCase());
                        param.setMessageStoreType(ConfigureJMSCluster.this.messageStoreType.toLowerCase());
                    }
                    param.setDbVendor(ConfigureJMSCluster.this.dbvendor);
                    param.setDbUsername(ConfigureJMSCluster.this.dbuser);
                    param.setDbPassword(ConfigureJMSCluster.this.jmsDbPassword);
                    param.setDbUrl(ConfigureJMSCluster.this.dburl);
                    if (ConfigureJMSCluster.this.props != null) {
                        for (Map.Entry<Object, Object> e : ConfigureJMSCluster.this.props.entrySet()) {
                            Property prop = (Property)param.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            param.getProperty().add(prop);
                        }
                    }
                    return param;
                }
            }, (ConfigBeanProxy)jmsAvailability);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.fail", "Unable to Configure JMS Cluster for cluster {0}.", new Object[]{this.clusterName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        String warning = "";
        if (instances.size() > 0) {
            warning = localStrings.getLocalString("configure.jms.cluster.clusterWithInstances", "WARNING: Please ensure that you have followed the instructions specified in the documentation before running this command with this option. Running this command without the required precautions can lead to inconsistent JMS behavior and corruption of configuration and message stores.");
        }
        report.setMessage(warning + "\n" + localStrings.getLocalString("configure.jms.cluster.success", "JMS Cluster Configuration updated for Cluster {0}.", new Object[]{this.clusterName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isSupportedDbVendor() {
        if (this.dbvendor != null) {
            return SUPPORTED_DB_VENDORS.contains(this.dbvendor.toLowerCase());
        }
        return false;
    }
}

