/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.SubscriptionIterator;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class ClusterSubscriptionInfo {
    private Subscription subscription = null;
    private Consumer consumer = null;
    private Cluster c = null;
    private GPacket pkt = null;

    private ClusterSubscriptionInfo(Subscription subscription) {
        this.subscription = subscription;
    }

    private ClusterSubscriptionInfo(Subscription subscription, Consumer consumer, Cluster cluster) {
        this.subscription = subscription;
        this.consumer = consumer;
        this.c = cluster;
    }

    private ClusterSubscriptionInfo(GPacket gPacket) {
        this(gPacket, null);
    }

    private ClusterSubscriptionInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterSubscriptionInfo newInstance(Subscription subscription) {
        return new ClusterSubscriptionInfo(subscription);
    }

    public static ClusterSubscriptionInfo newInstance(Subscription subscription, Consumer consumer, Cluster cluster) {
        return new ClusterSubscriptionInfo(subscription, consumer, cluster);
    }

    public static ClusterSubscriptionInfo newInstance(GPacket gPacket) {
        return new ClusterSubscriptionInfo(gPacket);
    }

    public static ClusterSubscriptionInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterSubscriptionInfo(gPacket, cluster);
    }

    public GPacket getGPacket(short s) {
        return this.getGPacket(s, false);
    }

    public GPacket getGPacket(short s, boolean bl) {
        assert (this.subscription != null);
        assert (s == 5 || s == 35 || s == 7);
        if (bl) assert (s == 5 || s == 7);
        GPacket gPacket = null;
        switch (s) {
            case 5: {
                ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(this.subscription, null);
                gPacket = clusterConsumerInfo.getGPacket(s);
                if (bl) {
                    gPacket.putProp((Object)"N", (Object)this.subscription.getDurableName());
                    gPacket.putProp((Object)"I", (Object)this.subscription.getClientID());
                    gPacket.putProp((Object)"M", (Object)true);
                    break;
                }
                ChangeRecordInfo changeRecordInfo = this.subscription.getCurrentChangeRecordInfo(5);
                if (changeRecordInfo == null) break;
                gPacket.putProp((Object)"shareccSeq1", (Object)changeRecordInfo.getSeq());
                gPacket.putProp((Object)"shareccUUID1", (Object)changeRecordInfo.getUUID());
                gPacket.putProp((Object)"shareccResetUUID1", (Object)changeRecordInfo.getResetUUID());
                break;
            }
            case 35: {
                assert (this.consumer != null);
                gPacket = GPacket.getInstance();
                gPacket.setType(s);
                String string = this.subscription.getDurableName();
                if (string != null) {
                    gPacket.putProp((Object)"N", (Object)new String(string));
                }
                String string2 = this.subscription.getClientID();
                gPacket.putProp((Object)"I", (Object)new String(string2));
                gPacket.putProp((Object)(String.valueOf(this.consumer.getConsumerUID().longValue()) + ":" + "prefetch"), (Object)new Integer(this.consumer.getPrefetch()));
                gPacket.putProp((Object)"allowsNonDurable", (Object)new Boolean(true));
                this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    ClusterConsumerInfo.writeConsumer(this.consumer, dataOutputStream);
                    dataOutputStream.flush();
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gPacket.setPayload(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
                break;
            }
            case 7: {
                gPacket = GPacket.getInstance();
                gPacket.setType(s);
                gPacket.putProp((Object)"C", (Object)new Integer(1));
                String string = this.subscription.getDurableName();
                String string3 = this.subscription.getClientID();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeUTF(string3);
                    dataOutputStream.flush();
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gPacket.setPayload(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
                if (bl) {
                    gPacket.putProp((Object)"N", (Object)new String(string));
                    gPacket.putProp((Object)"I", (Object)new String(string3));
                    gPacket.putProp((Object)"M", (Object)new Boolean(true));
                    break;
                }
                ChangeRecordInfo changeRecordInfo = this.subscription.getCurrentChangeRecordInfo(7);
                if (changeRecordInfo == null) break;
                gPacket.putProp((Object)"shareccSeq1", (Object)changeRecordInfo.getSeq());
                gPacket.putProp((Object)"shareccUUID1", (Object)changeRecordInfo.getUUID());
                gPacket.putProp((Object)"shareccResetUUID1", (Object)changeRecordInfo.getResetUUID());
            }
        }
        return gPacket;
    }

    public int getConsumerCount() {
        assert (this.pkt != null);
        short s = this.pkt.getType();
        assert (s == 5 || s == 9 || s == 7);
        int n = (Integer)this.pkt.getProp((Object)"C");
        assert (n == 1);
        return n;
    }

    public ChangeRecordInfo getShareccInfo(int n) {
        if (this.pkt.getProp((Object)("shareccSeq" + n)) == null) {
            return null;
        }
        ChangeRecordInfo changeRecordInfo = new ChangeRecordInfo();
        changeRecordInfo.setSeq((Long)this.pkt.getProp((Object)("shareccSeq" + n)));
        changeRecordInfo.setUUID((String)this.pkt.getProp((Object)("shareccUUID" + n)));
        changeRecordInfo.setResetUUID((String)this.pkt.getProp((Object)("shareccResetUUID" + n)));
        changeRecordInfo.setType(this.pkt.getType());
        return changeRecordInfo;
    }

    public boolean isConfigSyncResponse() {
        assert (this.pkt != null);
        boolean bl = false;
        if (this.pkt.getProp((Object)"M") != null) {
            bl = (Boolean)this.pkt.getProp((Object)"M");
        }
        return bl;
    }

    public String getDurableName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"N");
    }

    public String getClientID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"I");
    }

    public Boolean allowsNonDurable() {
        assert (this.pkt != null);
        return (Boolean)this.pkt.getProp((Object)"allowsNonDurable");
    }

    public Consumer getConsumer() throws Exception {
        BrokerAddress brokerAddress;
        assert (this.pkt != null);
        short s = this.pkt.getType();
        assert (s == 35);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pkt.getPayload().array());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        Consumer consumer = ClusterConsumerInfo.readConsumer(dataInputStream);
        Integer n = (Integer)this.pkt.getProp((Object)(String.valueOf(consumer.getConsumerUID().longValue()) + ":" + "prefetch"));
        if (n != null) {
            consumer.setRemotePrefetch(n);
        }
        if ((brokerAddress = this.c.unmarshalBrokerAddress(this.pkt)) != null) {
            consumer.getConsumerUID().setBrokerAddress(brokerAddress);
        }
        return consumer;
    }

    public Iterator getSubscriptions() {
        assert (this.pkt != null);
        short s = this.pkt.getType();
        assert (s == 7);
        return new SubscriptionIterator(this.pkt.getPayload().array(), this.getConsumerCount());
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public static GPacket getReplyGPacket(short s, int n) {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp((Object)"S", (Object)new Integer(n));
        return gPacket;
    }
}

