/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackEventListener;
import com.sun.messaging.jmq.jmsserver.multibroker.ClientDownCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterCreateDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterDestroyDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterUpdateDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ConfigSyncCompleteCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.GPacketCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.GoHAActiveCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestCreatedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestRemovedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.PrimaryInterestChangedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterGoodbyeInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageAckInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CallbackDispatcher
extends Thread {
    private static boolean DEBUG = false;
    private static final boolean DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all");
    private static final boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG || DEBUG_CLUSTER_ALL;
    private static final boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG || DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_MSG;
    protected static final Logger logger = Globals.getLogger();
    private MessageBusCallback cb = null;
    private LinkedList eventQ = null;
    private boolean stopThread = false;
    private ExecutorService commitAckExecutor = null;
    private ExecutorService syncAckExecutor = null;
    private ExecutorService msgDataExecutor = null;
    private BrokerResources br = Globals.getBrokerResources();
    private static FaultInjection fi = FaultInjection.getInjection();

    public CallbackDispatcher(MessageBusCallback messageBusCallback) {
        this.cb = messageBusCallback;
        this.eventQ = new LinkedList();
        this.setName("MessageBusCallbackDispatcher");
        this.setDaemon(true);
        this.start();
        this.commitAckExecutor = Executors.newSingleThreadExecutor();
        this.syncAckExecutor = Executors.newSingleThreadExecutor();
        this.msgDataExecutor = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configSyncComplete() {
        ConfigSyncCompleteCallbackEvent configSyncCompleteCallbackEvent = new ConfigSyncCompleteCallbackEvent();
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(configSyncCompleteCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGPacket(BrokerAddress brokerAddress, GPacket gPacket, Protocol protocol) {
        GPacketCallbackEvent gPacketCallbackEvent = new GPacketCallbackEvent(brokerAddress, gPacket, protocol);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(gPacketCallbackEvent);
            this.eventQ.notify();
        }
    }

    public void processMessageAckReply(final BrokerAddress brokerAddress, final GPacket gPacket, final Protocol protocol) {
        short s = gPacket.getType();
        if (s != 4) {
            throw new RuntimeException("Internal Error: Unexpected packet type " + s + " passed to CallbackDispatcher.processMessageAckReply()");
        }
        if (this.processCommitAck(brokerAddress, gPacket)) {
            return;
        }
        if (DEBUG_CLUSTER_MSG || DEBUG_CLUSTER_TXN) {
            logger.log(8, "processMessageAckReply: Received " + ProtocolGlobals.getPacketTypeDisplayString(s) + " from " + brokerAddress + ": " + ClusterMessageAckInfo.toString(gPacket));
        }
        try {
            this.syncAckExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        protocol.handleGPacket(CallbackDispatcher.this.cb, brokerAddress, gPacket);
                    }
                    catch (Throwable throwable) {
                        logger.logStack(16, "Exception in processing " + ClusterMessageAckInfo.toString(gPacket) + " from " + brokerAddress, throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore event " + ClusterMessageAckInfo.toString(gPacket) + " from " + brokerAddress);
            }
            logger.logStack(16, "Exception in submitting for processing " + ClusterMessageAckInfo.toString(gPacket) + " from " + brokerAddress, throwable);
        }
    }

    private boolean processCommitAck(final BrokerAddress brokerAddress, final GPacket gPacket) {
        if (!ClusterMessageAckInfo.isAckAckAsync(gPacket)) {
            return false;
        }
        Integer n = ClusterMessageAckInfo.getAckAckType(gPacket);
        if (n == null || n != 3) {
            return false;
        }
        Long l = ClusterMessageAckInfo.getAckAckTransactionID(gPacket);
        if (l == null) {
            return false;
        }
        if (ClusterMessageAckInfo.getAckAckStatus(gPacket) != 200) {
            logger.log(16, this.br.getKString("B2117", brokerAddress, ClusterMessageAckInfo.toString(gPacket)));
            return true;
        }
        if (DEBUG_CLUSTER_TXN || DEBUG) {
            logger.log(8, "processCommitAck: Received " + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + " from " + brokerAddress + ": " + ClusterMessageAckInfo.toString(gPacket));
        }
        if (CallbackDispatcher.fi.FAULT_INJECTION) {
            ClusterMessageAckInfo.CHECKFAULT(new HashMap(), 3, l, "msg.remote_ack.p.", "3");
        }
        try {
            final TransactionUID transactionUID = new TransactionUID(l);
            this.commitAckExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        Globals.getTransactionList().completeClusterTransactionBrokerState(transactionUID, 6, brokerAddress, true);
                    }
                    catch (Throwable throwable) {
                        logger.log(16, "Unable to update cluster transaction COMMIT completion state for " + brokerAddress + ": " + ClusterMessageAckInfo.toString(gPacket), throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore event " + ClusterMessageAckInfo.toString(gPacket) + " from " + brokerAddress);
            }
            logger.logStack(16, "Exception in submitting for processing " + ClusterMessageAckInfo.toString(gPacket) + " from " + brokerAddress, throwable);
        }
        return true;
    }

    public void processMessageData(final BrokerAddress brokerAddress, final GPacket gPacket, final Protocol protocol) {
        short s = gPacket.getType();
        if (s != 1 && s != 6 && s != 10 && s != 36 && s != 8 && s != 22) {
            throw new RuntimeException("Internal Error: Unexpected packet type " + s + " passed to CallbackDispatcher.processMessageData()");
        }
        if (DEBUG_CLUSTER_MSG || DEBUG_CLUSTER_TXN) {
            logger.log(8, "processMessageData: Received " + ProtocolGlobals.getPacketTypeDisplayString(s) + " from " + brokerAddress);
        }
        try {
            this.msgDataExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        protocol.handleGPacket(CallbackDispatcher.this.cb, brokerAddress, gPacket);
                    }
                    catch (Throwable throwable) {
                        logger.logStack(16, "Exception in processing " + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + " from " + brokerAddress, throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore packet " + ProtocolGlobals.getPacketTypeDisplayString(s) + " from " + brokerAddress);
            }
            logger.logStack(16, "Exception in submitting for processing " + ProtocolGlobals.getPacketTypeDisplayString(s) + " from " + brokerAddress, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGoodbye(BrokerAddress brokerAddress, ClusterGoodbyeInfo clusterGoodbyeInfo) {
        CallbackEvent callbackEvent = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator iterator = this.eventQ.iterator();
            while (iterator.hasNext()) {
                GPacketCallbackEvent gPacketCallbackEvent;
                callbackEvent = (CallbackEvent)iterator.next();
                if (!(callbackEvent instanceof GPacketCallbackEvent) || !(gPacketCallbackEvent = (GPacketCallbackEvent)callbackEvent).getSender().equals(brokerAddress) || gPacketCallbackEvent.getEventType() != 3) continue;
                logger.log(16, "Discard unprocessed G_MESSAGE_ACK  because received GOODBYE from " + brokerAddress);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGoodbyeReply(BrokerAddress brokerAddress) {
        CallbackEvent callbackEvent = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator iterator = this.eventQ.iterator();
            while (iterator.hasNext()) {
                GPacketCallbackEvent gPacketCallbackEvent;
                callbackEvent = (CallbackEvent)iterator.next();
                if (!(callbackEvent instanceof GPacketCallbackEvent) || !(gPacketCallbackEvent = (GPacketCallbackEvent)callbackEvent).getSender().equals(brokerAddress) || gPacketCallbackEvent.getEventType() != 4) continue;
                if (DEBUG) {
                    logger.log(8, "Processed G_MESSAGE_ACK_REPLY from " + brokerAddress);
                }
                gPacketCallbackEvent.dispatch(this.cb);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestCreated(Consumer consumer) {
        InterestCreatedCallbackEvent interestCreatedCallbackEvent = new InterestCreatedCallbackEvent(consumer);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(interestCreatedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestRemoved(Consumer consumer, Set set, boolean bl) {
        InterestRemovedCallbackEvent interestRemovedCallbackEvent = new InterestRemovedCallbackEvent(consumer, set, bl);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(interestRemovedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeStateChanged(ConsumerUID consumerUID) {
        PrimaryInterestChangedCallbackEvent primaryInterestChangedCallbackEvent = new PrimaryInterestChangedCallbackEvent(consumerUID);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(primaryInterestChangedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeStateChanged(Consumer consumer) {
        PrimaryInterestChangedCallbackEvent primaryInterestChangedCallbackEvent = new PrimaryInterestChangedCallbackEvent(consumer);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(primaryInterestChangedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientDown(ConnectionUID connectionUID) {
        ClientDownCallbackEvent clientDownCallbackEvent = new ClientDownCallbackEvent(connectionUID);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(clientDownCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brokerDown(BrokerAddress brokerAddress) {
        CallbackEvent callbackEvent = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator iterator = this.eventQ.iterator();
            while (iterator.hasNext()) {
                GPacketCallbackEvent gPacketCallbackEvent;
                callbackEvent = (CallbackEvent)iterator.next();
                if (!(callbackEvent instanceof GPacketCallbackEvent) || !(gPacketCallbackEvent = (GPacketCallbackEvent)callbackEvent).getSender().equals(brokerAddress) || gPacketCallbackEvent.getSender().getBrokerSessionUID() != null && brokerAddress.getBrokerSessionUID() != null && !gPacketCallbackEvent.getSender().getBrokerSessionUID().equals((Object)brokerAddress.getBrokerSessionUID())) continue;
                if (gPacketCallbackEvent.getEventType() == 4 || gPacketCallbackEvent.getEventType() == 5 || gPacketCallbackEvent.getEventType() == 7 || gPacketCallbackEvent.getEventType() == 21) {
                    gPacketCallbackEvent.dispatch(this.cb);
                }
                iterator.remove();
            }
        }
        this.cb.brokerDown(brokerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCreateDestination(Destination destination) {
        ClusterCreateDestinationCallbackEvent clusterCreateDestinationCallbackEvent = new ClusterCreateDestinationCallbackEvent(destination, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore create destination event on " + destination);
                return;
            }
            this.eventQ.add(clusterCreateDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterCreateDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDestroyDestination(DestinationUID destinationUID) {
        ClusterDestroyDestinationCallbackEvent clusterDestroyDestinationCallbackEvent = new ClusterDestroyDestinationCallbackEvent(destinationUID, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore destroy destination event on " + destinationUID);
                return;
            }
            this.eventQ.add(clusterDestroyDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterDestroyDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdateDestination(DestinationUID destinationUID, Map map) {
        ClusterUpdateDestinationCallbackEvent clusterUpdateDestinationCallbackEvent = new ClusterUpdateDestinationCallbackEvent(destinationUID, map, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore update destination event on " + destinationUID);
                return;
            }
            this.eventQ.add(clusterUpdateDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterUpdateDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goHAActive() {
        GoHAActiveCallbackEvent goHAActiveCallbackEvent = new GoHAActiveCallbackEvent();
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(goHAActiveCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.stopThread = true;
            this.eventQ.notify();
        }
        this.msgDataExecutor.shutdown();
        this.commitAckExecutor.shutdown();
        this.syncAckExecutor.shutdown();
        try {
            this.join(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            if (!this.msgDataExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.log(8, "Force cluster msgDataExecutor thread shutdown");
                this.msgDataExecutor.shutdownNow();
                this.msgDataExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            this.msgDataExecutor.shutdownNow();
        }
        try {
            if (!this.commitAckExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.log(8, "Force cluster commitAckExecutor thread shutdown");
                this.commitAckExecutor.shutdownNow();
                this.commitAckExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            this.commitAckExecutor.shutdownNow();
        }
        try {
            if (!this.syncAckExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.log(8, "Force cluster syncAckExecutor thread shutdown");
                this.syncAckExecutor.shutdownNow();
                this.syncAckExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            this.syncAckExecutor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("stopThread", this.stopThread);
        Object[] objectArray = null;
        AbstractList abstractList = this.eventQ;
        synchronized (abstractList) {
            objectArray = this.eventQ.toArray();
        }
        hashtable.put("eventQCount", objectArray.length);
        abstractList = new Vector();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Vector)abstractList).add(objectArray[i].toString());
        }
        hashtable.put("eventQ", abstractList);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block38: {
            var1_1 = BrokerStateHandler.getRestartCode();
            var2_2 = Globals.getBrokerResources().getKString("B0083");
            var3_3 = null;
            try {
                try {
                    var4_4 = true;
lbl7:
                    // 4 sources

                    while (true) {
                        ** try [egrp 2[TRYBLOCK] [6, 8 : 18->144)] { 
lbl9:
                        // 1 sources

                        break;
lbl10:
                        // 1 sources

                        catch (Exception var5_7) {
                            CallbackDispatcher.logger.logStack(16, "Cluster dispatcher thread encountered exception: " + var5_7.getMessage(), (Throwable)var5_7);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var4_5) {
                    CallbackDispatcher.logger.logStack(16, "Cluster dispatcher thread got unrecoverable exception", var4_5);
                    var12_16 = null;
                    if (!this.stopThread) {
                        CallbackDispatcher.logger.log(16, "Cluster dispatcher thread exiting");
                    }
                    var13_19 = this.eventQ;
                    synchronized (var13_19) {
                        try {
                            var3_3 = (CallbackEvent)this.eventQ.removeFirst();
                            while (var3_3 != null) {
                                var14_23 = var3_3.getEventListener();
                                if (var14_23 != null) {
                                    var14_23.eventProcessed();
                                }
                                var3_3 = (CallbackEvent)this.eventQ.removeFirst();
                            }
                        }
                        catch (NoSuchElementException var14_24) {
                            // empty catch block
                        }
                        this.stopThread = true;
                        return;
                    }
                }
            }
            catch (Throwable var11_27) {
                var12_17 = null;
                if (!this.stopThread) {
                    CallbackDispatcher.logger.log(16, "Cluster dispatcher thread exiting");
                }
                var13_20 = this.eventQ;
                synchronized (var13_20) {
                    block39: {
                        ** try [egrp 8[TRYBLOCK] [15 : 290->338)] { 
lbl43:
                        // 1 sources

                        var3_3 = (CallbackEvent)this.eventQ.removeFirst();
                        while (var3_3 != null) {
                            var14_25 = var3_3.getEventListener();
                            if (var14_25 != null) {
                                var14_25.eventProcessed();
                            }
                            var3_3 = (CallbackEvent)this.eventQ.removeFirst();
                        }
                        break block39;
lbl51:
                        // 1 sources

                        catch (NoSuchElementException var14_26) {
                            // empty catch block
                        }
                    }
                    this.stopThread = true;
                    throw var11_27;
                }
            }
            while (true) {
                var5_6 = this.eventQ;
                synchronized (var5_6) {
                    while (!this.stopThread && this.eventQ.isEmpty()) {
                        try {
                            this.eventQ.wait();
                        }
                        catch (Exception var6_10) {}
                    }
                    if (this.stopThread) {
                        break block38;
                    }
                    var3_3 = (CallbackEvent)this.eventQ.removeFirst();
                }
                try {
                    var3_3.dispatch(this.cb);
                    var4_4 = true;
                    var9_12 = null;
                    var10_13 = var3_3.getEventListener();
                    if (var10_13 == null) continue;
                    var10_13.eventProcessed();
                }
                catch (Throwable var8_14) {
                    var9_12 = null;
                    var10_13 = var3_3.getEventListener();
                    if (var10_13 == null) throw var8_14;
                    var10_13.eventProcessed();
                    throw var8_14;
                }
            }
lbl86:
            // 1 sources

            catch (OutOfMemoryError var5_8) {
                block40: {
                    if (!var4_4) break block40;
                    var4_4 = false;
                    Globals.handleGlobalError(var5_8, var2_2);
                    try {
                        CallbackDispatcher.sleep(1L);
                    }
                    catch (InterruptedException var6_11) {}
                    ** GOTO lbl7
                }
                Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, var5_8, false, false, false);
                ** continue;
            }
        }
        var12_15 = null;
        if (!this.stopThread) {
            CallbackDispatcher.logger.log(16, "Cluster dispatcher thread exiting");
        }
        var13_18 = this.eventQ;
        synchronized (var13_18) {
            block41: {
                ** try [egrp 8[TRYBLOCK] [15 : 290->338)] { 
lbl105:
                // 1 sources

                var3_3 = (CallbackEvent)this.eventQ.removeFirst();
                while (var3_3 != null) {
                    var14_21 = var3_3.getEventListener();
                    if (var14_21 != null) {
                        var14_21.eventProcessed();
                    }
                    var3_3 = (CallbackEvent)this.eventQ.removeFirst();
                }
                break block41;
lbl113:
                // 1 sources

                catch (NoSuchElementException var14_22) {
                    // empty catch block
                }
            }
            this.stopThread = true;
            return;
        }
    }
}

