/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.List;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.PostStartup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JmsProviderLifecycle
implements PostStartup,
PostConstruct {
    private static final String JMS_INITIALIZE_ON_DEMAND = "org.glassfish.jms.InitializeOnDemand";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String JMS_SERVICE = "jms-service";
    @Inject
    Habitat habitat;

    public void postConstruct() {
        if (this.eagerStartupRequired()) {
            try {
                this.initializeBroker();
            }
            catch (ConnectorRuntimeException e) {
                e.printStackTrace();
                e.printStackTrace();
            }
        }
    }

    public void initializeBroker() throws ConnectorRuntimeException {
        String module = "jmsra";
        String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.habitat.getComponent(ConnectorRuntime.class);
        connectorRuntime.createActiveResourceAdapter(loc, module, null);
    }

    private boolean eagerStartupRequired() {
        JmsService jmsService = this.getJmsService();
        if (jmsService == null) {
            return false;
        }
        String integrationMode = jmsService.getType();
        List jmsHostList = jmsService.getJmsHost();
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        JmsHost defaultJmsHost = null;
        for (JmsHost host : jmsHostList) {
            if (defaultJmsHostName == null || !defaultJmsHostName.equals(host.getName())) continue;
            defaultJmsHost = host;
            break;
        }
        if (defaultJmsHost == null && jmsHostList != null && jmsHostList.size() > 0) {
            defaultJmsHost = (JmsHost)jmsHostList.get(0);
        }
        boolean lazyInit = false;
        if (defaultJmsHost != null) {
            lazyInit = Boolean.parseBoolean(defaultJmsHost.getLazyInit());
        }
        if (REMOTE.equals(integrationMode)) {
            return false;
        }
        String jmsInitializeOnDemand = System.getProperty(JMS_INITIALIZE_ON_DEMAND);
        if ("true".equals(jmsInitializeOnDemand)) {
            return false;
        }
        if (EMBEDDED.equals(integrationMode) && !lazyInit) {
            return true;
        }
        return LOCAL.equals(integrationMode);
    }

    private JmsService getJmsService() {
        Domain domain = (Domain)Globals.get(Domain.class);
        String serverName = System.getProperty("com.sun.aas.instanceName");
        Server server = domain.getServerNamed(serverName);
        Config config = server.getConfig();
        return config.getJmsService();
    }
}

