/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core.cluster;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.ClusterRouter;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.cluster.BrokerConsumers;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultibrokerRouter
implements ClusterRouter {
    private static boolean DEBUG = false;
    private static Logger logger = Globals.getLogger();
    private static final String ENFORCE_REMOTE_DEST_LIMIT_PROP = "imq.cluster.enforceRemoteDestinationLimit";
    private static boolean ENFORCE_REMOTE_DEST_LIMIT = Globals.getConfig().getBooleanProperty("imq.cluster.enforceRemoteDestinationLimit", true);
    private static boolean ROUTE_REJECTED_REMOTE_MSG = Boolean.getBoolean("imq.cluster.routeRejectedRemoteMsg");
    ClusterBroadcast cb = null;
    Protocol p = null;
    BrokerConsumers bc = null;

    public MultibrokerRouter(ClusterBroadcast clusterBroadcast) {
        this.cb = clusterBroadcast;
        this.p = clusterBroadcast.getProtocol();
        this.bc = new BrokerConsumers(this.p);
    }

    public static String msgToString(int n) {
        switch (n) {
            case 0: {
                return "MSG_DELIVERED";
            }
            case 1: {
                return "MSG_ACKNOWLEDGED";
            }
            case 8: {
                return "MSG_PREPARE";
            }
            case 9: {
                return "MSG_ROLLEDBACK";
            }
            case 5: {
                return "MSG_IGNORED";
            }
            case 6: {
                return "MSG_UNDELIVERABLE";
            }
            case 7: {
                return "MSG_DEAD";
            }
        }
        return "UNKNOWN";
    }

    public void addConsumer(Consumer consumer) throws BrokerException, IOException, SelectorFormatException {
        this.bc.addConsumer(consumer);
    }

    public void removeConsumer(ConsumerUID consumerUID, Set set, boolean bl) throws BrokerException, IOException {
        this.bc.removeConsumer(consumerUID, set, bl);
    }

    public void removeConsumers(ConnectionUID connectionUID) throws BrokerException, IOException {
        this.bc.removeConsumers(connectionUID);
    }

    public void brokerDown(BrokerAddress brokerAddress) throws BrokerException, IOException {
        this.bc.brokerDown(brokerAddress);
    }

    public void forwardMessage(PacketReference packetReference, Collection collection) {
        this.bc.forwardMessageToRemote(packetReference, collection);
    }

    public void shutdown() {
        this.bc.destroy();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void handleJMSMsg(Packet var1_1, List var2_2, BrokerAddress var3_3, boolean var4_4) throws BrokerException {
        block45: {
            var5_5 = true;
            var6_6 = new ArrayList<Object>();
            var7_7 = new ArrayList<Object>();
            var8_8 = null;
            var9_9 = new HashMap<String, String>();
            var9_9.put("MSG_REMOTE_REJECTED", "true");
            for (ConsumerUID var11_11 : var2_2) {
                var12_13 = Consumer.getConsumer(var11_11);
                if (var12_13 != null && var12_13.isValid()) {
                    var6_6.add(var12_13);
                    var13_14 /* !! */  = var12_13.getStoredConsumerUID();
                    if (var13_14 /* !! */  != null && !var13_14 /* !! */ .equals(var11_11) || var12_13.getSubscription() != null) continue;
                    var5_5 = false;
                    continue;
                }
                var7_7.add(var11_11);
            }
            var11_12 = false;
            var12_13 = Destination.get(var1_1.getSysMessageID());
            if (!(var12_13 == null || (var13_14 /* !! */  = var12_13.getAddress()) != null && var13_14 /* !! */ .equals(var3_3))) {
                if (MultibrokerRouter.DEBUG) {
                    MultibrokerRouter.logger.log(8, "Remote message " + var12_13.getSysMessageID() + " home broker " + var13_14 /* !! */  + " changed to " + var3_3);
                }
                Destination.remoteCheckMessageHomeChange((PacketReference)var12_13, var3_3);
            }
            if ((var12_13 = Destination.get(var1_1.getSysMessageID())) != null) {
                var11_12 = true;
                var12_13.setBrokerAddress(var3_3);
                if (var1_1.getRedelivered()) {
                    var12_13.overrideRedeliver();
                }
            } else {
                var12_13 = PacketReference.createReference(var1_1, null);
                var12_13.setBrokerAddress(var3_3);
            }
            if (var4_4) {
                for (var13_15 = 0; var13_15 < var6_6.size(); ++var13_15) {
                    var14_17 = (Consumer)var6_6.get(var13_15);
                    var12_13.addMessageDeliveredAck(var14_17.getConsumerUID());
                }
            }
            var13_16 = null;
            var14_17 = new ArrayList<E>();
            try {
                if (var12_13 == null) {
                    return;
                }
                if (var12_13.getDestinationUID().isWildcard()) {
                    var13_16 = Destination.findMatchingIDs(var12_13.getDestinationUID());
                } else {
                    var15_18 = Destination.getDestination(var12_13.getDestinationUID().getName(), var12_13.getDestinationUID().isQueue() != false ? 1 : 2, true, true);
                    if (var15_18 != null) {
                        var13_16 = new ArrayList<DestinationUID>();
                        var13_16.add(var15_18.getDestinationUID());
                    }
                }
                if (var13_16 == null || var13_16.isEmpty()) {
                    var7_7.addAll(var6_6);
                    var6_6.clear();
                    break block45;
                }
                if (!var11_12 && !var6_6.isEmpty()) {
                    var12_13.setNeverStore(true);
                    var12_13.store(var6_6);
                    var15_19 = false;
                    for (DestinationUID var16_22 : var13_16) {
                        var17_25 = Destination.getDestination(var16_22);
                        if (!var5_5) {
                            var15_19 = true;
                        } else {
                            var18_26 = "imq.cluster.enforceRemoteDestinationLimit" + var16_22.getLongString();
                            var15_19 = Globals.getConfig().getProperty((String)var18_26) == null ? MultibrokerRouter.ENFORCE_REMOTE_DEST_LIMIT : Globals.getConfig().getBooleanProperty((String)var18_26);
                        }
                        if (MultibrokerRouter.DEBUG) {
                            MultibrokerRouter.logger.log(8, "Route remote message " + var12_13 + " sent from " + var3_3 + " to destination(s) " + var16_22 + " for consumer(s) " + var6_6 + " hasflowcontrol=" + var5_5 + ", enforcelimit=" + var15_19);
                        }
                        if (!var17_25.queueMessage((PacketReference)var12_13, false, var15_19)) {
                            var7_7.addAll(var6_6);
                            if (!MultibrokerRouter.ROUTE_REJECTED_REMOTE_MSG) {
                                var6_6.clear();
                            }
                            break block45;
                        }
                        var14_17.add(var17_25);
                    }
                    break block45;
                }
                if (var11_12) {
                    var12_13.add(var6_6);
                }
            }
            catch (IOException var15_20) {
                MultibrokerRouter.logger.logStack(8, "Internal Exception ", (Throwable)var15_20);
                var7_7.addAll(var6_6);
                if (!MultibrokerRouter.ROUTE_REJECTED_REMOTE_MSG) {
                    var6_6.clear();
                    var8_8 = var9_9;
                }
            }
            catch (BrokerException var15_21) {
                var7_7.addAll(var6_6);
                if (MultibrokerRouter.ROUTE_REJECTED_REMOTE_MSG) break block45;
                var6_6.clear();
                var8_8 = var9_9;
            }
        }
        if (var6_6.isEmpty()) {
            var15_18 = null;
            var10_10 = var14_17.iterator();
            while (var10_10.hasNext()) {
                try {
                    var15_18 = (Destination)var10_10.next();
                    var15_18.removeMessage(var12_13.getSysMessageID(), null);
                }
                catch (Throwable var16_23) {
                    var17_25 = new Object[]{var12_13.getSysMessageID(), var3_3 == null ? "" : var3_3, var15_18, var6_6.toString(), var16_23.toString()};
                    var18_26 = Globals.getBrokerResources().getKString("B2245", (Object[])var17_25);
                    if (MultibrokerRouter.DEBUG) {
                        MultibrokerRouter.logger.logStack(16, (String)var18_26, var16_23);
                        continue;
                    }
                    MultibrokerRouter.logger.log(16, (String)var18_26);
                }
            }
            var14_17.clear();
        }
        var15_18 = "\n";
        for (var16_24 = 0; var16_24 < var6_6.size(); ++var16_24) {
            var17_25 = (Consumer)var6_6.get(var16_24);
            if (!var17_25.routeMessage((PacketReference)var12_13, false)) {
                try {
                    if (!var12_13.acknowledged(var17_25.getConsumerUID(), var17_25.getStoredConsumerUID(), true, false)) ** GOTO lbl136
                    if (var13_16 == null) continue;
                    for (Object var18_26 : var13_16) {
                        var19_28 = Destination.getDestination((DestinationUID)var18_26);
                        var19_28.removeRemoteMessage(var12_13.getSysMessageID(), RemoveReason.ACKNOWLEDGED, (PacketReference)var12_13);
                    }
                }
                catch (Exception var18_27) {
                    MultibrokerRouter.logger.log(8, "Internal error processing ack", (Throwable)var18_27);
                }
            } else {
                var12_13.addRemoteConsumerUID(var17_25.getConsumerUID(), var17_25.getConsumerUID().getConnectionUID());
            }
lbl136:
            // 4 sources

            if (!MultibrokerRouter.DEBUG) continue;
            var15_18 = (String)var15_18 + "\t" + var17_25.getConsumerUID() + "\n";
        }
        if (MultibrokerRouter.DEBUG) {
            MultibrokerRouter.logger.log(1, "MessageBus: Delivering message to : {0}", var15_18);
        }
        var15_18 = "\n";
        var17_25 = null;
        var18_26 = null;
        var19_28 = null;
        for (var16_24 = 0; var16_24 < var7_7.size(); ++var16_24) {
            try {
                var17_25 = var7_7.get(var16_24);
                if (var17_25 instanceof Consumer) {
                    var18_26 = var17_25.getConsumerUID();
                    var19_28 = (Consumer)var17_25;
                } else {
                    var18_26 = (ConsumerUID)var17_25;
                    var19_28 = Consumer.getConsumer((ConsumerUID)var18_26);
                }
                if (!MultibrokerRouter.ROUTE_REJECTED_REMOTE_MSG && var19_28 != null && var4_4) {
                    var12_13.setBrokerAddress(var3_3);
                    var19_28.addRemotePendingResume((PacketReference)var12_13);
                }
                this.cb.acknowledgeMessage(var3_3, var12_13.getSysMessageID(), (ConsumerUID)var18_26, 5, var8_8, false);
            }
            catch (Exception var20_29) {
                MultibrokerRouter.logger.log(16, "sendMessageAck IGNORE failed to" + var3_3);
            }
            if (!MultibrokerRouter.DEBUG) continue;
            var15_18 = (String)var15_18 + "\t" + var7_7.get(var16_24) + "\n";
        }
        if (MultibrokerRouter.DEBUG && var7_7.size() > 0) {
            MultibrokerRouter.logger.log(1, "MessageBus: Invalid targets : {0}", var15_18);
        }
    }

    public void handleAck(int n, SysMessageID sysMessageID, ConsumerUID consumerUID, Map map) throws BrokerException {
        this.bc.acknowledgeMessageFromRemote(n, sysMessageID, consumerUID, map);
    }

    public void handleAck2P(int n, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, Map map, Long l, BrokerAddress brokerAddress) throws BrokerException {
        this.bc.acknowledgeMessageFromRemote2P(n, sysMessageIDArray, consumerUIDArray, map, l, brokerAddress);
    }

    public void handleCtrlMsg(int n, HashMap hashMap) throws BrokerException {
    }

    public Hashtable getDebugState() {
        return this.bc.getDebugState();
    }
}

