/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.objmgr;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.InvalidPropertyException;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.Queue;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.ReadOnlyPropertyException;
import com.sun.messaging.Topic;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.XAQueueConnectionFactory;
import com.sun.messaging.XATopicConnectionFactory;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrOptions;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrPrinter;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrProperties;
import com.sun.messaging.jmq.admin.apps.objmgr.Utils;
import com.sun.messaging.jmq.admin.objstore.AuthenticationException;
import com.sun.messaging.jmq.admin.objstore.AuthenticationNotSupportedException;
import com.sun.messaging.jmq.admin.objstore.CommunicationException;
import com.sun.messaging.jmq.admin.objstore.GeneralNamingException;
import com.sun.messaging.jmq.admin.objstore.InitializationException;
import com.sun.messaging.jmq.admin.objstore.NameAlreadyExistsException;
import com.sun.messaging.jmq.admin.objstore.NameNotFoundException;
import com.sun.messaging.jmq.admin.objstore.NoPermissionException;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.objstore.ObjStoreException;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;
import com.sun.messaging.jmq.admin.objstore.SchemaViolationException;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.JMSObjFactory;
import com.sun.messaging.jmq.util.MultiColumnPrinter;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.naming.MissingVersionNumberException;
import com.sun.messaging.naming.UnsupportedVersionNumberException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.directory.Attributes;

public class CmdRunner
implements ObjMgrOptions {
    private static AdminResources ar = Globals.getAdminResources();
    private ObjMgrProperties objMgrProps;

    public CmdRunner(ObjMgrProperties objMgrProperties) {
        this.objMgrProps = objMgrProperties;
    }

    public int runCommands() {
        int n = 0;
        Object var2_2 = null;
        String string = this.objMgrProps.getCommand();
        if (string.equals("add")) {
            n = this.runAddCommand(this.objMgrProps);
        } else if (string.equals("delete")) {
            n = this.runDeleteCommand(this.objMgrProps);
        } else if (string.equals("query")) {
            n = this.runQueryCommand(this.objMgrProps);
        } else if (string.equals("list")) {
            this.runListCommand(this.objMgrProps);
        } else if (string.equals("update")) {
            n = this.runUpdateCommand(this.objMgrProps);
        }
        return n;
    }

    private ObjStore createStore(ObjStoreAttrs objStoreAttrs) {
        ObjStore objStore = null;
        if (objStoreAttrs == null) {
            return null;
        }
        try {
            ObjStoreManager objStoreManager = ObjStoreManager.getObjStoreManager();
            objStore = objStoreManager.createStore(objStoreAttrs);
        }
        catch (NameNotFoundException nameNotFoundException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
            objStore = null;
        }
        catch (ObjStoreException objStoreException) {
            this.handleRunCommandExceptions(objStoreException);
            objStore = null;
        }
        return objStore;
    }

    private void openStore(ObjStore objStore) throws ObjStoreException {
        objStore.open();
    }

    private ObjStore openStore(ObjStoreAttrs objStoreAttrs) {
        ObjStore objStore = null;
        if (objStoreAttrs == null) {
            return null;
        }
        try {
            ObjStoreManager objStoreManager = ObjStoreManager.getObjStoreManager();
            objStore = objStoreManager.createStore(objStoreAttrs);
            objStore.open();
        }
        catch (NameNotFoundException nameNotFoundException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
            objStore = null;
        }
        catch (ObjStoreException objStoreException) {
            this.handleRunCommandExceptions(objStoreException);
            objStore = null;
        }
        return objStore;
    }

    private void printAddCmdDescription(Object object, String string, String string2, ObjStoreAttrs objStoreAttrs, String string3) {
        Globals.stdOutPrintln(ar.getString("A1100", Utils.getObjTypeString(string)));
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(2, 4);
        objMgrPrinter.printObjPropertiesFromObj((AdministeredObject)object);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1101"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(string2);
        Globals.stdOutPrintln("");
        ObjMgrPrinter.printReadOnly(string3);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1102"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter2 = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        objMgrPrinter2.print();
        Globals.stdOutPrintln("");
    }

    private int runAddCommand(ObjMgrProperties objMgrProperties) {
        int n = 0;
        String string = null;
        Object object = null;
        String string2 = ar.getString("A5016");
        String string3 = ar.getString("A5015");
        String string4 = ar.getString("A5018");
        String string5 = ar.getString("A5017");
        String string6 = objMgrProperties.getObjType();
        Properties properties = objMgrProperties.getObjProperties();
        String string7 = objMgrProperties.getLookupName();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        this.checkObjStoreAttrs(objStoreAttrs);
        Attributes attributes = objMgrProperties.getBindAttrs();
        boolean bl = objMgrProperties.forceModeSet();
        Object object2 = null;
        try {
            if (string6.equals("q")) {
                object2 = JMSObjFactory.createQueue(properties);
            } else if (string6.equals("t")) {
                object2 = JMSObjFactory.createTopic(properties);
            } else if (string6.equals("qf")) {
                object2 = JMSObjFactory.createQueueConnectionFactory(properties);
            } else if (string6.equals("tf")) {
                object2 = JMSObjFactory.createTopicConnectionFactory(properties);
            } else if (string6.equals("cf")) {
                object2 = JMSObjFactory.createConnectionFactory(properties);
            } else if (string6.equals("xtf")) {
                object2 = JMSObjFactory.createXATopicConnectionFactory(properties);
            } else if (string6.equals("xqf")) {
                object2 = JMSObjFactory.createXAQueueConnectionFactory(properties);
            } else if (string6.equals("xcf")) {
                object2 = JMSObjFactory.createXAConnectionFactory(properties);
            }
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string7);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1027"));
            return 1;
        }
        JMSObjFactory.doReadOnlyForAdd(object2, objMgrProperties.readOnlyValue());
        this.printAddCmdDescription(object2, string6, string7, objStoreAttrs, objMgrProperties.readOnlyValue());
        ObjStore objStore = this.createStore(objStoreAttrs);
        if (objStore == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1027"));
            return 1;
        }
        if (!bl) {
            objStore = this.promptForAuthentication(objStore);
        }
        try {
            this.openStore(objStore);
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string7);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1027"));
            return 1;
        }
        if (!bl) {
            try {
                object = objStore.retrieve(string7);
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (Exception exception) {
                this.handleRunCommandExceptions(exception, string7);
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(ar.getString("A1027"));
                return 1;
            }
            if (object != null) {
                Globals.stdOutPrintln(ar.getCString("A1000"), ar.getString("A2000", string7));
                Globals.stdOutPrintln(ar.getCString("A1000"), ar.getString("A2001"));
                string = this.getUserInput(ar.getString("A5000"), string5);
            }
        }
        if (string5.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1023"));
        } else if (string3.equalsIgnoreCase(string) || string2.equalsIgnoreCase(string) || object == null || bl) {
            try {
                if (attributes.size() > 0) {
                    objStore.add(string7, object2, attributes, true);
                } else {
                    objStore.add(string7, object2, true);
                }
            }
            catch (NameAlreadyExistsException nameAlreadyExistsException) {
            }
            catch (NameNotFoundException nameNotFoundException) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
                n = 1;
            }
            catch (Exception exception) {
                this.handleRunCommandExceptions(exception, string7);
                n = 1;
            }
            if (n == 0) {
                Globals.stdOutPrintln(ar.getString("A1020"));
            } else {
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(ar.getString("A1027"));
            }
        } else {
            Globals.stdOutPrintln(ar.getString("A1026", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1023"));
            n = 1;
        }
        return n;
    }

    private void printDeleteCmdDescription(String string, ObjStoreAttrs objStoreAttrs) {
        Globals.stdOutPrintln(ar.getString("A1103"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(string);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1104"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        objMgrPrinter.print();
        Globals.stdOutPrintln("");
    }

    private int runDeleteCommand(ObjMgrProperties objMgrProperties) {
        int n = 0;
        String string = objMgrProperties.getLookupName();
        Object object = null;
        String string2 = null;
        String string3 = ar.getString("A5016");
        String string4 = ar.getString("A5015");
        String string5 = ar.getString("A5018");
        String string6 = ar.getString("A5017");
        boolean bl = objMgrProperties.forceModeSet();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        this.checkObjStoreAttrs(objStoreAttrs);
        this.printDeleteCmdDescription(string, objStoreAttrs);
        ObjStore objStore = this.createStore(objStoreAttrs);
        if (objStore == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            return 1;
        }
        if (!bl) {
            objStore = this.promptForAuthentication(objStore);
        }
        try {
            this.openStore(objStore);
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            return 1;
        }
        try {
            object = objStore.retrieve(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            Globals.stdErrPrintln(ar.getKString("A3051", string));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            return 1;
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            return 1;
        }
        if (object != null) {
            if (!bl) {
                string2 = this.getUserInput(ar.getString("A5001"), string6);
            }
            if (string4.equalsIgnoreCase(string2) || string3.equalsIgnoreCase(string2) || bl) {
                try {
                    objStore.delete(string);
                }
                catch (Exception exception) {
                    this.handleRunCommandExceptions(exception, string);
                    n = 1;
                }
                if (n == 0) {
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(ar.getString("A1021"));
                } else {
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(ar.getString("A1028"));
                }
            } else if (string6.equalsIgnoreCase(string2) || string5.equalsIgnoreCase(string2)) {
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(ar.getString("A1024"));
            } else {
                Globals.stdOutPrintln(ar.getString("A1026", string2));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(ar.getString("A1024"));
                n = 1;
            }
        } else {
            Globals.stdErrPrintln(ar.getKString("A3051"), string);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            n = 1;
        }
        return n;
    }

    private void printQueryCmdDescription(String string, ObjStoreAttrs objStoreAttrs) {
        Globals.stdOutPrintln(ar.getString("A1105"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(string);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1106"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        objMgrPrinter.print();
        Globals.stdOutPrintln("");
    }

    private int runQueryCommand(ObjMgrProperties objMgrProperties) {
        int n = 0;
        String string = objMgrProperties.getLookupName();
        Object object = null;
        boolean bl = objMgrProperties.forceModeSet();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        this.checkObjStoreAttrs(objStoreAttrs);
        this.printQueryCmdDescription(string, objStoreAttrs);
        ObjStore objStore = this.createStore(objStoreAttrs);
        if (objStore == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1030"));
            return 1;
        }
        if (!bl) {
            objStore = this.promptForAuthentication(objStore);
        }
        try {
            this.openStore(objStore);
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1030"));
            return 1;
        }
        try {
            object = objStore.retrieve(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            Globals.stdErrPrintln(ar.getKString("A3051", string));
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1030"));
            return 1;
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string);
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1030"));
            return 1;
        }
        if (object != null) {
            ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(2, 4);
            objMgrPrinter.printJMSObject(object);
            Globals.stdOutPrintln("");
            ObjMgrPrinter.printReadOnly(((AdministeredObject)object).isReadOnly());
        } else {
            Globals.stdErrPrintln(ar.getKString("A3051", string));
            n = 1;
        }
        if (n == 0) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1029"));
        } else {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1030"));
        }
        return n;
    }

    private void printListCmdDescription(String string, ObjStoreAttrs objStoreAttrs) {
        String string2 = Utils.getObjTypeString(string);
        if (string2 == null) {
            Globals.stdOutPrintln(ar.getString("A1107"));
        } else {
            Globals.stdOutPrintln(ar.getString("A1108", string2));
        }
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        objMgrPrinter.print();
        Globals.stdOutPrintln("");
    }

    private int runListCommand(ObjMgrProperties objMgrProperties) {
        int n = 0;
        String string = objMgrProperties.getObjType();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        this.checkObjStoreAttrs(objStoreAttrs);
        boolean bl = objMgrProperties.forceModeSet();
        this.printListCmdDescription(string, objStoreAttrs);
        ObjStore objStore = this.createStore(objStoreAttrs);
        if (objStore == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1033"));
            return 1;
        }
        if (!bl) {
            objStore = this.promptForAuthentication(objStore);
        }
        try {
            this.openStore(objStore);
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1033"));
            return 1;
        }
        n = string != null ? this.listByType(objStore, string) : this.listAll(objStore);
        if (n == 0) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1032"));
        } else {
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1033"));
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printUpdateCmdDescription(String string, String string2, Properties properties, ObjStoreAttrs objStoreAttrs, String string3) {
        Object object;
        Object var6_6 = null;
        if (var6_6 != null) {
            block12: {
                object = null;
                try {
                    if (string.equals("q")) {
                        object = JMSObjFactory.createQueue(properties);
                        break block12;
                    }
                    if (string.equals("t")) {
                        object = JMSObjFactory.createTopic(properties);
                        break block12;
                    }
                    if (string.equals("qf")) {
                        object = JMSObjFactory.createQueueConnectionFactory(properties);
                        break block12;
                    }
                    if (string.equals("tf")) {
                        object = JMSObjFactory.createTopicConnectionFactory(properties);
                        break block12;
                    }
                    if (string.equals("cf")) {
                        object = JMSObjFactory.createConnectionFactory(properties);
                        break block12;
                    }
                    if (string.equals("xtf")) {
                        object = JMSObjFactory.createXATopicConnectionFactory(properties);
                        break block12;
                    }
                    if (string.equals("xqf")) {
                        object = JMSObjFactory.createXAQueueConnectionFactory(properties);
                        break block12;
                    }
                    if (string.equals("xcf")) {
                        object = JMSObjFactory.createXAConnectionFactory(properties);
                    }
                }
                catch (Exception exception) {
                    this.handleRunCommandExceptions(exception, string2);
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(ar.getString("A1027"));
                    return;
                }
            }
            Globals.stdOutPrintln(ar.getString("A1110", (Object)var6_6));
            Globals.stdOutPrintln(string2);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1111"));
            Globals.stdOutPrintln("");
            ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(properties, 2, 4);
            objMgrPrinter.print();
        } else {
            Globals.stdOutPrintln(ar.getString("A1109"));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(string2);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1111"));
            Globals.stdOutPrintln("");
            object = new ObjMgrPrinter(properties, 2, 4);
            ((MultiColumnPrinter)object).print();
        }
        Globals.stdOutPrintln("");
        ObjMgrPrinter.printReadOnly(string3);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1112"));
        Globals.stdOutPrintln("");
        object = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        ((MultiColumnPrinter)object).print();
        Globals.stdOutPrintln("");
    }

    private int runUpdateCommand(ObjMgrProperties objMgrProperties) {
        Object object;
        int n = 0;
        String string = null;
        Object object2 = null;
        String string2 = null;
        String string3 = ar.getString("A5016");
        String string4 = ar.getString("A5015");
        String string5 = ar.getString("A5018");
        String string6 = ar.getString("A5017");
        String string7 = objMgrProperties.getLookupName();
        boolean bl = objMgrProperties.forceModeSet();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        this.checkObjStoreAttrs(objStoreAttrs);
        Properties properties = objMgrProperties.getObjProperties();
        string2 = objMgrProperties.getObjType();
        Attributes attributes = objMgrProperties.getBindAttrs();
        this.printUpdateCmdDescription(string2, string7, properties, objStoreAttrs, objMgrProperties.readOnlyValue());
        ObjStore objStore = this.createStore(objStoreAttrs);
        if (objStore == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1031"));
            return 1;
        }
        if (!bl) {
            objStore = this.promptForAuthentication(objStore);
        }
        try {
            this.openStore(objStore);
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string7);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1031"));
            return 1;
        }
        try {
            object2 = objStore.retrieve(string7);
        }
        catch (NameNotFoundException nameNotFoundException) {
            Globals.stdErrPrintln(ar.getKString("A3051", string7));
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1031"));
            return 1;
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string7);
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1031"));
            return 1;
        }
        if (object2 != null) {
            if ((string2 = this.checkObjectType(object2, string2)) == null) {
                Globals.stdOutPrintln("");
                Globals.stdErrPrintln(ar.getString("A1031"));
                return 1;
            }
        } else {
            Globals.stdErrPrintln(ar.getKString("A3051", string7));
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1031"));
            return 1;
        }
        if (!bl && object2 != null) {
            if (object2 instanceof AdministeredObject) {
                object = (AdministeredObject)object2;
                String string8 = AdministeredObject.getVERSION();
                String string9 = ((AdministeredObject)object).getStoredVersion();
                if (!((AdministeredObject)object).isStoredVersionCompatible()) {
                    Globals.stdErrPrintln(ar.getString("A2004", string9, string8));
                }
            }
            string = this.getUserInput(ar.getString("A5002"), string6);
        }
        if (string6.equalsIgnoreCase(string) || string5.equalsIgnoreCase(string)) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1025"));
        } else if ((string4.equalsIgnoreCase(string) || string3.equalsIgnoreCase(string) || bl) && object2 != null) {
            object = this.updateObject(object2, string2, objMgrProperties);
            if (object == null) {
                return 1;
            }
            try {
                if (attributes.size() > 0) {
                    objStore.add(string7, object, attributes, true);
                } else {
                    objStore.add(string7, object, true);
                }
            }
            catch (NameAlreadyExistsException nameAlreadyExistsException) {
                n = 1;
            }
            catch (Exception exception) {
                this.handleRunCommandExceptions(exception, string7);
                n = 1;
            }
            if (n == 0) {
                if (!bl) {
                    Globals.stdErrPrintln("");
                }
                Globals.stdOutPrintln(ar.getString("A1022"));
            } else {
                Globals.stdErrPrintln("");
                Globals.stdErrPrintln(ar.getString("A1031"));
            }
        } else {
            Globals.stdOutPrintln(ar.getString("A1026", string));
            Globals.stdErrPrintln("");
            Globals.stdOutPrintln(ar.getString("A1025"));
            n = 1;
        }
        return n;
    }

    private String checkObjectType(Object object, String string) {
        if (string == null) {
            if (object instanceof Topic) {
                string = "t";
            } else if (object instanceof Queue) {
                string = "q";
            } else if (object instanceof XAQueueConnectionFactory) {
                string = "xqf";
            } else if (object instanceof XATopicConnectionFactory) {
                string = "xcf";
            } else if (object instanceof XAConnectionFactory) {
                string = "xtf";
            } else if (object instanceof TopicConnectionFactory) {
                string = "tf";
            } else if (object instanceof QueueConnectionFactory) {
                string = "qf";
            } else if (object instanceof ConnectionFactory) {
                string = "cf";
            }
        } else if (!(object instanceof Topic && "t".equals(string) || object instanceof Queue && "q".equals(string) || object instanceof XATopicConnectionFactory && "xtf".equals(string) || object instanceof XAQueueConnectionFactory && "xqf".equals(string) || object instanceof XAConnectionFactory && "xcf".equals(string) || object instanceof QueueConnectionFactory && "qf".equals(string) || object instanceof TopicConnectionFactory && "tf".equals(string) || object instanceof ConnectionFactory && "cf".equals(string))) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3058"));
            return null;
        }
        return string;
    }

    private Object updateObject(Object object, String string, ObjMgrProperties objMgrProperties) {
        Properties properties = objMgrProperties.getObjProperties();
        Object object2 = null;
        String string2 = objMgrProperties.readOnlyValue();
        try {
            if (string.equals("q")) {
                object2 = JMSObjFactory.updateQueue(object, properties, string2);
            } else if (string.equals("t")) {
                object2 = JMSObjFactory.updateTopic(object, properties, string2);
            } else if (string.equals("qf")) {
                object2 = JMSObjFactory.updateQueueConnectionFactory(object, properties, string2);
            } else if (string.equals("tf")) {
                object2 = JMSObjFactory.updateTopicConnectionFactory(object, properties, string2);
            } else if (string.equals("cf")) {
                object2 = JMSObjFactory.updateConnectionFactory(object, properties, string2);
            } else if (string.equals("xqf")) {
                object2 = JMSObjFactory.updateXAQueueConnectionFactory(object, properties, string2);
            } else if (string.equals("xtf")) {
                object2 = JMSObjFactory.updateXATopicConnectionFactory(object, properties, string2);
            } else if (string.equals("xcf")) {
                object2 = JMSObjFactory.updateXAConnectionFactory(object, properties, string2);
            }
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1031"));
            return null;
        }
        return object2;
    }

    private int listByType(ObjStore objStore, String string) {
        Vector vector = null;
        try {
            vector = objStore.list();
        }
        catch (NameNotFoundException nameNotFoundException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
            return 1;
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception);
            return 1;
        }
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(2, 4);
        Object[] objectArray = new String[2];
        objectArray[0] = ar.getString("A1044");
        objectArray[1] = ar.getString("A1045");
        objMgrPrinter.addTitle((String[])objectArray);
        for (int i = 0; i < vector.size(); ++i) {
            NameClassPair nameClassPair = (NameClassPair)vector.get(i);
            if (!(string.equals("t") && Topic.class.getName().equals(nameClassPair.getClassName()) || string.equals("q") && Queue.class.getName().equals(nameClassPair.getClassName()) || string.equals("tf") && TopicConnectionFactory.class.getName().equals(nameClassPair.getClassName()) || string.equals("qf") && QueueConnectionFactory.class.getName().equals(nameClassPair.getClassName()) || string.equals("cf") && ConnectionFactory.class.getName().equals(nameClassPair.getClassName()) || string.equals("xtf") && XATopicConnectionFactory.class.getName().equals(nameClassPair.getClassName()) || string.equals("xqf") && XAQueueConnectionFactory.class.getName().equals(nameClassPair.getClassName())) && (!string.equals("xcf") || !XAConnectionFactory.class.getName().equals(nameClassPair.getClassName()))) continue;
            objectArray[0] = nameClassPair.getName();
            objectArray[1] = nameClassPair.getClassName();
            objMgrPrinter.add(objectArray);
        }
        objMgrPrinter.print();
        return 0;
    }

    private int listAll(ObjStore objStore) {
        Vector vector = null;
        try {
            vector = objStore.list();
        }
        catch (NameNotFoundException nameNotFoundException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
            return 1;
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception);
            return 1;
        }
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(2, 4);
        Object[] objectArray = new String[2];
        objectArray[0] = ar.getString("A1044");
        objectArray[1] = ar.getString("A1045");
        objMgrPrinter.addTitle((String[])objectArray);
        for (int i = 0; i < vector.size(); ++i) {
            NameClassPair nameClassPair = (NameClassPair)vector.get(i);
            if (!Topic.class.getName().equals(nameClassPair.getClassName()) && !Queue.class.getName().equals(nameClassPair.getClassName()) && !TopicConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !QueueConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !ConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !XATopicConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !XAQueueConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !XAConnectionFactory.class.getName().equals(nameClassPair.getClassName())) continue;
            objectArray[0] = nameClassPair.getName();
            objectArray[1] = nameClassPair.getClassName();
            objMgrPrinter.add(objectArray);
        }
        objMgrPrinter.print();
        return 0;
    }

    private String getUserInput(String string) {
        return this.getUserInput(string, null);
    }

    private String getUserInput(String string, String string2) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            Globals.stdOutPrint(string);
            String string3 = bufferedReader.readLine();
            if (string3.equals("") && string2 != null) {
                string3 = string2;
            }
            return string3;
        }
        catch (IOException iOException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3081"));
            return null;
        }
    }

    private String getPassword(String string) {
        Password password = new Password();
        if (password.echoPassword()) {
            Globals.stdOutPrintln(ar.getString("A2015"));
        }
        Globals.stdOutPrint(string);
        return password.getPassword();
    }

    private void handleRunCommandExceptions(Exception exception) {
        this.handleRunCommandExceptions(exception, null);
    }

    private void handleRunCommandExceptions(Exception exception, String string) {
        if (exception instanceof InitializationException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3050"));
        } else if (exception instanceof AuthenticationException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3053"));
        } else if (exception instanceof AuthenticationNotSupportedException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3054"));
        } else if (exception instanceof NoPermissionException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3055"));
        } else if (exception instanceof CommunicationException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3056"));
        } else if (exception instanceof InvalidPropertyException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3070", exception.getMessage()));
            Globals.stdErrPrintln("");
            Globals.stdErrPrintln(ar.getString("A1623"));
        } else if (exception instanceof InvalidPropertyValueException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3072", exception.getMessage()));
        } else if (exception instanceof ReadOnlyPropertyException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3071"));
        } else if (exception instanceof SchemaViolationException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3057"));
        } else if (exception instanceof GeneralNamingException) {
            Exception exception2 = ((GeneralNamingException)exception).getLinkedException();
            if (exception2 instanceof UnsupportedVersionNumberException) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3059", ((UnsupportedVersionNumberException)exception2).getExplanation(), string));
            } else if (exception2 instanceof MissingVersionNumberException) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3060", string));
            } else {
                Globals.stdErrPrintln(exception2.toString());
            }
        } else if (exception instanceof ObjStoreException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3061"));
            Globals.stdErrPrintln(exception.toString());
            Globals.stdErrPrintln(((ObjStoreException)exception).getLinkedException().toString());
        } else {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A4000"));
            Globals.stdErrPrintln(exception.toString());
        }
    }

    private void handleInitializationExceptions(Exception exception) {
        this.handleRunCommandExceptions(exception);
    }

    private void checkObjStoreAttrs(ObjStoreAttrs objStoreAttrs) {
        String[] stringArray = new String[]{"java.naming.factory.initial", "java.naming.provider.url"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = (String)objStoreAttrs.get(stringArray[i]);
            if (string != null) continue;
            Globals.stdErrPrintln(ar.getString("A2002", stringArray[i]));
        }
        System.out.println("");
    }

    private ObjStore promptForAuthentication(ObjStore objStore) {
        ObjStoreAttrs objStoreAttrs = objStore.getObjStoreAttrs();
        Vector vector = objStore.checkAuthentication(objStoreAttrs);
        int n = vector.size();
        boolean bl = false;
        if (vector != null) {
            for (int i = 0; i < n; ++i) {
                bl = true;
                String string = (String)vector.elementAt(i);
                String string2 = null;
                string2 = string.equals("java.naming.security.credentials") ? this.getPassword(ar.getString("A5019", string)) : this.getUserInput(ar.getString("A5019", string));
                objStore.addObjStoreAttr(string, string2);
            }
            if (bl) {
                Globals.stdOutPrintln("");
            }
        }
        return objStore;
    }
}

