/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.Refable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;

public class XAConnectionFactoryImpl
implements XAConnectionFactory,
Refable {
    private XAConnectionFactory _cf = null;
    private String _ref = null;
    private boolean _isEmbeded = false;
    private boolean _isMultiRM = false;
    private boolean _firstTime = true;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;

    public XAConnectionFactoryImpl(XAConnectionFactory xAConnectionFactory, String string, boolean bl) {
        this._cf = xAConnectionFactory;
        this._ref = string;
        this._isMultiRM = bl;
    }

    public XAConnectionFactoryImpl(BridgeContext bridgeContext, Properties properties, boolean bl, String string, boolean bl2) throws Exception {
        this._bc = bridgeContext;
        this._jmsprop = properties;
        this._cf = bridgeContext.getXAConnectionFactory(properties);
        this._ref = string;
        this._isEmbeded = bl;
        this._isMultiRM = bl2;
    }

    public XAConnection createXAConnection() throws JMSException {
        if (this._bc != null) {
            XAConnectionFactory xAConnectionFactory = null;
            try {
                xAConnectionFactory = this._bc.getXAConnectionFactory(this._jmsprop);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                JMSBridge.getJMSBridgeResources();
                JMSException jMSException = new JMSException(string, "BSJ3009");
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            return xAConnectionFactory.createXAConnection();
        }
        return this._cf.createXAConnection();
    }

    public XAConnection createXAConnection(String string, String string2) throws JMSException {
        if (this._bc != null) {
            XAConnectionFactory xAConnectionFactory = null;
            try {
                xAConnectionFactory = this._bc.getXAConnectionFactory(this._jmsprop);
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                JMSBridge.getJMSBridgeResources();
                JMSException jMSException = new JMSException(string3, "BSJ3009");
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            return xAConnectionFactory.createXAConnection(string, string2);
        }
        return this._cf.createXAConnection(string, string2);
    }

    public String getRef() {
        return this._ref;
    }

    public Object getRefed() {
        return this._cf;
    }

    public boolean isEmbeded() {
        return this._isEmbeded;
    }

    public boolean isMultiRM() {
        return this._isMultiRM;
    }

    public String toString() {
        String string = this._ref + (this._isEmbeded ? ", embeded" : "") + (this._isMultiRM ? ", multirm" : "");
        String string2 = null;
        if (this._firstTime) {
            string2 = "[" + string + "]" + this._cf.toString();
            this._firstTime = false;
        } else {
            string2 = "[" + string + "]" + this._cf.getClass().getName();
        }
        return string2;
    }
}

