/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmsAvailability;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.inbound.ActiveInboundResourceAdapterImpl;
import com.sun.enterprise.connectors.jms.inflow.MdbContainerProps;
import com.sun.enterprise.connectors.jms.system.JMSConfigListener;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.rmi.Naming;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.grizzly.LazyServiceInitializer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ActiveJmsResourceAdapter
extends ActiveInboundResourceAdapterImpl
implements LazyServiceInitializer,
PostConstruct {
    static Logger _logger = LogDomains.getLogger(ActiveJmsResourceAdapter.class, (String)"javax.enterprise.resource.jms");
    private final String SETTER = "setProperty";
    private static final String SEPARATOR = "#";
    private static final String MQ_PASS_FILE_PREFIX = "asmq";
    private static final String MQ_PASS_FILE_KEY = "imq.imqcmd.password=";
    public static final String CONNECTION_URL = "ConnectionURL";
    private final String RECONNECTENABLED = "ReconnectEnabled";
    private final String RECONNECTINTERVAL = "ReconnectInterval";
    private final String RECONNECTATTEMPTS = "ReconnectAttempts";
    private static final String GROUPNAME = "GroupName";
    private static final String CLUSTERCONTAINER = "InClusteredContainer";
    public static final String BROKERTYPE = "BrokerType";
    private static final String BROKERINSTANCENAME = "BrokerInstanceName";
    private static final String BROKERBINDADDRESS = "BrokerBindAddress";
    private static final String BROKERPORT = "BrokerPort";
    private static final String BROKERARGS = "BrokerArgs";
    private static final String BROKERHOMEDIR = "BrokerHomeDir";
    private static final String BROKERLIBDIR = "BrokerLibDir";
    private static final String BROKERVARDIR = "BrokerVarDir";
    private static final String BROKERJAVADIR = "BrokerJavaDir";
    private static final String BROKERSTARTTIMEOUT = "BrokerStartTimeOut";
    public static final String ADMINUSERNAME = "AdminUsername";
    public static final String ADMINPASSWORD = "AdminPassword";
    private static final String ADMINPASSFILE = "AdminPassFile";
    private static final String USERNAME = "UserName";
    private static final String PASSWORD = "Password";
    private static final String MQ_PORTMAPPER_BIND = "doBind";
    private static final String MASTERBROKER = "MasterBroker";
    private static final String JMXSERVICEURL = "JMXServiceURL";
    private static final String JMXSERVICEURLLIST = "JMXServiceURLList";
    private static final String JMXCONNECTORENV = "JMXConnectorEnv";
    private static final String USEJNDIRMISERVICEURL = "useJNDIRMIServiceURL";
    private static final String RMIREGISTRYPORT = "RmiRegistryPort";
    private static final String USEEXTERNALRMIREGISTRY = "startRMIRegistry";
    private static final int DEFAULTRMIREGISTRYPORT = 7776;
    private static final int BROKERRMIPORTOFFSET = 100;
    private static final String SSLJMXCONNECTOR = "SslJMXConnector";
    private static final String CONVENTIONAL_CLUSTER_DB_PREFIX = "imq.cluster.sharecc.persist.jdbc.";
    private static final String ENHANCED_CLUSTER_DB_PREFIX = "imq.persist.jdbc.";
    private static final String HAREQUIRED = "HARequired";
    private static final String CLUSTERID = "ClusterId";
    private static final String BROKERID = "BrokerId";
    private static final String PINGINTERVAL = "PingInterval";
    private static final String DBTYPE = "DBType";
    private static final String DBTYPE_HADB = "hadb";
    private static final String BROKERENABLEHA = "BrokerEnableHA";
    private static final String DB_HADB_PROPS = "DBProps";
    private static final String DB_HADB_USER = "hadb.user";
    private static final String DB_HADB_PASSWORD = "hadb.password";
    private static final String DB_HADB_DRIVERCLASS = "hadb.driverClass";
    private static final String DS_HADB_PROPS = "DSProps";
    private static final String DS_HADB_SERVERLIST = "hadb.serverList";
    private final String CONTAINER = "InAppClientContainer";
    public static final String DESTINATION = "Destination";
    public static final String DESTINATION_TYPE = "DestinationType";
    private static String SUBSCRIPTION_NAME = "SubscriptionName";
    private static String CLIENT_ID = "ClientID";
    public static final String PHYSICAL_DESTINATION = "Name";
    private static String MAXPOOLSIZE = "EndpointPoolMaxSize";
    private static String MINPOOLSIZE = "EndpointPoolSteadySize";
    private static String RESIZECOUNT = "EndpointPoolResizeCount";
    private static String RESIZETIMEOUT = "EndpointPoolResizeTimeout";
    private static String REDELIVERYCOUNT = "EndpointExceptionRedeliveryAttempts";
    private static String LOWERCASE_REDELIVERYCOUNT = "endpointExceptionRedeliveryAttempts";
    public static final String ADDRESSLIST = "AddressList";
    private static String ADRLIST_BEHAVIOUR = "AddressListBehavior";
    private static String ADRLIST_ITERATIONS = "AddressListIterations";
    private static final String MDBIDENTIFIER = "MdbName";
    private static final String JMS_SERVICE = "mq-service";
    private static final String MCFADDRESSLIST = "MessageServiceAddressList";
    private StringManager sm = StringManager.getManager(ActiveJmsResourceAdapter.class);
    private MQAddressList urlList = null;
    private String addressList;
    private String brkrPort;
    private static final String DUSERNAME = "User";
    private static final String DPASSWORD = "Password";
    private static final String DSERVERLIST = "ServerList";
    private static final String HADB_CONNECTION_URL_PREFIX = "jdbc:sun:hadb:";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String DIRECT = "DIRECT";
    private final String DEFAULT_STORE_POOL_JNDI_NAME = "jdbc/hastore";
    private static String MQRmiPort = System.getProperty("com.sun.enterprise.connectors.system.MQRmiPort");
    private static final String DASRMIPORT = "31099";
    private static final String REVERT_TO_EMBEDDED_PROPERTY = "com.sun.enterprise.connectors.system.RevertToEmbedded";
    private static final String BROKER_RMI_PORT = "com.sun.enterprise.connectors.system.mq.rmiport";
    private static final String DEFAULT_SERVER = "server";
    private static final String DEFAULT_MQ_INSTANCE = "imqbroker";
    public static final String MQ_DIR_NAME = "imq";
    private Properties dbProps = null;
    private Properties dsProps = null;
    private String brokerInstanceName = null;
    private File mqPassFile = null;
    @Inject
    Habitat habitat;
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private GlassfishNamingManager nm;
    Domain domain = (Domain)Globals.get(Domain.class);

    public ActiveJmsResourceAdapter() {
        if (this.mqPassFile != null) {
            this.mqPassFile.delete();
        }
    }

    public void postConstruct() {
        try {
            JMSConfigListener jmsConfigListener = (JMSConfigListener)this.habitat.getComponent(JMSConfigListener.class);
            jmsConfigListener.setActiveResourceAdapter(this);
            JmsRaUtil raUtil = new JmsRaUtil();
            raUtil.upgradeIfNecessary();
        }
        catch (Throwable t) {
            t.printStackTrace();
            _logger.log(Level.FINE, "Cannot upgrade jmsra" + t.getMessage());
        }
    }

    protected void loadRAConfiguration() throws ConnectorRuntimeException {
        if (this.connectorRuntime.isServer()) {
            try {
                this.setLifecycleProperties();
            }
            catch (Exception e) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                throw (ConnectorRuntimeException)cre.initCause((Throwable)e);
            }
            this.setMdbContainerProperties();
            this.setJmsServiceProperties(null);
            this.setClusterRABeanProperties();
            this.setAvailabilityProperties();
        } else {
            this.setAppClientRABeanProperties();
        }
        super.loadRAConfiguration();
        this.postRAConfiguration();
    }

    protected void startResourceAdapter(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        try {
            if (this.moduleName_.equals("jmsra")) {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ResourceAdapterInternalException {
                        ActiveJmsResourceAdapter.this.resourceadapter_.start(ActiveJmsResourceAdapter.this.bootStrapContextImpl);
                        return null;
                    }
                });
            } else {
                this.resourceadapter_.start(this.bootStrapContextImpl);
            }
        }
        catch (PrivilegedActionException ex) {
            throw new ResourceAdapterInternalException((Throwable)ex);
        }
    }

    protected Set mergeRAConfiguration(ResourceAdapterConfig raConfig, List<Property> raConfigProps) {
        if (!this.connectorRuntime.isServer()) {
            return super.mergeRAConfiguration(raConfig, raConfigProps);
        }
        Set mergedProps = super.mergeRAConfiguration(raConfig, raConfigProps);
        String brokerType = null;
        for (ConnectorConfigProperty element : mergedProps) {
            if (!element.getName().equals(BROKERTYPE)) continue;
            brokerType = element.getValue();
        }
        boolean cluster = false;
        try {
            cluster = ActiveJmsResourceAdapter.isClustered();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!cluster && (brokerType.equals(LOCAL) || brokerType.equals(EMBEDDED) || brokerType.equals(DIRECT))) {
            Iterator iter = mergedProps.iterator();
            while (iter.hasNext()) {
                ConnectorConfigProperty element = (ConnectorConfigProperty)iter.next();
                if (!element.getName().equals(CONNECTION_URL)) continue;
                iter.remove();
            }
        }
        return mergedProps;
    }

    public void setup() throws ConnectorRuntimeException {
        if (this.connectionDefs_ == null) {
            throw new ConnectorRuntimeException("No Connection Defs defined in the RA.xml");
        }
        if (this.isServer() && !this.isSystemRar(this.moduleName_)) {
            this.createAllConnectorResources();
        }
        _logger.log(Level.FINE, "Completed Active Resource adapter setup", this.moduleName_);
    }

    private void setAvailabilityProperties() throws ConnectorRuntimeException {
        if (!ActiveJmsResourceAdapter.isClustered()) {
            return;
        }
        try {
            Domain domain = (Domain)Globals.get(Domain.class);
            ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
            Server server = domain.getServerNamed(serverContext.getInstanceName());
            JmsService jmsService = server.getConfig().getJmsService();
            AvailabilityService as = server.getConfig().getAvailabilityService();
            boolean useMasterBroker = true;
            if (as != null && as.getJmsAvailability() != null && !MASTERBROKER.equalsIgnoreCase(as.getJmsAvailability().getConfigStoreType())) {
                useMasterBroker = false;
            }
            boolean isJmsAvailabilityEnabled = this.isJMSAvailabilityOn(as);
            if (ActiveJmsResourceAdapter.isClustered() && (!useMasterBroker || isJmsAvailabilityEnabled)) {
                ActiveJmsResourceAdapter.logFine("Setting AvailabilityProperties.. ");
                if (jmsService.getType().equals(REMOTE)) {
                    return;
                }
                ConnectorDescriptor cd = this.getDescriptor();
                String clusterName = this.getMQClusterName();
                ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CLUSTERID, clusterName, "Cluster Id", "java.lang.String");
                this.setProperty(cd, envProp1);
                if (this.brokerInstanceName == null) {
                    this.brokerInstanceName = ActiveJmsResourceAdapter.getBrokerInstanceName(jmsService);
                }
                ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(BROKERID, this.brokerInstanceName, "Broker Id", "java.lang.String");
                this.setProperty(cd, envProp2);
                if (as == null) {
                    ActiveJmsResourceAdapter.logFine("Availability Service is null. Not setting HA attributes");
                    return;
                }
                if (isJmsAvailabilityEnabled) {
                    ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(HAREQUIRED, "true", "HA Required", "java.lang.String");
                    this.setProperty(cd, envProp3);
                    ConnectorConfigProperty envProp4 = new ConnectorConfigProperty(BROKERENABLEHA, "true", "BrokerEnableHA flag", "java.lang.Boolean");
                    this.setProperty(cd, envProp4);
                    String nodeHostName = domain.getNodeNamed(server.getNodeRef()).getNodeHost();
                    if (nodeHostName != null) {
                        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(BROKERBINDADDRESS, nodeHostName, "Broker Bind Address", "java.lang.String");
                        this.setProperty(cd, envProp5);
                    }
                    this.loadDBProperties(ENHANCED_CLUSTER_DB_PREFIX, as.getJmsAvailability());
                } else {
                    this.loadDBProperties(CONVENTIONAL_CLUSTER_DB_PREFIX, as.getJmsAvailability());
                }
            } else {
                ActiveJmsResourceAdapter.logFine("Instance not clustered. Not setting HA attributes");
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private void loadDBProperties(String prefix, JmsAvailability jmsAvailability) {
        if (this.dbProps == null) {
            this.dbProps = new Properties();
        }
        this.dbProps.setProperty("imq.cluster.clusterid", this.getMQClusterName());
        this.dbProps.setProperty("imq.persist.store", jmsAvailability.getMessageStoreType());
        if (!Boolean.valueOf(jmsAvailability.getAvailabilityEnabled()).booleanValue()) {
            this.dbProps.setProperty("imq.cluster.nomasterbroker", "true");
        } else {
            this.dbProps.setProperty("imq.brokerid", ActiveJmsResourceAdapter.getBrokerInstanceName(this.getJmsService()));
        }
        String dbVendor = jmsAvailability.getDbVendor();
        String dbuser = jmsAvailability.getDbUsername();
        String dbPassword = jmsAvailability.getDbPassword();
        String dbJdbcUrl = jmsAvailability.getDbUrl();
        this.dbProps.setProperty(prefix + "dbVendor", dbVendor);
        String fullprefix = prefix + dbVendor + ".";
        if (dbuser != null) {
            this.dbProps.setProperty(fullprefix + "user", dbuser);
        }
        if (dbPassword != null) {
            this.dbProps.setProperty(fullprefix + "password", dbPassword);
        }
        List dbprops = jmsAvailability.getProperty();
        String propertyPrefix = fullprefix + "property.";
        if (dbJdbcUrl != null) {
            if ("derby".equals(dbVendor)) {
                this.dbProps.setProperty(fullprefix + "opendburl", dbJdbcUrl);
            } else {
                this.dbProps.setProperty(propertyPrefix + "url", dbJdbcUrl);
            }
        }
        for (Object obj : dbprops) {
            Property prop = (Property)obj;
            String key = prop.getName();
            String value = prop.getValue();
            if (key.startsWith("imq.")) {
                this.dbProps.setProperty(key, value);
                continue;
            }
            this.dbProps.setProperty(propertyPrefix + key, value);
        }
    }

    protected void postRAConfiguration() throws ConnectorRuntimeException {
        try {
            Method mthds;
            if (this.dbProps == null) {
                this.dbProps = new Properties();
            }
            this.dbProps.setProperty("imq.cluster.dynamicChangeMasterBrokerEnabled", "true");
            if (this.dbProps != null && (mthds = this.resourceadapter_.getClass().getMethod("setBrokerProps", Properties.class)) != null) {
                ActiveJmsResourceAdapter.logFine("Setting property:DBProps=" + this.dbProps.toString());
                mthds.invoke((Object)this.resourceadapter_, this.dbProps);
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private boolean isJMSAvailabilityOn(AvailabilityService as) {
        if (as == null) {
            return false;
        }
        JmsAvailability ja = as.getJmsAvailability();
        boolean jmsAvailability = false;
        if (ja != null) {
            jmsAvailability = Boolean.parseBoolean(ja.getAvailabilityEnabled());
        }
        _logger.log(Level.FINE, "JMS availability :: " + jmsAvailability);
        return jmsAvailability;
    }

    private void setLifecycleProperties() throws Exception, ConnectorRuntimeException {
        String defaultJmsHost = this.getJmsService().getDefaultJmsHost();
        ActiveJmsResourceAdapter.logFine("Default JMS Host :: " + defaultJmsHost);
        JmsHost jmsHost = this.getJmsHost();
        if (jmsHost != null) {
            String brokerPort;
            JavaConfig javaConfig = (JavaConfig)Globals.get(JavaConfig.class);
            String java_home = javaConfig.getJavaHome();
            String brokerType = this.adjustForDirectMode(this.getJmsService().getType());
            this.brkrPort = brokerPort = jmsHost.getPort();
            String adminUserName = jmsHost.getAdminUserName();
            String adminPassword = JmsRaUtil.getUnAliasedPwd(jmsHost.getAdminPassword());
            List jmsHostProps = this.getJmsService().getProperty();
            String username = null;
            String password = null;
            if (jmsHostProps != null) {
                for (int i = 0; i < jmsHostProps.size(); ++i) {
                    Property jmsProp = (Property)jmsHostProps.get(i);
                    String propName = jmsProp.getName();
                    String propValue = jmsProp.getValue();
                    if ("user-name".equals(propName)) {
                        username = propValue;
                        continue;
                    }
                    if (!"password".equals(propName)) continue;
                    password = propValue;
                }
            }
            ActiveJmsResourceAdapter.logFine("Broker UserName = " + username);
            this.createMQVarDirectoryIfNecessary();
            String brokerVarDir = this.getMQVarDir();
            String tmpString = this.getJmsService().getStartArgs();
            if (tmpString == null) {
                tmpString = "";
            }
            String brokerArgs = tmpString;
            List jmsProperties = this.getJmsService().getProperty();
            List jmsHostProperties = jmsHost.getProperty();
            Properties jmsServiceProp = this.listToProperties(jmsProperties);
            Properties jmsHostProp = this.listToProperties(jmsHostProperties);
            jmsServiceProp.putAll((Map<?, ?>)jmsHostProp);
            if (jmsServiceProp.size() > 0) {
                if (this.dbProps == null) {
                    this.dbProps = new Properties();
                }
                this.dbProps.putAll((Map<?, ?>)jmsServiceProp);
            }
            String brokerHomeDir = this.getBrokerHomeDir();
            String brokerLibDir = this.getBrokerLibDir();
            if (this.brokerInstanceName == null) {
                this.brokerInstanceName = ActiveJmsResourceAdapter.getBrokerInstanceName(this.getJmsService());
            }
            long brokerTimeOut = this.getBrokerTimeOut(this.getJmsService());
            ConnectorDescriptor cd = this.getDescriptor();
            ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(BROKERTYPE, brokerType, "Broker Type", "java.lang.String");
            this.setProperty(cd, envProp1);
            ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(BROKERINSTANCENAME, this.brokerInstanceName, "Broker Instance Name", "java.lang.String");
            this.setProperty(cd, envProp2);
            ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(BROKERPORT, brokerPort, "Broker Port", "java.lang.String");
            this.setProperty(cd, envProp3);
            ConnectorConfigProperty envProp4 = new ConnectorConfigProperty(BROKERARGS, brokerArgs, "Broker Args", "java.lang.String");
            this.setProperty(cd, envProp4);
            ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(BROKERHOMEDIR, brokerHomeDir, "Broker Home Dir", "java.lang.String");
            this.setProperty(cd, envProp5);
            ConnectorConfigProperty envProp14 = new ConnectorConfigProperty(BROKERLIBDIR, brokerLibDir, "Broker Lib Dir", "java.lang.String");
            this.setProperty(cd, envProp14);
            ConnectorConfigProperty envProp6 = new ConnectorConfigProperty(BROKERJAVADIR, java_home, "Broker Java Dir", "java.lang.String");
            this.setProperty(cd, envProp6);
            ConnectorConfigProperty envProp7 = new ConnectorConfigProperty(BROKERVARDIR, brokerVarDir, "Broker Var Dir", "java.lang.String");
            this.setProperty(cd, envProp7);
            ConnectorConfigProperty envProp8 = new ConnectorConfigProperty(BROKERSTARTTIMEOUT, "" + brokerTimeOut, "Broker Start Timeout", "java.lang.String");
            this.setProperty(cd, envProp8);
            ConnectorConfigProperty envProp9 = new ConnectorConfigProperty(ADMINUSERNAME, adminUserName, "Broker admin username", "java.lang.String");
            this.setProperty(cd, envProp9);
            ConnectorConfigProperty envProp10 = new ConnectorConfigProperty(ADMINPASSWORD, adminPassword, "Broker admin password", "java.lang.String");
            this.setProperty(cd, envProp10);
            ConnectorConfigProperty envProp11 = new ConnectorConfigProperty(USERNAME, username, "Broker username", "java.lang.String");
            this.setProperty(cd, envProp11);
            ConnectorConfigProperty envProp12 = new ConnectorConfigProperty("Password", password, "Broker password", "java.lang.String");
            this.setProperty(cd, envProp12);
        }
    }

    private Properties listToProperties(List<Property> props) {
        Properties properties = new Properties();
        if (props != null) {
            for (Property prop : props) {
                String key = prop.getName();
                String value = prop.getValue();
                properties.setProperty(key, value);
            }
        }
        return properties;
    }

    private String adjustForDirectMode(String brokerType) {
        if (!ActiveJmsResourceAdapter.isClustered() && brokerType.equals(EMBEDDED)) {
            String revertToEmbedded = System.getProperty(REVERT_TO_EMBEDDED_PROPERTY);
            if (revertToEmbedded != null && revertToEmbedded.equals("true")) {
                return EMBEDDED;
            }
            return DIRECT;
        }
        return brokerType;
    }

    private long getBrokerTimeOut(JmsService jmsService) {
        long defaultTimeout;
        long timeout = defaultTimeout = 30000L;
        String specifiedTimeOut = jmsService.getInitTimeoutInSeconds();
        if (specifiedTimeOut != null) {
            timeout = (long)Integer.parseInt(specifiedTimeOut) * 1000L;
        }
        return timeout;
    }

    public static String getBrokerInstanceName(JmsService js) {
        ServerEnvironmentImpl serverenv = (ServerEnvironmentImpl)Globals.get(ServerEnvironmentImpl.class);
        Domain domain = (Domain)Globals.get(Domain.class);
        String asInstance = serverenv.getInstanceName();
        String domainName = null;
        if (ActiveJmsResourceAdapter.isClustered()) {
            Server server = domain.getServerNamed(asInstance);
            domainName = server.getCluster().getName();
        } else {
            domainName = serverenv.getDomainName();
        }
        String s = ActiveJmsResourceAdapter.getBrokerInstanceName(domainName, asInstance, js);
        ActiveJmsResourceAdapter.logFine("Got broker Instancename as " + s);
        String converted = ActiveJmsResourceAdapter.convertStringToValidMQIdentifier(s);
        ActiveJmsResourceAdapter.logFine("converted instance name " + converted);
        return converted;
    }

    public boolean handles(ConnectorDescriptor cd, String moduleName) {
        return ConnectorsUtil.isJMSRA((String)moduleName);
    }

    public void validateActivationSpec(ActivationSpec spec) {
        boolean validate = "true".equals(System.getProperty("validate.jms.ra"));
        if (validate) {
            try {
                spec.validate();
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "endpointfactory.as_validate_Failed", ex);
            }
        }
    }

    private static String getBrokerInstanceName(String asDomain, String asInstance, JmsService js) {
        List jmsProperties = js.getProperty();
        String instanceName = null;
        String suffix = null;
        if (jmsProperties != null) {
            for (int ii = 0; ii < jmsProperties.size(); ++ii) {
                Property p = (Property)jmsProperties.get(ii);
                String name = p.getName();
                if (name.equals("instance-name")) {
                    instanceName = p.getValue();
                }
                if (name.equals("instance-name-suffix")) {
                    suffix = p.getValue();
                }
                if (!name.equals("append-version") || !Boolean.valueOf(p.getValue()).booleanValue()) continue;
                suffix = Version.getMajorVersion() + "_" + Version.getMinorVersion();
            }
        }
        if (instanceName != null) {
            return instanceName;
        }
        instanceName = asInstance.equals(DEFAULT_SERVER) ? DEFAULT_MQ_INSTANCE : asDomain + "_" + asInstance;
        if (suffix != null) {
            instanceName = instanceName + "_" + suffix;
        }
        return instanceName;
    }

    private void createMQVarDirectoryIfNecessary() {
        String asInstanceRoot = this.getServerEnvironment().getInitFilePath().getPath();
        String mqInstanceDir = asInstanceRoot + File.separator + MQ_DIR_NAME;
        File instanceDir = new File(mqInstanceDir);
        if (!instanceDir.exists() || !instanceDir.isDirectory()) {
            instanceDir.mkdirs();
        }
    }

    private String getMQVarDir() {
        String asInstanceRoot = this.getServerEnvironment().getDomainRoot().getPath();
        String mqInstanceDir = asInstanceRoot + File.separator + MQ_DIR_NAME;
        return mqInstanceDir;
    }

    private String getBrokerLibDir() {
        String brokerLibDir = System.getProperty("com.sun.aas.imqLib");
        ActiveJmsResourceAdapter.logFine("broker lib dir from system property " + brokerLibDir);
        return brokerLibDir;
    }

    private String getBrokerHomeDir() {
        String brokerHomeDir = System.getProperty("com.sun.aas.imqBin");
        ActiveJmsResourceAdapter.logFine("broker home dir from system property " + brokerHomeDir);
        if (brokerHomeDir == null) {
            String IMQ_INSTALL_SUBDIR = File.separator + ".." + File.separator + ".." + File.separator + MQ_DIR_NAME;
            brokerHomeDir = this.getServerEnvironment().getDomainRoot() + IMQ_INSTALL_SUBDIR;
        } else {
            brokerHomeDir = brokerHomeDir + File.separator + "..";
        }
        ActiveJmsResourceAdapter.logFine("Broker Home Directory :: " + brokerHomeDir);
        ActiveJmsResourceAdapter.logFine("broker home dir finally" + brokerHomeDir);
        return brokerHomeDir;
    }

    private void setClusterRABeanProperties() throws ConnectorRuntimeException {
        ConnectorDescriptor cd = super.getDescriptor();
        try {
            if (ActiveJmsResourceAdapter.isClustered()) {
                JmsService jmsService = (JmsService)Globals.get(JmsService.class);
                String val = this.getGroupName();
                ConnectorConfigProperty envProp = new ConnectorConfigProperty(GROUPNAME, val, "Group Name", "java.lang.String");
                this.setProperty(cd, envProp);
                ActiveJmsResourceAdapter.logFine("CLUSTERED instance - setting groupname as" + val);
                boolean inClusteredContainer = false;
                if (jmsService.getType().equals(EMBEDDED) || jmsService.getType().equals(LOCAL)) {
                    inClusteredContainer = true;
                }
                ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CLUSTERCONTAINER, Boolean.toString(inClusteredContainer), "Cluster container flag", "java.lang.Boolean");
                this.setProperty(cd, envProp1);
                ActiveJmsResourceAdapter.logFine("CLUSTERED instance - setting inclusteredcontainer as" + inClusteredContainer);
                if (jmsService.getType().equals(REMOTE)) {
                    return;
                }
                if (!this.isDBEnabled()) {
                    String masterbrkr = this.getMasterBroker();
                    ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(MASTERBROKER, masterbrkr, "Master  Broker", "java.lang.String");
                    this.setProperty(cd, envProp2);
                    ActiveJmsResourceAdapter.logFine("MASTERBROKER - setting master broker val" + masterbrkr);
                }
            } else {
                ActiveJmsResourceAdapter.logFine("Instance not Clustered and hence not setting groupname");
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private boolean isDBEnabled() {
        Domain domain = (Domain)Globals.get(Domain.class);
        ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
        Server server = domain.getServerNamed(serverContext.getInstanceName());
        AvailabilityService as = server.getConfig().getAvailabilityService();
        JmsService jmsService = server.getConfig().getJmsService();
        if (as != null) {
            JmsAvailability jmsAvailability = as.getJmsAvailability();
            if (jmsAvailability.getAvailabilityEnabled() != null && Boolean.parseBoolean(jmsAvailability.getAvailabilityEnabled())) {
                return true;
            }
            if (jmsAvailability.getConfigStoreType() != null && !"MASTERBROKER".equalsIgnoreCase(jmsAvailability.getConfigStoreType())) {
                return true;
            }
        }
        return false;
    }

    private void setAppClientRABeanProperties() throws ConnectorRuntimeException {
        ActiveJmsResourceAdapter.logFine("In Appclient container!!!");
        ConnectorDescriptor cd = super.getDescriptor();
        ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(BROKERTYPE, REMOTE, "Broker Type", "java.lang.String");
        this.setProperty(cd, envProp1);
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(GROUPNAME, "", "Group Name", "java.lang.String");
        cd.removeConfigProperty(envProp2);
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(CLUSTERCONTAINER, "false", "Cluster flag", "java.lang.Boolean");
        this.setProperty(cd, envProp3);
    }

    private static boolean isClustered() {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        if (clusters == null) {
            return false;
        }
        List clusterList = clusters.getCluster();
        ServerContext serverctx = (ServerContext)Globals.get(ServerContext.class);
        return JmsRaUtil.isClustered(clusterList, serverctx.getInstanceName());
    }

    private String getGroupName() throws Exception {
        return this.getDomainName() + SEPARATOR + this.getClusterName();
    }

    private String getClusterName() {
        ServerContext serverctx = (ServerContext)Globals.get(ServerContext.class);
        String instanceName = serverctx.getInstanceName();
        Domain domain = (Domain)Globals.get(Domain.class);
        Server server = domain.getServerNamed(instanceName);
        return server.getCluster() != null ? server.getCluster().getName() : null;
    }

    private String getMQClusterName() {
        return ActiveJmsResourceAdapter.convertStringToValidMQIdentifier(this.getClusterName()) + "_MQ";
    }

    private String getMasterBroker() throws Exception {
        return this.urlList.getMasterBroker(this.getClusterName());
    }

    private static String convertStringToValidMQIdentifier(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLetterOrDigit(s.charAt(i))) continue;
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }

    private String getDomainName() throws Exception {
        return "";
    }

    public void reloadRA(JmsService js) throws ConnectorRuntimeException {
        this.setMdbContainerProperties();
        this.setJmsServiceProperties(js);
        super.loadRAConfiguration();
        this.rebindDescriptor();
    }

    public void addJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.addMQUrl(host);
        this.setAddressList();
    }

    public void deleteJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.removeMQUrl(host);
        this.setAddressList();
    }

    protected JmsHost getJmsHost() {
        String defaultJmsHost = this.getJmsService().getDefaultJmsHost();
        JmsHost jmsHost = null;
        if (defaultJmsHost == null || defaultJmsHost.equals("")) {
            jmsHost = (JmsHost)Globals.get(JmsHost.class);
        } else {
            List jmsHostsList = this.getJmsService().getJmsHost();
            for (int i = 0; i < jmsHostsList.size(); ++i) {
                JmsHost tmpJmsHost = (JmsHost)jmsHostsList.get(i);
                if (tmpJmsHost == null || !tmpJmsHost.getName().equals(defaultJmsHost)) continue;
                jmsHost = tmpJmsHost;
            }
            if (jmsHost == null) {
                jmsHost = jmsHostsList != null && jmsHostsList.size() > 0 ? (JmsHost)jmsHostsList.get(0) : (JmsHost)Globals.get(JmsHost.class);
            }
        }
        return jmsHost;
    }

    public void updateJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.updateMQUrl(host);
        this.setAddressList();
    }

    private void setMdbContainerProperties() throws ConnectorRuntimeException {
        JmsRaUtil raUtil = new JmsRaUtil(null);
        ConnectorDescriptor cd = super.getDescriptor();
        raUtil.setMdbContainerProperties();
        String val = "" + MdbContainerProps.getReconnectEnabled();
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty("ReconnectEnabled", val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        val = "" + MdbContainerProps.getReconnectDelay();
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty("ReconnectInterval", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = "" + MdbContainerProps.getReconnectMaxRetries();
        ConnectorConfigProperty envProp4 = new ConnectorConfigProperty("ReconnectAttempts", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
        String integrationMode = this.getJmsService().getType();
        boolean lazyInit = Boolean.valueOf(this.getJmsHost().getLazyInit());
        val = "true";
        if (EMBEDDED.equals(integrationMode) && lazyInit) {
            val = "false";
        }
        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(MQ_PORTMAPPER_BIND, val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp5);
    }

    private void setAddressList() throws ConnectorRuntimeException {
        try {
            JmsService jmsService = (JmsService)Globals.get(JmsService.class);
            this.setConnectionURL(jmsService, this.urlList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.loadRAConfiguration();
    }

    private void setConnectionURL(JmsService jmsService, MQAddressList urlList) {
        ConnectorDescriptor cd = super.getDescriptor();
        String val = urlList.toString();
        if (val != null) {
            _logger.log(Level.INFO, "jms.connection.url", val);
            ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CONNECTION_URL, val, val, "java.lang.String");
            this.setProperty(cd, envProp1);
        }
    }

    private void setJmsServiceProperties(JmsService service) throws ConnectorRuntimeException {
        JmsRaUtil jmsraUtil = new JmsRaUtil(service);
        jmsraUtil.setupAddressList();
        this.urlList = jmsraUtil.getUrlList();
        this.addressList = this.urlList.toString();
        _logger.log(Level.INFO, "addresslist.setjmsservice.provider", this.addressList);
        ConnectorDescriptor cd = super.getDescriptor();
        this.setConnectionURL(service, this.urlList);
        String val = "" + jmsraUtil.getReconnectEnabled();
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty("ReconnectEnabled", val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        int newval = new Integer(jmsraUtil.getReconnectInterval()) * 1000;
        val = "" + newval;
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty("ReconnectInterval", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = "" + jmsraUtil.getReconnectAttempts();
        ConnectorConfigProperty envProp4 = new ConnectorConfigProperty("ReconnectAttempts", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
        val = "" + jmsraUtil.getAddressListBehaviour();
        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(ADRLIST_BEHAVIOUR, val, val, "java.lang.String");
        this.setProperty(cd, envProp5);
        val = "" + jmsraUtil.getAddressListIterations();
        ConnectorConfigProperty envProp6 = new ConnectorConfigProperty(ADRLIST_ITERATIONS, val, val, "java.lang.Integer");
        this.setProperty(cd, envProp6);
        boolean useExternal = this.shouldUseExternalRmiRegistry(jmsraUtil);
        val = new Boolean(useExternal).toString();
        ConnectorConfigProperty envProp7 = new ConnectorConfigProperty(USEEXTERNALRMIREGISTRY, val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp7);
        _logger.log(Level.FINE, "Start RMI registry set as " + val);
        String configuredRmiRegistryPort = null;
        configuredRmiRegistryPort = !useExternal ? this.getRmiRegistryPort() : this.getUniqueRmiRegistryPort();
        val = configuredRmiRegistryPort;
        if (val != null) {
            ConnectorConfigProperty envProp8 = new ConnectorConfigProperty(RMIREGISTRYPORT, val, val, "java.lang.Integer");
            this.setProperty(cd, envProp8);
            _logger.log(Level.FINE, "RMI registry port set as " + val);
        } else {
            _logger.log(Level.WARNING, "invalid.rmi.registy.port");
        }
    }

    private boolean shouldUseExternalRmiRegistry(JmsRaUtil jmsraUtil) {
        boolean useExternalRmiRegistry = !this.isASRmiRegistryPortAvailable(jmsraUtil);
        return useExternalRmiRegistry;
    }

    private String getUniqueRmiRegistryPort() {
        int mqrmiport = 7776;
        try {
            String configuredport = System.getProperty(BROKER_RMI_PORT);
            mqrmiport = configuredport != null ? Integer.parseInt(configuredport) : Integer.parseInt(this.brkrPort) + 100;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "" + mqrmiport;
    }

    private String getRmiRegistryPort() {
        String val = null;
        if (MQRmiPort != null && !MQRmiPort.trim().equals("")) {
            return MQRmiPort;
        }
        String configuredPort = null;
        try {
            configuredPort = this.getConfiguredRmiRegistryPort();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getLocalizedMessage());
            _logger.log(Level.FINE, "Exception while getting configured rmi registry port", ex);
        }
        if (configuredPort != null) {
            return configuredPort;
        }
        if (this.isDAS()) {
            return DASRMIPORT;
        }
        return val;
    }

    private boolean isDAS() {
        return DEFAULT_SERVER.equals(this.getServerContext().getInstanceName());
    }

    private String getConfiguredRmiRegistryHost() throws Exception {
        return this.getJmxConnector().getAddress();
    }

    private String getConfiguredRmiRegistryPort() throws Exception {
        return this.getJmxConnector().getPort();
    }

    private JmxConnector getJmxConnector() throws Exception {
        List jmxConnectors = this.getAdminService().getJmxConnector();
        String sysJmsConnectorName = this.getAdminService().getSystemJmxConnectorName();
        if (jmxConnectors != null) {
            for (int i = 0; i < jmxConnectors.size(); ++i) {
                if (!sysJmsConnectorName.equals(((JmxConnector)jmxConnectors.get(i)).getName())) continue;
                return (JmxConnector)jmxConnectors.get(i);
            }
        }
        return null;
    }

    private boolean isASRmiRegistryPortAvailable(JmsRaUtil jmsraUtil) {
        ActiveJmsResourceAdapter.logFine("isASRmiRegistryPortAvailable - JMSService Type:" + jmsraUtil.getJMSServiceType());
        if (jmsraUtil.getJMSServiceType().equals(REMOTE) || jmsraUtil.getJMSServiceType().equals(LOCAL)) {
            return false;
        }
        String name = null;
        try {
            name = "rmi://" + this.getConfiguredRmiRegistryHost() + ":" + this.getConfiguredRmiRegistryPort();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Attempting to list " + name);
            }
            String[] ss = Naming.list(name);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("List on " + name + " succeeded");
            }
            return true;
        }
        catch (Exception e) {
            _logger.fine(e.getMessage() + " " + name);
            return false;
        }
    }

    private void setProperty(ConnectorDescriptor cd, ConnectorConfigProperty envProp) {
        cd.removeConfigProperty(envProp);
        cd.addConfigProperty(envProp);
    }

    private void rebindDescriptor() throws ConnectorRuntimeException {
        try {
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor((String)super.getModuleName());
            this.nm.publishObject(descriptorJNDIName, (Object)super.getDescriptor(), true);
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ne.getMessage());
            throw (ConnectorRuntimeException)cre.initCause((Throwable)ne);
        }
    }

    public ManagedConnectionFactory[] createManagedConnectionFactories(ConnectorConnectionPool cpr, ClassLoader loader) {
        _logger.log(Level.FINE, "RECOVERY : Entering createMCFS in AJMSRA");
        ArrayList<ManagedConnectionFactory> mcfs = new ArrayList<ManagedConnectionFactory>();
        if (this.getAddressListCount() < 2) {
            mcfs.add(this.createManagedConnectionFactory(cpr, loader));
            _logger.log(Level.FINE, "Brokers are not clustered,So doing normal recovery");
        } else {
            String addlist = null;
            Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
            for (ConnectorConfigProperty prop : s) {
                String propName = prop.getName();
                if (!propName.equalsIgnoreCase("imqAddressList") && !propName.equalsIgnoreCase("Addresslist")) continue;
                addlist = prop.getValue();
            }
            StringTokenizer tokenizer = null;
            tokenizer = addlist == null || addlist.trim().equalsIgnoreCase("localhost") ? new StringTokenizer(this.addressList, ",") : new StringTokenizer(addlist, ",");
            _logger.log(Level.FINE, "No of addresses found " + tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String brokerurl = tokenizer.nextToken();
                ManagedConnectionFactory mcf = super.createManagedConnectionFactory(cpr, loader);
                for (ConnectorConfigProperty prop : s) {
                    String propName = prop.getName();
                    String propValue = prop.getValue();
                    if (!propName.startsWith(MQ_DIR_NAME) || propValue == "") continue;
                    try {
                        Method meth = mcf.getClass().getMethod("setProperty", String.class, String.class);
                        if (propName.trim().equalsIgnoreCase("imqAddressList")) {
                            meth.invoke((Object)mcf, prop.getName(), brokerurl);
                            continue;
                        }
                        meth.invoke((Object)mcf, prop.getName(), prop.getValueObject());
                    }
                    catch (NoSuchMethodException ex) {
                        _logger.log(Level.WARNING, "no.such.method", new Object[]{"setProperty", mcf.getClass().getName()});
                    }
                    catch (Exception ex) {
                        _logger.log(Level.SEVERE, "error.execute.method", new Object[]{"setProperty", mcf.getClass().getName()});
                    }
                }
                ConnectorConfigProperty addressProp3 = new ConnectorConfigProperty(ADDRESSLIST, brokerurl, "Address List", "java.lang.String");
                _logger.log(Level.INFO, "addresslist", brokerurl);
                HashSet<ConnectorConfigProperty> addressProp = new HashSet<ConnectorConfigProperty>();
                addressProp.add(addressProp3);
                SetMethodAction setMethodAction = new SetMethodAction((Object)mcf, addressProp);
                try {
                    setMethodAction.run();
                }
                catch (Exception e) {
                    // empty catch block
                }
                mcfs.add(mcf);
            }
        }
        return mcfs.toArray(new ManagedConnectionFactory[0]);
    }

    protected ManagedConnectionFactory instantiateMCF(final String mcfClass, final ClassLoader loader) throws Exception {
        ManagedConnectionFactory mcf = null;
        if (this.moduleName_.equals("jmsra")) {
            Object tmp = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ActiveJmsResourceAdapter.this.instantiateManagedConnectionFactory(mcfClass, loader);
                }
            });
            mcf = (ManagedConnectionFactory)tmp;
        }
        return mcf;
    }

    private ManagedConnectionFactory instantiateManagedConnectionFactory(String mcfClass, ClassLoader loader) throws Exception {
        return super.instantiateMCF(mcfClass, loader);
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool cpr, ClassLoader loader) {
        ManagedConnectionFactory mcf = super.createManagedConnectionFactory(cpr, loader);
        if (mcf != null) {
            Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
            for (ConnectorConfigProperty prop : s) {
                String propName = prop.getName();
                if (!propName.startsWith(MQ_DIR_NAME) || prop.getValue() == "") continue;
                try {
                    Method meth = mcf.getClass().getMethod("setProperty", String.class, String.class);
                    meth.invoke((Object)mcf, prop.getName(), prop.getValueObject());
                }
                catch (NoSuchMethodException ex) {
                    _logger.log(Level.WARNING, "no.such.method", new Object[]{"setProperty", mcf.getClass().getName()});
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "error.execute.method", new Object[]{"setProperty", mcf.getClass().getName()});
                }
            }
            String moduleName = this.getModuleName();
            if (ConnectorAdminServiceUtils.isJMSRA((String)moduleName)) {
                try {
                    Set configProperties = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
                    Object[] array = configProperties.toArray();
                    for (int i = 0; i < array.length; ++i) {
                        ConnectorConfigProperty property;
                        if (!(array[i] instanceof ConnectorConfigProperty) || !ADDRESSLIST.equals((property = (ConnectorConfigProperty)array[i]).getName()) || property.getValue() != null && !"".equals(property.getValue()) && !"localhost".equals(property.getValue())) continue;
                        _logger.log(Level.FINE, "raraddresslist.default.value", property.getValue());
                        configProperties.remove(property);
                    }
                    SetMethodAction setMethodAction = new SetMethodAction((Object)mcf, configProperties);
                    setMethodAction.run();
                }
                catch (Exception Ex) {
                    String mcfClass = cpr.getConnectorDescriptorInfo().getManagedConnectionFactoryClass();
                    _logger.log(Level.WARNING, "rardeployment.mcfcreation_error", new Object[]{mcfClass, Ex.getMessage()});
                    _logger.log(Level.FINE, "rardeployment.mcfcreation_error", Ex);
                }
            }
        }
        return mcf;
    }

    public void updateMDBRuntimeInfo(EjbMessageBeanDescriptor descriptor_, BeanPoolDescriptor poolDescriptor) throws ConnectorRuntimeException {
        String jndiName = descriptor_.getJndiName();
        if (jndiName == null || "".equals(jndiName)) {
            _logger.log(Level.SEVERE, "Missing Destination JNDI Name");
            String msg = this.sm.getString("ajra.error_in_dd");
            throw new ConnectorRuntimeException(msg);
        }
        String resourceAdapterMid = "jmsra";
        descriptor_.setResourceAdapterMid(resourceAdapterMid);
        String appName = descriptor_.getApplication().getAppName();
        String moduleName = ConnectorsUtil.getModuleName((EjbMessageBeanDescriptor)descriptor_);
        String destName = this.getPhysicalDestinationFromConfiguration(jndiName, appName, moduleName);
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION, destName, null));
        if (descriptor_.getDestinationType() != null && !"".equals(descriptor_.getDestinationType())) {
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, descriptor_.getDestinationType(), null));
        } else {
            try {
                String instanceName = this.getServerEnvironment().getInstanceName();
                List serversList = this.getServers().getServer();
                Server server = null;
                for (int j = 0; j < serversList.size(); ++j) {
                    if (!instanceName.equals(((Server)serversList.get(j)).getName())) continue;
                    server = (Server)serversList.get(j);
                }
                AdminObjectResource aor = (AdminObjectResource)ResourcesUtil.createInstance().getResource(jndiName, appName, moduleName, AdminObjectResource.class);
                if (aor != null && "jmsra".equals(aor.getResAdapter())) {
                    descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, aor.getResType(), null));
                    _logger.log(Level.INFO, "endpoint.determine.destinationtype", new Object[]{aor.getResType(), aor.getJndiName(), descriptor_.getName()});
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(SUBSCRIPTION_NAME, descriptor_.getDurableSubscriptionName(), null));
        String mdbCF = null;
        try {
            mdbCF = descriptor_.getIASEjbExtraDescriptors().getMdbConnectionFactory().getJndiName();
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        if (mdbCF != null && mdbCF != "") {
            this.setValuesFromConfiguration(mdbCF, descriptor_);
        }
        if (poolDescriptor != null) {
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MAXPOOLSIZE, "" + poolDescriptor.getMaxPoolSize(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MINPOOLSIZE, "" + poolDescriptor.getSteadyPoolSize(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZECOUNT, "" + poolDescriptor.getPoolResizeQuantity(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZETIMEOUT, "" + poolDescriptor.getPoolIdleTimeoutInSeconds(), "", "java.lang.Integer"));
            if (descriptor_.getActivationConfigValue(REDELIVERYCOUNT) == null && descriptor_.getActivationConfigValue(LOWERCASE_REDELIVERYCOUNT) == null) {
                descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(REDELIVERYCOUNT, "" + MdbContainerProps.getMaxRuntimeExceptions(), "", "java.lang.Integer"));
            }
        }
        try {
            boolean clustered = ActiveJmsResourceAdapter.isClustered();
            ActiveJmsResourceAdapter.logFine("Are we in a Clustered contained ? " + clustered);
            if (clustered) {
                this.setClusterActivationSpecProperties(descriptor_);
                ActiveJmsResourceAdapter.logFine("Creating physical destination " + destName);
                ActiveJmsResourceAdapter.logFine("Destination is Queue? " + descriptor_.hasQueueDest());
                if (descriptor_.hasQueueDest()) {
                    this.autoCreatePhysicalDest(destName, true);
                } else {
                    this.autoCreatePhysicalDest(destName, false);
                }
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    void autoCreatePhysicalDest(String destName, boolean isQueue) throws ConnectorRuntimeException {
        if (destName == null || destName.indexOf("*") != -1 || destName.indexOf(">") == -1) {
            // empty if block
        }
    }

    private void setClusterActivationSpecProperties(EjbMessageBeanDescriptor descriptor_) throws Exception {
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MDBIDENTIFIER, "" + this.getMDBIdentifier(descriptor_), "MDB Identifier", "java.lang.String"));
        ActiveJmsResourceAdapter.logFine("CLUSTERED instance - setting MDB identifier as" + this.getMDBIdentifier(descriptor_));
    }

    private String getMDBIdentifier(EjbMessageBeanDescriptor descriptor_) throws Exception {
        return this.getDomainName() + SEPARATOR + this.getClusterName() + SEPARATOR + descriptor_.getUniqueId();
    }

    private String getPhysicalDestinationFromConfiguration(String logicalDest, String appName, String moduleName) throws ConnectorRuntimeException {
        Property ep = null;
        try {
            AdminObjectResource res = null;
            res = (AdminObjectResource)ResourcesUtil.createInstance().getResource(logicalDest, appName, moduleName, AdminObjectResource.class);
            if (res == null) {
                String msg = this.sm.getString("ajra.err_getting_dest", (Object)logicalDest);
                throw new ConnectorRuntimeException(msg);
            }
            ep = res.getProperty(PHYSICAL_DESTINATION);
        }
        catch (Exception ce) {
            String msg = this.sm.getString("ajra.err_getting_dest", (Object)logicalDest);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            cre.initCause((Throwable)ce);
            throw cre;
        }
        if (ep == null) {
            String msg = this.sm.getString("ajra.cannot_find_phy_dest", (Object)ep);
            throw new ConnectorRuntimeException(msg);
        }
        return ep.getValue();
    }

    private void setValuesFromConfiguration(String cfName, EjbMessageBeanDescriptor descriptor_) throws ConnectorRuntimeException {
        List ep = null;
        try {
            String appName = descriptor_.getApplication().getAppName();
            String moduleName = ConnectorsUtil.getModuleName((EjbMessageBeanDescriptor)descriptor_);
            ConnectorResource res = (ConnectorResource)ResourcesUtil.createInstance().getResource(cfName, appName, moduleName, ConnectorResource.class);
            if (res == null) {
                String msg = this.sm.getString("ajra.mdb_cf_not_created", (Object)cfName);
                throw new ConnectorRuntimeException(msg);
            }
            com.sun.enterprise.config.serverbeans.ConnectorConnectionPool ccp = (com.sun.enterprise.config.serverbeans.ConnectorConnectionPool)ResourcesUtil.createInstance().getResource(res.getPoolName(), appName, moduleName, com.sun.enterprise.config.serverbeans.ConnectorConnectionPool.class);
            ep = ccp.getProperty();
        }
        catch (Exception ce) {
            String msg = this.sm.getString("ajra.mdb_cf_not_created", (Object)cfName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            cre.initCause((Throwable)ce);
            throw cre;
        }
        if (ep == null) {
            String msg = this.sm.getString("ajra.cannot_find_phy_dest");
            throw new ConnectorRuntimeException(msg);
        }
        for (int i = 0; i < ep.size(); ++i) {
            String val;
            Property prop = (Property)ep.get(i);
            String name = prop.getName();
            if (name.equals(MCFADDRESSLIST)) {
                name = ADDRESSLIST;
            }
            if ((val = prop.getValue()) == null || val.equals("")) continue;
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(name, val, null));
        }
    }

    private static void logFine(String s) {
        _logger.fine(s);
    }

    public int getAddressListCount() {
        StringTokenizer tokenizer = null;
        int count = 1;
        if (this.addressList != null) {
            tokenizer = new StringTokenizer(this.addressList, ",");
            count = tokenizer.countTokens();
        }
        ActiveJmsResourceAdapter.logFine("Address list count is " + count);
        return count;
    }

    private ServerEnvironmentImpl getServerEnvironment() {
        return (ServerEnvironmentImpl)this.habitat.getComponent(ServerEnvironmentImpl.class);
    }

    private AdminService getAdminService() {
        return (AdminService)this.habitat.getComponent(AdminService.class);
    }

    private Servers getServers() {
        return (Servers)this.habitat.getComponent(Servers.class);
    }

    private JmsService getJmsService() {
        Domain domain = (Domain)Globals.get(Domain.class);
        String serverName = System.getProperty("com.sun.aas.instanceName");
        Server server = domain.getServerNamed(serverName);
        Config config = server.getConfig();
        return config.getJmsService();
    }

    private ServerContext getServerContext() {
        return (ServerContext)this.habitat.getComponent(ServerContext.class);
    }

    public String getServiceName() {
        return JMS_SERVICE;
    }

    public boolean initializeService() {
        try {
            String module = "jmsra";
            String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
            ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.habitat.getComponent(ConnectorRuntime.class);
            connectorRuntime.createActiveResourceAdapter(loc, module, null);
            return true;
        }
        catch (ConnectorRuntimeException e) {
            e.printStackTrace();
            e.printStackTrace();
            return false;
        }
    }

    public void handleRequest(SelectableChannel selectableChannel) {
        SocketChannel socketChannel = null;
        if (selectableChannel instanceof SocketChannel) {
            socketChannel = (SocketChannel)selectableChannel;
            try {
                Class<?> c = this.resourceadapter_.getClass();
                Method m = c.getMethod("getPortMapperClientHandler", null);
                Object handler = m.invoke((Object)this.resourceadapter_, null);
                m = handler.getClass().getMethod("handleRequest", SocketChannel.class);
                m.invoke(handler, socketChannel);
            }
            catch (Exception ex) {
                String message = this.sm.getString("error.invoke.portmapper", (Object)ex.getLocalizedMessage());
                throw new RuntimeException(message, ex);
            }
        } else {
            throw new IllegalArgumentException(this.sm.getString("invalid.socket.channel"));
        }
    }

    public void setMasterBroker(String newMasterBroker) {
        try {
            Class<?> c = this.resourceadapter_.getClass();
            Method m = c.getMethod("setMasterBroker", String.class);
            m.invoke((Object)this.resourceadapter_, newMasterBroker);
            _logger.log(Level.INFO, "set.master.broker.success", newMasterBroker);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "set.master.broker.fail", new Object[]{newMasterBroker, ex.getMessage()});
        }
    }

    protected void setClusterBrokerList(String brokerList) {
        try {
            Class<?> c = this.resourceadapter_.getClass();
            Method m = c.getMethod("setClusterBrokerList", String.class);
            m.invoke((Object)this.resourceadapter_, brokerList);
            _logger.log(Level.INFO, "set.cluster.brokerlist.success", brokerList);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "set.cluster.brokerlist.fail", new Object[]{brokerList, ex.getMessage()});
        }
    }
}

