/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.audit;

import com.sun.messaging.jmq.jmsserver.audit.MQAuditService;
import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class MQAuditManager
extends MQAuditSession {
    private MQAuditSession logAuditSession = null;
    private MQAuditSession bsmAuditSession = null;

    MQAuditManager() {
        if (!MQAuditService.AUDIT_LOGGING_LICENSED) {
            return;
        }
        if (MQAuditService.logAuditEnabled) {
            try {
                this.logAuditSession = MQAuditService.getAuditSession("log");
                this.auditOn = this.logAuditSession.isAuditOn();
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, "Failed to get audit session to log audit records");
            }
        }
        if (MQAuditService.bsmAudit) {
            try {
                this.bsmAuditSession = MQAuditService.getAuditSession("bsm");
                this.auditOn = this.auditOn || this.bsmAuditSession.isAuditOn();
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, "Failed to get audit session to log BSM audit records");
            }
        }
    }

    public void setInstance(String string, String string2, int n) {
        super.setInstance(string, string2, n);
        if (this.logAuditSession != null) {
            this.logAuditSession.setInstance(string, string2, n);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.setInstance(string, string2, n);
        }
    }

    public void authentication(String string, String string2, boolean bl) {
        if (this.logAuditSession != null) {
            this.logAuditSession.authentication(string, string2, bl);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.authentication(string, string2, bl);
        }
    }

    public void brokerOperation(String string, String string2, String string3) {
        if (this.logAuditSession != null) {
            this.logAuditSession.brokerOperation(string, string2, string3);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.brokerOperation(string, string2, string3);
        }
    }

    public void connectionAuth(String string, String string2, String string3, String string4, boolean bl) {
        if (this.logAuditSession != null) {
            this.logAuditSession.connectionAuth(string, string2, string3, string4, bl);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.connectionAuth(string, string2, string3, string4, bl);
        }
    }

    public void destinationAuth(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.logAuditSession != null) {
            this.logAuditSession.destinationAuth(string, string2, string3, string4, string5, bl);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.destinationAuth(string, string2, string3, string4, string5, bl);
        }
    }

    public void storeOperation(String string, String string2, String string3) {
        if (this.logAuditSession != null) {
            this.logAuditSession.storeOperation(string, string2, string3);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.storeOperation(string, string2, string3);
        }
    }

    public void destinationOperation(String string, String string2, String string3, String string4, String string5) {
        if (this.logAuditSession != null) {
            this.logAuditSession.destinationOperation(string, string2, string3, string4, string5);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.destinationOperation(string, string2, string3, string4, string5);
        }
    }

    public void durableSubscriberOperation(String string, String string2, String string3, String string4, String string5) {
        if (this.logAuditSession != null) {
            this.logAuditSession.durableSubscriberOperation(string, string2, string3, string4, string5);
        }
        if (this.bsmAuditSession != null) {
            this.bsmAuditSession.durableSubscriberOperation(string, string2, string3, string4, string5);
        }
    }
}

