/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.MessageInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore200;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;

class MsgStore {
    static final String MESSAGE_FDPOOL_LIMIT_PROP = "imq.persist.file.message.fdpool.limit";
    static final int DEFAULT_MESSAGE_FDPOOL_LIMIT = 0;
    static final String FILE_POOL_LIMIT_PROP = "imq.persist.file.destination.message.filepool.limit";
    static final int DEFAULT_MESSAGE_FILE_POOL_LIMIT = 100;
    static final String FILE_POOL_CLEANRATIO_PROP = "imq.persist.file.message.filepool.cleanratio";
    static final int DEFAULT_FILE_POOL_CLEANRATIO = 60;
    static final String CLEANUP_MSGSTORE_PROP = "imq.persist.file.message.cleanup";
    static final boolean DEFAULT_CLEANUP_MSGSTORE = true;
    static final String INITIAL_VRFILE_SIZE_PROP = "imq.persist.file.message.vrfile.initial_size";
    static final long DEFAULT_INITIAL_VRFILE_SIZE = 1024L;
    static final String VRFILE_BLOCK_SIZE_PROP = "imq.persist.file.message.vrfile.block_size";
    static final int DEFAULT_VRFILE_BLOCK_SIZE = 256;
    static final String VRFILE_MAX_RECORD_SIZE_PROP = "imq.persist.file.message.max_record_size";
    static final long DEFAULT_VRFILE_MAX_RECORD_SIZE = 1024L;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private BrokerConfig config = Globals.getConfig();
    private static final String MESSAGE_DIR = "message" + File.separator;
    private File msgDir = null;
    int msgfdlimit = 0;
    int poollimit = 100;
    int cleanratio = 60;
    SizeString initialFileSize = null;
    SizeString maxRecordSize = null;
    int blockSize = 0;
    private HashMap dstMap = new HashMap();
    private FileStore parent = null;
    private static final Enumeration emptyEnum = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };

    MsgStore(FileStore fileStore, File file, boolean bl) throws BrokerException {
        this.init(fileStore, file);
        if (bl) {
            if (Store.getDEBUG()) {
                this.logger.log(1, "MsgStore initialized with reset option");
            }
            this.clearAll(false);
        }
    }

    MsgStore(FileStore fileStore, File file, File file2, boolean bl) throws BrokerException {
        this.init(fileStore, file);
        if (bl) {
            File file3 = new File(file2, MESSAGE_DIR);
            try {
                FileUtil.removeFiles((File)file3, (boolean)false);
            }
            catch (IOException iOException) {
                this.logger.log(32, "B4149", (Object)file3, (Throwable)iOException);
                throw new BrokerException(this.br.getString("B4149", file3), iOException);
            }
        }
        boolean bl2 = fileStore.upgradeNoBackup();
        try {
            MsgStore200 msgStore200 = new MsgStore200(new File(file2, MESSAGE_DIR));
            while (msgStore200.hasMoreMessages()) {
                Packet packet = msgStore200.nextMessage();
                ConsumerUID[] consumerUIDArray = msgStore200.nextCUIDs();
                int[] nArray = msgStore200.nextStates();
                DestinationUID destinationUID = DestinationUID.getUID(packet.getDestination(), packet.getIsQueue());
                this.storeMessage(destinationUID, packet, consumerUIDArray, nArray, false);
                if (!bl2) continue;
                msgStore200.removeData(packet.getSysMessageID(), false);
            }
            msgStore200.close();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4153", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4153"), iOException);
        }
    }

    private void init(FileStore fileStore, File file) throws BrokerException {
        this.msgfdlimit = this.config.getIntProperty(MESSAGE_FDPOOL_LIMIT_PROP, 0);
        this.poollimit = this.config.getIntProperty(FILE_POOL_LIMIT_PROP, 100);
        this.cleanratio = this.config.getIntProperty(FILE_POOL_CLEANRATIO_PROP, 60);
        this.initialFileSize = this.config.getSizeProperty(INITIAL_VRFILE_SIZE_PROP, 1024L);
        this.blockSize = this.config.getIntProperty(VRFILE_BLOCK_SIZE_PROP, 256);
        this.maxRecordSize = this.config.getSizeProperty(VRFILE_MAX_RECORD_SIZE_PROP, 1024L);
        this.msgDir = new File(file, MESSAGE_DIR);
        if (!this.msgDir.exists() && !this.msgDir.mkdirs()) {
            this.logger.log(32, "B3017", (Object)this.msgDir.toString());
            throw new BrokerException(this.br.getString("B3017", this.msgDir.toString()));
        }
        this.parent = fileStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getDebugState() {
        Hashtable hashtable = new Hashtable();
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            for (DstMsgStore dstMsgStore : this.dstMap.values()) {
                hashtable.putAll(dstMsgStore.getDebugState());
            }
        }
        return hashtable;
    }

    void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        long l;
        long l2;
        if (Store.getDEBUG()) {
            this.logger.log(1, "storeMessage for " + destinationUID);
        }
        if (Globals.isNewTxnLogEnabled() && TransactionLogManager.logNonTransactedMsgSend && !TransactionLogManager.isReplayInProgress() && (l2 = packet.getTransactionID()) <= 0L) {
            TransactionWorkMessage transactionWorkMessage = new TransactionWorkMessage(destinationUID, packet, consumerUIDArray);
            this.parent.logNonTxnMessage(transactionWorkMessage);
            bl = false;
        }
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true, true, true);
        MessageInfo messageInfo = dstMsgStore.storeMessage(packet, consumerUIDArray, nArray, bl);
        if (Globals.logNonTransactedMsgSend() && !Globals.isNewTxnLogEnabled() && (l = packet.getTransactionID()) <= 0L) {
            byte[] byArray = messageInfo.getCachedMessageBytes();
            if (byArray == null) {
                byArray = packet.getBytes();
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 12);
            byteBuffer.putLong(l);
            byteBuffer.putInt(1);
            byteBuffer.put(byArray);
            this.parent.logTxn(1, byteBuffer.array());
        }
    }

    Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        try {
            return this.getDstMsgStore(destinationUID).getMessage(sysMessageID);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4107", (Object)sysMessageID.toString(), (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4107", sysMessageID.toString()), iOException);
        }
    }

    boolean containsMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true, true, true);
        return dstMsgStore.containsMsg(sysMessageID);
    }

    void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl) throws IOException, BrokerException {
        this.getDstMsgStore(destinationUID).removeMessage(sysMessageID, bl);
    }

    void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        SysMessageID sysMessageID = packet.getSysMessageID();
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true, true, false);
        if (dstMsgStore == null || !dstMsgStore.containsMsg(sysMessageID)) {
            this.logger.log(32, "B3007", (Object)sysMessageID, (Object)destinationUID);
            throw new BrokerException(this.br.getString("B3007", sysMessageID, destinationUID));
        }
        this.storeMessage(destinationUID2, packet, consumerUIDArray, nArray, bl);
        try {
            dstMsgStore.removeMessage(packet.getSysMessageID(), bl);
        }
        catch (BrokerException brokerException) {
            this.getDstMsgStore(destinationUID2).removeMessage(packet.getSysMessageID(), bl);
            Object[] objectArray = new Object[]{sysMessageID, destinationUID, destinationUID2};
            this.logger.log(32, "B4187", objectArray, (Throwable)brokerException);
            throw brokerException;
        }
    }

    public boolean hasMessageBeenAcked(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getDstMsgStore(destinationUID).getMessageInfo(sysMessageID).hasMessageBeenAck();
    }

    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destination.getDestinationUID(), true, false, false);
        if (dstMsgStore != null) {
            return dstMsgStore.getStorageInfo();
        }
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compactDestination(Destination destination) throws BrokerException {
        if (destination != null) {
            DstMsgStore dstMsgStore = this.getDstMsgStore(destination.getDestinationUID(), true, false, false);
            if (dstMsgStore != null) {
                dstMsgStore.compact();
            }
        } else {
            Iterator iterator = null;
            Object object = this.dstMap;
            synchronized (object) {
                iterator = ((HashMap)this.dstMap.clone()).values().iterator();
            }
            while (iterator.hasNext()) {
                object = (DstMsgStore)iterator.next();
                ((DstMsgStore)object).compact();
            }
        }
    }

    void removeAllMessages(DestinationUID destinationUID, boolean bl) throws IOException, BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true, false, false);
        if (dstMsgStore != null) {
            dstMsgStore.removeAllMessages(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMessageDir(DestinationUID destinationUID, boolean bl) throws IOException, BrokerException {
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.remove(destinationUID);
            if (dstMsgStore != null) {
                dstMsgStore.releaseMessageDir(bl);
            }
        }
    }

    Enumeration messageEnumeration() {
        Enumeration enumeration = new Enumeration(){
            Iterator dstitr;
            Enumeration tempenum;
            Object nextToReturn;
            {
                this.dstitr = MsgStore.this.parent.getDstStore().getDestinations().iterator();
                this.tempenum = null;
                this.nextToReturn = null;
            }

            public boolean hasMoreElements() {
                while (true) {
                    if (this.tempenum != null) {
                        if (this.tempenum.hasMoreElements()) {
                            this.nextToReturn = this.tempenum.nextElement();
                            return true;
                        }
                        this.tempenum = null;
                        continue;
                    }
                    while (this.dstitr.hasNext()) {
                        Destination destination = (Destination)this.dstitr.next();
                        try {
                            this.tempenum = MsgStore.this.messageEnumeration(destination.getDestinationUID());
                            break;
                        }
                        catch (BrokerException brokerException) {
                            Logger logger = MsgStore.this.logger;
                            MsgStore.this.logger;
                            MsgStore.this.br;
                            logger.log(32, "B4145", (Object)destination.getDestinationUID(), (Throwable)brokerException);
                        }
                    }
                    if (this.tempenum == null) break;
                }
                return false;
            }

            public Object nextElement() {
                if (this.nextToReturn != null) {
                    Object object = this.nextToReturn;
                    this.nextToReturn = null;
                    return object;
                }
                throw new NoSuchElementException();
            }
        };
        return enumeration;
    }

    Enumeration messageEnumeration(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true, false, false);
        if (dstMsgStore != null) {
            return dstMsgStore.messageEnumeration();
        }
        return emptyEnum;
    }

    int getMessageCount(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true, false, false);
        if (dstMsgStore != null) {
            return dstMsgStore.getMessageCount();
        }
        return 0;
    }

    long getByteCount(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true, false, false);
        if (dstMsgStore != null) {
            return dstMsgStore.getByteCount();
        }
        return 0L;
    }

    void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        try {
            if (Globals.isNewTxnLogEnabled()) {
                DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true, true, true);
            }
            this.getDstMsgStore(destinationUID).storeInterestStates(sysMessageID, consumerUIDArray, nArray, bl);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4105", (Object)sysMessageID.toString());
            throw new BrokerException(this.br.getString("B4105", sysMessageID.toString()), iOException);
        }
    }

    void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        try {
            this.getDstMsgStore(destinationUID).updateInterestState(sysMessageID, consumerUID, n, bl);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4015", (Object)consumerUID.toString(), (Object)sysMessageID.toString());
            throw new BrokerException(this.br.getString("B4015", consumerUID.toString(), sysMessageID.toString()), iOException);
        }
    }

    int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        return this.getDstMsgStore(destinationUID).getMessageInfo(sysMessageID).getInterestState(consumerUID);
    }

    HashMap getInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getDstMsgStore(destinationUID).getMessageInfo(sysMessageID).getInterestStates();
    }

    ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getDstMsgStore(destinationUID).getMessageInfo(sysMessageID).getConsumerUIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll(boolean bl) throws BrokerException {
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            if (this.dstMap != null) {
                this.closeAllDstMsgStore(false);
                this.dstMap.clear();
            }
            try {
                FileUtil.removeFiles((File)this.msgDir, (boolean)false);
            }
            catch (IOException iOException) {
                this.logger.log(32, "B4149", (Object)this.msgDir, (Throwable)iOException);
                throw new BrokerException(this.br.getString("B4149", this.msgDir), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sync(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = null;
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            dstMsgStore = (DstMsgStore)this.dstMap.get(destinationUID);
        }
        if (dstMsgStore != null) {
            dstMsgStore.sync();
        }
    }

    void close(boolean bl) {
        boolean bl2 = this.config.getBooleanProperty(CLEANUP_MSGSTORE_PROP, true);
        this.closeAllDstMsgStore(bl2);
        this.dstMap.clear();
    }

    File getDirName(DestinationUID destinationUID) {
        StringBuffer stringBuffer = new StringBuffer(destinationUID.toString());
        int n = -1;
        while ((n = stringBuffer.indexOf(":")) != -1) {
            stringBuffer.deleteCharAt(n);
        }
        return new File(this.msgDir, stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DstMsgStore getDstMsgStore(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = null;
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            dstMsgStore = (DstMsgStore)this.dstMap.get(destinationUID);
        }
        if (dstMsgStore == null) {
            this.logger.log(32, "B3013", (Object)destinationUID);
            throw new BrokerException(this.br.getString("B3013", destinationUID));
        }
        return dstMsgStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DstMsgStore getDstMsgStore(DestinationUID destinationUID, boolean bl, boolean bl2, boolean bl3) throws BrokerException {
        this.parent.getDstStore().checkDestination(destinationUID.toString());
        DstMsgStore dstMsgStore = null;
        try {
            HashMap hashMap = this.dstMap;
            synchronized (hashMap) {
                File file;
                dstMsgStore = (DstMsgStore)this.dstMap.get(destinationUID);
                if (dstMsgStore == null && bl && ((file = this.getDirName(destinationUID)).exists() || bl3)) {
                    dstMsgStore = new DstMsgStore(this, destinationUID, file, bl2);
                    this.dstMap.put(destinationUID, dstMsgStore);
                }
            }
        }
        catch (BrokerException brokerException) {
            if ((bl || bl3) && brokerException.getStatusCode() == 405) {
                this.logger.log(32, brokerException.toString());
                Broker.getBroker().exit(14, brokerException.toString(), BrokerEvent.Type.FATAL_ERROR, brokerException, true, true, false);
            }
            throw brokerException;
        }
        return dstMsgStore;
    }

    private void closeAllDstMsgStore(boolean bl) {
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            if (dstMsgStore == null) continue;
            dstMsgStore.close(bl);
        }
    }
}

