/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class DirectTextPacket
extends DirectPacket
implements TextMessage {
    private String text = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectTextPacket";

    public DirectTextPacket(DirectSession directSession, JMSService jMSService, String string) throws JMSException {
        super(directSession, jMSService);
        if (_logFINE) {
            Object[] objectArray = new Object[]{directSession, jMSService, string};
            _loggerOC.entering(_className, "constructor()", objectArray);
        }
        this.text = string;
    }

    public DirectTextPacket(JMSPacket jMSPacket, long l, DirectSession directSession, JMSService jMSService) throws JMSException {
        super(jMSPacket, l, directSession, jMSService);
        this._getMessageBodyFromPacket();
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    public String getText() throws JMSException {
        if (_logFINE) {
            String string = "getText()";
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":");
        }
        return this.text;
    }

    public void setText(String string) throws JMSException {
        String string2 = "setText()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string2 + ":" + string);
        }
        this.checkForReadOnlyMessageBody(string2);
        this.text = string;
    }

    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(1);
    }

    protected void _setBodyToPacket() throws JMSException {
        if (this.text != null) {
            try {
                super._setMessageBodyOfPacket(this.text.getBytes("UTF8"));
            }
            catch (Exception exception) {
                String string = "MQJMSRA_DM4001: :ERROR setting TextMessage body=" + this.text + ":Exception=" + exception.getMessage();
                _loggerJM.severe(string);
                JMSException jMSException = new JMSException(string);
                jMSException.initCause((Throwable)exception);
                throw jMSException;
            }
        }
    }

    protected void _getMessageBodyFromPacket() throws JMSException {
        try {
            byte[] byArray = this._getMessageBodyByteArray();
            if (byArray != null) {
                this.text = new String(byArray, "UTF8");
            }
        }
        catch (Exception exception) {
            String string = "MQJMSRA_DM4001: :Exception getting body for receieved TextMessage" + exception.getMessage();
            _loggerJM.severe(string);
            JMSException jMSException = new JMSException(string);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }
}

