/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Hashtable;

public class DefaultHandler
extends ErrHandler {
    private static boolean DEBUG = false;

    public void sendError(IMQConnection iMQConnection, BrokerException brokerException, Packet packet) {
        this.logger.logStack(32, "B3100", (Object)"Uncaught Exception", (Throwable)brokerException);
        this.sendError(iMQConnection, packet, brokerException.getMessage(), brokerException.getStatusCode());
    }

    public void sendError(IMQConnection iMQConnection, Packet packet, String string, int n) {
        this.sendError(iMQConnection, packet.getSendAcknowledge(), packet.getPacketType(), packet.getConsumerID(), string, n);
    }

    public void sendError(IMQConnection iMQConnection, boolean bl, int n, long l, String string, int n2) {
        if (bl) {
            Packet packet = new Packet(iMQConnection.useDirectBuffers());
            packet.setPacketType(n + 1);
            packet.setConsumerID(l);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("JMQStatus", new Integer(n2));
            if (string != null) {
                hashtable.put("JMQReason", string);
            }
            packet.setProperties(hashtable);
            iMQConnection.sendControlMessage(packet);
        }
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        if (packet.getSendAcknowledge()) {
            if (DEBUG) {
                this.logger.log(4, "DefaultHandler: replying to unknown packet type: " + packet.getPacketType());
            }
            Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
            packet2.setPacketType(packet.getPacketType() + 1);
            packet2.setConsumerID(packet.getConsumerID());
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("JMQStatus", new Integer(501));
            packet2.setProperties(hashtable);
            iMQConnection.sendControlMessage(packet2);
        } else if (DEBUG) {
            this.logger.log(4, "DefaultHandler: ignoring unknown packet type : " + packet.getPacketType());
        }
        return true;
    }
}

