/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.GenericPortMapperClient;
import com.sun.messaging.jmq.management.JMXMQAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.JMException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class AdminConnectionFactory
extends AdministeredObject {
    private static final String defaultsBase = "AdminConnectionFactory";
    private static final String DEFAULT_IMQ_ADMIN_USERNAME_PASSWORD = "admin";
    private static final String DEFAULT_IMQ_ADMIN_USERNAME_LABEL = "Default Administrator Username";
    private static final String DEFAULT_IMQ_ADMIN_PASSWORD_LABEL = "Default Administrator Password";

    public AdminConnectionFactory() {
        super(defaultsBase);
    }

    protected AdminConnectionFactory(String string) {
        super(string);
    }

    public JMXConnector createConnection() throws JMException {
        String string = null;
        String string2 = null;
        try {
            string = this.getCurrentConfiguration().getProperty("imqDefaultAdminUsername");
            string2 = this.getCurrentConfiguration().getProperty("imqDefaultAdminPassword");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createConnection(string, string2);
    }

    public JMXConnector createConnection(String string, String string2) throws JMException {
        JMXConnector jMXConnector = null;
        JMXServiceURL jMXServiceURL = null;
        jMXServiceURL = this.getJMXServiceURL();
        try {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            String[] stringArray = new String[]{string, string2};
            hashMap.put("jmx.remote.credentials", stringArray);
            jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
        }
        catch (Exception exception) {
            JMException jMException = new JMException("Caught exception when creating JMXConnector");
            jMException.initCause(exception);
            throw jMException;
        }
        return jMXConnector;
    }

    public String toString() {
        return "Oracle GlassFish(tm) Server MQ AdminConnectionFactory" + super.toString();
    }

    public JMXServiceURL getJMXServiceURL() throws JMException {
        JMXServiceURL jMXServiceURL;
        GenericPortMapperClient genericPortMapperClient;
        String string;
        int n;
        String string2;
        String string3 = null;
        try {
            string3 = this.getCurrentConfiguration().getProperty("imqAddress");
            JMXMQAddress jMXMQAddress = JMXMQAddress.createAddress(string3);
            string2 = jMXMQAddress.getHostName();
            n = jMXMQAddress.getPort();
            string = jMXMQAddress.getServiceName();
        }
        catch (Exception exception) {
            JMException jMException = new JMException("Caught exception when parsing address: " + string3);
            jMException.initCause(exception);
            throw jMException;
        }
        try {
            genericPortMapperClient = new GenericPortMapperClient(string2, n);
        }
        catch (Exception exception) {
            JMException jMException = new JMException("Caught exception when contacing portmapper.");
            jMException.initCause(exception);
            throw jMException;
        }
        String string4 = genericPortMapperClient.getProperty("url", null, "JMX", string);
        if (string4 == null) {
            JMException jMException = new JMException("No JMXServiceURL was found for connector " + string + ".\n" + "Address used: " + string3);
            throw jMException;
        }
        try {
            jMXServiceURL = new JMXServiceURL(string4);
        }
        catch (MalformedURLException malformedURLException) {
            JMException jMException = new JMException("Caught exception when creating JMXServiceURL.");
            jMException.initCause(malformedURLException);
            throw jMException;
        }
        return jMXServiceURL;
    }

    public void setDefaultConfiguration() {
        this.configuration = new Properties();
        this.configurationTypes = new Properties();
        this.configurationLabels = new Properties();
        this.configuration.put("imqDefaultAdminUsername", DEFAULT_IMQ_ADMIN_USERNAME_PASSWORD);
        this.configurationTypes.put("imqDefaultAdminUsername", "java.lang.String");
        this.configurationLabels.put("imqDefaultAdminUsername", DEFAULT_IMQ_ADMIN_USERNAME_LABEL);
        this.configuration.put("imqDefaultAdminPassword", DEFAULT_IMQ_ADMIN_USERNAME_PASSWORD);
        this.configurationTypes.put("imqDefaultAdminPassword", "java.lang.String");
        this.configurationLabels.put("imqDefaultAdminPassword", DEFAULT_IMQ_ADMIN_PASSWORD_LABEL);
    }
}

