/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionClosedListener;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestrictionListener;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TimerTask;

class MasterBrokerWaiter
extends Thread
implements ServiceRestrictionListener,
ConnectionClosedListener,
Runnable {
    static Logger logger = Globals.getLogger();
    static final long waitinterval = 15000L;
    static final int DEFAULT_MAXWAIT = 90;
    static long maxwait = (long)Globals.getConfig().getIntProperty("imq.cluster.nowaitForMasterBrokerTimeoutInSeconds", 90) * 1000L;
    static MasterBrokerWaiter waiter = null;
    static ErrHandler defaultHandler = null;
    Object lock = new Object();
    ArrayList<Request> requests = new ArrayList();
    boolean notified = false;

    MasterBrokerWaiter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRestrictionChanged(Service service) {
        Object object = this.lock;
        synchronized (object) {
            this.notified = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        if (PacketHandler.getDEBUG()) {
            logger.log(8, "MasterBrokerWaiter.connectionClosed(): " + connection);
        }
        Object object = this.lock;
        synchronized (object) {
            this.notified = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNotify(long l, boolean bl) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.notified && !this.requests.isEmpty()) {
                if (bl) {
                    logger.log(8, Globals.getBrokerResources().getKString("B1349", Thread.currentThread().getName(), "" + l / 1000L + "[" + maxwait / 1000L + "]"));
                }
                this.lock.wait(l);
            }
            this.notified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addRequest(Packet packet, IMQConnection iMQConnection, String string, String string2, ErrHandler errHandler) {
        if (maxwait == 0L) {
            return false;
        }
        Class<MasterBrokerWaiter> clazz = MasterBrokerWaiter.class;
        synchronized (MasterBrokerWaiter.class) {
            if (defaultHandler == null) {
                defaultHandler = errHandler;
            }
            boolean bl = true;
            if (waiter == null) {
                waiter = new MasterBrokerWaiter();
                waiter.setDaemon(true);
                waiter.setName("MQ-mbwaiter");
                bl = false;
            }
            waiter.addRequest(packet, iMQConnection, string, string2);
            if (!bl) {
                waiter.start();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTimedout(Request request) {
        Object object = this.lock;
        synchronized (object) {
            request.timedout = true;
            this.notified = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(Packet packet, IMQConnection iMQConnection, String string, String string2) {
        Request request = new Request();
        PacketInfo packetInfo = new PacketInfo();
        packetInfo.sendack = packet.getSendAcknowledge();
        packetInfo.pktype = packet.getPacketType();
        packetInfo.consumerID = packet.getConsumerID();
        request.pi = packetInfo;
        request.con = iMQConnection;
        request.service = iMQConnection.getService();
        request.retrymsg = string;
        request.errmsg = string2;
        request.service.addServiceRestrictionListener(this);
        request.con.addConnectionClosedListener(this);
        Object object = this.lock;
        synchronized (object) {
            this.requests.add(request);
            this.lock.notifyAll();
        }
        if (maxwait > 0L) {
            request.timertask = new TimeoutTimerTask(this, request);
            Globals.getTimer().schedule((TimerTask)request.timertask, maxwait);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(Request request) {
        Object object = this.lock;
        synchronized (object) {
            this.requests.remove(request);
        }
        request.service.removeServiceRestrictionListener(this);
        request.con.removeConnectionClosedListener(this);
        if (request.timertask != null) {
            request.timertask.cancel();
        }
    }

    public void sendRetry(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        Request request = null;
        while (iterator.hasNext()) {
            request = (Request)iterator.next();
            defaultHandler.sendError(request.con, request.pi.sendack, request.pi.pktype, request.pi.consumerID, request.retrymsg, 449);
        }
    }

    public void sendError(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        Request request = null;
        while (iterator.hasNext()) {
            request = (Request)iterator.next();
            defaultHandler.sendError(request.con, request.pi.sendack, request.pi.pktype, request.pi.consumerID, request.errmsg, 503);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Request[] requestArray;
        long l;
        long l2 = 0L;
        long l3 = l = System.currentTimeMillis();
        long l4 = 0L;
        block16: while (true) {
            Object object = MasterBrokerWaiter.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.data.MasterBrokerWaiter.class
            ArrayList<Request> arrayList = this.lock;
            // MONITORENTER : arrayList
            if (this.requests.isEmpty()) {
                waiter = null;
                logger.log(8, Globals.getBrokerResources().getKString("B1358", "[" + Thread.currentThread().getName() + "]"));
                // MONITOREXIT : arrayList
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : arrayList
            // MONITOREXIT : object
            object = new ArrayList();
            arrayList = new ArrayList<Request>();
            requestArray = null;
            Class<MasterBrokerWaiter> clazz = MasterBrokerWaiter.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.data.MasterBrokerWaiter.class
            ServiceRestriction[] serviceRestrictionArray = this.lock;
            // MONITORENTER : this.lock
            requestArray = this.requests.toArray(new Request[0]);
            // MONITOREXIT : serviceRestrictionArray
            // MONITOREXIT : clazz
            if (requestArray != null) {
                for (int i = 0; i < requestArray.length; ++i) {
                    if (requestArray[i].con.getConnectionState() >= 6) {
                        this.removeRequest(requestArray[i]);
                    }
                    if (maxwait < 0L) {
                        requestArray[i].totalwaited = 0L;
                    } else if (requestArray[i].totalwaited >= maxwait || requestArray[i].timedout) {
                        arrayList.add(requestArray[i]);
                        this.removeRequest(requestArray[i]);
                    }
                    serviceRestrictionArray = requestArray[i].service.getServiceRestrictions();
                    if (serviceRestrictionArray == null) {
                        ((ArrayList)object).add(requestArray[i]);
                        this.removeRequest(requestArray[i]);
                    } else {
                        boolean bl = false;
                        for (int j = 0; j < serviceRestrictionArray.length; ++j) {
                            if (serviceRestrictionArray[j] != ServiceRestriction.NO_SYNC_WITH_MASTERBROKER) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            ((ArrayList)object).add(requestArray[i]);
                            this.removeRequest(requestArray[i]);
                        }
                    }
                    requestArray[i].con.updateAccessTime(true);
                }
            }
            this.sendRetry((ArrayList)object);
            this.sendError(arrayList);
            boolean bl = false;
            if (l - l2 > 15000L) {
                bl = true;
                l2 = l;
            }
            serviceRestrictionArray = this.lock;
            // MONITORENTER : serviceRestrictionArray
            requestArray = this.requests.toArray(new Request[0]);
            this.waitForNotify(15000L, bl);
            // MONITOREXIT : serviceRestrictionArray
            l3 = l;
            l = System.currentTimeMillis();
            l4 = l - l3 > 0L ? l - l3 : 0L;
            int n = 0;
            while (true) {
                if (n >= requestArray.length) continue block16;
                requestArray[n].totalwaited += l4;
                ++n;
            }
            break;
        }
        catch (InterruptedException interruptedException) {
            logger.log(8, Globals.getBrokerResources().getKString("B1350", Thread.currentThread().getName()));
            ArrayList<Request> arrayList = new ArrayList<Request>();
            Class<MasterBrokerWaiter> clazz = MasterBrokerWaiter.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.data.MasterBrokerWaiter.class
            Object object = this.lock;
            // MONITORENTER : object
            requestArray = this.requests.toArray(new Request[0]);
            int n = 0;
            while (true) {
                if (n >= requestArray.length) {
                    // MONITOREXIT : object
                    waiter = null;
                    // MONITOREXIT : clazz
                    this.sendError(arrayList);
                    logger.log(8, Globals.getBrokerResources().getKString("B1358", "[" + Thread.currentThread().getName() + "]"));
                    return;
                }
                this.removeRequest(requestArray[n]);
                arrayList.add(requestArray[n]);
                ++n;
            }
        }
    }

    class TimeoutTimerTask
    extends TimerTask {
        MasterBrokerWaiter waiter = null;
        Request rq = null;

        public TimeoutTimerTask(MasterBrokerWaiter masterBrokerWaiter2, Request request) {
            this.waiter = masterBrokerWaiter2;
            this.rq = request;
        }

        public void run() {
            this.waiter.requestTimedout(this.rq);
        }
    }

    class PacketInfo {
        boolean sendack;
        int pktype;
        long consumerID;

        PacketInfo() {
        }
    }

    class Request {
        PacketInfo pi = null;
        IMQConnection con = null;
        Service service = null;
        long totalwaited = 0L;
        String errmsg = "";
        String retrymsg = "";
        TimeoutTimerTask timertask = null;
        boolean timedout = false;

        Request() {
        }
    }
}

