/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ReceiveQueue;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class MessageConsumerImpl
extends Consumer
implements MessageConsumer,
Traceable {
    protected MessageListener messageListener = null;
    protected SessionImpl session = null;
    protected ReceiveQueue receiveQueue = null;
    private boolean syncReadFlag = true;
    protected SysMessageID lastDeliveredID = null;
    private boolean pendingPrefetch = false;

    public MessageConsumerImpl(SessionImpl sessionImpl, javax.jms.Destination destination, String string, boolean bl) throws JMSException {
        super(sessionImpl.getConnection(), destination, string, bl);
        this.session = sessionImpl;
        this.init();
    }

    public MessageConsumerImpl(SessionImpl sessionImpl, javax.jms.Destination destination) throws JMSException {
        super(sessionImpl.getConnection(), destination);
        this.session = sessionImpl;
    }

    protected void init() throws JMSException {
        try {
            this.checkConsumerCreation();
            this.receiveQueue = new ReceiveQueue();
            if (!this.session.getTransacted()) {
                this.acknowledgeMode = this.session.acknowledgeMode;
            }
            this.addInterest();
            if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I300");
            }
        }
        catch (JMSException jMSException) {
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    protected void setInterestId(Long l) {
        this.lastDeliveredID = null;
        this.pendingPrefetch = false;
        super.setInterestId(l);
    }

    private void addInterest() throws JMSException {
        this.session.checkConsumerCreation();
        this.registerInterest();
    }

    private void removeInterest() throws JMSException {
        this.session.removeMessageConsumer(this);
        this.deregisterInterest();
    }

    private synchronized void setSyncReadFlag(boolean bl) {
        this.syncReadFlag = bl;
    }

    protected synchronized boolean getSyncReadFlag() {
        return this.syncReadFlag;
    }

    protected void checkReceive() throws JMSException {
        JMSException jMSException;
        String string;
        this.checkState();
        if (!this.getSyncReadFlag()) {
            string = AdministeredObject.cr.getKString("C4032");
            jMSException = new JMSException(string, "C4032");
            ExceptionHandler.throwJMSException(jMSException);
        }
        if (this.session.failoverOccurred && this.session.acknowledgeMode == 2) {
            string = AdministeredObject.cr.getKString("C4106");
            jMSException = new JMSException(string, "C4106");
            ExceptionHandler.throwJMSException(jMSException);
        }
        this.session.checkFailOver();
    }

    protected void stop() {
        this.receiveQueue.stop();
    }

    protected void stopNoWait() {
        this.receiveQueue.stopNoWait();
    }

    protected void start() {
        this.receiveQueue.start();
    }

    protected SessionQueue getReceiveQueue() {
        return this.receiveQueue;
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected Long getReadQueueId() {
        return this.session.getSessionId();
    }

    protected void onMessage(MessageImpl messageImpl) throws JMSException {
        if (this.getSyncReadFlag()) {
            this.receiveQueue.enqueueNotify(messageImpl);
        } else if (this.receiveQueue.isEmpty()) {
            this.deliverAndAcknowledge(messageImpl);
        } else {
            this.receiveQueue.enqueueNotify(messageImpl);
            this.onMessageToListenerFromReceiveQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessageToListenerFromReceiveQueue() throws JMSException {
        if (!this.receiveQueue.isEmpty()) {
            ReceiveQueue receiveQueue = this.receiveQueue;
            synchronized (receiveQueue) {
                while (!this.receiveQueue.isEmpty()) {
                    MessageImpl messageImpl = (MessageImpl)this.receiveQueue.dequeue();
                    if (messageImpl == null) continue;
                    this.deliverAndAcknowledge(messageImpl);
                }
                this.session.sessionQueue.setListenerLate(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverAndAcknowledge(MessageImpl messageImpl) throws JMSException {
        this.session.sessionReader.setCurrentMessage(messageImpl);
        try {
            block9: {
                this.session.setIsMessageListenerThread(true);
                if (!this.isDMQConsumer && messageImpl._isExpired()) {
                    this.session.acknowledgeExpired(messageImpl);
                    Object var5_2 = null;
                    this.session.setIsMessageListenerThread(false);
                    return;
                }
                try {
                    this.messageListener.onMessage((Message)messageImpl);
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                    if (this.session.getTransacted() || this.session.acknowledgeMode == 2) break block9;
                    messageImpl.doAcknowledge = false;
                    messageImpl.setJMSRedelivered(true);
                    try {
                        this.messageListener.onMessage((Message)messageImpl);
                        messageImpl.doAcknowledge = true;
                    }
                    catch (Exception exception2) {
                        Debug.printStackTrace(exception2);
                    }
                }
            }
            if (!(!messageImpl.doAcknowledge || messageImpl.consumerInRA || this.session.getTransacted() && this.connection.isAppTransactedAck())) {
                this.session.acknowledge(messageImpl);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.session.setIsMessageListenerThread(false);
            throw throwable;
        }
        Object var5_3 = null;
        this.session.setIsMessageListenerThread(false);
        if (!this.session.getTransacted() || !this.connection.isAppTransactedAck()) {
            this.lastDeliveredID = messageImpl.getMessageID();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkState();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkState();
        this.messageListener = messageListener;
        if (messageListener == null) {
            this.setSyncReadFlag(true);
        } else {
            this.setSyncReadFlag(false);
            if (this.receiveQueue.size() > 0) {
                this.session.sessionQueue.setListenerLateNotify();
            }
        }
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    /*
     * Exception decompiling
     */
    public Message receive(long var1_1) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receiveNoWait() throws JMSException {
        Object var4_2;
        MessageImpl messageImpl = null;
        while (true) {
            block10: {
                this.checkReceive();
                try {
                    if (this.receiveQueue.getIsLocked()) {
                        Message message = null;
                        var4_2 = null;
                        this.receiveQueue.setReceiveInProcess(false);
                        return message;
                    }
                    this.receiveQueue.setReceiveInProcess(true);
                    if (this.noprefetch && this.pendingPrefetch) {
                        this.session.doPrefetch(this);
                        this.pendingPrefetch = false;
                    }
                    if ((messageImpl = (MessageImpl)this.receiveQueue.dequeue()) == null) break;
                    if (!this.isDMQConsumer && messageImpl._isExpired()) {
                        if (this.noprefetch) {
                            this.pendingPrefetch = true;
                            this.session.acknowledgeExpired(messageImpl, false);
                            break block10;
                        } else {
                            this.session.acknowledgeExpired(messageImpl, true);
                        }
                        break block10;
                    }
                    if (this.noprefetch) {
                        this.pendingPrefetch = true;
                        this.session.acknowledge(messageImpl, false);
                    } else {
                        this.session.acknowledge(messageImpl, true);
                    }
                    this.lastDeliveredID = messageImpl.getMessageID();
                    break;
                }
                catch (Throwable throwable) {
                    var4_2 = null;
                    this.receiveQueue.setReceiveInProcess(false);
                    throw throwable;
                }
            }
            var4_2 = null;
            this.receiveQueue.setReceiveInProcess(false);
        }
        var4_2 = null;
        this.receiveQueue.setReceiveInProcess(false);
        return messageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        int n = 0;
        ReceiveQueue receiveQueue = this.receiveQueue;
        synchronized (receiveQueue) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        try {
            if (Thread.currentThread() != this.session.sessionReader.sessionThread) {
                this.session.sessionQueue.stop(true);
            }
            this.stop();
            n = this.receiveQueue.size();
            this.receiveQueue.close();
            if (!this.session.connection.isBroken() && !this.session.connection.recoverInProcess) {
                if (this.session.dupsOkAckOnTimeout) {
                    this.session.syncedDupsOkCommitAcknowledge();
                }
                this.removeInterest();
            }
            if (this.session.connection.getBrokerProtocolLevel() < 350 && (this.session.isTransacted || this.session.acknowledgeMode == 2 || this.session.acknowledgeMode == 3)) {
                this.session.removeUnAckedMessages(this.interestId);
            }
            this.removeUndeliveredMessages();
            if (Thread.currentThread() == this.session.sessionReader.sessionThread) {
                this.session.sessionReader.currentMessage.doAcknowledge = false;
            } else {
                this.session.sessionQueue.start();
            }
            if (this.debug) {
                Debug.println("message consumer closed ...");
                Debug.println(this);
            }
            this.messageListener = null;
            this.isClosed = true;
            Object var5_4 = null;
            this.session.resetConnectionFlowControl(n);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.session.resetConnectionFlowControl(n);
            if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I301");
            }
            throw throwable;
        }
        if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
            this.logLifeCycle("I301");
        }
    }

    protected void removeUndeliveredMessages() throws JMSException {
        int n = 0;
        Object[] objectArray = this.session.sessionQueue.toArray();
        int n2 = objectArray.length;
        if (n2 > 0) {
            int n3;
            Vector<ReadOnlyPacket> vector = new Vector<ReadOnlyPacket>();
            long l = this.interestId;
            for (n3 = 0; n3 < n2; ++n3) {
                ReadOnlyPacket readOnlyPacket = (ReadOnlyPacket)objectArray[n3];
                if (readOnlyPacket == null || readOnlyPacket.getConsumerID() != l) continue;
                vector.addElement(readOnlyPacket);
            }
            n = vector.size();
            for (n3 = 0; n3 < vector.size(); ++n3) {
                if (this.debug) {
                    Debug.println("removing msg from sessionq: " + vector.elementAt(n3));
                }
                this.session.sessionQueue.remove(vector.elementAt(n3));
            }
            this.session.resetConnectionFlowControl(n);
        }
    }

    protected SysMessageID getLastDeliveredID() {
        return this.lastDeliveredID;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ MessageConsumerImpl dump ------");
        printStream.println("Interest ID: " + this.getInterestId());
        printStream.println("is registered: " + this.getIsRegistered());
        printStream.println("is durable: " + this.getDurable());
        if (this.durable) {
            printStream.println("durableName: " + this.getDurableName());
        }
        printStream.println("destination: " + this.getDestination());
        printStream.println("selector: " + this.messageSelector);
        if (this.receiveQueue != null) {
            this.receiveQueue.dump(printStream);
        } else {
            printStream.println("receiveQueue is null.");
        }
    }

    protected Hashtable getDebugState(boolean bl) {
        Hashtable hashtable = super.getDebugState(bl);
        hashtable.put("# pending", String.valueOf(this.receiveQueue.size()));
        hashtable.put("syncReadFlag", String.valueOf(this.syncReadFlag));
        if (bl) {
            hashtable.put("receiveQueue", this.receiveQueue);
        }
        return hashtable;
    }

    public Object TEST_GetAttribute(String string) {
        if (string.startsWith("FlowControl")) {
            return this.session.readChannel.flowControl.TEST_GetAttribute(string, this);
        }
        return null;
    }

    public void logLifeCycle(String string) {
        if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
            SessionImpl.sessionLogger.log(Level.FINE, string, this);
        }
    }

    public String toString() {
        String string = null;
        try {
            string = ((Destination)this.destination).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.session.toString() + ", ConsumerID=" + this.getInterestId() + ", DestName=" + string;
    }
}

