/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Hashtable;

class DestinationStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private BDBStore parent = null;
    private Database db = null;
    private EntryBinding dataBinding = null;

    protected DestinationStore(BDBStore bDBStore) {
        this.parent = bDBStore;
        this.db = bDBStore.getDstDatabase();
        this.dataBinding = new SerialBinding((ClassCatalog)bDBStore.getClassCatalog(), Destination.class);
    }

    protected void storeDestination(Transaction transaction, Destination destination) throws BrokerException {
        this.storeDestination(transaction, destination, false);
    }

    protected void storeDestination(Transaction transaction, Destination destination, boolean bl) throws BrokerException {
        try {
            String string = destination.getDestinationUID().toString();
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            this.dataBinding.objectToEntry((Object)destination, databaseEntry2);
            OperationStatus operationStatus = this.db.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                if (bl) {
                    return;
                }
                String string2 = this.br.getString("B3012", destination.getName());
                this.logger.log(32, string2);
                throw new BrokerException(string2);
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4014", destination.getName());
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void updateDestination(Transaction transaction, Destination destination) throws BrokerException {
        try {
            String string = destination.getDestinationUID().toString();
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string2 = this.br.getKString("B3013", destination.getName());
                this.logger.log(32, string2);
                throw new DestinationNotFoundException(string2);
            }
            databaseEntry2 = new DatabaseEntry();
            this.dataBinding.objectToEntry((Object)destination, databaseEntry2);
            operationStatus = this.db.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4014", destination.getName());
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void removeDestination(Transaction transaction, Destination destination) throws BrokerException {
        String string = destination.getDestinationUID().toString();
        try {
            try {
                this.parent.getMsgStore().removeDestination(transaction, destination.getDestinationUID());
            }
            catch (DestinationNotFoundException destinationNotFoundException) {
                // empty catch block
            }
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            OperationStatus operationStatus = this.db.delete(transaction, databaseEntry);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string2 = this.br.getKString("B3013", string.toString());
                this.logger.log(32, string2);
                throw new DestinationNotFoundException(string2);
            }
        }
        catch (Exception exception) {
            String string3 = this.br.getKString("B4144", string);
            this.logger.log(32, string3);
            throw new BrokerException(string3, exception);
        }
    }

    protected Destination getDestination(Transaction transaction, DestinationUID destinationUID) throws BrokerException {
        try {
            String string = destinationUID.toString();
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                return null;
            }
            return (Destination)this.dataBinding.entryToObject(databaseEntry2);
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4224", destinationUID.getName());
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void checkDestinationExist(Transaction transaction, DestinationUID destinationUID) throws BrokerException {
        try {
            String string = destinationUID.toString();
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string2 = this.br.getKString("B3013", destinationUID.toString());
                throw new DestinationNotFoundException(string2);
            }
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4224", destinationUID.getName());
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected Destination[] getAllDestinations(Transaction transaction) throws BrokerException {
        ArrayList<Destination> arrayList = new ArrayList<Destination>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            String string = null;
            Destination destination = null;
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                string = new String(databaseEntry.getData(), "UTF-8");
                destination = (Destination)this.dataBinding.entryToObject(databaseEntry2);
                arrayList.add(destination);
            }
            cursor.close();
            Destination[] destinationArray = arrayList.toArray(new Destination[0]);
            return destinationArray;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4031");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all destinations from store: " + exception.getMessage());
                }
            }
        }
    }

    protected void clearAll(Transaction transaction, boolean bl) throws BrokerException {
        Destination[] destinationArray = this.getAllDestinations(transaction);
        int n = destinationArray.length;
        if (!bl) {
            for (int i = 0; i < n; ++i) {
                this.removeDestination(transaction, destinationArray[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                try {
                    this.parent.getMsgStore().removeDestination(transaction, destinationArray[i].getDestinationUID());
                    continue;
                }
                catch (DestinationNotFoundException destinationNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("dbCount", String.valueOf(this.db.count()));
        hashtable.put("dbConfig", this.db.getConfig().toString());
        return hashtable;
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore: closing with " + this.db.count() + " destinations");
        }
    }
}

