/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MessageEnumeration
implements Enumeration {
    ResultSet rs = null;
    PreparedStatement pstmt = null;
    Connection conn = null;
    String sql = null;
    MessageDAOImpl dao = null;
    Packet nextPacket = null;
    Store store = null;
    boolean closed = false;

    MessageEnumeration(ResultSet resultSet, PreparedStatement preparedStatement, Connection connection, String string, MessageDAOImpl messageDAOImpl, Store store) {
        this.rs = resultSet;
        this.pstmt = preparedStatement;
        this.conn = connection;
        this.sql = string;
        this.dao = messageDAOImpl;
        this.store = store;
    }

    public boolean hasMoreElements() {
        block10: {
            try {
                this.nextPacket = (Packet)this.dao.loadData(this.rs, true);
                if (this.nextPacket == null && this.setClosed()) {
                    try {
                        Util.close(this.rs, this.pstmt, this.conn, null);
                    }
                    catch (Throwable throwable) {
                        this.dao.logger.log(16, this.dao.br.getKString("B2233", throwable.toString()));
                    }
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                this.nextPacket = null;
                if (throwable instanceof IOException) {
                    throwable2 = DBManager.wrapIOException("[" + this.sql + "]", (IOException)throwable);
                } else if (throwable instanceof SQLException) {
                    throwable2 = DBManager.wrapSQLException("[" + this.sql + "]", (SQLException)throwable);
                }
                this.dao.logger.logStack(32, throwable2.getMessage(), throwable);
                if (!this.setClosed()) break block10;
                try {
                    Util.close(this.rs, this.pstmt, this.conn, throwable2);
                }
                catch (Exception exception) {
                    this.dao.logger.log(16, this.dao.br.getKString("B2233", exception.toString()));
                }
            }
        }
        return this.nextPacket != null;
    }

    public Object nextElement() {
        if (this.nextPacket == null) {
            throw new NoSuchElementException();
        }
        if (this.store.closed()) {
            throw new NoSuchElementException(this.dao.br.getKString("B1341"));
        }
        return this.nextPacket;
    }

    public void cancel() {
        if (!this.closed) {
            try {
                this.pstmt.cancel();
            }
            catch (Throwable throwable) {
                this.dao.logger.log(16, this.dao.br.getKString("B2234", "[" + this.sql + "]", throwable.toString()));
            }
        }
    }

    private synchronized boolean setClosed() {
        if (!this.closed) {
            this.closed = true;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.setClosed()) {
            try {
                Util.close(this.rs, this.pstmt, this.conn, null);
            }
            catch (Exception exception) {
                this.dao.logger.log(16, this.dao.br.getKString("B2233", exception.toString()));
            }
        }
    }
}

