/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.util.DirectXAResourceMap;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DirectXAResource
implements XAResource {
    private JMSService jmsservice;
    private DirectConnection dc;
    private long connectionId;
    private long mTransactionId = 0L;
    private XidImpl mXid = null;
    private int id = 0;
    private boolean isEnlisted = false;
    private boolean usedByMDB = false;
    private HashMap<String, Long> transactionIds = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectXAResource";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSXAResource = "javax.resourceadapter.mqjmsra.xa";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJX = Logger.getLogger("javax.resourceadapter.mqjmsra.xa");
    private static final transient String _lgrName = "com.sun.messaging.jms.ra.DirectXAResource";
    private static final transient Logger _logger = Logger.getLogger("com.sun.messaging.jms.ra.DirectXAResource");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DXA";
    private static final transient String _lgrMID_EET = "MQJMSRA_DXA1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_DXA1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_DXA2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_DXA3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_DXA4001: ";
    private static int idCounter = 0;
    protected static int _logLevel;
    protected static boolean _logFINE;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    private int resourceState = 0;

    public DirectXAResource(DirectConnection directConnection, JMSService jMSService, long l) {
        Object[] objectArray = new Object[]{directConnection, jMSService, l};
        _loggerOC.entering("com.sun.messaging.jms.ra.DirectXAResource", "constructor()", objectArray);
        this.dc = directConnection;
        this.jmsservice = jMSService;
        this.connectionId = directConnection.getConnectionId();
        this.isEnlisted = false;
        this.id = ++idCounter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        XidImpl xidImpl;
        boolean bl2;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") Commit  " + this.printXid(xid) + " (onePhase=" + bl + ")");
        }
        String string = "commit()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":onePhase=" + bl + ":transactionId=" + this.mTransactionId);
        }
        JMSServiceReply jMSServiceReply = null;
        try {
            try {
                jMSServiceReply = this.jmsservice.commitTransaction(this.connectionId, this.mTransactionId, xid, bl ? 0x40000000 : 0);
                this.setEnlisted(false);
                if (_logFINE) {
                    _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":committed transactionId=" + this.mTransactionId);
                }
            }
            catch (JMSServiceException jMSServiceException) {
                String string2;
                JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
                switch (status) {
                    case CONFLICT: {
                        string2 = "CONFLICT: " + jMSServiceException.getCause().toString();
                        break;
                    }
                    default: {
                        string2 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                    }
                }
                String string3 = "commitTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and onePhase:" + bl + " due to " + string2;
                _loggerOC.severe(string3);
                XAException xAException = new XAException(-3);
                xAException.initCause(jMSServiceException);
                throw xAException;
            }
            Object var11_5 = null;
            bl2 = false;
            xidImpl = this.mXid;
        }
        catch (Throwable throwable) {
            Object var11_6 = null;
            boolean bl3 = false;
            XidImpl xidImpl2 = this.mXid;
            DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.mXid, bl3);
            int i = 0;
            while (true) {
                if (i >= directXAResourceArray.length) {
                    DirectXAResourceMap.unregister(xidImpl2);
                    throw throwable;
                }
                DirectXAResource directXAResource = directXAResourceArray[i];
                try {
                    directXAResource.clearTransactionInfo();
                }
                catch (JMSException jMSException) {
                    _loggerJX.log(Level.SEVERE, "MQRA:DXAR:commit:XAException-Exception=" + jMSException.getMessage(), jMSException);
                    Debug.printStackTrace(jMSException);
                    XAException xAException = new XAException(-7);
                    xAException.initCause(jMSException);
                    throw xAException;
                }
                ++i;
            }
        }
        DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.mXid, bl2);
        for (int i = 0; i < directXAResourceArray.length; ++i) {
            DirectXAResource directXAResource = directXAResourceArray[i];
            try {}
            catch (JMSException jMSException) {
                _loggerJX.log(Level.SEVERE, "MQRA:DXAR:commit:XAException-Exception=" + jMSException.getMessage(), jMSException);
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
            directXAResource.clearTransactionInfo();
        }
        DirectXAResourceMap.unregister(xidImpl);
    }

    public void clearTransactionInfo() throws JMSException {
        this.dc.deleteTemporaryDestinationsIfClosed();
        this.resourceState = 0;
        this.mTransactionId = 0L;
        this.mXid = null;
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") End     " + this.printXid(xid) + this.printFlags(n));
        }
        String string = "end()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":flags=" + n + ":transactionId=" + this.mTransactionId);
        }
        this.resourceState = this.isFail(n) ? 2 : (this.isSuspend(n) ? 3 : 4);
        if (ResourceAdapter.isRevert6882044()) {
            this.sendEndToBroker(xid, n);
        } else if (this.resourceState == 4) {
            boolean bl = true;
            DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.mXid, true);
            for (int i = 0; i < directXAResourceArray.length; ++i) {
                DirectXAResource directXAResource = directXAResourceArray[i];
                if (directXAResource.getResourceState() == 4) continue;
                bl = false;
            }
            if (bl) {
                this.sendEndToBroker(xid, n);
            }
        } else if (this.resourceState == 2) {
            this.sendEndToBroker(xid, n);
        } else if (this.resourceState == 3) {
            // empty if block
        }
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":ended transactionId=" + this.mTransactionId);
        }
    }

    public synchronized void sendEndToBroker(Xid xid, int n) throws XAException {
        String string = "endToBroker()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":flags=" + n + ":transactionId=" + this.mTransactionId);
        }
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.endTransaction(this.connectionId, this.mTransactionId, xid, n);
            if (_logFINE) {
                _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":ended transactionId=" + this.mTransactionId);
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string2;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case CONFLICT: {
                    string2 = "CONFLICT: " + jMSServiceException.getCause().toString();
                    break;
                }
                default: {
                    string2 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                }
            }
            String string3 = "endTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and flags=" + n + " due to " + string2;
            _loggerOC.severe(string3);
            XAException xAException = new XAException(-3);
            xAException.initCause(jMSServiceException);
            throw xAException;
        }
    }

    public void forget(Xid xid) throws XAException {
        if (_logFINE) {
            _loggerJX.warning("MQJMSRA_DXA1101: forget()UNSUPPORTED:Xid=" + xid.toString());
        }
        XidImpl xidImpl = new XidImpl(xid);
        DirectXAResourceMap.unregister(xidImpl);
        if (this.mXid != null && this.mXid.equals(xidImpl)) {
            try {
                this.clearTransactionInfo();
            }
            catch (JMSException jMSException) {
                _loggerJX.log(Level.SEVERE, "MQRA:DXAR:forget:XAException-Exception=" + jMSException.getMessage(), jMSException);
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: getTransactionTimeout() = 0");
        }
        return 0;
    }

    public int getResourceState() {
        return this.resourceState;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: isSameRM()");
        }
        return ResourceAdapter.isSameRMAllowed() && xAResource instanceof DirectXAResource;
    }

    public synchronized int prepare(Xid xid) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") Prepare     " + this.printXid(xid));
        }
        String string = "prepare()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":transactionId=" + this.mTransactionId);
        }
        int n = 0;
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.prepareTransaction(this.connectionId, this.mTransactionId, xid);
            if (_logFINE) {
                _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":prepared transactionId=" + this.mTransactionId);
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string2;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case CONFLICT: {
                    string2 = "CONFLICT: " + jMSServiceException.getCause().toString();
                    break;
                }
                default: {
                    string2 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                }
            }
            String string3 = "prepareTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + string2;
            _loggerOC.severe(string3);
            XAException xAException = new XAException(-3);
            xAException.initCause(jMSServiceException);
            throw xAException;
        }
        this.resourceState = 5;
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: recover():flags=" + n);
        }
        Xid[] xidArray = null;
        try {
            xidArray = this.jmsservice.recoverXATransactions(this.connectionId, n);
        }
        catch (JMSServiceException jMSServiceException) {
            String string;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case CONFLICT: {
                    string = "CONFLICT: " + jMSServiceException.getCause().toString();
                    break;
                }
                default: {
                    string = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                }
            }
            String string2 = "recoverXATransactions (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + string;
            _loggerOC.severe(string2);
            XAException xAException = new XAException(-3);
            xAException.initCause(jMSServiceException);
            throw xAException;
        }
        return xidArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback(Xid xid) throws XAException {
        boolean bl;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") Rollback  " + this.printXid(xid) + ")");
        }
        String string = "rollback()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":transactionId=" + this.mTransactionId);
        }
        JMSServiceReply jMSServiceReply = null;
        try {
            try {
                jMSServiceReply = this.jmsservice.rollbackTransaction(this.connectionId, this.mTransactionId, xid, true, true);
                this.setEnlisted(false);
                if (_logFINE) {
                    _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":rolled back transactionId=" + this.mTransactionId);
                }
            }
            catch (JMSServiceException jMSServiceException) {
                String string2;
                JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
                switch (status) {
                    case CONFLICT: {
                        string2 = "CONFLICT: " + jMSServiceException.getCause().toString();
                        break;
                    }
                    default: {
                        string2 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause();
                    }
                }
                String string3 = "rollbackTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + ":transactionId=" + this.mTransactionId + " due to " + string2;
                _loggerOC.severe(string3);
                XAException xAException = new XAException(-3);
                xAException.initCause(jMSServiceException);
                throw xAException;
            }
            Object var10_4 = null;
            bl = false;
        }
        catch (Throwable throwable) {
            Object var10_5 = null;
            boolean bl2 = false;
            DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.mXid, bl2);
            XidImpl xidImpl2 = this.mXid;
            int i = 0;
            while (true) {
                if (i >= directXAResourceArray.length) {
                    DirectXAResourceMap.unregister(xidImpl2);
                    throw throwable;
                }
                DirectXAResource directXAResource = directXAResourceArray[i];
                try {
                    directXAResource.clearTransactionInfo();
                }
                catch (JMSException jMSException) {
                    _loggerJX.log(Level.SEVERE, "MQRA:DXAR:rollback:XAException-Exception=" + jMSException.getMessage(), jMSException);
                    Debug.printStackTrace(jMSException);
                    XAException xAException = new XAException(-7);
                    xAException.initCause(jMSException);
                    throw xAException;
                }
                ++i;
            }
        }
        DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.mXid, bl);
        XidImpl xidImpl = this.mXid;
        for (int i = 0; i < directXAResourceArray.length; ++i) {
            DirectXAResource directXAResource = directXAResourceArray[i];
            try {}
            catch (JMSException jMSException) {
                _loggerJX.log(Level.SEVERE, "MQRA:DXAR:rollback:XAException-Exception=" + jMSException.getMessage(), jMSException);
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
            directXAResource.clearTransactionInfo();
        }
        DirectXAResourceMap.unregister(xidImpl);
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: setTransactionTimeout()=" + n + ":returning false.");
        }
        return false;
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") Start   " + this.printXid(xid) + this.printFlags(n));
        }
        JMSServiceReply jMSServiceReply = null;
        long l = 0L;
        String string = "start()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":flags=" + n + ":connectioId=" + this.connectionId);
        }
        if (!this.isResume(n) || ResourceAdapter.isRevert6882044()) {
            l = this.sendStartToBroker(xid, n, jMSServiceReply, l);
            this.validateAndSaveXidTransactionID(xid, l);
            DirectXAResourceMap.register(this.mXid, this, this.isJoin(n));
        }
        this.setEnlisted(true);
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":started transactionId=" + this.mTransactionId);
        }
    }

    private long sendStartToBroker(Xid xid, int n, JMSServiceReply jMSServiceReply, long l) throws XAException {
        try {
            jMSServiceReply = this.jmsservice.startTransaction(this.connectionId, 0L, xid, n, JMSService.TransactionAutoRollback.UNSPECIFIED, 0L);
            try {
                l = jMSServiceReply.getJMQTransactionID();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string = "MQJMSRA_DXA4001: JMSServiceException:Missing JMQTransactionID";
                XAException xAException = new XAException(-7);
                xAException.initCause(noSuchFieldException);
                _loggerOC.severe(string);
                throw xAException;
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case NOT_IMPLEMENTED: {
                    string = "TransactionAutoRollback not implemented.";
                    break;
                }
                case CONFLICT: {
                    string = "CONFLICT: " + jMSServiceException.getCause().toString();
                    break;
                }
                default: {
                    string = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                }
            }
            String string2 = "startTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + string;
            _loggerOC.severe(string2);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSServiceException);
            throw xAException;
        }
        return l;
    }

    private void validateAndSaveXidTransactionID(Xid xid, long l) {
        assert (l != 0L);
        if (this.mTransactionId == 0L && this.mXid == null) {
            this.mTransactionId = l;
            this.mXid = new XidImpl(xid);
        } else if (this.mXid.equals(xid)) {
            if (this.mTransactionId != l) {
                _loggerJX.log(Level.INFO, "DXAR:start():Warning: XAResource with state " + this.getStateAsString() + " received diff txId for same Xid:" + "switching transactionId:" + "\nDXAR TXid=" + this.mTransactionId + "\ngot  TXid=" + l + "\nFor   Xid=" + this.printXid(this.mXid));
                this.mTransactionId = l;
            }
        } else {
            _loggerJX.log(Level.INFO, "DXAR:start():Warning: XAResource with state " + this.getStateAsString() + " received diff Xid for open txnId:" + "switching transactionId:" + "\nDXAR  Xid=" + this.printXid(this.mXid) + "\nDXAR TXid=" + this.mTransactionId + "\ngot   Xid=" + this.printXid(xid) + "\ngot  TXid=" + l);
            this.mTransactionId = l;
            this.mXid = new XidImpl(xid);
        }
    }

    public synchronized void setEnlisted(boolean bl) {
        this.isEnlisted = bl;
        if (!this.usedByMDB && this.dc != null) {
            this.dc.setEnlisted(bl);
        }
    }

    protected void _setUsedByMDB(boolean bl) {
        this.usedByMDB = bl;
    }

    public synchronized boolean isEnlisted() {
        return this.isEnlisted;
    }

    public synchronized void setRollback(boolean bl, Throwable throwable) {
    }

    public int _getId() {
        return this.id;
    }

    public long _getTransactionId() {
        return this.mTransactionId;
    }

    private String printXid(Xid xid) {
        return "(GlobalTransactionID=" + xid.getGlobalTransactionId() + ", BranchQualifier=" + xid.getBranchQualifier() + ") ";
    }

    private boolean isJoin(int n) {
        return (n & 0x200000) == 0x200000;
    }

    private boolean isResume(int n) {
        return (n & 0x8000000) == 0x8000000;
    }

    private boolean isNoFlags(int n) {
        return (n & 0) == 0;
    }

    private boolean isFail(int n) {
        return (n & 0x20000000) == 0x20000000;
    }

    private boolean isOnePhase(int n) {
        return (n & 0x40000000) == 0x40000000;
    }

    private boolean isSuccess(int n) {
        return (n & 0x4000000) == 0x4000000;
    }

    private boolean isSuspend(int n) {
        return (n & 0x2000000) == 0x2000000;
    }

    private boolean isTMENDRSCAN(int n) {
        return (n & 0x800000) == 0x800000;
    }

    private boolean TMSTARTRSCAN(int n) {
        return (n & 0x1000000) == 0x1000000;
    }

    private String printFlags(int n) {
        String string = "(Flags: ";
        if (this.isJoin(n)) {
            string = string + "JOIN ";
        }
        if (this.isNoFlags(n)) {
            string = string + "TMNOFLAGS ";
        }
        if (this.isFail(n)) {
            string = string + "TMFAIL ";
        }
        if (this.isOnePhase(n)) {
            string = string + "TMONEPHASE ";
        }
        if (this.isResume(n)) {
            string = string + "TMRESUME ";
        }
        if (this.isSuccess(n)) {
            string = string + "TMSUCCESS ";
        }
        if (this.isSuspend(n)) {
            string = string + "TMSUSPEND ";
        }
        if (this.isTMENDRSCAN(n)) {
            string = string + "TMENDRSCAN ";
        }
        if (this.TMSTARTRSCAN(n)) {
            string = string + "TMSTARTRSCAN ";
        }
        string = string + ")";
        return string;
    }

    private String getStateAsString() {
        switch (this.getResourceState()) {
            case 0: {
                return "CREATED";
            }
            case 1: {
                return "STARTED";
            }
            case 2: {
                return "FAILED";
            }
            case 3: {
                return "INCOMPLETE";
            }
            case 4: {
                return "COMPLETE";
            }
            case 5: {
                return "PREPARED";
            }
        }
        return Integer.toString(this.getResourceState());
    }

    static {
        _logFINE = false;
        Level level = _loggerJX.getLevel();
        if (level != null && (_logLevel = level.intValue()) <= Level.FINE.intValue()) {
            _logFINE = true;
        }
    }
}

