/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;

public class ClusteredBrokerImpl
implements ClusteredBroker {
    protected Logger logger = Globals.getLogger();
    protected BrokerResources br = Globals.getBrokerResources();
    String brokerName = null;
    MQAddress address = null;
    transient String instanceName = null;
    boolean local = false;
    boolean configed = false;
    Integer status = new Integer(0);
    BrokerState state = BrokerState.INITIALIZING;
    Integer version = new Integer(0);
    UID brokerSessionUID = null;
    boolean isgen = false;
    ClusterManagerImpl parent = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredBrokerImpl(ClusterManagerImpl clusterManagerImpl, MQAddress mQAddress, boolean bl, UID uID) {
        this.parent = clusterManagerImpl;
        this.local = bl;
        this.address = mQAddress;
        this.brokerSessionUID = uID;
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            if (bl) {
                this.brokerName = Globals.getBrokerID();
                this.instanceName = Globals.getConfigName();
            }
            if (this.brokerName == null) {
                this.isgen = true;
                ++clusterManagerImpl.brokerindx;
                this.brokerName = "broker" + clusterManagerImpl.brokerindx;
            }
        }
    }

    private ClusteredBrokerImpl() {
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClusteredBroker)) {
            return false;
        }
        return this.getBrokerName().equals(((ClusteredBroker)object).getBrokerName());
    }

    public int hashCode() {
        return this.getBrokerName().hashCode();
    }

    public String toString() {
        if (!this.local) {
            return this.brokerName + "(" + this.address + ")";
        }
        return this.brokerName + "* (" + this.address + ")";
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public MQAddress getBrokerURL() {
        return this.address;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public void setBrokerURL(MQAddress mQAddress) throws Exception {
        MQAddress mQAddress2 = this.address;
        this.address = mQAddress;
        this.parent.brokerChanged(ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), mQAddress2, this.address, null, null);
    }

    public boolean isLocalBroker() {
        return this.local;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized int getVersion() {
        return this.version == null ? 0 : this.version;
    }

    public synchronized void setVersion(int n) throws Exception {
        Integer n2 = this.version;
        this.version = new Integer(n);
        this.parent.brokerChanged(ClusterReason.VERSION_CHANGED, this.getBrokerName(), n2, this.version, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int n, Object object) {
        Integer n2 = null;
        UID uID = null;
        if (BrokerStatus.getBrokerIsDown(n)) {
            n = BrokerStatus.setBrokerLinkIsDown(n);
        } else if (BrokerStatus.getBrokerLinkIsDown(n)) {
            n = BrokerStatus.setBrokerIsDown(n);
        } else if (BrokerStatus.getBrokerLinkIsUp(n)) {
            n = BrokerStatus.setBrokerIsUp(n);
        } else if (BrokerStatus.getBrokerIsUp(n)) {
            n = BrokerStatus.setBrokerLinkIsUp(n);
        }
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            if (this.status == n) {
                return;
            }
            n2 = this.status;
            this.status = new Integer(n);
            uID = this.getBrokerSessionUID();
        }
        this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n2, this.status, uID, object);
        try {
            if (BrokerStatus.getBrokerIsUp(n)) {
                this.setState(BrokerState.OPERATING);
            }
            if (BrokerStatus.getBrokerIsDown(n)) {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Error setting state ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokerIsUp(boolean bl, UID uID, Object object) {
        UID uID2 = uID;
        Integer n = null;
        Integer n2 = null;
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            if (!bl && !uID2.equals((Object)this.getBrokerSessionUID())) {
                this.logger.log(8, this.br.getKString("B1337", "[BrokerSession:" + uID2 + "]", this.toString()));
                n = new Integer(16);
                n2 = BrokerStatus.setBrokerIsDown(n);
            } else {
                n = this.status;
                int n3 = 0;
                n3 = bl ? BrokerStatus.setBrokerIsUp(this.status) : BrokerStatus.setBrokerIsDown(this.status);
                this.status = new Integer(n3);
                uID2 = this.getBrokerSessionUID();
                n2 = this.status;
            }
        }
        this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, n2, uID2, object);
        try {
            if (bl) {
                this.setState(BrokerState.OPERATING);
            } else {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Error setting state ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokerLinkUp(boolean bl, Object object) {
        Integer n = null;
        UID uID = null;
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            n = this.status;
            uID = this.getBrokerSessionUID();
            int n2 = 0;
            n2 = bl ? BrokerStatus.setBrokerLinkIsUp(BrokerStatus.setBrokerIsUp(this.status)) : BrokerStatus.setBrokerLinkIsDown(BrokerStatus.setBrokerIsDown(this.status));
            this.status = new Integer(n2);
        }
        this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, this.status, uID, object);
        try {
            if (bl) {
                this.setState(BrokerState.OPERATING);
            } else {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Error setting state ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokerInDoubt(boolean bl, Object object) {
        UID uID = (UID)object;
        Integer n = null;
        Integer n2 = null;
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            if (bl && !uID.equals((Object)this.getBrokerSessionUID())) {
                this.logger.log(8, this.br.getKString("B1336", "[BrokerSession:" + uID + "]", this.toString()));
                n = new Integer(257);
                n2 = BrokerStatus.setBrokerInDoubt(n);
            } else {
                n = this.status;
                int n3 = 0;
                uID = this.getBrokerSessionUID();
                n3 = bl ? BrokerStatus.setBrokerInDoubt(this.status) : BrokerStatus.setBrokerNotInDoubt(this.status);
                n2 = this.status = new Integer(n3);
            }
        }
        this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, n2, uID, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ClusteredBrokerImpl clusteredBrokerImpl = this;
        synchronized (clusteredBrokerImpl) {
            this.status = new Integer(BrokerStatus.setBrokerIsDown(this.status));
        }
        if (!this.isConfigBroker()) {
            this.parent.removeFromAllBrokers(this.getBrokerName());
        }
        this.parent.brokerChanged(ClusterReason.REMOVED, this.getBrokerName(), this, null, this.getBrokerSessionUID(), null);
    }

    public BrokerState getState() {
        return this.state;
    }

    public void setState(BrokerState brokerState) throws IllegalAccessException, IllegalStateException, IllegalArgumentException {
        BrokerState brokerState2 = this.state;
        this.state = brokerState;
        this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, this.state, null, null);
    }

    public boolean isConfigBroker() {
        return this.configed;
    }

    protected void setConfigBroker(boolean bl) {
        this.configed = bl;
    }

    public synchronized UID getBrokerSessionUID() {
        return this.brokerSessionUID;
    }

    public synchronized void setBrokerSessionUID(UID uID) {
        this.brokerSessionUID = uID;
    }

    public boolean isBrokerIDGenerated() {
        return this.isgen;
    }
}

