/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClusterTakeoverMEPrepareInfo
implements ClusterProtocolHelper {
    protected Logger logger = Globals.getLogger();
    private String groupName = null;
    private String nodeName = null;
    private String masterHostPort = null;
    private Integer replicaPort = null;
    private byte[] commitToken = null;
    private String targetNodeName = null;
    private Long xid = null;
    private Cluster c = null;
    private String uuid = null;
    private Long syncTimeout = null;
    private GPacket pkt = null;

    private ClusterTakeoverMEPrepareInfo(String string, String string2, String string3, Integer n, byte[] byArray, Long l, String string4, String string5, Long l2, Cluster cluster) {
        this.groupName = string;
        this.nodeName = string2;
        this.masterHostPort = string3;
        this.replicaPort = n;
        this.targetNodeName = string4;
        this.xid = l2;
        this.c = cluster;
        this.commitToken = byArray;
        this.syncTimeout = l;
        this.uuid = string5;
    }

    private ClusterTakeoverMEPrepareInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterTakeoverMEPrepareInfo newInstance(String string, String string2, String string3, Integer n, byte[] byArray, Long l, String string4, String string5, Long l2, Cluster cluster) {
        return new ClusterTakeoverMEPrepareInfo(string, string2, string3, n, byArray, l, string4, string5, l2, cluster);
    }

    public static ClusterTakeoverMEPrepareInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterTakeoverMEPrepareInfo(gPacket, cluster);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)57);
        gPacket.putProp((Object)"groupName", (Object)this.groupName);
        gPacket.putProp((Object)"nodeName", (Object)this.nodeName);
        gPacket.putProp((Object)"masterHostPort", (Object)this.masterHostPort);
        gPacket.putProp((Object)"replicaPort", (Object)this.replicaPort);
        gPacket.putProp((Object)"clusterid", (Object)Globals.getClusterID());
        gPacket.putProp((Object)"targetNodeName", (Object)this.targetNodeName);
        gPacket.putProp((Object)"X", (Object)this.xid);
        gPacket.putProp((Object)"UUID", (Object)this.uuid);
        gPacket.putProp((Object)"TS", (Object)new Long(System.currentTimeMillis()));
        if (this.syncTimeout != null) {
            gPacket.putProp((Object)"syncTimeout", (Object)this.syncTimeout);
        }
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        gPacket.setPayload(ByteBuffer.wrap(this.commitToken));
        gPacket.setBit(1, true);
        return gPacket;
    }

    public String getGroupName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"groupName");
    }

    public String getNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"nodeName");
    }

    public String getMasterHostPort() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"masterHostPort");
    }

    public Integer getReplicaPort() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp((Object)"replicaPort");
    }

    public String getClusterID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"clusterid");
    }

    public byte[] getCommitToken() {
        assert (this.pkt != null);
        byte[] byArray = null;
        if (this.pkt.getPayload() != null) {
            byArray = this.pkt.getPayload().array();
        }
        return byArray;
    }

    public Long getSyncTimeout() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"syncTimeout");
    }

    public String getTargetNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"targetNodeName");
    }

    public BrokerAddress getOwnerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public String getUUID() {
        if (this.pkt != null) {
            return (String)this.pkt.getProp((Object)"UUID");
        }
        return this.uuid;
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"X");
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"TS");
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int n, String string, String string2) {
        assert (this.pkt != null);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)58);
        gPacket.putProp((Object)"X", (Object)((Long)this.pkt.getProp((Object)"X")));
        gPacket.putProp((Object)"S", (Object)new Integer(n));
        if (string != null) {
            gPacket.putProp((Object)"reason", (Object)string);
        }
        if (string2 != null) {
            gPacket.putProp((Object)"replicaHostPort", (Object)string2);
        }
        return gPacket;
    }

    public void sendReply(BrokerAddress brokerAddress, int n, String string, Object object) {
        if (!this.needReply()) {
            return;
        }
        String string2 = (String)object;
        GPacket gPacket = this.getReplyGPacket(n, string, string2);
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{ProtocolGlobals.getPacketTypeDisplayString(58), brokerAddress.toString(), this.toString()};
            BrokerResources brokerResources = Globals.getBrokerResources();
            Globals.getBrokerResources();
            this.logger.logStack(32, brokerResources.getKString("B3192", objectArray), (Throwable)exception);
        }
    }

    public String toString() {
        if (this.pkt == null) {
            return "[" + this.groupName + "[" + this.nodeName + ", " + this.masterHostPort + "]target=" + this.targetNodeName + ", timeout=" + this.syncTimeout + ", xid=" + this.xid + ", uuid=" + this.uuid + "]";
        }
        return "[" + this.getGroupName() + "[" + this.getNodeName() + ", " + this.getMasterHostPort() + "]target=" + this.getTargetNodeName() + ", timeout=" + this.getSyncTimeout() + ", xid=" + this.getXid() + ", uuid=" + this.getUUID() + ", time=" + this.getTimestamp() + "]";
    }

    protected static Long getReplyPacketXid(GPacket gPacket) {
        return (Long)gPacket.getProp((Object)"X");
    }

    protected String getReplyReplicaHostPort(GPacket gPacket) {
        return (String)gPacket.getProp((Object)"replicaHostPort");
    }
}

