/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.tcp;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Hashtable;

public class TcpStreams
implements ProtocolStreams {
    protected Socket socket = null;
    private InputStream is = null;
    private OutputStream os = null;
    protected boolean blocking = true;
    private int inputBufferSize = 0;
    private int outputBufferSize = 0;

    public TcpStreams(Socket socket) throws IOException {
        this(socket, true, 0, 0);
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public AbstractSelectableChannel getChannel() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.getChannel();
    }

    public TcpStreams(Socket socket, boolean bl, int n, int n2) throws IOException {
        this.blocking = bl;
        this.socket = socket;
        if (this.getChannel() != null) {
            this.getChannel().configureBlocking(bl);
        }
        this.inputBufferSize = n;
        this.outputBufferSize = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "Can not get an input stream without a socket"));
        }
        if (this.is == null) {
            TcpStreams tcpStreams = this;
            synchronized (tcpStreams) {
                if (this.is == null) {
                    if (this.socket == null) {
                        return null;
                    }
                    this.is = this.socket.getInputStream();
                    if (this.inputBufferSize > 0) {
                        this.is = new BufferedInputStream(this.is, this.inputBufferSize);
                    }
                }
            }
        }
        return this.is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "Can not get an output stream without a socket"));
        }
        if (this.os == null) {
            TcpStreams tcpStreams = this;
            synchronized (tcpStreams) {
                if (this.os == null) {
                    if (this.socket == null) {
                        return null;
                    }
                    this.os = this.socket.getOutputStream();
                    if (this.outputBufferSize > 0) {
                        this.os = new BufferedOutputStream(this.os, this.outputBufferSize);
                    }
                }
            }
        }
        return this.os;
    }

    public synchronized void close() throws IOException {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.getChannel() != null) {
            this.getChannel().close();
        }
        this.socket.close();
        this.socket = null;
    }

    public int getLocalPort() {
        if (this.socket == null) {
            return 0;
        }
        return this.socket.getLocalPort();
    }

    public int getRemotePort() {
        if (this.socket == null) {
            return 0;
        }
        return this.socket.getPort();
    }

    public InetAddress getLocalAddress() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.getLocalAddress();
    }

    public InetAddress getRemoteAddress() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.getInetAddress();
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public String toString() {
        return "tcp connection to " + this.socket;
    }

    public String toDebugString() {
        return this.toString() + this.socket + " inBufsz=" + this.inputBufferSize + ",outBufSz=" + this.outputBufferSize;
    }

    public Hashtable getDebugState() {
        return new Hashtable();
    }
}

