/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.CommitToken;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.CommitPointConsistencyPolicy;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ha.RepHAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ConfigRecordStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.DestinationStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.InitTakeoverRunnable;
import com.sun.messaging.jmq.jmsserver.persist.bdb.InterestStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.JoinRunnable;
import com.sun.messaging.jmq.jmsserver.persist.bdb.MessageEnumeration;
import com.sun.messaging.jmq.jmsserver.persist.bdb.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.PropertiesStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ReplicationStateChangeListener;
import com.sun.messaging.jmq.jmsserver.persist.bdb.TakeoverSessionStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.TxnStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.Util;
import com.sun.messaging.jmq.jmsserver.service.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BDBStore
extends Store {
    public static final int STORE_VERSION = 460;
    static final String BDB_PROP_PREFIX = "imq.persist.bdb.";
    static final String MAX_RETRIES_PROP = "imq.persist.bdb..maxRetriesOnLockConflict";
    static final String HOSTNAME_PROP = "imq.persist.bdb.replication.hostname";
    static final String PORTBASE_PROP = "imq.persist.bdb.replication.portbase";
    static final String REPLICA_SYNC_TIMEOUT_PROP = "imq.persist.bdb.replication.replicaSyncTimeout";
    static final String REPLICA_MAX_CLOCK_SKEW_PROP = "imq.persist.bdb.replication.maxClockSkew";
    private static final ConsumerUID[] emptysids = new ConsumerUID[0];
    private static final int[] emptystates = new int[0];
    static final int OP_DEFAULT_MAX_RETRIES = 5;
    static final int DEFAULT_REPLICA_SYNC_TIMEOUT = 3600;
    static final int DEFAULT_REPLICA_MAX_CLOCK_SKEW = 15;
    private Database dstDatabase = null;
    private Database intDatabase = null;
    private Database txnDatabase = null;
    private Database txnackDatabase = null;
    private Database configRecordDatabase = null;
    private Database propDatabase = null;
    private Database takeoverSessionDatabase = null;
    private Database classDatabase = null;
    private StoredClassCatalog classCatalog = null;
    private DestinationStore dstStore = null;
    private MsgStore msgStore = null;
    private InterestStore intStore = null;
    private PropertiesStore propStore = null;
    private TakeoverSessionStore takeoverSessionStore = null;
    private ConfigRecordStore configRecordStore = null;
    private TxnStore txnStore = null;
    static final String BDBSTORE_BASENAME = "bdb";
    static final String BDBSTORE_TOP = "bdb460";
    static final String REPLICA_TOP = "bdb460_replicas";
    static final String BROKERSTATE_FILENAME = "brokerstate";
    private Object replicaTOPLock = new Object();
    private int maxRetries = config.getIntProperty("imq.persist.bdb..maxRetriesOnLockConflict", 5);
    private long replicaSyncTimeout = config.getIntProperty("imq.persist.bdb.replication.replicaSyncTimeout", 3600);
    private long maxClockSkew = config.getIntProperty("imq.persist.bdb.replication.maxClockSkew", 15);
    private List<Enumeration> dataEnums = Collections.synchronizedList(new ArrayList());
    private TransactionConfig syncTxncf = null;
    protected Map<String, ReplicatedEnvironment> replicaEnvs = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, ExecutorService> joinExecutors = Collections.synchronizedMap(new LinkedHashMap());
    private Object replicaPortLock = new Object();
    private AtomicInteger nextReplicaPort = null;
    private int shutdownReplicaTimeout = 60;
    protected String myrepGroupName = null;
    protected String myrepNodeName = null;
    private File envhome = null;
    private Environment dbEnv = null;
    private DatabaseConfig dbcf = null;
    private boolean replica = false;
    private ExecutorService joinExecutor = null;
    ReplicationStateChangeListener repStateListener = null;
    private static final String BROKERSTATE_HOSTPORT = "HOSTPORT:";
    private static final String BROKERSTATE_TAKEOVER_ME_BEGIN = "TAKEOVER_ME:";
    private static final String BROKERSTATE_TAKEOVER_ME_PREPARED = "TAKEOVER_ME_PREPARED";
    private static final String BROKERSTATE_TAKEOVER_ME_ACKED = "TAKEOVER_ME_ACKED";

    public BDBStore() throws BrokerException {
        String string = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName() + File.separator;
        File file = new File(string);
        this.envhome = new File(file, BDBSTORE_TOP);
        if (this.removeStore && !this.envhome.exists()) {
            return;
        }
        UID uID = null;
        boolean bl = false;
        String string2 = null;
        try {
            Object object;
            block49: {
                Object object2;
                File file2;
                DataInputStream dataInputStream;
                File file3;
                if (!StoreManager.bdbREPEnabled()) {
                    throw new BrokerException("imq.persist.bdb.replication.enabled=false not supported");
                }
                if (StoreManager.bdbREPEnabled() && Globals.getClusterID() == null) {
                    throw new BrokerException("imq.cluster.clusterid must set when replication enabled");
                }
                if (!this.envhome.exists()) {
                    if (!this.envhome.mkdirs()) {
                        logger.log(32, "B3017", (Object)this.envhome);
                        throw new BrokerException(br.getString("B3017", this.envhome));
                    }
                    if (StoreManager.bdbREPEnabled()) {
                        bl = true;
                        uID = this.writeToBrokerStateNewStoreSession(this.envhome, true);
                    }
                } else if (StoreManager.bdbREPEnabled()) {
                    file3 = new File(this.envhome, BROKERSTATE_FILENAME);
                    if (!file3.exists()) {
                        throw new BrokerException("brokerstate not found");
                    }
                    dataInputStream = new DataInputStream(new FileInputStream(file3));
                    uID = new UID(Long.valueOf(dataInputStream.readUTF()).longValue());
                    boolean bl2 = false;
                    object = null;
                    try {
                        while (true) {
                            if (((String)(object = dataInputStream.readUTF())).startsWith(BROKERSTATE_HOSTPORT)) {
                                int n = ((String)object).indexOf(":");
                                string2 = ((String)object).substring(BROKERSTATE_HOSTPORT.length());
                                continue;
                            }
                            if (((String)object).equals(BROKERSTATE_TAKEOVER_ME_PREPARED)) break;
                        }
                        bl2 = true;
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                    dataInputStream.close();
                    if (bl2) {
                        File file4 = new File(this.envhome.getPath() + "." + uID + ".deleted");
                        if (!this.envhome.renameTo(file4)) {
                            throw new BrokerException("Unable to rename " + this.envhome + " to " + file4);
                        }
                        file2 = new File(file, REPLICA_TOP);
                        if (file2.exists() && !file2.renameTo((File)(object2 = new File(file2.getPath() + "." + uID + ".deleted")))) {
                            throw new BrokerException("Unable to rename " + file2 + " to " + object2);
                        }
                        if (!this.envhome.mkdirs()) {
                            logger.log(32, "B3017", (Object)this.envhome);
                            throw new BrokerException(br.getString("B3017", this.envhome));
                        }
                        if (StoreManager.bdbREPEnabled()) {
                            bl = true;
                            uID = this.writeToBrokerStateNewStoreSession(this.envhome, true);
                        }
                    }
                }
                this.syncTxncf = new TransactionConfig();
                this.syncTxncf.setDurability(Durability.COMMIT_SYNC);
                file3 = new Durability(Durability.SyncPolicy.WRITE_NO_SYNC, Durability.SyncPolicy.WRITE_NO_SYNC, Durability.ReplicaAckPolicy.NONE);
                dataInputStream = new EnvironmentConfig();
                dataInputStream.setAllowCreate(!this.removeStore && this.createStore);
                dataInputStream.setTransactional(true);
                dataInputStream.setReadOnly(false);
                dataInputStream.setDurability((Durability)file3);
                dataInputStream.setTxnTimeout(60L, TimeUnit.SECONDS);
                this.dbcf = new DatabaseConfig();
                this.dbcf.setAllowCreate(!this.removeStore && this.createStore);
                this.dbcf.setTransactional(true);
                this.dbcf.setSortedDuplicates(false);
                if (!this.removeStore) {
                    if (this.createStore) {
                        logger.log(8, "B1170");
                    } else {
                        logger.log(8, "B1171");
                    }
                }
                logger.logToAll(8, "Using Berkeley DB Java Edition " + JEVersion.CURRENT_VERSION);
                try {
                    if (!StoreManager.bdbREPEnabled()) {
                        this.dbEnv = new Environment(this.envhome, (EnvironmentConfig)dataInputStream);
                        logger.logToAll(8, "BDB EnvironmentConfig: " + this.dbEnv.getConfig());
                    } else {
                        String string3 = null;
                        while (true) {
                            object = new ReplicationConfig();
                            this.myrepGroupName = BDBStore.makeReplicationGroupID(Globals.getConfigName(), uID);
                            object.setMaxClockDelta(this.maxClockSkew, TimeUnit.SECONDS);
                            object.setDesignatedPrimary(true);
                            object.setConfigParam("je.rep.electableGroupSizeOverride", "1");
                            object.setConfigParam("je.rep.electionsPrimaryRetries", "1");
                            object.setGroupName(this.myrepGroupName);
                            this.myrepNodeName = BDBStore.makeReplicationNodeName(Globals.getConfigName(), uID);
                            object.setNodeName(this.myrepNodeName);
                            string3 = this.getMyReplicationHostPort();
                            if (!bl && string2 != null && !string2.equals(string3)) {
                                String string4 = "Replication hostport cannot be changed for an existing store session. This broker's current store session " + uID + " had hostport " + string2 + ", but new hostport is " + string3;
                                logger.log(32, string4);
                                throw new BrokerException(string4);
                            }
                            object.setNodeHostPort(string3);
                            logger.log(8, "BDB replication group " + this.myrepGroupName + " on [" + this.myrepNodeName + ", " + string3 + "]");
                            object.setHelperHosts(string3);
                            this.dbEnv = new ReplicatedEnvironment(this.envhome, (ReplicationConfig)object, (EnvironmentConfig)dataInputStream);
                            this.repStateListener = new ReplicationStateChangeListener(this, this.myrepNodeName, this.myrepGroupName);
                            ((ReplicatedEnvironment)this.dbEnv).setStateChangeListener((StateChangeListener)this.repStateListener);
                            try {
                                logger.log(8, "Waiting becoming BDB replication master for group " + this.myrepGroupName);
                                this.repStateListener.waitBecomeMaster(30000L);
                            }
                            catch (Exception exception) {
                                if (bl) {
                                    throw exception;
                                }
                                if (!(exception instanceof BrokerException)) {
                                    throw exception;
                                }
                                logger.log(8, "Store session " + uID + " has been taken over by someone, start new store session");
                                this.dbEnv.close();
                                file2 = new File(file, "bdb460.deleted");
                                if (!this.envhome.renameTo(file2)) {
                                    throw new BrokerException(br.getKString("B2249", this.envhome.getPath(), file2.getPath()));
                                }
                                if (!this.envhome.mkdirs()) {
                                    logger.log(32, "B3017", (Object)this.envhome);
                                    throw new BrokerException(br.getString("B3017", this.envhome));
                                }
                                uID = this.writeToBrokerStateNewStoreSession(this.envhome, true);
                                bl = true;
                                continue;
                            }
                            break;
                        }
                        if (bl) {
                            this.writeToBrokerState(BROKERSTATE_HOSTPORT + string3);
                        }
                        logger.logToAll(8, "BDB ReplicatedEnvironmentConfig: " + this.dbEnv.getConfig());
                        Globals.setStoreSession(uID);
                        ((RepHAClusteredBrokerImpl)Globals.getClusterManager().getLocalBroker()).setStoreSessionUID(uID);
                        object = ((ReplicatedEnvironment)this.dbEnv).getGroup().getElectableNodes();
                        ReplicationNode replicationNode = null;
                        int n = 0;
                        object2 = object.iterator();
                        while (object2.hasNext()) {
                            replicationNode = (ReplicationNode)object2.next();
                            int n2 = replicationNode.getPort();
                            if (n2 <= n) continue;
                            n = n2;
                        }
                        this.nextReplicaPort = new AtomicInteger(n + 1);
                        logger.logToAll(8, "BDB store started with store session " + uID);
                    }
                }
                catch (EnvironmentNotFoundException environmentNotFoundException) {
                    if (!this.removeStore) break block49;
                    logger.log(8, environmentNotFoundException.getMessage());
                    return;
                }
            }
            if (StoreManager.bdbREPEnabled()) {
                logger.logToAll(8, "BDB ReplicationConfig: " + ((ReplicatedEnvironment)this.dbEnv).getRepConfig());
            }
            if (this.removeStore) {
                Transaction transaction = this.dbEnv.beginTransaction(null, null);
                try {
                    transaction.setTxnTimeout(300L, TimeUnit.SECONDS);
                    object = this.dbEnv.getDatabaseNames();
                    for (int i = 0; i < object.size(); ++i) {
                        this.dbEnv.removeDatabase(transaction, (String)object.get(i));
                    }
                    transaction.commit(new Durability(Durability.SyncPolicy.SYNC, null, null));
                    return;
                }
                catch (Exception exception) {
                    logger.logStack(32, "Failed to remove store ", (Throwable)exception);
                    try {
                        transaction.abort();
                    }
                    catch (Exception exception2) {
                        logger.logStack(16, "Abort removing store transaction failed", (Throwable)exception2);
                    }
                    throw new BrokerException(exception.getMessage(), exception);
                }
            }
            if (this.resetStore) {
                this.truncateDatabases(this.dbEnv);
            }
            this.classDatabase = this.dbEnv.openDatabase(null, "classdb", this.dbcf);
            this.classCatalog = new StoredClassCatalog(this.classDatabase);
            this.openStores(this.dbEnv);
            if (this.resetStore) {
                this.clearMessages(false);
            } else {
                if (this.resetMessage) {
                    this.clearMessages(true);
                }
                if (this.resetInterest) {
                    this.clearInterests();
                }
            }
        }
        catch (Exception exception) {
            logger.logStack(32, exception.getMessage(), (Throwable)exception);
            this.close();
            throw new BrokerException(exception.getMessage(), exception);
        }
    }

    private BDBStore(Environment environment) throws BrokerException {
        this.replica = true;
        this.dbEnv = environment;
        this.dbcf = new DatabaseConfig();
        this.dbcf.setAllowCreate(false);
        this.dbcf.setTransactional(true);
        this.dbcf.setSortedDuplicates(false);
        this.classDatabase = this.dbEnv.openDatabase(null, "classdb", this.dbcf);
        this.classCatalog = new StoredClassCatalog(this.classDatabase);
        this.openStores(environment);
    }

    private boolean isReplica() {
        return this.replica;
    }

    @Override
    public String getMyReplicationGroupName() {
        return this.myrepGroupName;
    }

    @Override
    public String getMyReplicationNodeName() {
        return this.myrepNodeName;
    }

    @Override
    public long getDefaultReplicaSyncTimeout() throws BrokerException {
        return this.replicaSyncTimeout;
    }

    @Override
    public String getMyReplicationHostPort() throws BrokerException {
        int n;
        String string = Globals.getBrokerInetAddress().getHostAddress();
        String string2 = Globals.getConfig().getProperty(PORTBASE_PROP);
        if (string2 == null) {
            return string + ":" + new ReplicationConfig().getNodePort();
        }
        try {
            n = Integer.parseInt(string2);
            if (n <= 0) {
                throw new IllegalArgumentException("Invalid value " + string2 + " for property " + PORTBASE_PROP);
            }
        }
        catch (Exception exception) {
            throw new BrokerException("Invalid value " + string2 + " for property " + PORTBASE_PROP, exception);
        }
        return string + ":" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getMyReplicaPort(String string, BrokerMQAddress brokerMQAddress, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "getMyReplicaPort(" + (Object)((Object)brokerMQAddress) + ")");
        }
        if (string.equals(this.getMyReplicationNodeName())) {
            throw new BrokerException("Unexpected call to getMyReplicaPort for " + string + " which is same as this broker");
        }
        if (bl) {
            super.checkClosedAndSetInProgress();
        }
        try {
            Set set = ((ReplicatedEnvironment)this.dbEnv).getGroup().getElectableNodes();
            logger.log(8, "This broker current replication group [" + this.getMyReplicationGroupName() + "] members: " + set);
            Integer n = null;
            ReplicationNode replicationNode2 = null;
            ArrayList arrayList = new ArrayList();
            for (ReplicationNode replicationNode2 : set) {
                n = replicationNode2.getPort();
                if (!replicationNode2.getName().equals(string) || !replicationNode2.getSocketAddress().getAddress().equals(brokerMQAddress.getHost())) continue;
                Integer n2 = n;
                return n2;
            }
            if (this.nextReplicaPort == null) {
                throw new BrokerException("Unexpected: replica port not initialized");
            }
            Integer n3 = this.nextReplicaPort.addAndGet(1);
            return n3;
        }
        finally {
            if (bl) {
                super.setInProgress(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMyReplicas() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "getMyReplicas()");
        }
        super.checkClosedAndSetInProgress();
        try {
            Set set = ((ReplicatedEnvironment)this.dbEnv).getGroup().getElectableNodes();
            logger.log(8, "This broker current replication group [" + this.getMyReplicationGroupName() + "] members: " + set);
            String string = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string = ((ReplicationNode)iterator.next()).getName();
                if (string.equals(this.getMyReplicationNodeName())) continue;
                arrayList.add(string);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public static String getInstNameFromNodeName(String string) throws BrokerException {
        int n = string.lastIndexOf("S");
        if (n < 0 || n >= string.length() - 1) {
            String string2 = "Malformed replicain node name " + string;
            throw new BrokerException(string2);
        }
        String string3 = string.substring(0, n);
        if (string3 == null || string3.trim().length() == 0) {
            String string4 = "Malformed replicain node name " + string;
            throw new BrokerException(string4);
        }
        String string5 = string.substring(n + 1);
        try {
            Long l = Long.valueOf(string5);
        }
        catch (Exception exception) {
            String string6 = "Malformed replicain node name " + string;
            throw new BrokerException(string6, exception);
        }
        return string3;
    }

    public static UID getStoreSessionFromNodeName(String string) throws BrokerException {
        int n = string.lastIndexOf("S");
        if (n < 0 || n >= string.length() - 1) {
            String string2 = "Malformed replicain node name " + string;
            throw new BrokerException(string2);
        }
        String string3 = string.substring(0, n);
        if (string3 == null || string3.trim().length() == 0) {
            String string4 = "Malformed repliction node name " + string;
            throw new BrokerException(string4);
        }
        String string5 = string.substring(n + 1);
        Long l = null;
        try {
            l = Long.valueOf(string5);
        }
        catch (Exception exception) {
            String string6 = "Malformed replicain node name " + string;
            throw new BrokerException(string6, exception);
        }
        return new UID(l.longValue());
    }

    public String toString() {
        if (this.dbEnv == null) {
            return "[BDBStore@" + super.toString() + "]";
        }
        return "[" + this.dbEnv.getHome().getName() + "@" + super.toString() + "]";
    }

    private UID writeToBrokerStateNewStoreSession(File file, boolean bl) throws BrokerException {
        UID uID = new UID();
        String string = BROKERSTATE_FILENAME;
        try {
            File file2 = new File(file, BROKERSTATE_FILENAME);
            string = file2.getPath();
            if (bl && !file2.createNewFile()) {
                throw new IOException(string + " exists but expected not exist");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.writeUTF(String.valueOf(uID));
            dataOutputStream.flush();
            fileOutputStream.getChannel().force(true);
            dataOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            String string2 = "Unable to persist broker store session " + uID + " to file " + string;
            logger.logStack(32, string2, (Throwable)exception);
            throw new BrokerException(string2);
        }
        return uID;
    }

    private void writeToBrokerState(String string) throws BrokerException {
        String string2 = BROKERSTATE_FILENAME;
        try {
            File file = new File(this.envhome, BROKERSTATE_FILENAME);
            string2 = file.getPath();
            if (!file.exists()) {
                throw new IOException(string2 + " does not exist");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
            fileOutputStream.getChannel().force(true);
            dataOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            String string3 = "Unable to persist takeoverme state to file " + string2;
            logger.logStack(32, string3, (Throwable)exception);
            throw new BrokerException(string3);
        }
    }

    private void openStores(Environment environment) throws BrokerException {
        String string = this.isReplica() ? "replicated" : "";
        try {
            this.dstDatabase = environment.openDatabase(null, "dststore", this.dbcf);
            this.intDatabase = environment.openDatabase(null, "intstore", this.dbcf);
            this.txnDatabase = environment.openDatabase(null, "txnstore", this.dbcf);
            this.txnackDatabase = environment.openDatabase(null, "txnackstore", this.dbcf);
            this.configRecordDatabase = environment.openDatabase(null, "crstore", this.dbcf);
            this.propDatabase = environment.openDatabase(null, "propstore", this.dbcf);
            this.takeoverSessionDatabase = environment.openDatabase(null, "takeovers", this.dbcf);
            this.dstStore = new DestinationStore(this);
            this.msgStore = new MsgStore(this, this.dstStore);
            this.intStore = new InterestStore(this);
            this.txnStore = new TxnStore(this);
            this.propStore = new PropertiesStore(this);
            this.takeoverSessionStore = new TakeoverSessionStore(this);
            this.configRecordStore = new ConfigRecordStore(this);
        }
        catch (Exception exception) {
            String string2 = "Failed to open " + string + " store databases  " + environment;
            logger.logStack(32, string2, (Throwable)exception);
            throw new BrokerException(string2, exception);
        }
    }

    private void truncateDatabases(Environment environment) throws BrokerException {
        String string = this.isReplica() ? "replica[" + environment + "]" : "";
        Transaction transaction = environment.beginTransaction(null, null);
        try {
            transaction.setTxnTimeout(300L, TimeUnit.SECONDS);
            List list = environment.getDatabaseNames();
            String string2 = null;
            for (int i = 0; i < list.size(); ++i) {
                string2 = (String)list.get(i);
                if (string2.equals("dststore")) continue;
                environment.truncateDatabase(transaction, (String)list.get(i), false);
            }
            transaction.commit(new Durability(Durability.SyncPolicy.SYNC, null, null));
        }
        catch (Exception exception) {
            logger.logStack(32, "Failed to reset " + string + " store", (Throwable)exception);
            try {
                transaction.abort();
            }
            catch (Exception exception2) {
                logger.logStack(16, "Failed to abort reset " + string + " store transaction", (Throwable)exception2);
            }
            throw new BrokerException(exception.getMessage(), exception);
        }
    }

    protected Environment getDBEnv() {
        return this.dbEnv;
    }

    @Override
    public final int getStoreVersion() {
        return 460;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeWaitOnClose() {
        Iterator<Enumeration> iterator = null;
        List<Enumeration> list = this.dataEnums;
        synchronized (list) {
            iterator = this.dataEnums.iterator();
            Enumeration enumeration = null;
            while (iterator.hasNext()) {
                enumeration = iterator.next();
                if (!(enumeration instanceof MessageEnumeration)) continue;
                ((MessageEnumeration)enumeration).cancel();
            }
        }
    }

    @Override
    public void close(boolean bl) {
        if (this.closed) {
            return;
        }
        logger.logToAll(8, "Closing BDB store .. ");
        super.setClosedAndWait();
        try {
            this.closeStores(false);
        }
        catch (Exception exception) {
            logger.log(16, "Exception in closing store: " + exception.getMessage());
        }
    }

    private void closeStores(boolean bl) throws Exception {
        block50: {
            int n;
            block49: {
                block48: {
                    block47: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                block40: {
                                                    String string = this.isReplica() ? "replica[" + this.dbEnv + "]" : "";
                                                    int n2 = n = bl ? 32 : 16;
                                                    if (this.msgStore != null) {
                                                        this.msgStore.close();
                                                    }
                                                    if (this.dstStore != null) {
                                                        this.dstStore.close();
                                                    }
                                                    if (this.intStore != null) {
                                                        this.intStore.close();
                                                    }
                                                    if (this.txnStore != null) {
                                                        this.txnStore.close();
                                                    }
                                                    if (this.propStore != null) {
                                                        this.propStore.close();
                                                    }
                                                    if (this.configRecordStore != null) {
                                                        this.configRecordStore.close();
                                                    }
                                                    if (this.takeoverSessionStore != null) {
                                                        this.takeoverSessionStore.close();
                                                    }
                                                    try {
                                                        if (this.dstDatabase != null) {
                                                            this.dstDatabase.close();
                                                        }
                                                    }
                                                    catch (Exception exception) {
                                                        logger.logStack(n, "Exception in closing destination database", (Throwable)exception);
                                                        if (!bl) break block40;
                                                        throw exception;
                                                    }
                                                }
                                                try {
                                                    if (this.intDatabase != null) {
                                                        this.intDatabase.close();
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    logger.logStack(n, "Exception in closing interest database", (Throwable)exception);
                                                    if (!bl) break block41;
                                                    throw exception;
                                                }
                                            }
                                            try {
                                                if (this.txnDatabase != null) {
                                                    this.txnDatabase.close();
                                                }
                                            }
                                            catch (Exception exception) {
                                                logger.logStack(n, "Exception in closing transaction database", (Throwable)exception);
                                                if (!bl) break block42;
                                                throw exception;
                                            }
                                        }
                                        try {
                                            if (this.txnackDatabase != null) {
                                                this.txnackDatabase.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            logger.logStack(n, "Exception in closing transaction ack database", (Throwable)exception);
                                            if (!bl) break block43;
                                            throw exception;
                                        }
                                    }
                                    try {
                                        if (this.configRecordDatabase != null) {
                                            this.configRecordDatabase.close();
                                        }
                                    }
                                    catch (Exception exception) {
                                        logger.logStack(n, "Exception in closing cluster configuration change record database", (Throwable)exception);
                                        if (!bl) break block44;
                                        throw exception;
                                    }
                                }
                                try {
                                    if (this.propDatabase != null) {
                                        this.propDatabase.close();
                                    }
                                }
                                catch (Exception exception) {
                                    logger.logStack(n, "Exception in closing properties database", (Throwable)exception);
                                    if (!bl) break block45;
                                    throw exception;
                                }
                            }
                            try {
                                if (this.takeoverSessionDatabase != null) {
                                    this.takeoverSessionDatabase.close();
                                }
                            }
                            catch (Exception exception) {
                                logger.logStack(n, "Exception in closing takeover session database", (Throwable)exception);
                                if (!bl) break block46;
                                throw exception;
                            }
                        }
                        try {
                            if (this.classCatalog != null) {
                                this.classCatalog.close();
                            }
                        }
                        catch (Exception exception) {
                            logger.logStack(n, "Exception in closing class catalog", (Throwable)exception);
                            if (!bl) break block47;
                            throw exception;
                        }
                    }
                    try {
                        if (this.classDatabase != null) {
                            this.classDatabase.close();
                        }
                    }
                    catch (Exception exception) {
                        logger.logStack(n, "Exception in closing class catalog database", (Throwable)exception);
                        if (!bl) break block48;
                        throw exception;
                    }
                }
                if (this.dbEnv instanceof ReplicatedEnvironment && !this.isReplica()) {
                    try {
                        logger.log(8, "Shutdown BDB replication group " + this.myrepGroupName);
                        ((ReplicatedEnvironment)this.dbEnv).shutdownGroup((long)this.shutdownReplicaTimeout, TimeUnit.SECONDS);
                    }
                    catch (Exception exception) {
                        logger.logStack(n, "Exception in shutdown BDB replicated environment", (Throwable)exception);
                        if (!bl) break block49;
                        throw exception;
                    }
                }
            }
            try {
                if (this.dbEnv != null) {
                    this.dbEnv.close();
                }
            }
            catch (Exception exception) {
                logger.logStack(n, "Exception in closing BDB environment", (Throwable)exception);
                if (!bl) break block50;
                throw exception;
            }
        }
        logger.log(8, "BDB store close complete");
    }

    @Override
    public void clearAll(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.clearAll(" + bl + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.closeStores(true);
            this.truncateDatabases(this.dbEnv);
            this.openStores(this.dbEnv);
            this.clearMessages(false);
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            throw new BrokerException("Close store failed: " + exception.getMessage(), exception);
        }
        finally {
            this.setInProgress(false);
        }
    }

    private void clearMessages(boolean bl) throws BrokerException {
        Transaction transaction = this.dbEnv.beginTransaction(null, null);
        try {
            transaction.setTxnTimeout(300L, TimeUnit.SECONDS);
            this.dstStore.clearAll(transaction, bl);
            transaction.commit(new Durability(Durability.SyncPolicy.SYNC, null, null));
            return;
        }
        catch (Exception exception) {
            logger.logStack(32, "Clear all messages in store failed", (Throwable)exception);
            try {
                transaction.abort();
            }
            catch (Exception exception2) {
                logger.logStack(16, "Failed to abort clear messages transaction", (Throwable)exception2);
            }
            throw new BrokerException(exception.getMessage(), exception);
        }
    }

    private void clearInterests() throws BrokerException {
        Transaction transaction = this.dbEnv.beginTransaction(null, null);
        try {
            transaction.setTxnTimeout(300L, TimeUnit.SECONDS);
            this.intStore.clearAll(transaction);
            transaction.commit(new Durability(Durability.SyncPolicy.SYNC, null, null));
            return;
        }
        catch (Exception exception) {
            logger.logStack(32, "Clear all interests in store failed", (Throwable)exception);
            try {
                transaction.abort();
            }
            catch (Exception exception2) {
                logger.logStack(16, "Failed to abort clear interests transaction", (Throwable)exception2);
            }
            throw new BrokerException(exception.getMessage(), exception);
        }
    }

    protected CommitToken storeTakeoverSession(String string, String string2, boolean bl, boolean bl2) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeTakeoverSession(" + string + ", " + string2 + ")");
        }
        if (bl) {
            this.checkClosedAndSetInProgress();
        }
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, this.syncTxncf);
                    this.takeoverSessionStore.storeTakeoverSession(transaction, string, string2, bl2);
                    transaction.commit();
                    CommitToken commitToken = transaction.getCommitToken();
                    return commitToken;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeTakeoverSession(" + string + ", " + string2 + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                this.setInProgress(false);
            }
        }
    }

    protected String getTakeoverSessionState(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTakeoverSessionState(" + string + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, this.syncTxncf);
                    String string2 = this.takeoverSessionStore.getTakeoverSessionState(transaction, string);
                    transaction.commit();
                    String string3 = string2;
                    return string3;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getTakeoverSessionState(" + string + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    protected void updateTakeoverSessionState(String string, String string2, String string3) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateTakeoverSessionState(" + string + ", " + string2 + ", " + string3 + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, this.syncTxncf);
                    this.takeoverSessionStore.updateTakeoverSessionState(transaction, string, string2, string3);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeTakeoverSession(" + string + ", " + string2 + ", " + string3 + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeMessage(" + packet.getSysMessageID() + "[" + destinationUID + "])");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.msgStore.storeMessage(transaction, destinationUID, packet, consumerUIDArray, nArray);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeMessage(" + packet.getSysMessageID() + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeMessage(" + packet.getSysMessageID() + "[" + destinationUID + "])");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.msgStore.storeMessage(transaction, destinationUID, packet, emptysids, emptystates);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeMessage(" + packet.getSysMessageID() + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl, boolean bl2) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeMessage(" + sysMessageID + "[" + destinationUID + "])");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.msgStore.removeMessage(transaction, destinationUID, sysMessageID);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "removeMessage(" + sysMessageID + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.moveMessage(" + packet.getSysMessageID() + "[" + destinationUID + ", " + destinationUID2 + "])");
        }
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        if (consumerUIDArray == null) {
            consumerUIDArray = emptysids;
            nArray = emptystates;
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.msgStore.moveMessage(transaction, packet, destinationUID, destinationUID2, consumerUIDArray, nArray);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "moveMessage(" + packet.getSysMessageID() + "[" + destinationUID + ", " + destinationUID2 + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeAllMessages(Destination destination, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeAllMessages(" + destination + ")");
        }
        throw new BrokerException("not implemented");
    }

    @Override
    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.messageEnumeration(" + destination + ") called");
        }
        this.checkClosedAndSetInProgress();
        Enumeration enumeration = null;
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    enumeration = this.msgStore.messageEnumeration(transaction, destination);
                    transaction.commit();
                    this.dataEnums.add(enumeration);
                    return enumeration;
                }
                catch (Throwable throwable) {
                    if (enumeration != null) {
                        this.dataEnums.remove(enumeration);
                        ((MessageEnumeration)enumeration).close();
                    }
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "messageEnumeration(" + destination + ")", this);
                    }
                    retryStrategy.assertShouldRetry(throwable);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                if (enumeration != null) {
                    this.dataEnums.remove(enumeration);
                    ((MessageEnumeration)enumeration).close();
                }
                if (throwable instanceof BrokerException) {
                    throw (BrokerException)throwable;
                }
                throw new BrokerException(throwable.toString(), throwable);
            }
            catch (Throwable throwable2) {
                this.setInProgress(false);
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEnumeration(Enumeration enumeration) {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.closeEnumeration(" + (enumeration == null ? "null" : enumeration.getClass().getName()) + ") called");
        }
        if (!(enumeration instanceof MessageEnumeration)) {
            return;
        }
        try {
            this.dataEnums.remove(enumeration);
            ((MessageEnumeration)enumeration).close();
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Packet getMessage(DestinationUID destinationUID, String string) throws BrokerException {
        return this.getMessage(destinationUID, SysMessageID.get((String)string));
    }

    @Override
    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getMessage(" + sysMessageID + "[" + destinationUID + "]) called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    Packet packet = this.msgStore.getMessage(transaction, destinationUID, sysMessageID);
                    transaction.commit();
                    Packet packet2 = packet;
                    return packet2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getMessage(" + sysMessageID + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl, Packet packet) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeInterestStates(" + sysMessageID + "[" + destinationUID + "]) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.msgStore.storeInterestStates(transaction, destinationUID, sysMessageID, consumerUIDArray, nArray);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeInterestStates(" + sysMessageID + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl, TransactionUID transactionUID, boolean bl2) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "BDBStore.updateInterestState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.msgStore.updateInterestState(transaction, destinationUID, sysMessageID, consumerUID, n);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "updateInterestState(" + sysMessageID + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getInterestState(" + sysMessageID + "[" + destinationUID + "]) called");
        }
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    int n = this.msgStore.getInterestState(transaction, destinationUID, sysMessageID, consumerUID);
                    transaction.commit();
                    int n2 = n;
                    return n2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getInterestState(" + sysMessageID + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getInterestStates(" + sysMessageID + "[" + destinationUID + "]) called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    HashMap hashMap = this.msgStore.getInterestStates(transaction, destinationUID, sysMessageID);
                    transaction.commit();
                    HashMap hashMap2 = hashMap;
                    return hashMap2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getInterestStates(" + sysMessageID + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getConsumerUIDs(" + sysMessageID + "[" + destinationUID + "]) called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    ConsumerUID[] consumerUIDArray = this.msgStore.getUnAckedConsumerUIDs(transaction, destinationUID, sysMessageID);
                    transaction.commit();
                    ConsumerUID[] consumerUIDArray2 = consumerUIDArray;
                    return consumerUIDArray2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getConsumerUIDs(" + sysMessageID + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public boolean hasMessageBeenAcked(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.hasMessageBeenAcked(" + sysMessageID + "[" + destinationUID + "]) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    boolean bl = this.msgStore.hasMessageBeenAcked(transaction, destinationUID, sysMessageID);
                    transaction.commit();
                    boolean bl2 = bl;
                    return bl2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "hasMessageBeenAcked(" + sysMessageID + "[" + destinationUID + "])", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeInterest(Consumer consumer, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeInterest(" + consumer + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.intStore.storeInterest(transaction, consumer);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeInterest(" + consumer + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeInterest(Consumer consumer, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeInterest(" + consumer + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.intStore.removeInterest(transaction, consumer);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "removeInterest(" + consumer + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Consumer[] getAllInterests() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    Consumer[] consumerArray = this.intStore.getAllInterests(transaction);
                    transaction.commit();
                    Consumer[] consumerArray2 = consumerArray;
                    return consumerArray2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getAllInterests()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeDestination(Destination destination, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeDestination( " + destination + ")");
        }
        if (destination == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.dstStore.storeDestination(transaction, destination);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeDestination(" + destination + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateDestination(" + destination + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.dstStore.updateDestination(transaction, destination);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "updateDestination(" + destination + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeDestination(Destination destination, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeDestination(" + destination + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.dstStore.removeDestination(transaction, destination);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "removeDestination(" + destination + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Destination getDestination(DestinationUID destinationUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getDestination(" + destinationUID + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    Destination destination = this.dstStore.getDestination(transaction, destinationUID);
                    transaction.commit();
                    Destination destination2 = destination;
                    return destination2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getDestination(" + destinationUID + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Destination[] getAllDestinations() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllDestinations()");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    Destination[] destinationArray = this.dstStore.getAllDestinations(transaction);
                    transaction.commit();
                    Destination[] destinationArray2 = destinationArray;
                    return destinationArray2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getAllDestinations()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeTransaction(" + transactionUID + "[" + transactionState + "]) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.storeTransaction(transaction, transactionUID, transactionState);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeTransaction(" + transactionUID + ", " + transactionState + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws BrokerException {
        this.removeTransaction(transactionUID, false, bl);
    }

    @Override
    public void removeTransaction(TransactionUID transactionUID, boolean bl, boolean bl2) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeTransaction(" + transactionUID + ", " + bl + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl2 ? this.syncTxncf : null);
                    if (bl) {
                        this.txnStore.removeTransactionAck(transaction, transactionUID);
                    }
                    this.txnStore.removeTransaction(transaction, transactionUID);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "removeTransaction(" + transactionUID + ", " + bl + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateTransactionState(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateTransactionState(" + transactionUID + ", " + transactionState + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.updateTransactionState(transaction, transactionUID, transactionState.getState());
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "updateTransactionState(" + transactionUID + ", " + transactionState + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllTransactionStates() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "BDBStore.getAllTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    HashMap hashMap = this.txnStore.getAllTransactionStates(transaction);
                    transaction.commit();
                    HashMap hashMap2 = hashMap;
                    return hashMap2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getAllTransactionStates()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeTransactionAck(" + transactionUID + ", " + transactionAcknowledgement + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.storeTransactionAck(transaction, transactionUID, transactionAcknowledgement);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeTransactionAck(" + transactionUID + ", " + transactionAcknowledgement + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeTransactionAck(" + transactionUID + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.removeTransactionAck(transaction, transactionUID);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "removeTransactionAck(" + transactionUID + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTransactionAcks(" + transactionUID + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    TransactionAcknowledgement[] transactionAcknowledgementArray = this.txnStore.getTransactionAcks(transaction, transactionUID);
                    transaction.commit();
                    TransactionAcknowledgement[] transactionAcknowledgementArray2 = transactionAcknowledgementArray;
                    return transactionAcknowledgementArray2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getTransactionAcks(" + transactionUID + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    HashMap hashMap = this.txnStore.getAllTransactionAcks(transaction);
                    transaction.commit();
                    HashMap hashMap2 = hashMap;
                    return hashMap2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getAllTransactionAcks()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeTransaction(" + transactionUID + ", " + transactionInfo + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.storeTransaction(transaction, transactionUID, transactionInfo);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeTransaction(" + transactionUID + ", " + transactionInfo + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeClusterTransaction(" + transactionUID + ", " + transactionState + ", " + transactionBrokerArray + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.storeClusterTransaction(transaction, transactionUID, transactionState, transactionBrokerArray);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeClusterTransaction(" + transactionUID + ", " + transactionState + ", " + transactionBrokerArray + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateClusterTransaction(" + transactionUID + ", " + transactionBrokerArray + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.updateClusterTransaction(transaction, transactionUID, transactionBrokerArray);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeClusterTransaction(" + transactionUID + ", " + transactionBrokerArray + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getClusterTransactionBrokers(" + transactionUID + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    TransactionBroker[] transactionBrokerArray = this.txnStore.getClusterTransactionBrokers(transaction, transactionUID);
                    transaction.commit();
                    TransactionBroker[] transactionBrokerArray2 = transactionBrokerArray;
                    return transactionBrokerArray2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getClusterTransactionBrokers(" + transactionUID + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateClusterTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateClusterTransactionBrokerState(" + transactionUID + ", " + TransactionState.toString(n) + ", " + transactionBroker + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.updateTransactionBrokerState(transaction, transactionUID, n, transactionBroker);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "updateClusterTransactionBrokerState(" + transactionUID + ", " + TransactionState.toString(n) + ", " + transactionBroker + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeRemoteTransaction(" + transactionUID + ", " + transactionState + ", " + transactionAcknowledgementArray + ", " + brokerAddress + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.txnStore.storeRemoteTransaction(transaction, transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeRemoteTransaction(" + transactionUID + ", " + transactionState + ", " + transactionAcknowledgementArray + ", " + brokerAddress + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getRemoteTransactionHomeBroker(" + transactionUID + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    BrokerAddress brokerAddress = this.txnStore.getRemoteTransactionHomeBroker(transaction, transactionUID);
                    transaction.commit();
                    BrokerAddress brokerAddress2 = brokerAddress;
                    return brokerAddress2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getRemoteTransactionHomeBroker(" + transactionUID + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllRemoteTransactionStates() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllRemoteTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    HashMap hashMap = this.txnStore.getAllRemoteTransactionStates(transaction);
                    transaction.commit();
                    HashMap hashMap2 = hashMap;
                    return hashMap2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getAllRemoteTransactionStates()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTransactionState(" + transactionUID + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    TransactionState transactionState = this.txnStore.getTransactionState(transaction, transactionUID);
                    transaction.commit();
                    TransactionState transactionState2 = transactionState;
                    return transactionState2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getTransactionState(" + transactionUID + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public TransactionInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTransactionInfo(" + transactionUID + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    TransactionInfo transactionInfo = this.txnStore.getTransactionInfo(transaction, transactionUID);
                    transaction.commit();
                    TransactionInfo transactionInfo2 = transactionInfo;
                    return transactionInfo2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getTransactionInfo(" + transactionUID + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Collection getTransactions(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTransactions(" + string + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    Collection collection = this.txnStore.getAllTransactions(transaction);
                    transaction.commit();
                    Collection collection2 = collection;
                    return collection2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getTransactions(" + string + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateProperty(" + string + ") called");
        }
        if (string == null) {
            throw new NullPointerException("null property name on updateProperty");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.propStore.updateProperty(transaction, string, object);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "updateProperty(" + string + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Object getProperty(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getProperty(" + string + ") called");
        }
        if (string == null) {
            throw new NullPointerException("null property name on getProperty()");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    Object object = this.propStore.getProperty(transaction, string);
                    transaction.commit();
                    Object object2 = object;
                    return object2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getProperty(" + string + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    String[] stringArray = this.propStore.getPropertyNames(transaction);
                    transaction.commit();
                    String[] stringArray2 = stringArray;
                    return stringArray2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getPropertyNames()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllProperties() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    Properties properties = this.propStore.getProperties(transaction);
                    transaction.commit();
                    Properties properties2 = properties;
                    return properties2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getProperties()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeConfigChangeRecord(" + l + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.configRecordStore.storeConfigChangeRecord(transaction, l, byArray);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "storeConfigChangeRecord(" + l + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long l) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getConfigChangeRecordsSince(" + l + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    ArrayList<ChangeRecordInfo> arrayList = this.configRecordStore.getConfigChangeRecordsSince(transaction, l);
                    transaction.commit();
                    ArrayList<ChangeRecordInfo> arrayList2 = arrayList;
                    return arrayList2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getConfigChangeRecordsSince(" + l + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    List<ChangeRecordInfo> list = this.configRecordStore.getAllConfigRecords(transaction);
                    transaction.commit();
                    List<ChangeRecordInfo> list2 = list;
                    return list2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getAllConfigRecords()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, bl ? this.syncTxncf : null);
                    this.configRecordStore.clearAll(transaction);
                    transaction.commit();
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "clearAll()", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getMessageStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getMessageStorageInfo(" + destination + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction transaction = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    transaction = this.dbEnv.beginTransaction(null, null);
                    HashMap hashMap = this.msgStore.getMessageStorageInfo(transaction, destination.getDestinationUID());
                    transaction.commit();
                    HashMap hashMap2 = hashMap;
                    return hashMap2;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(transaction, this.maxRetries, logger, "getMessageStorageInfo(" + destination + ")", this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String getStoreType() {
        return BDBSTORE_BASENAME;
    }

    @Override
    public boolean isJDBCStore() {
        return false;
    }

    @Override
    public boolean isBDBStore() {
        return true;
    }

    @Override
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        throw new BrokerException("BDBStore.getStorageInfo: Operation not supported");
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("BDBStore version", String.valueOf(460));
        hashtable.put("dstStore", this.dstStore.getDebugState());
        hashtable.put("msgStore", this.msgStore.getDebugState());
        hashtable.put("intStore", this.intStore.getDebugState());
        hashtable.put("txnStore", this.txnStore.getDebugState());
        hashtable.put("propStore", this.propStore.getDebugState());
        hashtable.put("configRecordStore", this.configRecordStore.getDebugState());
        return hashtable;
    }

    @Override
    public void compactDestination(Destination destination) throws BrokerException {
    }

    protected Database getDstDatabase() {
        return this.dstDatabase;
    }

    protected Database getIntDatabase() {
        return this.intDatabase;
    }

    protected Database getTxnDatabase() {
        return this.txnDatabase;
    }

    protected Database getTxnAckDatabase() {
        return this.txnackDatabase;
    }

    protected Database getConfigRecordDatabase() {
        return this.configRecordDatabase;
    }

    protected Database getPropDatabase() {
        return this.propDatabase;
    }

    protected Database getTakeoverSessionDatabase() {
        return this.takeoverSessionDatabase;
    }

    protected StoredClassCatalog getClassCatalog() {
        return this.classCatalog;
    }

    protected DestinationStore getDstStore() {
        return this.dstStore;
    }

    protected MsgStore getMsgStore() {
        return this.msgStore;
    }

    protected TxnStore getTxnStore() {
        return this.txnStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void joinReplicationGroup(String string, String string2, String string3, Integer n, byte[] byArray, Long l, boolean bl, BrokerAddress brokerAddress, ClusterProtocolHelper clusterProtocolHelper) throws BrokerException {
        this.checkClosedAndSetInProgress(16);
        ExecutorService executorService = null;
        try {
            Object object = this.joinExecutors;
            synchronized (object) {
                executorService = this.joinExecutors.get(string2);
                if (executorService == null) {
                    executorService = Executors.newSingleThreadExecutor();
                    this.joinExecutors.put(string2, executorService);
                }
            }
            object = new JoinRunnable(string, string2, string3, n, byArray, l, bl, brokerAddress, clusterProtocolHelper, this);
            executorService.execute((Runnable)object);
        }
        catch (Throwable throwable) {
            logger.logStack(32, "Exception in execute joinReplicationGroup " + clusterProtocolHelper, throwable);
            throw new BrokerException(throwable.getMessage(), throwable);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initTakeoverBrokerStore(String string, String string2, String string3, BrokerAddress brokerAddress, ClusterProtocolHelper clusterProtocolHelper) throws BrokerException {
        this.checkClosedAndSetInProgress();
        ExecutorService executorService = null;
        try {
            Object object = this.joinExecutors;
            synchronized (object) {
                executorService = this.joinExecutors.get(string2);
                if (executorService == null) {
                    throw new BrokerException("Unexpected init takeover " + clusterProtocolHelper + ": not prepared");
                }
            }
            logger.log(8, "BDB store update takeover session " + string2 + " to " + "TAKEOVER_INIT");
            this.updateTakeoverSessionState(string2, "TAKEOVER_INIT", "PREPARED");
            object = new InitTakeoverRunnable(string, string2, string3, brokerAddress, clusterProtocolHelper, this);
            executorService.execute((Runnable)object);
        }
        catch (Throwable throwable) {
            logger.logStack(32, "Exception in execute initTakeoverBrokerStore " + clusterProtocolHelper, throwable);
            throw new BrokerException(throwable.getMessage(), throwable);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReplicatedEnvironment joinReplicationGroup(String string, String string2, String string3, Integer n, byte[] byArray, Long l, boolean bl, boolean bl2, BrokerAddress brokerAddress) throws BrokerException {
        String string4 = string + "[" + string2 + ", " + string3 + "]" + (brokerAddress == null ? "" : brokerAddress);
        ReplicatedEnvironment replicatedEnvironment = this.replicaEnvs.get(string);
        if (replicatedEnvironment != null) {
            try {
                if (replicatedEnvironment.isValid()) {
                    try {
                        n = replicatedEnvironment.getRepConfig().getNodePort();
                    }
                    catch (Throwable throwable) {
                        logger.log(16, "Unable to get replica port from environment " + replicatedEnvironment + ": " + throwable.getMessage());
                    }
                }
                logger.log(8, "Closing existing replica environment " + replicatedEnvironment + " of " + string);
                replicatedEnvironment.close();
            }
            catch (Exception exception) {
                logger.logStack(16, "Failed to close existing replica replication environment:" + replicatedEnvironment + " for " + string, (Throwable)exception);
            }
        }
        if (n == null) {
            // empty if block
        }
        try {
            NetworkRestore networkRestore;
            Object object;
            Object object2;
            CommitPointConsistencyPolicy commitPointConsistencyPolicy = null;
            if (byArray != null) {
                object2 = new ObjectInputStream(new ByteArrayInputStream(byArray));
                object = (CommitToken)((ObjectInputStream)object2).readObject();
                ((ObjectInputStream)object2).close();
                commitPointConsistencyPolicy = new CommitPointConsistencyPolicy(object, l == null ? this.replicaSyncTimeout : l, TimeUnit.SECONDS);
            }
            object2 = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName() + File.separator;
            object = new File((String)object2);
            File file = new File((File)object, REPLICA_TOP);
            Object object3 = this.replicaTOPLock;
            synchronized (object3) {
                if (!file.exists() && !file.mkdirs()) {
                    String string5 = "Can't create replication store hierarchy " + file + " for " + string4;
                    logger.log(32, string5);
                    throw new BrokerException(string5);
                }
            }
            object3 = new File(file, string2);
            if (!((File)object3).exists() && !((File)object3).mkdirs()) {
                String string6 = "Can't create replication store hierarchy " + object3 + " for " + string4;
                logger.log(32, string6);
                throw new BrokerException(string6);
            }
            EnvironmentConfig environmentConfig = new EnvironmentConfig();
            environmentConfig.setAllowCreate(true);
            environmentConfig.setTransactional(true);
            environmentConfig.setTxnTimeout(60L, TimeUnit.SECONDS);
            ReplicationConfig replicationConfig = new ReplicationConfig();
            replicationConfig.setMaxClockDelta(this.maxClockSkew, TimeUnit.SECONDS);
            replicationConfig.setGroupName(string);
            replicationConfig.setNodeName(this.myrepNodeName);
            String string7 = Globals.getBrokerInetAddress().getHostAddress() + ":" + n;
            replicationConfig.setNodeHostPort(string7);
            replicationConfig.setHelperHosts(string3);
            if (bl) {
                replicationConfig.setNodePriority(1);
                replicationConfig.setConfigParam("je.rep.electableGroupSizeOverride", "2");
                replicationConfig.setConfigParam("je.rep.electionsPrimaryRetries", "1");
                replicationConfig.setConfigParam("je.rep.replicaTimeout", "2 s");
            } else if (bl2) {
                replicationConfig.setDesignatedPrimary(true);
                replicationConfig.setNodePriority(1);
                replicationConfig.setConfigParam("je.rep.electableGroupSizeOverride", "1");
                replicationConfig.setConfigParam("je.rep.electionsPrimaryRetries", "1");
            } else {
                replicationConfig.setDesignatedPrimary(false);
                replicationConfig.setNodePriority(0);
            }
            logger.log(8, "Creating replica environment on " + string7 + " for " + string4);
            ReplicatedEnvironment replicatedEnvironment2 = null;
            if (bl2) {
                replicatedEnvironment2 = new ReplicatedEnvironment((File)object3, replicationConfig, environmentConfig);
            } else {
                try {
                    replicatedEnvironment2 = new ReplicatedEnvironment((File)object3, replicationConfig, environmentConfig);
                }
                catch (InsufficientLogException insufficientLogException) {
                    logger.log(8, "Received InsufficientLogException in creating replicated environment for replication group " + string + ":" + insufficientLogException.getMessage() + ", Use NetWorkRestore and Retry");
                    networkRestore = new NetworkRestore();
                    NetworkRestoreConfig networkRestoreConfig = new NetworkRestoreConfig();
                    networkRestoreConfig.setRetainLogFiles(false);
                    networkRestore.execute(insufficientLogException, networkRestoreConfig);
                    replicatedEnvironment2 = new ReplicatedEnvironment((File)object3, replicationConfig, environmentConfig);
                }
            }
            replicatedEnvironment2.setStateChangeListener((StateChangeListener)new ReplicationStateChangeListener(this, string2, string));
            if (commitPointConsistencyPolicy != null) {
                TransactionConfig transactionConfig = new TransactionConfig();
                transactionConfig.setConsistencyPolicy((ReplicaConsistencyPolicy)commitPointConsistencyPolicy);
                networkRestore = replicatedEnvironment2.beginTransaction(null, transactionConfig);
                networkRestore.commit();
            }
            this.replicaEnvs.put(replicationConfig.getGroupName(), replicatedEnvironment2);
            logger.log(8, "Replication environment created for " + string4);
            return replicatedEnvironment2;
        }
        catch (Exception exception) {
            String string8 = "Failed to create replication environment for " + string4;
            logger.logStack(32, string8, (Throwable)exception);
            throw new BrokerException(string8, exception);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public TakeoverStoreInfo takeoverBrokerStore(String var1_1, UID var2_2, String var3_3, TakingoverTracker var4_4) throws TakeoverLockException, BrokerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeReplicaMembers(ReplicatedEnvironment replicatedEnvironment, String string) throws Exception {
        ReplicationGroup replicationGroup = replicatedEnvironment.getGroup();
        Set set = replicationGroup.getElectableNodes();
        logger.log(8, "Replication group [" + replicationGroup.getName() + "] members: " + set);
        ReplicationNode replicationNode2 = null;
        String string22 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ReplicationNode replicationNode2 : set) {
            string22 = replicationNode2.getName();
            if (string22.equals(string)) continue;
            arrayList.add(string22);
        }
        HashSet<InetSocketAddress> hashSet = new HashSet<InetSocketAddress>();
        hashSet.add(replicationGroup.getMember(string).getSocketAddress());
        ReplicationGroupAdmin replicationGroupAdmin = new ReplicationGroupAdmin(replicationGroup.getName(), hashSet);
        for (String string22 : arrayList) {
            logger.log(8, "Removing " + string22 + " from replication group [" + replicationGroup.getName() + "]");
            try {
                replicationGroupAdmin.removeMember(string22);
                logger.log(8, "Removed " + string22 + " from replication group [" + replicationGroup.getName() + "]");
            }
            catch (Throwable throwable) {
                logger.logStack(16, "Unable to remove " + string22 + " from replication group [" + replicationGroup.getName() + "]", throwable);
            }
        }
    }

    @Override
    public String takeoverME(String string, Long l) throws BrokerException {
        Object object;
        ObjectOutputStream objectOutputStream;
        Object object2;
        Object object3;
        String string2 = null;
        String string3 = UUID.randomUUID().toString();
        try {
            logger.log(8, "PREPARE takeover me by broker " + string);
            logger.log(8, "Setting store as closed");
            super.setClosedAndWait();
            this.writeToBrokerState(BROKERSTATE_TAKEOVER_ME_BEGIN + string);
            object3 = this.storeTakeoverSession(this.getMyReplicationNodeName(), "TAKEOVER_ME", false, true);
            if (object3 == null) {
                throw new BrokerException("Unexpected null commit token returned");
            }
            object2 = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream((OutputStream)object2);
            objectOutputStream.writeObject(object3);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            objectOutputStream.close();
            ((ByteArrayOutputStream)object2).close();
            string2 = Globals.getClusterBroadcast().sendTakeoverMEPrepare(string, (byte[])object, l, string3);
            logger.log(8, "The replica " + string + "[" + string2 + "] to takeover me has sync'ed,  closing store");
            this.writeToBrokerState(BROKERSTATE_TAKEOVER_ME_PREPARED);
            logger.log(8, "PREPARED takeover me by broker " + string);
            logger.log(8, br.getKString("B1395"));
            this.closeStores(false);
        }
        catch (Throwable throwable) {
            logger.logStack(32, "TAKEOVER ME by broker " + string + " failed to PREPARE", throwable);
            throw new BrokerException(throwable.getMessage(), throwable, 412);
        }
        object3 = null;
        try {
            object3 = Globals.getClusterBroadcast().sendTakeoverME(string, string3);
            this.writeToBrokerState(BROKERSTATE_TAKEOVER_ME_ACKED);
        }
        catch (Throwable throwable) {
            logger.logStack(32, "TAKEOVER ME by broker " + string + " failed", throwable);
            throw new BrokerException(throwable.getMessage(), throwable, 500);
        }
        object2 = null;
        objectOutputStream = null;
        object = null;
        Set set = null;
        HashSet<InetSocketAddress> hashSet = null;
        Iterator iterator = null;
        ReplicationNode replicationNode2 = null;
        for (Map.Entry<String, ReplicatedEnvironment> entry : this.replicaEnvs.entrySet()) {
            object2 = entry.getKey();
            logger.log(8, "Removing this broker from replication group " + (String)object2);
            objectOutputStream = entry.getValue();
            try {
                set = objectOutputStream.getGroup().getElectableNodes();
                hashSet = new HashSet<InetSocketAddress>();
                for (ReplicationNode replicationNode2 : set) {
                    hashSet.add(replicationNode2.getSocketAddress());
                }
                object = new ReplicationGroupAdmin((String)object2, hashSet);
                object.removeMember(this.getMyReplicationNodeName());
                logger.log(8, "Removed this broker from replication group " + (String)object2);
                objectOutputStream.close();
            }
            catch (Throwable throwable) {
                logger.logStack(16, "Failed to remove this broker from repilcation group " + (String)object2 + " members " + hashSet, throwable);
            }
        }
        return object3;
    }
}

