/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.ArrayList;
import java.util.HashMap;

public class ConsumerStates {
    private BrokerResources br = Globals.getBrokerResources();
    ConsumerUID[] sids = null;
    int[] states = null;
    SysMessageID mid = null;
    ArrayList<ConsumerUID> asids = null;
    ArrayList<Integer> astates = null;

    public ConsumerStates() {
    }

    public ConsumerStates(ConsumerUID[] consumerUIDArray, int[] nArray) {
        this.sids = consumerUIDArray;
        this.states = nArray;
    }

    protected ConsumerUID[] getConsumers() {
        return this.sids;
    }

    protected int[] getStates() {
        return this.states;
    }

    protected void setSysMessageID(SysMessageID sysMessageID) {
        this.mid = sysMessageID;
    }

    protected void toArrays() {
        this.sids = this.asids.toArray(new ConsumerUID[0]);
        int n = this.astates.size();
        this.states = new int[n];
        for (int i = 0; i < n; ++i) {
            this.states[i] = this.astates.get(i);
        }
    }

    protected void addConsumerState(ConsumerUID consumerUID, int n) {
        if (this.asids == null) {
            this.asids = new ArrayList();
            this.astates = new ArrayList();
        }
        this.asids.add(consumerUID);
        this.astates.add(n);
    }

    protected int getConsumerState(ConsumerUID consumerUID) throws BrokerException {
        int n = -1;
        if (this.asids == null || (n = this.asids.indexOf(consumerUID)) == -1) {
            throw new BrokerException(this.br.getKString("B3014", consumerUID, this.mid));
        }
        return this.astates.get(n);
    }

    protected void updateConsumerState(ConsumerUID consumerUID, int n) throws BrokerException {
        int n2 = -1;
        if (this.asids == null || (n2 = this.asids.indexOf(consumerUID)) == -1) {
            throw new BrokerException(this.br.getKString("B3014", consumerUID, this.mid));
        }
        this.astates.set(n2, n);
    }

    protected HashMap getInterestStates() throws BrokerException {
        if (this.asids == null) {
            throw new BrokerException(this.br.getKString("B3084", this.mid));
        }
        HashMap<ConsumerUID, Integer> hashMap = new HashMap<ConsumerUID, Integer>();
        ConsumerUID[] consumerUIDArray = this.asids.toArray(new ConsumerUID[0]);
        for (int i = 0; i < consumerUIDArray.length; ++i) {
            hashMap.put(consumerUIDArray[i], this.astates.get(i));
        }
        return hashMap;
    }

    protected ConsumerUID[] getUnAckedConsumerUIDs() throws BrokerException {
        if (this.asids == null) {
            return new ConsumerUID[0];
        }
        ArrayList<ConsumerUID> arrayList = new ArrayList<ConsumerUID>();
        ConsumerUID[] consumerUIDArray = this.asids.toArray(new ConsumerUID[0]);
        for (int i = 0; i < consumerUIDArray.length; ++i) {
            if (this.astates.get(i) == 2) continue;
            arrayList.add(consumerUIDArray[i]);
        }
        return arrayList.toArray(new ConsumerUID[0]);
    }

    protected boolean hasMessageBeenAcked() {
        if (this.astates == null || this.astates.size() == 0) {
            return false;
        }
        Integer n2 = null;
        for (Integer n2 : this.astates) {
            if (n2 == 2) continue;
            return false;
        }
        return true;
    }
}

