/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;
import java.util.LinkedHashMap;

class TakeoverSessionStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    protected static final String PREPARED = "PREPARED";
    protected static final String TAKEOVER_INIT = "TAKEOVER_INIT";
    protected static final String TAKEOVER_ME = "TAKEOVER_ME";
    private BDBStore parent = null;
    private Database db = null;

    protected TakeoverSessionStore(BDBStore bDBStore) {
        this.parent = bDBStore;
        this.db = bDBStore.getTakeoverSessionDatabase();
    }

    protected void storeTakeoverSession(Transaction transaction, String string, String string2, boolean bl) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry(string2.getBytes("UTF-8"));
            OperationStatus operationStatus = this.db.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string3 = "Takeover store session " + string + " exists";
                if (!bl) {
                    this.logger.log(32, string3);
                    throw new BrokerException(string3);
                }
                this.updateTakeoverSessionState(transaction, string, string2 + System.currentTimeMillis(), null);
            }
        }
        catch (Exception exception) {
            String string4 = "Store takeover session " + string + " failed";
            this.logger.log(32, string4);
            throw new BrokerException(string4, exception);
        }
    }

    protected void updateTakeoverSessionState(Transaction transaction, String string, String string2, String string3) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string4 = "Takeover session " + string + " not found in store";
                this.logger.log(32, string4);
                throw new BrokerException(string4);
            }
            String string5 = new String(databaseEntry2.getData(), "UTF-8");
            if (string3 != null && !string5.startsWith(string3)) {
                String string6 = "Takeover Session state " + string5 + " is not as expected " + string3;
                throw new BrokerException(string6);
            }
            databaseEntry2 = new DatabaseEntry((string2 + ":" + string5).getBytes("UTF-8"));
            operationStatus = this.db.put(transaction, databaseEntry, databaseEntry2);
        }
        catch (Exception exception) {
            String string7 = "Update takeover session " + string + " state " + string2 + " failed";
            this.logger.log(32, string7);
            throw new BrokerException(string7, exception);
        }
    }

    protected String getTakeoverSessionState(Transaction transaction, String string) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string2 = "Takeover session " + string + " not found in store";
                this.logger.log(32, string2);
                throw new BrokerException(string2);
            }
            return new String(databaseEntry2.getData(), "UTF-8");
        }
        catch (Exception exception) {
            String string3 = "get takeover session " + string + " state failed";
            this.logger.log(32, string3);
            throw new BrokerException(string3, exception);
        }
    }

    protected LinkedHashMap getAllTakeoverSessions(Transaction transaction) throws BrokerException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            String string = null;
            String string2 = null;
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                string = new String(databaseEntry.getData(), "UTF-8");
                string2 = new String(databaseEntry2.getData(), "UTF-8");
                linkedHashMap.put(string, string2);
            }
            cursor.close();
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
            return linkedHashMap2;
        }
        catch (Exception exception) {
            String string = "Get all takeoverSessions failed";
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all takeover sessions from store: " + exception.getMessage());
                }
            }
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("dbCount", String.valueOf(this.db.count()));
        hashtable.put("dbConfig", this.db.getConfig().toString());
        try {
            hashtable.put("takeoverSessions", this.getAllTakeoverSessions(null));
        }
        catch (Exception exception) {
            this.logger.logStack(32, "Unable to get takeover sessions", (Throwable)exception);
        }
        return hashtable;
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "TakeoverSessionStore: closing with " + this.db.count() + " entries");
        }
    }
}

