/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.TransactionAckArray;
import com.sun.messaging.jmq.jmsserver.persist.bdb.TransactionUIDTupleBinding;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;

class TxnStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private TransactionAcknowledgement[] emptyAckArray = new TransactionAcknowledgement[0];
    private BDBStore parent = null;
    private Database txndb = null;
    private Database txnackdb = null;
    private TupleBinding tidBinding = null;
    private EntryBinding tinfoBinding = null;
    private EntryBinding tacksBinding = null;

    protected TxnStore(BDBStore bDBStore) {
        this.parent = bDBStore;
        this.txndb = bDBStore.getTxnDatabase();
        this.txnackdb = bDBStore.getTxnAckDatabase();
        this.tidBinding = new TransactionUIDTupleBinding();
        this.tinfoBinding = new SerialBinding((ClassCatalog)bDBStore.getClassCatalog(), TransactionInfo.class);
        this.tacksBinding = new SerialBinding((ClassCatalog)bDBStore.getClassCatalog(), TransactionAckArray.class);
    }

    protected void storeTransaction(Transaction transaction, TransactionUID transactionUID, TransactionState transactionState) throws BrokerException {
        TransactionInfo transactionInfo = null;
        try {
            transactionInfo = new TransactionInfo(new TransactionState(transactionState));
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)transactionInfo, databaseEntry2);
            OperationStatus operationStatus = this.txndb.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getKString("B3015", transactionUID + "[" + transactionState.toString() + "]");
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4019", transactionUID + "[" + transactionState.toString() + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void storeClusterTransaction(Transaction transaction, TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray) throws BrokerException {
        TransactionInfo transactionInfo = null;
        try {
            transactionInfo = new TransactionInfo(new TransactionState(transactionState), null, transactionBrokerArray, 2);
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            this.tinfoBinding.objectToEntry((Object)transactionInfo, databaseEntry2);
            OperationStatus operationStatus = this.txndb.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getString("B3015", transactionUID + "[" + transactionInfo + "][" + transactionBrokerArray + "]");
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4019", transactionUID + "[" + transactionInfo + "][" + transactionBrokerArray + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void storeRemoteTransaction(Transaction transaction, TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress) throws BrokerException {
        TransactionInfo transactionInfo = null;
        try {
            transactionInfo = new TransactionInfo(new TransactionState(transactionState), brokerAddress, null, 3);
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus != OperationStatus.NOTFOUND) {
                String string = this.br.getString("B3015", transactionUID + "[" + transactionInfo + "][" + transactionAcknowledgementArray + "]");
                throw new BrokerException(string);
            }
            this.storeTransactionAcks(transaction, transactionUID, transactionAcknowledgementArray);
            databaseEntry2 = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)transactionInfo, databaseEntry2);
            operationStatus = this.txndb.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getString("B3015", transactionUID + "[" + transactionInfo + "][" + transactionAcknowledgementArray + "]");
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException && exception.getCause() instanceof ConflictException) {
                throw (BrokerException)exception;
            }
            String string = this.br.getString("B4019", transactionUID + "[" + transactionInfo + "][" + transactionAcknowledgementArray + "]");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected void storeTransaction(Transaction transaction, TransactionUID transactionUID, TransactionInfo transactionInfo) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            this.tinfoBinding.objectToEntry((Object)transactionInfo, databaseEntry2);
            OperationStatus operationStatus = this.txndb.putNoOverwrite(null, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getKString("B3015", transactionUID + "[" + transactionInfo + "]");
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4019", transactionUID + "[" + transactionInfo + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void removeTransaction(Transaction transaction, TransactionUID transactionUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            OperationStatus operationStatus = this.txndb.delete(transaction, databaseEntry);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3016", transactionUID);
                this.logger.log(32, string);
                throw new BrokerException(string, 404);
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4138", transactionUID);
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void updateTransactionState(Transaction transaction, TransactionUID transactionUID, int n) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3016", transactionUID + "[" + TransactionState.toString(n) + "]");
                throw new BrokerException(string);
            }
            TransactionInfo transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
            TransactionState transactionState = transactionInfo.getTransactionState();
            if (transactionState.getState() != n) {
                transactionState.setState(n);
            }
            databaseEntry2 = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)transactionInfo, databaseEntry2);
            operationStatus = this.txndb.put(transaction, databaseEntry, databaseEntry2);
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4137", transactionUID + "[" + TransactionState.toString(n) + "]");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected void updateClusterTransaction(Transaction transaction, TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3016", transactionUID + "[" + transactionBrokerArray + "]");
                throw new BrokerException(string);
            }
            TransactionInfo transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
            transactionInfo.setType(2);
            transactionInfo.setTransactionBrokers(transactionBrokerArray);
            databaseEntry2 = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)transactionInfo, databaseEntry2);
            operationStatus = this.txndb.put(transaction, databaseEntry, databaseEntry2);
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4019", transactionUID + "[" + transactionBrokerArray + "]");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected void updateTransactionBrokerState(Transaction transaction, TransactionUID transactionUID, int n, TransactionBroker transactionBroker) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3016", transactionUID + "[" + transactionBroker + "](" + TransactionState.toString(n) + ")");
                throw new BrokerException(string);
            }
            TransactionInfo transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
            TransactionState transactionState = transactionInfo.getTransactionState();
            if (transactionState.getState() != n) {
                Object[] objectArray = new Object[]{transactionBroker, transactionUID, TransactionState.toString(n), TransactionState.toString(transactionState.getState())};
                throw new BrokerException(this.br.getKString("B3219", objectArray), 409);
            }
            transactionInfo.updateBrokerState(transactionBroker);
            databaseEntry2 = new DatabaseEntry();
            this.tinfoBinding.objectToEntry((Object)transactionInfo, databaseEntry2);
            operationStatus = this.txndb.put(transaction, databaseEntry, databaseEntry2);
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4019", transactionUID + "[" + transactionBroker + "](" + TransactionState.toString(n) + ")");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected TransactionState getTransactionState(Transaction transaction, TransactionUID transactionUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3016", transactionUID);
                throw new BrokerException(string);
            }
            TransactionInfo transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
            TransactionState transactionState = transactionInfo.getTransactionState();
            return transactionState;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4233", transactionUID);
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected int getTransactionStateValue(Transaction transaction, TransactionUID transactionUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                return -1;
            }
            TransactionInfo transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
            TransactionState transactionState = transactionInfo.getTransactionState();
            if (transactionState != null) {
                return transactionState.getState();
            }
            return -1;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4233", transactionUID);
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected TransactionInfo getTransactionInfo(Transaction transaction, TransactionUID transactionUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                throw new BrokerException(this.br.getKString("B3016", transactionUID));
            }
            TransactionInfo transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
            return transactionInfo;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4233", transactionUID);
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected BrokerAddress getRemoteTransactionHomeBroker(Transaction transaction, TransactionUID transactionUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                throw new BrokerException(this.br.getKString("B3016", transactionUID));
            }
            TransactionInfo transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
            return transactionInfo.getTransactionHomeBroker();
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4233", transactionUID);
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected TransactionBroker[] getClusterTransactionBrokers(Transaction transaction, TransactionUID transactionUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                throw new BrokerException(this.br.getKString("B3016", transactionUID));
            }
            TransactionInfo transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
            return transactionInfo.getTransactionBrokers();
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4233", transactionUID);
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected HashMap getAllTransactionStates(Transaction transaction) throws BrokerException {
        HashMap<TransactionUID, TransactionInfo> hashMap = new HashMap<TransactionUID, TransactionInfo>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            TransactionUID transactionUID = null;
            TransactionInfo transactionInfo = null;
            cursor = this.txndb.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                transactionUID = (TransactionUID)this.tidBinding.entryToObject(databaseEntry);
                transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
                int n = transactionInfo.getType();
                if (n != 1 && n != 2) continue;
                hashMap.put(transactionUID, transactionInfo);
            }
            cursor.close();
            HashMap<TransactionUID, TransactionInfo> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4032");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all transactions from store: " + exception.getMessage());
                }
            }
        }
    }

    protected HashMap getAllRemoteTransactionStates(Transaction transaction) throws BrokerException {
        HashMap<TransactionUID, TransactionState> hashMap = new HashMap<TransactionUID, TransactionState>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            TransactionUID transactionUID = null;
            TransactionInfo transactionInfo = null;
            cursor = this.txndb.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                transactionUID = (TransactionUID)this.tidBinding.entryToObject(databaseEntry);
                transactionInfo = (TransactionInfo)this.tinfoBinding.entryToObject(databaseEntry2);
                int n = transactionInfo.getType();
                if (n != 3) continue;
                hashMap.put(transactionUID, transactionInfo.getTransactionState());
            }
            cursor.close();
            HashMap<TransactionUID, TransactionState> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4032");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all remote transactions from store: " + exception.getMessage());
                }
            }
        }
    }

    protected Collection getAllTransactions(Transaction transaction) throws BrokerException {
        ArrayList<TransactionUID> arrayList = new ArrayList<TransactionUID>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            TransactionUID transactionUID = null;
            cursor = this.txndb.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                transactionUID = (TransactionUID)this.tidBinding.entryToObject(databaseEntry);
                arrayList.add(transactionUID);
            }
            cursor.close();
            ArrayList<TransactionUID> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4032");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all transactions from store: " + exception.getMessage());
                }
            }
        }
    }

    protected void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "TxnStore.clearAll() called");
        }
    }

    protected void storeTransactionAck(Transaction transaction, TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement) throws BrokerException {
        if (transactionAcknowledgement == null) {
            throw new BrokerException("null ack on store transaction ack");
        }
        TransactionAcknowledgement[] transactionAcknowledgementArray = new TransactionAcknowledgement[]{transactionAcknowledgement};
        try {
            ArrayList<TransactionAcknowledgement> arrayList;
            TransactionAckArray transactionAckArray;
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.txndb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                throw new BrokerException(this.br.getKString("B3016", transactionUID.toString()));
            }
            databaseEntry2 = new DatabaseEntry();
            operationStatus = this.txnackdb.get(transaction, databaseEntry, databaseEntry2, null);
            boolean bl = true;
            if (operationStatus != OperationStatus.NOTFOUND) {
                bl = false;
                transactionAckArray = (TransactionAckArray)this.tacksBinding.entryToObject(databaseEntry2);
                arrayList = new ArrayList<TransactionAcknowledgement>(Arrays.asList(transactionAckArray.getAcks()));
                if (arrayList.contains(transactionAcknowledgement)) {
                    throw new BrokerException(this.br.getKString("B3062", transactionAcknowledgement, transactionUID));
                }
                arrayList.add(transactionAcknowledgement);
                transactionAcknowledgementArray = arrayList.toArray(new TransactionAcknowledgement[0]);
            }
            transactionAckArray = new TransactionAckArray(transactionAcknowledgementArray);
            databaseEntry2 = new DatabaseEntry();
            this.tacksBinding.objectToEntry((Object)transactionAckArray, databaseEntry2);
            if (bl) {
                operationStatus = this.txnackdb.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
                if (operationStatus == OperationStatus.KEYEXIST) {
                    arrayList = "Transaction ack update conflict for transation " + transactionUID + "[" + transactionAcknowledgement + "]";
                    this.logger.log(16, (String)((Object)arrayList));
                    throw new ConflictException((String)((Object)arrayList));
                }
            } else {
                operationStatus = this.txnackdb.put(transaction, databaseEntry, databaseEntry2);
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4056", transactionUID + "[" + transactionAcknowledgement + "]");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected void storeTransactionAcks(Transaction transaction, TransactionUID transactionUID, TransactionAcknowledgement[] transactionAcknowledgementArray) throws BrokerException {
        if (transactionAcknowledgementArray == null || transactionAcknowledgementArray.length == 0) {
            return;
        }
        TransactionAcknowledgement[] transactionAcknowledgementArray2 = transactionAcknowledgementArray;
        try {
            Object object;
            TransactionAckArray transactionAckArray;
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txnackdb.get(transaction, databaseEntry, databaseEntry2, null);
            boolean bl = true;
            if (operationStatus != OperationStatus.NOTFOUND) {
                bl = false;
                transactionAckArray = (TransactionAckArray)this.tacksBinding.entryToObject(databaseEntry2);
                object = new ArrayList<TransactionAcknowledgement>(Arrays.asList(transactionAckArray.getAcks()));
                ((ArrayList)object).addAll(Arrays.asList(transactionAcknowledgementArray));
                transactionAcknowledgementArray2 = ((ArrayList)object).toArray(new TransactionAcknowledgement[0]);
            }
            transactionAckArray = new TransactionAckArray(transactionAcknowledgementArray2);
            databaseEntry2 = new DatabaseEntry();
            this.tacksBinding.objectToEntry((Object)transactionAckArray, databaseEntry2);
            if (bl) {
                operationStatus = this.txnackdb.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
                if (operationStatus == OperationStatus.KEYEXIST) {
                    object = "Transaction ack update conflict for transation " + transactionUID + "[" + transactionAcknowledgementArray + "]";
                    this.logger.log(16, (String)object);
                    throw new ConflictException((String)object);
                }
            } else {
                operationStatus = this.txnackdb.put(transaction, databaseEntry, databaseEntry2);
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4056", transactionUID + "[" + transactionAcknowledgementArray2 + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void removeTransactionAck(Transaction transaction, TransactionUID transactionUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            OperationStatus operationStatus = this.txnackdb.delete(transaction, databaseEntry);
        }
        catch (Exception exception) {
            String string = this.br.getString("B4060", transactionUID);
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected TransactionAcknowledgement[] getTransactionAcks(Transaction transaction, TransactionUID transactionUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.tidBinding.objectToEntry((Object)transactionUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.txnackdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                return this.emptyAckArray;
            }
            TransactionAckArray transactionAckArray = (TransactionAckArray)this.tacksBinding.entryToObject(databaseEntry2);
            return transactionAckArray.getAcks();
        }
        catch (Exception exception) {
            String string = this.br.getString("B4229", transactionUID);
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected HashMap getAllTransactionAcks(Transaction transaction) throws BrokerException {
        HashMap<TransactionUID, TransactionAcknowledgement[]> hashMap = new HashMap<TransactionUID, TransactionAcknowledgement[]>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            TransactionUID transactionUID = null;
            TransactionAckArray transactionAckArray = null;
            cursor = this.txnackdb.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                transactionUID = (TransactionUID)this.tidBinding.entryToObject(databaseEntry);
                transactionAckArray = (TransactionAckArray)this.tacksBinding.entryToObject(databaseEntry2);
                hashMap.put(transactionUID, transactionAckArray.getAcks());
            }
            cursor.close();
            HashMap<TransactionUID, TransactionAcknowledgement[]> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4054");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all transaction acks from store: " + exception.getMessage());
                }
            }
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("txndbCount", String.valueOf(this.txndb.count()));
        hashtable.put("txndbConfig", this.txndb.getConfig().toString());
        hashtable.put("txnackdbCount", String.valueOf(this.txnackdb.count()));
        hashtable.put("txnackdbConfig", this.txnackdb.getConfig().toString());
        return hashtable;
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "TxnStore: closing " + this.txndb.count() + " txn records and " + this.txnackdb.count() + " txn-ack records");
        }
    }
}

