/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.bridge.BridgeServiceManager;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.BridgeBaseContextAdapter;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.GlobalErrorHandler;
import com.sun.messaging.jmq.jmsserver.audit.MQAuditService;
import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.ClusterRouter;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.protocol.Protocol;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.license.LicenseManager;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.mbeans.resources.MBeanResources;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatService;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.StoreManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.jmsserver.util.LoggerManager;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryManager;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;

public class Globals {
    private static final String[] saveStrings = new String[]{"imq.cluster.ha", "imq.cluster.clusterid", "imq.brokerid", "imq.persist.store", "imq.persist.jdbc.*"};
    public static final String IMQ = "imq";
    public static final String HOSTNAME_ALL = "*";
    private static GlobalErrorHandler errhandler = null;
    private static final Object lock = Globals.class;
    private static Globals globals = null;
    private static Protocol protocol = null;
    private static BrokerResources br = null;
    private static MBeanResources mbr = null;
    private static Logger logger = null;
    private static Version version = null;
    private static PortMapper portMapper = null;
    private static MQAddress mqAddress = null;
    private static LicenseManager licenseManager = null;
    private static LicenseBase currentLicense = null;
    private static ServiceManager serviceManager = null;
    private static ConnectionManager connectionManager = null;
    private static ClusterBroadcast messageBus = null;
    private static ClusterRouter messageRouter = null;
    private static HeartbeatService heartbeatService = null;
    private static MetricManager metricManager = null;
    private static TransactionList transList = null;
    private static MQTimer timer = null;
    private static boolean clearProps = false;
    private static Properties saveProps = null;
    private static Boolean HAEnabled = null;
    private static Boolean useSharedConfigRecord = null;
    private static String ClusterID = null;
    private static UID HAStoreSession = new UID(-1L);
    private static UID BrokerSession = null;
    private static String BrokerID = null;
    private static String hostname = null;
    private static String jmxHostname = null;
    private static BrokerAddress myaddr = null;
    private static InetAddress brokerInetAddress = null;
    private static InetAddress jmxInetAddress = null;
    private static PacketRouter[] routers = null;
    private static MemoryManager mem_manager = null;
    private static boolean useMem = true;
    private static MQAuditSession audit = null;
    private static Agent agent = null;
    private static BrokerStateHandler stateHandler = null;
    private static HAMonitorService hasvc = null;
    public static final String INTERNAL_PREFIX = "MQ_";
    public static final String DEFAULT_INSTANCE = "imqbroker";
    private static String configName = "imqbroker";
    private static Properties parameters = null;
    private static BrokerConfig config = null;
    private static ClusterManager clusterConfig = null;
    private static BridgeServiceManager bridgeManager = null;
    public static final String JMQ_HOME_PROPERTY = "imq.home";
    public static final String JMQ_VAR_HOME_PROPERTY = "imq.varhome";
    public static final String JMQ_INSTANCES_HOME_PROPERTY = "imq.instanceshome";
    public static final String JMQ_ETC_HOME_PROPERTY = "imq.etchome";
    public static final String JMQ_LIB_HOME_PROPERTY = "imq.libhome";
    public static final String JMQ_HOME_default = ".";
    public static final String JMQ_VAR_HOME_default = "var";
    public static final String JMQ_ETC_HOME_default_etc = "etc";
    public static final String JMQ_ETC_HOME_default_etcmq = "etc/mq";
    public static String JMQ_HOME;
    public static String JMQ_VAR_HOME;
    public static String JMQ_ETC_HOME;
    public static String JMQ_LIB_HOME;
    public static final String INSTANCES_HOME_DIRECTORY = "instances";
    public static String JMQ_INSTANCES_HOME;
    public static boolean pathinited;
    public static final String JMQ_BROKER_PROP_LOC;
    public static final String KEYSTORE_USE_PASSFILE_PROP = "imq.passfile.enabled";
    public static final String KEYSTORE_PASSDIR_PROP = "imq.passfile.dirpath";
    public static final String KEYSTORE_PASSFILE_PROP = "imq.passfile.name";
    public static final String READ_PROPERTIES_FROM_STDIN = "imq.readstdin.enabled";
    public static final String BROKERID_PROPERTY = "imq.brokerid";
    public static final String JDBCBROKERID_PROPERTY = "imq.persist.jdbc.brokerid";
    public static final String CLUSTERID_PROPERTY = "imq.cluster.clusterid";
    public static final String HA_ENABLED_PROPERTY = "imq.cluster.ha";
    public static final String PRIMARY_OWNER_NAME_PROPERTY = "imq.primaryowner.name";
    public static final String PRIMARY_OWNER_CONTACT_PROPERTY = "imq.primaryowner.contact";
    public static final String BROKER_ADMIN_DEFINED_ROLES_PROPERTY_BASE = "imq.broker.adminDefinedRoles";
    public static final String INSTALL_ROOT = "imq.install.root";
    public static final String NOWAIT_MASTERBROKER_PROP = "imq.cluster.nowaitForMasterBroker";
    public static final String DYNAMIC_CHANGE_MASTERBROKER_ENABLED_PROP = "imq.cluster.dynamicChangeMasterBrokerEnabled";
    public static final String NO_MASTERBROKER_PROP = "imq.cluster.nomasterbroker";
    public static final String AUTOCONNECT_CLUSTER_PROPERTY = "imq.cluster.brokerlist";
    public static final String MANUAL_AUTOCONNECT_CLUSTER_PROPERTY = "imq.cluster.brokerlist.manual";
    public static final String JMSRA_MANAGED_PROPERTY = "imq.jmsra.managed";
    private static Boolean _logNonTransactedMsgSend;
    public static final String LOG_NONTRANSACTEDMSGSEND_PROP = "imq.persist.file.txnLog.nonTransactedMsgSend.enabled";
    private static Boolean _minimizeWrites;
    public static final String MINIMIZE_WRITES_PROP = "imq.persist.file.minimizeWrites";
    private static Boolean _deliveryStateNotPersisted;
    public static final String DELIVERY_STATE_NOT_PERSITED_PROP = "imq.persist.file.deliveryStateNotPersisted";

    public static void cleanup() {
        clusterConfig = null;
        config = null;
        parameters = null;
        globals = null;
        br = null;
        logger = null;
        version = null;
        portMapper = null;
        mqAddress = null;
        licenseManager = null;
        currentLicense = null;
        serviceManager = null;
        connectionManager = null;
        messageBus = null;
        messageRouter = null;
        heartbeatService = null;
        metricManager = null;
        transList = null;
        timer = null;
        clearProps = false;
        saveProps = null;
        HAEnabled = null;
        useSharedConfigRecord = null;
        ClusterID = null;
        HAStoreSession = null;
        BrokerID = null;
        hostname = null;
        jmxHostname = null;
        myaddr = null;
        brokerInetAddress = null;
        jmxInetAddress = null;
        routers = null;
        mem_manager = null;
        MQAuditService.clear();
        audit = null;
        agent = null;
        stateHandler = null;
        pathinited = false;
        bridgeManager = null;
    }

    private Globals() {
    }

    public static void init(Properties properties, boolean bl, boolean bl2) {
        Globals.pathinit(null);
        clearProps = bl;
        if (properties == null) {
            return;
        }
        if (bl2) {
            saveProps = new Properties();
            for (int i = 0; i < saveStrings.length; ++i) {
                String string;
                if (saveStrings[i].endsWith(HOSTNAME_ALL)) {
                    string = saveStrings[i].substring(0, saveStrings[i].length() - 1);
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (!string2.startsWith(string)) continue;
                        String string3 = properties.getProperty(string2);
                        saveProps.put(string2, string3);
                    }
                    continue;
                }
                string = properties.getProperty(saveStrings[i]);
                if (string == null) continue;
                saveProps.put(saveStrings[i], string);
            }
        }
        configName = properties.getProperty("imq.instancename", DEFAULT_INSTANCE);
        properties.setProperty(JMQ_VAR_HOME_PROPERTY, JMQ_VAR_HOME);
        properties.setProperty(JMQ_LIB_HOME_PROPERTY, JMQ_LIB_HOME);
        properties.setProperty(JMQ_ETC_HOME_PROPERTY, JMQ_ETC_HOME);
        properties.setProperty(JMQ_INSTANCES_HOME_PROPERTY, JMQ_INSTANCES_HOME);
        properties.setProperty(JMQ_HOME_PROPERTY, JMQ_HOME);
        properties.setProperty("imq.instancename", configName);
        parameters = properties;
    }

    public static boolean isMasterBrokerSpecified() {
        if (parameters == null) {
            return false;
        }
        return parameters.get("imq.cluster.masterbroker") != null;
    }

    public static boolean isJMSRAManagedSpecified() {
        if (parameters == null) {
            return false;
        }
        String string = parameters.getProperty(JMSRA_MANAGED_PROPERTY);
        return string != null && string.trim().toLowerCase().equals("true");
    }

    public static boolean isJMSRAManagedBroker() {
        return Globals.getConfig().getBooleanProperty(JMSRA_MANAGED_PROPERTY, false);
    }

    public static void setMemMgrOn(boolean bl) {
        useMem = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryManager getMemManager() {
        if (!useMem) {
            return null;
        }
        if (mem_manager == null) {
            Object object = lock;
            synchronized (object) {
                if (mem_manager == null) {
                    mem_manager = new MemoryManager();
                }
            }
        }
        return mem_manager;
    }

    public static void setAgent(Agent agent) {
        Globals.agent = agent;
    }

    public static Agent getAgent() {
        return agent;
    }

    public static String getPrimaryOwnerName() {
        return Globals.getConfig().getProperty(PRIMARY_OWNER_NAME_PROPERTY, System.getProperty("user.name"));
    }

    public static String getPrimaryOwnerContact() {
        return Globals.getConfig().getProperty(PRIMARY_OWNER_CONTACT_PROPERTY, System.getProperty("user.name"));
    }

    public static String[] getBrokerAdminDefinedRoles() {
        String string = "imq.broker.adminDefinedRoles.count";
        String string2 = Globals.getConfig().getProperty(string);
        String[] stringArray = null;
        int n = 0;
        if (string2 == null || string2.equals("")) {
            return Globals.getDefaultBrokerAdminDefinedRoles();
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            Logger logger = Globals.getLogger();
            logger.log(16, "Invalid value for property " + string + ": " + string2);
            return Globals.getDefaultBrokerAdminDefinedRoles();
        }
        if (n == 0) {
            return Globals.getDefaultBrokerAdminDefinedRoles();
        }
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string3 = "imq.broker.adminDefinedRoles.name" + i;
            stringArray[i] = Globals.getConfig().getProperty(string3);
        }
        return stringArray;
    }

    public static String[] getDefaultBrokerAdminDefinedRoles() {
        String[] stringArray = new String[]{Globals.getConfig().getProperty("imq.instancename")};
        return stringArray;
    }

    public static String getInstallRoot() {
        String string = Globals.getConfig().getProperty(INSTALL_ROOT);
        if (string != null) {
            return string;
        }
        return Globals.getConfig().getProperty(JMQ_HOME_PROPERTY, "/");
    }

    public static void setProtocol(Protocol protocol) {
        Globals.protocol = protocol;
    }

    public static Protocol getProtocol() {
        return protocol;
    }

    public static void setBrokerStateHandler(BrokerStateHandler brokerStateHandler) {
        stateHandler = brokerStateHandler;
    }

    public static BrokerStateHandler getBrokerStateHandler() {
        return stateHandler;
    }

    public static void setHAMonitorService(HAMonitorService hAMonitorService) {
        hasvc = hAMonitorService;
    }

    public static HAMonitorService getHAMonitorService() {
        return hasvc;
    }

    public static void setBridgeServiceManager(BridgeServiceManager bridgeServiceManager) {
        bridgeManager = bridgeServiceManager;
    }

    public static BridgeServiceManager getBridgeServiceManager() {
        return bridgeManager;
    }

    public static boolean bridgeEnabled() {
        return BridgeBaseContextAdapter.bridgeEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Globals getGlobals() {
        if (globals == null) {
            Object object = lock;
            synchronized (object) {
                if (globals == null) {
                    globals = new Globals();
                }
            }
        }
        return globals;
    }

    public static MQTimer getTimer() {
        return Globals.getTimer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQTimer getTimer(boolean bl) {
        if (timer == null) {
            Object object = lock;
            synchronized (object) {
                if (timer == null) {
                    timer = new MQTimer(true);
                    MQTimer.setLogger(Globals.getLogger());
                    timer.initUncaughtExceptionHandler();
                }
            }
        }
        if (bl) {
            timer.purge();
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerResources getBrokerResources() {
        if (br == null) {
            Object object = lock;
            synchronized (object) {
                if (br == null) {
                    br = BrokerResources.getResources(Locale.getDefault());
                }
            }
        }
        return br;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanResources getMBeanResources() {
        if (mbr == null) {
            Object object = lock;
            synchronized (object) {
                if (mbr == null) {
                    mbr = MBeanResources.getResources(Locale.getDefault());
                }
            }
        }
        return mbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger() {
        if (logger == null) {
            Object object = lock;
            synchronized (object) {
                if (logger == null) {
                    logger = new Logger(JMQ_VAR_HOME);
                    logger.setResourceBundle(Globals.getBrokerResources());
                }
            }
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion() {
        if (version == null) {
            Object object = lock;
            synchronized (object) {
                if (version == null) {
                    version = new Version(false);
                }
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortMapper getPortMapper() {
        if (portMapper == null) {
            Object object = lock;
            synchronized (object) {
                if (portMapper == null) {
                    portMapper = new PortMapper(configName);
                    try {
                        portMapper.setParameters(Globals.getConfig());
                        portMapper.bind();
                    }
                    catch (PropertyUpdateException propertyUpdateException) {
                        Logger logger = Globals.getLogger();
                        logger.log(32, propertyUpdateException.getMessage());
                    }
                }
            }
        }
        return portMapper;
    }

    public static LicenseManager getLicenseManager() {
        if (licenseManager == null) {
            licenseManager = new LicenseManager();
        }
        return licenseManager;
    }

    public static LicenseBase getCurrentLicense(String string) throws BrokerException {
        if (currentLicense == null) {
            currentLicense = Globals.getLicenseManager().getLicense(string);
        }
        return currentLicense;
    }

    public static String getHostname() {
        return hostname;
    }

    public static String getJMXHostname() {
        if (jmxHostname != null) {
            return jmxHostname;
        }
        return Globals.getHostname();
    }

    public static boolean getJDBCHAEnabled() {
        return StoreManager.isConfiguredJDBCStore() && Globals.getHAEnabled();
    }

    public static boolean getBDBREPEnabled() {
        return StoreManager.isConfiguredBDBStore() && StoreManager.bdbREPEnabled();
    }

    public static boolean getHAEnabled() {
        if (HAEnabled == null) {
            BrokerConfig brokerConfig = Globals.getConfig();
            boolean bl = brokerConfig.getBooleanProperty(HA_ENABLED_PROPERTY, false);
            String string = brokerConfig.getProperty(CLUSTERID_PROPERTY);
            if (bl) {
                if (string == null || string.length() == 0) {
                    throw new RuntimeException(Globals.getBrokerResources().getKString("B4253"));
                }
                HAEnabled = Boolean.TRUE;
                ClusterID = string;
            } else {
                if (string != null && string.length() != 0) {
                    ClusterID = string;
                }
                HAEnabled = Boolean.FALSE;
            }
        }
        return HAEnabled;
    }

    public static ServiceManager getServiceManager() {
        return serviceManager;
    }

    public static MetricManager getMetricManager() {
        return metricManager;
    }

    public static TransactionList getTransactionList() {
        return transList;
    }

    public static ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    public static ClusterBroadcast getClusterBroadcast() {
        return messageBus;
    }

    public static ClusterRouter getClusterRouter() {
        return messageRouter;
    }

    public static BrokerAddress getMyAddress() {
        return myaddr;
    }

    public static void setHostname(String string) {
        hostname = string;
    }

    public static void setJMXHostname(String string) {
        jmxHostname = string;
    }

    public static String getClusterID() {
        return ClusterID;
    }

    public static UID getStoreSession() throws BrokerException {
        if (HAStoreSession == null || HAStoreSession.longValue() == -1L) {
            throw new BrokerException("B3044", "HA store session UID has not been initialized");
        }
        return HAStoreSession;
    }

    public static void setStoreSession(UID uID) {
        HAStoreSession = uID;
    }

    public static UID getBrokerSessionID() {
        return BrokerSession;
    }

    public static String getBrokerID() {
        if (BrokerID == null) {
            BrokerID = Globals.getConfig().getProperty(BROKERID_PROPERTY, Globals.getConfig().getProperty(JDBCBROKERID_PROPERTY));
        }
        return BrokerID;
    }

    public static String getIdentityName() {
        String string = Globals.getBrokerID();
        if (string != null) {
            return string;
        }
        return Globals.getConfigName();
    }

    public static void setServiceManager(ServiceManager serviceManager) {
        Globals.serviceManager = serviceManager;
    }

    public static void setMetricManager(MetricManager metricManager) {
        Globals.metricManager = metricManager;
    }

    public static void setTransactionList(TransactionList transactionList) {
        transList = transactionList;
    }

    public static void setConnectionManager(ConnectionManager connectionManager) {
        Globals.connectionManager = connectionManager;
    }

    public static void setClusterBroadcast(ClusterBroadcast clusterBroadcast) {
        messageBus = clusterBroadcast;
    }

    public static void setClusterRouter(ClusterRouter clusterRouter) {
        messageRouter = clusterRouter;
    }

    public static void registerHeartbeatService(HeartbeatService heartbeatService) {
        Globals.heartbeatService = heartbeatService;
    }

    public static HeartbeatService getHeartbeatService() {
        return heartbeatService;
    }

    public static void setMyAddress(BrokerAddress brokerAddress) {
        myaddr = brokerAddress;
    }

    public static void setBrokerInetAddress(InetAddress inetAddress) {
        brokerInetAddress = inetAddress;
    }

    public static InetAddress getBrokerInetAddress() {
        return brokerInetAddress;
    }

    public static void setJMXInetAddress(InetAddress inetAddress) {
        jmxInetAddress = inetAddress;
    }

    public static InetAddress getJMXInetAddress() {
        if (jmxInetAddress != null) {
            return jmxInetAddress;
        }
        return Globals.getBrokerInetAddress();
    }

    public static String getBrokerHostName() {
        if (hostname != null && !hostname.equals(HOSTNAME_ALL)) {
            return hostname;
        }
        if (brokerInetAddress == null) {
            return null;
        }
        return brokerInetAddress.getCanonicalHostName();
    }

    public static void setGlobalErrorHandler(GlobalErrorHandler globalErrorHandler) {
        errhandler = globalErrorHandler;
    }

    public static void handleGlobalError(Throwable throwable, String string) {
        if (!errhandler.handleGlobalError(throwable, string)) {
            logger.logStack(32, "B3100", "received unexpected exception  ", throwable);
            Throwable throwable2 = new Throwable();
            throwable2.fillInStackTrace();
            logger.logStack(4, "Calling stack trace", throwable2);
        }
    }

    public static void setPacketRouters(PacketRouter[] packetRouterArray) {
        routers = packetRouterArray;
    }

    public static PacketRouter getPacketRouter(int n) throws IndexOutOfBoundsException {
        if (routers == null || n > routers.length) {
            throw new IndexOutOfBoundsException(Globals.getBrokerResources().getKString("B4117", "requested invalid packet router " + n));
        }
        return routers[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerConfig getConfig() {
        if (config == null) {
            Object object = lock;
            synchronized (object) {
                if (config == null) {
                    Object object2;
                    try {
                        config = new BrokerConfig(configName, parameters, clearProps, saveProps);
                    }
                    catch (BrokerException brokerException) {
                        Globals.getLogger().logStack(32, "Internal Error: Unable to load broker, configuration properties are not available. Exiting", brokerException.getCause());
                        Broker.getBroker().exit(-1, "Internal Error: Unable to load broker, configuration properties are not available. Exiting", BrokerEvent.Type.FATAL_ERROR);
                    }
                    if (parameters != null) {
                        object2 = parameters.propertyNames();
                        Properties properties = System.getProperties();
                        while (object2.hasMoreElements()) {
                            String string = (String)object2.nextElement();
                            if (string.startsWith("imq.")) continue;
                            properties.put(string, parameters.getProperty(string));
                        }
                    }
                    object2 = Globals.getLogger();
                    ((Logger)object2).configure(config, IMQ);
                    new LoggerManager(logger, config);
                    ((Logger)object2).open();
                }
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initClusterManager(MQAddress mQAddress) throws BrokerException {
        Object object = lock;
        synchronized (object) {
            if (clusterConfig == null) {
                String string = Globals.getConfig().getProperty("imq.cluster.manager.class");
                if (Globals.getJDBCHAEnabled()) {
                    string = Globals.getConfig().getProperty("imq.hacluster.jdbc.manager.class");
                } else if (Globals.getBDBREPEnabled()) {
                    string = Globals.getConfig().getProperty("imq.hacluster.bdb.manager.class");
                }
                try {
                    Class<?> clazz = Class.forName(string);
                    clusterConfig = (ClusterManager)clazz.newInstance();
                    clusterConfig.initialize(mQAddress);
                    mqAddress = mQAddress;
                    ClusteredBroker clusteredBroker = clusterConfig.getLocalBroker();
                    BrokerSession = clusteredBroker.getBrokerSessionUID();
                }
                catch (Exception exception) {
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    throw new BrokerException(Globals.getBrokerResources().getKString("B3198"), exception);
                }
            }
        }
    }

    public static ClusterManager getClusterManager() {
        return clusterConfig;
    }

    public static void reInitializeConfig(String string) {
        config = null;
        if (string == null) {
            string = DEFAULT_INSTANCE;
        }
        configName = string;
    }

    public static String getConfigName() {
        return configName;
    }

    public static String getInstanceDir() {
        return JMQ_INSTANCES_HOME + File.separator + configName;
    }

    public static String getInstanceEtcDir() {
        return JMQ_INSTANCES_HOME + File.separator + configName + File.separator + JMQ_ETC_HOME_default_etc;
    }

    public static Store getStore() throws BrokerException {
        return StoreManager.getStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQAuditSession getAuditSession() {
        if (audit == null) {
            Object object = lock;
            synchronized (object) {
                if (audit == null) {
                    MQAuditService.init();
                    try {
                        audit = MQAuditService.getAuditSession();
                        LockFile lockFile = LockFile.getCurrentLockFile();
                        if (lockFile != null) {
                            audit.setInstance(lockFile.getInstance(), lockFile.getHost(), lockFile.getPort());
                        }
                    }
                    catch (BrokerException brokerException) {
                        Globals.getLogger().logStack(32, brokerException.toString(), brokerException);
                        Broker.getBroker().exit(1, brokerException.toString(), BrokerEvent.Type.EXCEPTION);
                    }
                }
            }
        }
        return audit;
    }

    public static void releaseStore() throws BrokerException {
        StoreManager.releaseStore(true);
    }

    public static void setMQAddress(MQAddress mQAddress) {
        ClusterManager clusterManager = Globals.getClusterManager();
        try {
            clusterManager.setMQAddress(mQAddress);
        }
        catch (Exception exception) {
            logger.log(8, "B3100", (Object)("Received bad address " + mQAddress + " ignoring"), (Throwable)exception);
            return;
        }
        mqAddress = mQAddress;
    }

    public static MQAddress getMQAddress() {
        return mqAddress;
    }

    public static boolean nowaitForMasterBroker() {
        return Globals.getConfig().getBooleanProperty(NOWAIT_MASTERBROKER_PROP, false);
    }

    public static boolean dynamicChangeMasterBrokerEnabled() {
        return Globals.getConfig().getBooleanProperty(DYNAMIC_CHANGE_MASTERBROKER_ENABLED_PROP, false) || Globals.getBDBREPEnabled();
    }

    public static boolean useMasterBroker() {
        if (Globals.getHAEnabled()) {
            return false;
        }
        if (Globals.useSharedConfigRecord()) {
            return false;
        }
        return Globals.getClusterManager().getMasterBroker() != null;
    }

    public static boolean useSharedConfigRecord() {
        if (useSharedConfigRecord == null) {
            if (Globals.getHAEnabled()) {
                useSharedConfigRecord = Boolean.FALSE;
            } else {
                boolean bl = Globals.getConfig().getBooleanProperty(NO_MASTERBROKER_PROP, false);
                if (bl) {
                    if (Globals.getClusterID() == null) {
                        throw new RuntimeException(Globals.getBrokerResources().getKString("B4317", CLUSTERID_PROPERTY, "imq.cluster.nomasterbroker=true"));
                    }
                    useSharedConfigRecord = Boolean.TRUE;
                } else {
                    useSharedConfigRecord = Boolean.FALSE;
                }
            }
        }
        return useSharedConfigRecord;
    }

    public static boolean isConfigForCluster() {
        return Globals.getHAEnabled() || Globals.getConfig().getProperty(AUTOCONNECT_CLUSTER_PROPERTY) != null || Globals.getConfig().getProperty(MANUAL_AUTOCONNECT_CLUSTER_PROPERTY) != null;
    }

    public static void pathinit(Properties properties) {
        String string;
        block16: {
            File file;
            if (pathinited) {
                return;
            }
            pathinited = true;
            if (properties == null) {
                properties = System.getProperties();
            }
            string = properties.getProperty(JMQ_HOME_PROPERTY, JMQ_HOME_default);
            try {
                string = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.log(32, "B3139", (Object)string, (Throwable)iOException);
            }
            JMQ_HOME = string;
            string = properties.getProperty(JMQ_VAR_HOME_PROPERTY, JMQ_HOME + File.separator + JMQ_VAR_HOME_default);
            try {
                string = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.log(32, "B3140", (Object)string, (Throwable)iOException);
            }
            JMQ_VAR_HOME = string;
            string = properties.getProperty(JMQ_LIB_HOME_PROPERTY, JMQ_HOME + File.separator + "lib");
            try {
                string = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.log(32, "B3141", (Object)string, (Throwable)iOException);
            }
            JMQ_LIB_HOME = string;
            string = properties.getProperty(JMQ_ETC_HOME_PROPERTY);
            if (string != null) {
                try {
                    file = new File(string);
                    if (!file.exists()) {
                        Globals.getLogger().log(32, "B3142", string);
                        break block16;
                    }
                    string = new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    Globals.getLogger().log(32, "B3142", (Object)string, (Throwable)iOException);
                }
            } else {
                string = JMQ_HOME + File.separator + JMQ_ETC_HOME_default_etcmq;
                file = new File(string);
                if (!file.exists()) {
                    string = JMQ_HOME + File.separator + JMQ_ETC_HOME_default_etc;
                    file = new File(string);
                }
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    logger.log(32, "B3142", (Object)string, (Throwable)iOException);
                }
            }
        }
        JMQ_ETC_HOME = string;
        JMQ_INSTANCES_HOME = JMQ_VAR_HOME + File.separator + INSTANCES_HOME_DIRECTORY;
    }

    public static boolean txnLogEnabled() {
        return StoreManager.txnLogEnabled();
    }

    public static boolean isNewTxnLogEnabled() {
        return StoreManager.newTxnLogEnabled();
    }

    public static boolean logNonTransactedMsgSend() {
        if (_logNonTransactedMsgSend == null) {
            _logNonTransactedMsgSend = Globals.txnLogEnabled() && Globals.getConfig().getBooleanProperty(LOG_NONTRANSACTEDMSGSEND_PROP);
        }
        return _logNonTransactedMsgSend;
    }

    public static boolean isMinimizeWrites() {
        if (_minimizeWrites == null) {
            _minimizeWrites = Globals.getConfig().getBooleanProperty(MINIMIZE_WRITES_PROP, false);
            Globals.getLogger().log(8, "imq.persist.file.minimizeWrites=" + _minimizeWrites);
        }
        return _minimizeWrites;
    }

    public static boolean isDeliveryStateNotPersisted() {
        if (_deliveryStateNotPersisted == null) {
            _deliveryStateNotPersisted = Globals.getConfig().getBooleanProperty(DELIVERY_STATE_NOT_PERSITED_PROP);
        }
        return _deliveryStateNotPersisted;
    }

    public static boolean isReadPropertiessFromStdin() {
        return Globals.getConfig().getBooleanProperty(READ_PROPERTIES_FROM_STDIN);
    }

    static {
        pathinited = false;
        JMQ_BROKER_PROP_LOC = "props" + File.separator + "broker" + File.separator;
        _logNonTransactedMsgSend = null;
        _minimizeWrites = null;
        _deliveryStateNotPersisted = null;
    }
}

