/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.StateManagementStrategyImpl;
import com.sun.faces.application.view.ViewHandlingStrategy;
import com.sun.faces.application.view.ViewMetadataImpl;
import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.FaceletFactory;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.compiler.SAXCompiler;
import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.composite.CompositeComponentBeanInfo;
import com.sun.faces.facelets.tag.ui.UIDebug;
import com.sun.faces.scripting.GroovyHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.beans.BeanInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewMetadata;
import javax.faces.view.facelets.FaceletContext;

public class FaceletViewHandlingStrategy
extends ViewHandlingStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private FaceletFactory faceletFactory;
    private String[] extensionsArray;
    private String[] prefixesArray;
    public static final String IS_BUILDING_METADATA = FaceletViewHandlingStrategy.class.getName() + ".IS_BUILDING_METADATA";
    private StateManagementStrategyImpl stateManagementStrategy;
    private boolean partialStateSaving;
    private Set<String> fullStateViewIds;
    private boolean groovyAvailable;

    public FaceletViewHandlingStrategy() {
        this.initialize();
    }

    public StateManagementStrategy getStateManagementStrategy(FacesContext context, String viewId) {
        return context.getAttributes().containsKey("partialStateSaving") ? this.stateManagementStrategy : null;
    }

    public BeanInfo getComponentMetadata(FacesContext context, Resource ccResource) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        FaceletFactory factory = (FaceletFactory)RequestStateManager.get(context, "com.sun.faces.FACELET_FACTORY");
        VariableMapper orig = ctx.getVariableMapper();
        UIComponent tmp = context.getApplication().createComponent("javax.faces.NamingContainer");
        UIPanel facetComponent = (UIPanel)context.getApplication().createComponent("javax.faces.Panel");
        facetComponent.setRendererType("javax.faces.Group");
        tmp.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", facetComponent);
        tmp.getAttributes().put("javax.faces.application.Resource.ComponentResource", ccResource);
        try {
            Facelet f = factory.getFacelet(ccResource.getURL());
            VariableMapperWrapper wrapper = new VariableMapperWrapper(orig){

                public ValueExpression resolveVariable(String variable) {
                    return super.resolveVariable(variable);
                }
            };
            ctx.setVariableMapper((VariableMapper)wrapper);
            context.getAttributes().put(IS_BUILDING_METADATA, Boolean.TRUE);
            f.apply(context, (UIComponent)facetComponent);
        }
        catch (Exception e) {
            if (e instanceof FacesException) {
                throw (FacesException)((Object)e);
            }
            throw new FacesException((Throwable)e);
        }
        finally {
            context.getAttributes().remove(IS_BUILDING_METADATA);
            ctx.setVariableMapper(orig);
        }
        CompositeComponentBeanInfo result = (CompositeComponentBeanInfo)tmp.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        return result;
    }

    public ViewMetadata getViewMetadata(FacesContext context, String viewId) {
        return new ViewMetadataImpl(viewId);
    }

    public Resource getScriptComponentResource(FacesContext context, Resource componentResource) {
        if (!this.groovyAvailable) {
            return null;
        }
        Resource result = null;
        String resourceName = componentResource.getResourceName();
        if (resourceName.endsWith(".xhtml")) {
            resourceName = resourceName.substring(0, resourceName.length() - 6) + ".groovy";
            ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
            result = resourceHandler.createResource(resourceName, componentResource.getLibraryName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext ctx, UIViewRoot viewToRender) throws IOException {
        if (!viewToRender.isRendered()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Rendering View: " + viewToRender.getViewId());
        }
        WriteBehindStateWriter stateWriter = null;
        try {
            ResponseWriter origWriter;
            if (!Util.isViewPopulated(ctx, viewToRender)) {
                this.buildView(ctx, viewToRender);
            }
            if ((origWriter = ctx.getResponseWriter()) == null) {
                origWriter = this.createResponseWriter(ctx);
            }
            stateWriter = new WriteBehindStateWriter((Writer)origWriter, ctx, this.responseBufferSize);
            ResponseWriter writer = origWriter.cloneWithWriter((Writer)stateWriter);
            ctx.setResponseWriter(writer);
            writer.startDocument();
            viewToRender.encodeAll(ctx);
            writer.endDocument();
            writer.close();
            boolean writtenState = stateWriter.stateWritten();
            if (writtenState) {
                stateWriter.flushToWriter();
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handleFaceletNotFound(ctx, viewToRender.getViewId(), fnfe.getMessage());
        }
        catch (Exception e) {
            this.handleRenderException(ctx, e);
        }
        finally {
            if (stateWriter != null) {
                stateWriter.release();
            }
        }
    }

    public UIViewRoot restoreView(FacesContext ctx, String viewId) {
        this.updateStateSavingType(ctx, viewId);
        if (UIDebug.debugRequest(ctx)) {
            ctx.getApplication().createComponent("javax.faces.ViewRoot");
        }
        return super.restoreView(ctx, viewId);
    }

    public UIViewRoot createView(FacesContext ctx, String viewId) {
        if (UIDebug.debugRequest(ctx)) {
            UIViewRoot root = (UIViewRoot)ctx.getApplication().createComponent("javax.faces.ViewRoot");
            root.setViewId(viewId);
            return root;
        }
        return super.createView(ctx, viewId);
    }

    public boolean handlesViewId(String viewId) {
        if (viewId != null) {
            int i;
            if (this.extensionsArray == null && this.prefixesArray == null) {
                return viewId.endsWith(".xhtml");
            }
            if (this.extensionsArray != null) {
                for (i = 0; i < this.extensionsArray.length; ++i) {
                    String extension = this.extensionsArray[i];
                    if (!viewId.endsWith(extension)) continue;
                    return true;
                }
            }
            if (this.prefixesArray != null) {
                for (i = 0; i < this.prefixesArray.length; ++i) {
                    String prefix = this.prefixesArray[i];
                    if (!viewId.startsWith(prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void buildView(FacesContext ctx, UIViewRoot view) throws IOException {
        if (Util.isViewPopulated(ctx, view)) {
            return;
        }
        this.updateStateSavingType(ctx, view.getViewId());
        view.setViewId(view.getViewId());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building View: " + view.getViewId());
        }
        if (this.faceletFactory == null) {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(ctx.getExternalContext());
            this.faceletFactory = associate.getFaceletFactory();
            assert (this.faceletFactory != null);
        }
        RequestStateManager.set(ctx, "com.sun.faces.FACELET_FACTORY", this.faceletFactory);
        Facelet f = this.faceletFactory.getFacelet(view.getViewId());
        f.apply(ctx, (UIComponent)view);
        this.doPostBuildActions(view);
        Util.setViewPopulated(ctx, view);
    }

    protected void initialize() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Initializing FaceletViewHandlingStrategy");
        }
        this.initializeMappings();
        WebConfiguration config = WebConfiguration.getInstance();
        this.partialStateSaving = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving);
        if (this.partialStateSaving) {
            String[] viewIds = config.getOptionValue(WebConfiguration.WebContextInitParameter.FullStateSavingViewIds, ",");
            this.fullStateViewIds = new HashSet<String>(viewIds.length, 1.0f);
            this.fullStateViewIds.addAll(Arrays.asList(viewIds));
            this.stateManagementStrategy = new StateManagementStrategyImpl(this, this.fullStateViewIds);
        }
        this.groovyAvailable = GroovyHelper.isGroovyAvailable(FacesContext.getCurrentInstance());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Initialization Successful");
        }
    }

    protected void initializeMappings() {
        String viewMappings = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.FaceletsViewMappings);
        if (viewMappings != null && viewMappings.length() > 0) {
            String[] mappingsArray = Util.split(viewMappings, ";");
            ArrayList<String> extensionsList = new ArrayList<String>(mappingsArray.length);
            ArrayList<String> prefixesList = new ArrayList<String>(mappingsArray.length);
            for (int i = 0; i < mappingsArray.length; ++i) {
                String mapping = mappingsArray[i].trim();
                int mappingLength = mapping.length();
                if (mappingLength <= 1) continue;
                if (mapping.charAt(0) == '*') {
                    extensionsList.add(mapping.substring(1));
                    continue;
                }
                if (mapping.charAt(mappingLength - 1) != '*') continue;
                prefixesList.add(mapping.substring(0, mappingLength - 1));
            }
            this.extensionsArray = new String[extensionsList.size()];
            extensionsList.toArray(this.extensionsArray);
            this.prefixesArray = new String[prefixesList.size()];
            prefixesList.toArray(this.prefixesArray);
        }
    }

    protected Compiler createCompiler() {
        return new SAXCompiler();
    }

    protected ResponseWriter createResponseWriter(FacesContext context) throws IOException {
        ExternalContext extContext = context.getExternalContext();
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            String id = context.getViewRoot().getRenderKitId();
            throw new IllegalStateException("No render kit was available for id \"" + id + "\"");
        }
        if (this.responseBufferSizeSet) {
            extContext.setResponseBufferSize(this.responseBufferSize);
        }
        String contentType = (String)extContext.getRequestMap().get("facelets.ContentType");
        String encoding = (String)extContext.getRequestMap().get("facelets.Encoding");
        ResponseWriter writer = renderKit.createResponseWriter((Writer)NullWriter.Instance, contentType, encoding);
        contentType = this.getResponseContentType(context, writer.getContentType());
        encoding = this.getResponseEncoding(context, writer.getCharacterEncoding());
        extContext.setResponseContentType(contentType);
        extContext.setResponseCharacterEncoding(encoding);
        writer = writer.cloneWithWriter(extContext.getResponseOutputWriter());
        return writer;
    }

    protected void handleRenderException(FacesContext context, Exception e) throws IOException {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            UIViewRoot root = context.getViewRoot();
            StringBuffer sb = new StringBuffer(64);
            sb.append("Error Rendering View");
            if (root != null) {
                sb.append('[');
                sb.append(root.getViewId());
                sb.append(']');
            }
            LOGGER.log(Level.SEVERE, sb.toString(), e);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new FacesException(e.getMessage(), (Throwable)e);
    }

    protected void handleFaceletNotFound(FacesContext context, String viewId, String message) throws IOException {
        context.getExternalContext().responseSendError(404, message != null ? viewId + ": " + message : viewId);
        context.responseComplete();
    }

    protected String getResponseEncoding(FacesContext context, String orig) {
        String encoding = orig;
        Map ctxAttributes = context.getAttributes();
        Map sessionMap = context.getExternalContext().getSessionMap();
        if (ctxAttributes.containsKey("facelets.Encoding")) {
            encoding = (String)ctxAttributes.get("facelets.Encoding");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Facelet specified alternate encoding {0}", encoding);
            }
            sessionMap.put("javax.faces.request.charset", encoding);
        }
        if (encoding == null) {
            encoding = context.getExternalContext().getRequestCharacterEncoding();
        }
        if (encoding == null) {
            encoding = (String)sessionMap.get("javax.faces.request.charset");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Session specified alternate encoding {0}", encoding);
            }
        }
        if (encoding == null) {
            encoding = "UTF-8";
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("ResponseWriter created had a null CharacterEncoding, defaulting to UTF-8");
            }
        }
        return encoding;
    }

    protected String getResponseContentType(FacesContext context, String orig) {
        String contentType = orig;
        Map m = context.getAttributes();
        if (m.containsKey("facelets.ContentType")) {
            contentType = (String)m.get("facelets.ContentType");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Facelet specified alternate contentType '" + contentType + "'");
            }
        }
        if (contentType == null) {
            contentType = "text/html";
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("ResponseWriter created had a null ContentType, defaulting to text/html");
            }
        }
        return contentType;
    }

    private void updateStateSavingType(FacesContext ctx, String viewId) {
        if (!ctx.getAttributes().containsKey("partialStateSaving")) {
            ctx.getAttributes().put("partialStateSaving", this.usePartialSaving(viewId));
        }
    }

    private boolean usePartialSaving(String viewId) {
        return this.partialStateSaving && !this.fullStateViewIds.contains(viewId);
    }

    private void doPostBuildActions(UIViewRoot root) {
        if (this.usePartialSaving(root.getViewId())) {
            this.stateManagementStrategy.notifyTrackChanges(root);
        }
    }

    protected static final class NullWriter
    extends Writer {
        static final NullWriter Instance = new NullWriter();

        protected NullWriter() {
        }

        public void write(char[] buffer) {
        }

        public void write(char[] buffer, int off, int len) {
        }

        public void write(String str) {
        }

        public void write(int c) {
        }

        public void write(String str, int off, int len) {
        }

        public void close() {
        }

        public void flush() {
        }
    }
}

