/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.logging.Level;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ImageRenderer
extends HtmlBasicRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.GRAPHICIMAGE);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("img", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeURIAttribute("src", (Object)ImageRenderer.src(context, component), "value");
        if (writer.getContentType().equals("application/xhtml+xml") && null == component.getAttributes().get("alt")) {
            writer.writeAttribute("alt", (Object)"", "alt");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.endElement("img");
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    private static String src(FacesContext context, UIComponent component) {
        String resName = (String)component.getAttributes().get("name");
        if (resName != null) {
            String libName = (String)component.getAttributes().get("library");
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(resName, libName);
            if (res == null) {
                if (ProjectStage.Development.equals((Object)context.getApplication().getProjectStage())) {
                    String msg = "Unable to find resource " + resName;
                    context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
                }
                return "RES_NOT_FOUND";
            }
            return res.getRequestPath();
        }
        String value = (String)((UIGraphic)component).getValue();
        if (value == null || value.length() == 0) {
            return "";
        }
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }
}

