/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.FaceletFactory;
import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.jsf.ComponentTagHandlerDelegateImpl;
import com.sun.faces.util.RequestStateManager;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.Expression;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Resource;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponentTagHandler
extends ComponentHandler
implements ComponentTagHandlerDelegateImpl.CreateComponentDelegate {
    private static String[] EXCLUDED_COPY_ATTRIBUTES;
    private Resource ccResource;

    CompositeComponentTagHandler(Resource ccResource, ComponentConfig config) {
        super(config);
        this.ccResource = ccResource;
        ((ComponentTagHandlerDelegateImpl)this.getTagHandlerDelegate()).setCreateComponentDelegate(this);
    }

    private void copyTagAttributesIntoComponentAttributes(FaceletContext ctx, UIComponent cc) {
        TagAttribute[] attrs;
        TagAttributes tagAttributes = this.tag.getAttributes();
        for (TagAttribute attr : attrs = tagAttributes.getAll()) {
            Object curVal;
            String value;
            String name = attr.getLocalName();
            if (!this.isNameValid(name) || null == (value = attr.getValue()) || 0 >= value.length()) continue;
            ValueExpression expression = attr.getValueExpression(ctx, Object.class);
            Map map = cc.getAttributes();
            boolean doPut = true;
            if (map.containsKey(name) && (curVal = map.get(name)) instanceof MethodExpression) {
                doPut = false;
            }
            if (!doPut) continue;
            map.put(name, expression);
        }
    }

    @Override
    public UIComponent createComponent(FaceletContext ctx) {
        FacesContext context = ctx.getFacesContext();
        UIComponent result = context.getApplication().createComponent(context, this.ccResource);
        result.subscribeToEvent(PostAddToViewEvent.class, (ComponentSystemEventListener)new CompositeAttributesCopyListener());
        return result;
    }

    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        super.applyNextHandler(ctx, c);
        this.applyCompositeComponent(ctx, c);
        if (ComponentHandler.isNew((UIComponent)c)) {
            FacesContext context = ctx.getFacesContext();
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            String viewId = context.getViewRoot().getViewId();
            ViewDeclarationLanguageFactory factory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
            ViewDeclarationLanguage vdl = factory.getViewDeclarationLanguage(viewId);
            vdl.retargetAttachedObjects(context, c, CompositeComponentTagHandler.getAttachedObjectHandlers(c, false));
            vdl.retargetMethodExpressions(context, c);
            if (Boolean.TRUE.equals(ctx.getFacesContext().getAttributes().get("partialStateSaving"))) {
                this.markInitialState(c);
            }
        }
    }

    private boolean isNameValid(String name) {
        return name != null && name.length() > 0 && Arrays.binarySearch(EXCLUDED_COPY_ATTRIBUTES, name) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCompositeComponent(FaceletContext ctx, UIComponent c) throws IOException {
        UIPanel facetComponent;
        FacesContext facesContext = ctx.getFacesContext();
        FaceletFactory factory = (FaceletFactory)RequestStateManager.get(facesContext, "com.sun.faces.FACELET_FACTORY");
        VariableMapper orig = ctx.getVariableMapper();
        if (ComponentHandler.isNew((UIComponent)c)) {
            facetComponent = (UIPanel)facesContext.getApplication().createComponent("javax.faces.Panel");
            facetComponent.setRendererType("javax.faces.Group");
            c.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", facetComponent);
        } else {
            facetComponent = (UIPanel)c.getFacets().get("javax.faces.component.COMPOSITE_FACET_NAME");
        }
        assert (null != facetComponent);
        try {
            Facelet f = factory.getFacelet(this.ccResource.getURL());
            this.copyTagAttributesIntoComponentAttributes(ctx, c);
            VariableMapperWrapper wrapper = new VariableMapperWrapper(orig){

                public ValueExpression resolveVariable(String variable) {
                    return super.resolveVariable(variable);
                }
            };
            ctx.setVariableMapper((VariableMapper)wrapper);
            f.apply(facesContext, (UIComponent)facetComponent);
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component) {
        return CompositeComponentTagHandler.getAttachedObjectHandlers(component, true);
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component, boolean create) {
        Map attrs = component.getAttributes();
        ArrayList result = (ArrayList)attrs.get("javax.faces.RetargetableHandlers");
        if (null == result) {
            if (create) {
                result = new ArrayList();
                attrs.put("javax.faces.RetargetableHandlers", result);
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        return result;
    }

    private void markInitialState(UIComponent c) {
        c.markInitialState();
        Iterator i = c.getFacetsAndChildren();
        while (i.hasNext()) {
            this.markInitialState((UIComponent)i.next());
        }
    }

    static {
        try {
            PropertyDescriptor[] properties = Introspector.getBeanInfo(UINamingContainer.class).getPropertyDescriptors();
            HashSet<String> props = new HashSet<String>();
            for (PropertyDescriptor pd : properties) {
                if (pd.getWriteMethod() == null) continue;
                props.add(pd.getName());
            }
            props.add("binding");
            Object[] propNames = props.toArray(new String[props.size()]);
            Arrays.sort(propNames);
            EXCLUDED_COPY_ATTRIBUTES = propNames;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static class CompositeAttributesCopyListener
    implements ComponentSystemEventListener,
    Serializable {
        public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
            UIComponent cc = event.getComponent();
            UIComponent compositeParent = UIComponent.getCompositeComponentParent((UIComponent)cc);
            if (compositeParent != null) {
                for (Map.Entry entry : cc.getAttributes().entrySet()) {
                    int lastDot;
                    String exprString;
                    Expression expr;
                    if (!(entry.getValue() instanceof Expression) || (expr = (Expression)entry.getValue()).isLiteralText() || !(exprString = expr.getExpressionString()).startsWith("#{cc.attrs.") || (lastDot = exprString.lastIndexOf(46)) == -1) continue;
                    String attrName = exprString.substring(lastDot + 1, exprString.length() - 1);
                    Object parentExpr = compositeParent.getAttributes().get(attrName);
                    if (!(parentExpr instanceof Expression)) continue;
                    cc.getAttributes().put(entry.getKey(), parentExpr);
                }
            }
        }
    }
}

