/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.component.behavior.AjaxBehaviors;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.facelets.tag.jsf.core.AjaxBehaviorListenerImpl;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.AjaxBehaviorListener;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;

public final class AjaxHandler
extends TagHandlerImpl
implements BehaviorHolderAttachedObjectHandler {
    private final TagAttribute event = this.getAttribute("event");
    private final TagAttribute execute = this.getAttribute("execute");
    private final TagAttribute render = this.getAttribute("render");
    private final TagAttribute onevent = this.getAttribute("onevent");
    private final TagAttribute onerror = this.getAttribute("onerror");
    private final TagAttribute disabled = this.getAttribute("disabled");
    private final TagAttribute immediate = this.getAttribute("immediate");
    private final TagAttribute listener = this.getAttribute("listener");
    private final boolean wrapping = this.isWrapping();

    public AjaxHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        String eventName = this.getEventName();
        if (this.wrapping) {
            this.applyWrapping(ctx, parent, eventName);
        } else {
            this.applyNested(ctx, parent, eventName);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        this.applyAttachedObject(ctx, parent, this.getEventName());
    }

    public String getFor() {
        return null;
    }

    public String getEventName() {
        return this.event != null ? this.event.getValue() : null;
    }

    private boolean isWrapping() {
        return this.nextHandler instanceof TagHandler || this.nextHandler instanceof CompositeFaceletHandler;
    }

    private void applyWrapping(FaceletContext ctx, UIComponent parent, String eventName) throws IOException {
        this.installAjaxResourceIfNecessary();
        AjaxBehavior ajaxBehavior = this.createAjaxBehavior(ctx, eventName);
        FacesContext context = ctx.getFacesContext();
        AjaxBehaviors ajaxBehaviors = AjaxBehaviors.getAjaxBehaviors(context, true);
        ajaxBehaviors.pushBehavior(context, ajaxBehavior, eventName);
        this.nextHandler.apply(ctx, parent);
        ajaxBehaviors.popBehavior();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyNested(FaceletContext ctx, UIComponent parent, String eventName) {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            BeanInfo componentBeanInfo = (BeanInfo)parent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            if (null == componentBeanInfo) {
                throw new TagException(this.tag, "Error: enclosing composite component does not have BeanInfo attribute");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.tag, "Error: enclosing composite component BeanInfo does not have BeanDescriptor");
            }
            List targetList = (List)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (null == targetList) {
                throw new TagException(this.tag, "Error: enclosing composite component does not support behavior events");
            }
            boolean supportedEvent = false;
            for (AttachedObjectTarget target : targetList) {
                if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                supportedEvent = true;
                break;
            }
            if (!supportedEvent) throw new TagException(this.tag, "Error: enclosing composite component does not support event " + eventName);
            CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add((AttachedObjectHandler)this);
            return;
        } else {
            if (!(parent instanceof ClientBehaviorHolder)) throw new TagException(this.tag, "Unable to attach <f:ajax> to non-ClientBehaviorHolder parent");
            this.applyAttachedObject(ctx, parent, eventName);
        }
    }

    private void applyAttachedObject(FaceletContext ctx, UIComponent parent, String eventName) {
        ClientBehaviorHolder bHolder = (ClientBehaviorHolder)parent;
        if (null == eventName ? null == (eventName = bHolder.getDefaultEventName()) : !bHolder.getEventNames().contains(eventName)) {
            throw new TagException(this.tag, "Event attribute could not be determined: " + eventName);
        }
        AjaxBehavior ajaxBehavior = this.createAjaxBehavior(ctx, eventName);
        bHolder.addClientBehavior(eventName, (ClientBehavior)ajaxBehavior);
        this.installAjaxResourceIfNecessary();
    }

    private AjaxBehavior createAjaxBehavior(FaceletContext ctx, String eventName) {
        Application application = ctx.getFacesContext().getApplication();
        AjaxBehavior behavior = (AjaxBehavior)application.createBehavior("javax.faces.behavior.Ajax");
        this.setBehaviorAttribute(ctx, behavior, this.onevent, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.onerror, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.disabled, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.immediate, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.execute, Object.class);
        this.setBehaviorAttribute(ctx, behavior, this.render, Object.class);
        if (null != this.listener) {
            behavior.addAjaxBehaviorListener((AjaxBehaviorListener)new AjaxBehaviorListenerImpl(this.listener.getMethodExpression(ctx, Object.class, new Class[]{AjaxBehaviorEvent.class}), this.listener.getMethodExpression(ctx, Object.class, new Class[0])));
        }
        return behavior;
    }

    private void setBehaviorAttribute(FaceletContext ctx, AjaxBehavior behavior, TagAttribute attr, Class type) {
        if (attr != null) {
            behavior.setValueExpression(attr.getLocalName(), attr.getValueExpression(ctx, type));
        }
    }

    private void installAjaxResourceIfNecessary() {
        String rlibrary;
        String rname;
        UIComponent resource;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getAttributes().get("com.sun.faces.jsfjsState") != null) {
            return;
        }
        String name = "jsf.js";
        String library = "javax.faces";
        UIViewRoot viewRoot = context.getViewRoot();
        ListIterator iter = viewRoot.getComponentResources(context, "head").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        iter = viewRoot.getComponentResources(context, "body").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        iter = viewRoot.getComponentResources(context, "form").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        UIOutput output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        output.getAttributes().put("name", "jsf.js");
        output.getAttributes().put("library", "javax.faces");
        viewRoot.addComponentResource(context, (UIComponent)output, "head");
        context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
    }
}

