/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathResourceHelper
extends ResourceHelper {
    private static final ClasspathResourceHelper INSTANCE = new ClasspathResourceHelper();
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String BASE_RESOURCE_PATH = "META-INF/resources";

    protected ClasspathResourceHelper() {
    }

    public static ClasspathResourceHelper getInstance() {
        return INSTANCE;
    }

    @Override
    public String getBaseResourcePath() {
        return BASE_RESOURCE_PATH;
    }

    @Override
    protected InputStream getNonCompressedInputStream(ResourceInfo resource, FacesContext ctx) throws IOException {
        String path;
        ClassLoader loader = Util.getCurrentLoader(this.getClass());
        InputStream in = loader.getResourceAsStream(path = resource.getPath());
        if (in == null) {
            in = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        return in;
    }

    @Override
    public URL getURL(ResourceInfo resource, FacesContext ctx) {
        ClassLoader loader = Util.getCurrentLoader(this.getClass());
        URL url = loader.getResource(resource.getPath());
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(resource.getPath());
        }
        return url;
    }

    @Override
    public LibraryInfo findLibrary(String libraryName, String localePrefix, FacesContext ctx) {
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = localePrefix == null ? this.getBaseResourcePath() + '/' + libraryName : this.getBaseResourcePath() + '/' + localePrefix + '/' + libraryName;
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            return null;
        }
        try {
            List<String> subPaths = this.getSubPaths(basePathURL);
            if (subPaths.isEmpty()) {
                return new LibraryInfo(libraryName, null, localePrefix, this);
            }
            VersionInfo version = this.getVersion(subPaths, false);
            return new LibraryInfo(libraryName, version, localePrefix, this);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    public ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        ResourceInfo value;
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = library != null ? library.getPath() + '/' + resourceName : (localePrefix == null ? this.getBaseResourcePath() + '/' + resourceName : this.getBaseResourcePath() + '/' + localePrefix + '/' + resourceName);
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            return null;
        }
        try {
            List<String> subPaths = this.getSubPaths(basePathURL);
            if (subPaths.isEmpty()) {
                value = library != null ? new ResourceInfo(library, resourceName, null, compressable) : new ResourceInfo(resourceName, null, localePrefix, this, compressable);
            } else {
                VersionInfo version = this.getVersion(subPaths, true);
                if (version == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_determine_resource_version", resourceName);
                    }
                    return null;
                }
                value = library != null ? new ResourceInfo(library, resourceName, version, compressable) : new ResourceInfo(resourceName, version, localePrefix, this, compressable);
            }
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        if (value.isCompressable()) {
            value = this.handleCompression(value);
        }
        return value;
    }

    private List<String> getSubPaths(URL url) throws IOException, URISyntaxException {
        List<String> paths = null;
        if ("jar".equals(url.getProtocol())) {
            paths = this.getPathsFromJARUrl(url);
        } else if ("file".equals(url.getProtocol())) {
            paths = this.getPathsFromFileURL(url);
        }
        return paths == null ? Collections.emptyList() : paths;
    }

    private List<String> getPathsFromJARUrl(URL url) throws IOException {
        ArrayList<String> paths = null;
        String urlString = url.toString();
        String pathElement = urlString.substring(urlString.indexOf("!/") + 2);
        InputStream in = null;
        try {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            conn.connect();
            JarURLConnection jconn = (JarURLConnection)conn;
            JarFile jar = jconn.getJarFile();
            String baseDir = pathElement + '/';
            JarEntry entry = jar.getJarEntry(baseDir);
            if (entry != null && !entry.isDirectory()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                String name = je.getName();
                if (name.equals(pathElement) || name.equals(baseDir) || !name.startsWith(pathElement)) continue;
                String path = name.substring(pathElement.length() + 1);
                if (path.charAt(path.length() - 1) == '/') {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.contains("/")) continue;
                if (paths == null) {
                    paths = new ArrayList<String>(4);
                }
                paths.add(path);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return paths;
    }

    private List<String> getPathsFromFileURL(URL url) throws IOException, URISyntaxException {
        ArrayList<String> paths = null;
        File baseDir = new File(url.toURI());
        if (baseDir.isDirectory()) {
            File[] subDirs;
            for (File sub : subDirs = baseDir.listFiles()) {
                if (paths == null) {
                    paths = new ArrayList<String>(subDirs.length);
                }
                paths.add(sub.getName());
            }
        }
        return paths;
    }
}

