/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.HtmlUtils;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class HtmlResponseWriter
extends ResponseWriter {
    private String contentType = "text/html";
    private String encoding = null;
    private Writer writer = null;
    private boolean closeStart;
    private WebConfiguration.DisableUnicodeEscaping disableUnicodeEscaping;
    private boolean escapeUnicode;
    private boolean escapeIso;
    private boolean dontEscape;
    private boolean writingCdata;
    private boolean isCdata;
    private boolean isScript;
    private boolean isStyle;
    private boolean scriptOrStyleSrc;
    private boolean isXhtml;
    private Writer origWriter;
    private FastStringWriter scriptBuffer;
    private FastStringWriter attributesBuffer;
    private Boolean isScriptHidingEnabled;
    private Boolean isScriptInAttributeValueEnabled;
    private char[] buffer = new char[1028];
    private char[] textBuffer = new char[128];
    private char[] charHolder = new char[1];
    private static final String BREAKCDATA = "]]><![CDATA[";
    private static final String ESCAPEDSINGLEBRACKET = "]]]><![CDATA[";
    private static final String ESCAPEDLT = "&lt;]]><![CDATA[";
    private static final String ESCAPEDSTART = "&lt;]]><![CDATA[![";
    private static final String ESCAPEDEND = "]]]><![CDATA[]>";
    private static final int CLOSEBRACKET = 93;
    private static final int LT = 60;
    static final Pattern CDATA_START_SLASH_SLASH = Pattern.compile("^//\\s*\\Q<![CDATA[\\E");
    static final Pattern CDATA_END_SLASH_SLASH = Pattern.compile("//\\s*\\Q]]>\\E$");
    static final Pattern CDATA_START_SLASH_STAR = Pattern.compile("^/\\*\\s*\\Q<![CDATA[\\E\\s*\\*/");
    static final Pattern CDATA_END_SLASH_STAR = Pattern.compile("/\\*\\s*\\Q]]>\\E\\s*\\*/$");

    public HtmlResponseWriter(Writer writer, String contentType, String encoding) throws FacesException {
        this(writer, contentType, encoding, null, null, null);
    }

    public HtmlResponseWriter(Writer writer, String contentType, String encoding, Boolean isScriptHidingEnabled, Boolean isScriptInAttributeValueEnabled, WebConfiguration.DisableUnicodeEscaping disableUnicodeEscaping) throws FacesException {
        this.writer = writer;
        if (null != contentType) {
            this.contentType = contentType;
        }
        this.encoding = encoding;
        WebConfiguration webConfig = null;
        if (isScriptHidingEnabled == null) {
            isScriptHidingEnabled = null == (webConfig = this.getWebConfiguration(webConfig)) ? WebConfiguration.BooleanWebContextInitParameter.EnableJSStyleHiding.getDefaultValue() : webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableJSStyleHiding);
        }
        if (isScriptInAttributeValueEnabled == null) {
            isScriptInAttributeValueEnabled = null == (webConfig = this.getWebConfiguration(webConfig)) ? WebConfiguration.BooleanWebContextInitParameter.EnableScriptInAttributeValue.getDefaultValue() : webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableScriptInAttributeValue);
        }
        if (disableUnicodeEscaping == null && (disableUnicodeEscaping = WebConfiguration.DisableUnicodeEscaping.getByValue(null == (webConfig = this.getWebConfiguration(webConfig)) ? WebConfiguration.WebContextInitParameter.DisableUnicodeEscaping.getDefaultValue() : webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.DisableUnicodeEscaping))) == null) {
            disableUnicodeEscaping = WebConfiguration.DisableUnicodeEscaping.False;
        }
        this.isScriptHidingEnabled = isScriptHidingEnabled;
        this.isScriptInAttributeValueEnabled = isScriptInAttributeValueEnabled;
        this.disableUnicodeEscaping = disableUnicodeEscaping;
        this.attributesBuffer = new FastStringWriter(128);
        if (!HtmlUtils.validateEncoding(encoding)) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.ENCODING_ERROR", new Object[0]));
        }
        String charsetName = encoding.toUpperCase();
        switch (disableUnicodeEscaping) {
            case True: {
                this.escapeUnicode = false;
                this.escapeIso = false;
                break;
            }
            case False: {
                this.escapeUnicode = true;
                this.escapeIso = true;
                break;
            }
            case Auto: {
                this.escapeUnicode = !HtmlUtils.isUTFencoding(charsetName);
                this.escapeIso = !HtmlUtils.isISO8859_1encoding(charsetName) && !HtmlUtils.isUTFencoding(charsetName);
            }
        }
    }

    private WebConfiguration getWebConfiguration(WebConfiguration webConfig) {
        ExternalContext extContext;
        if (webConfig != null) {
            return webConfig;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != context && null != (extContext = context.getExternalContext())) {
            webConfig = WebConfiguration.getInstance(extContext);
        }
        return webConfig;
    }

    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.closeStartIfNecessary();
    }

    public String getContentType() {
        return this.contentType;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        try {
            return new HtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding(), this.isScriptHidingEnabled, this.isScriptInAttributeValueEnabled, this.disableUnicodeEscaping);
        }
        catch (FacesException e) {
            throw new IllegalStateException();
        }
    }

    public void endDocument() throws IOException {
        this.writer.flush();
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if (!this.writingCdata) {
            this.dontEscape = false;
        }
        this.isXhtml = this.getContentType().equals("application/xhtml+xml");
        if (this.isScriptOrStyle(name) && !this.scriptOrStyleSrc && this.writer instanceof FastStringWriter) {
            String result = ((FastStringWriter)this.writer).getBuffer().toString();
            this.writer = this.origWriter;
            if (result != null) {
                String trim = result.trim();
                if (this.isXhtml) {
                    if (this.isScript) {
                        Matcher cdataStartSlashSlash = CDATA_START_SLASH_SLASH.matcher(trim);
                        Matcher cdataEndSlashSlash = CDATA_END_SLASH_SLASH.matcher(trim);
                        Matcher cdataStartSlashStar = CDATA_START_SLASH_STAR.matcher(trim);
                        Matcher cdataEndSlashStar = CDATA_END_SLASH_STAR.matcher(trim);
                        int trimLen = trim.length();
                        if (cdataStartSlashSlash.find() && cdataEndSlashSlash.find()) {
                            int start = cdataStartSlashSlash.end() - cdataStartSlashSlash.start();
                            int end = trimLen - (cdataEndSlashSlash.end() - cdataEndSlashSlash.start());
                            this.writer.write(trim.substring(start, end));
                        } else if (null != cdataStartSlashSlash.reset() && cdataStartSlashSlash.find() && cdataEndSlashStar.find()) {
                            int start = cdataStartSlashSlash.end() - cdataStartSlashSlash.start();
                            int end = trimLen - (cdataEndSlashStar.end() - cdataEndSlashStar.start());
                            this.writer.write(trim.substring(start, end));
                        } else if (cdataStartSlashStar.find() && null != cdataEndSlashStar.reset() && cdataEndSlashStar.find()) {
                            int start = cdataStartSlashStar.end() - cdataStartSlashStar.start();
                            int end = trimLen - (cdataEndSlashStar.end() - cdataEndSlashStar.start());
                            this.writer.write(trim.substring(start, end));
                        } else if (null != cdataStartSlashStar.reset() && cdataStartSlashStar.find() && null != cdataEndSlashStar.reset() && cdataEndSlashSlash.find()) {
                            int start = cdataStartSlashStar.end() - cdataStartSlashStar.start();
                            int end = trimLen - (cdataEndSlashSlash.end() - cdataEndSlashSlash.start());
                            this.writer.write(trim.substring(start, end));
                        } else {
                            this.writer.write(result);
                        }
                    } else if (trim.startsWith("<![CDATA[") && trim.endsWith("]]>")) {
                        this.writer.write(trim.substring(9, trim.length() - 3));
                    } else {
                        this.writer.write(result);
                    }
                } else if (trim.startsWith("<!--") && trim.endsWith("//-->")) {
                    this.writer.write(trim.substring(4, trim.length() - 5));
                } else {
                    this.writer.write(result);
                }
            }
            if (this.isXhtml) {
                if (!this.writingCdata) {
                    if (this.isScript) {
                        this.writer.write("\n//]]>\n");
                    } else {
                        this.writer.write("\n]]>\n");
                    }
                }
            } else if (this.isScriptHidingEnabled.booleanValue()) {
                this.writer.write("\n//-->\n");
            }
        }
        this.isScript = false;
        this.isStyle = false;
        if ("cdata".equalsIgnoreCase(name)) {
            this.endCDATA();
            return;
        }
        if (this.closeStart) {
            boolean isEmptyElement = HtmlUtils.isEmptyElement(name);
            if (isEmptyElement) {
                this.flushAttributes();
                this.writer.write(" />");
                this.closeStart = false;
                return;
            }
            this.flushAttributes();
            this.writer.write(62);
            this.closeStart = false;
        }
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(62);
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
    }

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        this.closeStartIfNecessary();
        this.isScriptOrStyle(name);
        this.scriptOrStyleSrc = false;
        if ("cdata".equalsIgnoreCase(name)) {
            this.isCdata = true;
            this.startCDATA();
            return;
        }
        if (this.writingCdata) {
            this.isCdata = false;
            this.writingCdata = true;
            this.dontEscape = true;
        }
        this.writer.write(60);
        this.writer.write(name);
        this.closeStart = true;
    }

    public void startCDATA() throws IOException {
        if (this.writingCdata) {
            throw new IllegalStateException("CDATA tags may not nest");
        }
        this.closeStartIfNecessary();
        this.writingCdata = true;
        this.dontEscape = true;
        this.writer.write("<![CDATA[");
        this.closeStart = false;
    }

    public void endCDATA() throws IOException {
        this.closeStartIfNecessary();
        this.writer.write("]]>");
        this.writingCdata = false;
        this.dontEscape = false;
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartIfNecessary();
        if (this.writingCdata) {
            this.writer.write(this.escapeArray(cbuf));
        } else {
            this.writer.write(cbuf);
        }
    }

    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        if (this.writingCdata) {
            if (c == 93) {
                this.writer.write(ESCAPEDSINGLEBRACKET);
            } else if (c == 60) {
                this.writer.write(ESCAPEDLT);
            } else {
                this.writer.write(c);
            }
        } else {
            this.writer.write(c);
        }
    }

    public void write(String str) throws IOException {
        this.closeStartIfNecessary();
        if (str == null) {
            this.writer.write(str);
            return;
        }
        if (this.writingCdata) {
            this.write(str.toCharArray());
        } else {
            this.writer.write(str);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        if (off < 0 || len < 0 || off + len > cbuf.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > cbuf.length");
        }
        if (this.writingCdata) {
            char[] nbuf = new char[off + len];
            System.arraycopy(cbuf, off, nbuf, 0, len);
            this.writer.write(this.escapeArray(nbuf));
        } else {
            this.writer.write(cbuf, off, len);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        if (off < 0 || len < 0 || off + len > str.length()) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > str.length()");
        }
        if (this.writingCdata) {
            this.write(str.substring(off, off + len).toCharArray());
        } else {
            this.writer.write(str, off, len);
        }
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        Class<?> valueClass;
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if (value == null) {
            return;
        }
        if (this.isCdata) {
            return;
        }
        if (name.equalsIgnoreCase("src") && this.isScriptOrStyle()) {
            this.scriptOrStyleSrc = true;
        }
        if ((valueClass = value.getClass()) == Boolean.class) {
            if (Boolean.TRUE.equals(value)) {
                this.attributesBuffer.write(32);
                this.attributesBuffer.write(name);
                this.attributesBuffer.write("=\"");
                this.attributesBuffer.write(name);
                this.attributesBuffer.write(34);
            }
        } else {
            this.attributesBuffer.write(32);
            this.attributesBuffer.write(name);
            this.attributesBuffer.write("=\"");
            String val = value.toString();
            this.ensureTextBufferCapacity(val);
            HtmlUtils.writeAttribute(this.attributesBuffer, this.escapeUnicode, this.escapeIso, this.buffer, val, this.textBuffer, this.isScriptInAttributeValueEnabled);
            this.attributesBuffer.write(34);
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (comment == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (this.writingCdata) {
            return;
        }
        this.closeStartIfNecessary();
        this.writer.write("<!--");
        this.writer.write(comment.toString());
        this.writer.write("-->");
    }

    public void writeText(char text) throws IOException {
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text);
        } else {
            this.charHolder[0] = text;
            HtmlUtils.writeText(this.writer, this.escapeUnicode, this.escapeIso, this.buffer, this.charHolder);
        }
    }

    public void writeText(char[] text) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text);
        } else {
            HtmlUtils.writeText(this.writer, this.escapeUnicode, this.escapeIso, this.buffer, text);
        }
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        this.closeStartIfNecessary();
        if (this.writingCdata) {
            this.writer.write(this.escapeArray(text.toString().toCharArray()));
        } else if (this.dontEscape) {
            this.writer.write(text.toString());
        } else {
            String val = text.toString();
            this.ensureTextBufferCapacity(val);
            HtmlUtils.writeText(this.writer, this.escapeUnicode, this.escapeIso, this.buffer, val, this.textBuffer);
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        if (off < 0 || off > text.length || len < 0 || len > text.length) {
            throw new IndexOutOfBoundsException();
        }
        this.closeStartIfNecessary();
        if (this.writingCdata) {
            char[] cbuf = new char[off + len];
            System.arraycopy(text, off, cbuf, 0, len);
            this.writer.write(this.escapeArray(cbuf));
        } else if (this.dontEscape) {
            this.writer.write(text, off, len);
        } else {
            HtmlUtils.writeText(this.writer, this.escapeUnicode, this.escapeIso, this.buffer, text, off, len);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if (value == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "value"));
        }
        if (this.isCdata) {
            return;
        }
        if (name.equalsIgnoreCase("src") && this.isScriptOrStyle()) {
            this.scriptOrStyleSrc = true;
        }
        this.attributesBuffer.write(32);
        this.attributesBuffer.write(name);
        this.attributesBuffer.write("=\"");
        String stringValue = value.toString();
        this.ensureTextBufferCapacity(stringValue);
        if (stringValue.startsWith("javascript:")) {
            HtmlUtils.writeAttribute(this.attributesBuffer, this.escapeUnicode, this.escapeIso, this.buffer, stringValue, this.textBuffer, this.isScriptInAttributeValueEnabled);
        } else {
            HtmlUtils.writeURL(this.attributesBuffer, stringValue, this.textBuffer, this.encoding);
        }
        this.attributesBuffer.write(34);
    }

    private void ensureTextBufferCapacity(String source) {
        int len = source.length();
        if (this.textBuffer.length < len) {
            this.textBuffer = new char[len * 2];
        }
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.flushAttributes();
            this.writer.write(62);
            this.closeStart = false;
            if (this.isScriptOrStyle() && !this.scriptOrStyleSrc) {
                this.isXhtml = this.getContentType().equals("application/xhtml+xml");
                if (this.isXhtml) {
                    if (!this.writingCdata) {
                        if (this.isScript) {
                            this.writer.write("\n//<![CDATA[\n");
                        } else {
                            this.writer.write("\n<![CDATA[\n");
                        }
                    }
                } else if (this.isScriptHidingEnabled.booleanValue()) {
                    this.writer.write("\n<!--\n");
                }
                this.origWriter = this.writer;
                if (this.scriptBuffer == null) {
                    this.scriptBuffer = new FastStringWriter(1024);
                }
                this.scriptBuffer.reset();
                this.writer = this.scriptBuffer;
                this.isScript = false;
                this.isStyle = false;
            }
        }
    }

    private void flushAttributes() throws IOException {
        StringBuilder b = this.attributesBuffer.getBuffer();
        int totalLength = b.length();
        if (totalLength != 0) {
            int curIdx = 0;
            while (curIdx < totalLength) {
                if (totalLength - curIdx > this.buffer.length) {
                    int end = curIdx + this.buffer.length;
                    b.getChars(curIdx, end, this.buffer, 0);
                    this.writer.write(this.buffer);
                    curIdx += this.buffer.length;
                    continue;
                }
                int len = totalLength - curIdx;
                b.getChars(curIdx, curIdx + len, this.buffer, 0);
                this.writer.write(this.buffer, 0, len);
                curIdx += len;
            }
            this.attributesBuffer.reset();
        }
    }

    private boolean isScriptOrStyle(String name) {
        if ("script".equalsIgnoreCase(name)) {
            this.isScript = true;
            this.dontEscape = true;
        } else if ("style".equalsIgnoreCase(name)) {
            this.isStyle = true;
            this.dontEscape = true;
        } else {
            this.isScript = false;
            this.isStyle = false;
            this.dontEscape = false;
        }
        return this.isScript || this.isStyle;
    }

    private boolean isScriptOrStyle() {
        return this.isScript || this.isStyle;
    }

    private String escapeArray(char[] cbuf) {
        if (cbuf == null || cbuf.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(cbuf.length);
        if (cbuf.length == 1) {
            if (cbuf[0] == '<') {
                builder.append(ESCAPEDLT);
            } else if (cbuf[0] == '[') {
                builder.append(ESCAPEDSINGLEBRACKET);
            } else {
                builder.append(cbuf[0]);
            }
            return builder.toString();
        }
        if (cbuf.length == 2) {
            if (cbuf[0] == '<' && cbuf[1] == '!') {
                builder.append(ESCAPEDLT);
                builder.append(cbuf[1]);
            } else if (cbuf[0] == ']' && cbuf[1] == ']') {
                builder.append(ESCAPEDSINGLEBRACKET);
                builder.append(ESCAPEDSINGLEBRACKET);
            } else {
                builder.append(cbuf[0]);
                builder.append(cbuf[1]);
            }
            return builder.toString();
        }
        boolean last = false;
        for (int i = 0; i < cbuf.length - 2; ++i) {
            if (cbuf[i] == '<' && cbuf[i + 1] == '!' && cbuf[i + 2] == '[') {
                builder.append(ESCAPEDSTART);
                i += 2;
            } else if (cbuf[i] == ']' && cbuf[i + 1] == ']' && cbuf[i + 2] == '>') {
                builder.append(ESCAPEDEND);
                i += 2;
            } else {
                builder.append(cbuf[i]);
            }
            if (i != cbuf.length - 1) continue;
            last = true;
        }
        if (!last) {
            if (cbuf[cbuf.length - 2] == '<') {
                builder.append(ESCAPEDLT);
            } else if (cbuf[cbuf.length - 2] == '[') {
                builder.append(ESCAPEDSINGLEBRACKET);
            } else {
                builder.append(cbuf[cbuf.length - 2]);
            }
            if (cbuf[cbuf.length - 1] == '<') {
                builder.append(ESCAPEDLT);
            } else if (cbuf[cbuf.length - 1] == '[') {
                builder.append(ESCAPEDSINGLEBRACKET);
            } else {
                builder.append(cbuf[cbuf.length - 1]);
            }
        }
        return builder.toString();
    }
}

