/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component;

import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class CompositeComponentStackManager {
    private static final String MANAGER_KEY = CompositeComponentStackManager.class.getName();
    private StackHandler treeCreation = new TreeCreationStackHandler();
    private StackHandler runtime = new RuntimeStackHandler();
    private FacesContext ctx;

    private CompositeComponentStackManager(FacesContext ctx) {
        this.ctx = ctx;
    }

    public static CompositeComponentStackManager getManager(FacesContext ctx) {
        CompositeComponentStackManager manager = (CompositeComponentStackManager)ctx.getAttributes().get(MANAGER_KEY);
        if (manager == null) {
            manager = new CompositeComponentStackManager(ctx);
            ctx.getAttributes().put(MANAGER_KEY, manager);
        }
        return manager;
    }

    public boolean push(UIComponent compositeComponent) {
        return this.getStackHandler(StackType.Evaluation).push(compositeComponent);
    }

    public boolean push(UIComponent compositeComponent, StackType stackType) {
        return this.getStackHandler(stackType).push(compositeComponent);
    }

    public boolean push() {
        return this.getStackHandler(StackType.Evaluation).push();
    }

    public boolean push(StackType stackType) {
        return this.getStackHandler(stackType).push();
    }

    public void pop(StackType stackType) {
        this.getStackHandler(stackType).pop();
    }

    public void pop() {
        this.getStackHandler(StackType.Evaluation).pop();
    }

    public UIComponent peek() {
        return this.getStackHandler(StackType.Evaluation).peek();
    }

    public UIComponent peek(StackType stackType) {
        return this.getStackHandler(stackType).peek();
    }

    private StackHandler getStackHandler(StackType type) {
        StackHandler handler = null;
        switch (type) {
            case TreeCreation: {
                handler = this.treeCreation;
                break;
            }
            case Evaluation: {
                handler = this.runtime;
            }
        }
        return handler;
    }

    private final class TreeCreationStackHandler
    extends BaseStackHandler {
        private TreeCreationStackHandler() {
        }

        public void pop() {
            Stack<UIComponent> s = this.getStack(false);
            if (s != null && !this.stack.isEmpty()) {
                this.stack.pop();
                if (this.stack.isEmpty()) {
                    this.delete();
                }
            }
        }

        public boolean push() {
            return false;
        }

        public boolean push(UIComponent compositeComponent) {
            if (compositeComponent != null) {
                assert (UIComponent.isCompositeComponent((UIComponent)compositeComponent));
                Stack<UIComponent> s = this.getStack(true);
                s.push(compositeComponent);
                return true;
            }
            return false;
        }
    }

    private final class RuntimeStackHandler
    extends BaseStackHandler {
        private RuntimeStackHandler() {
        }

        public void delete() {
            Stack<UIComponent> s = this.getStack(false);
            if (s != null) {
                s.clear();
            }
        }

        public void pop() {
            Stack<UIComponent> s = this.getStack(false);
            if (s != null && !s.isEmpty()) {
                s.pop();
            }
        }

        public boolean push() {
            return this.push(null);
        }

        public boolean push(UIComponent compositeComponent) {
            Stack<UIComponent> tstack = CompositeComponentStackManager.this.treeCreation.getStack(false);
            Stack<UIComponent> stack = this.getStack(false);
            UIComponent ccp = null;
            if (tstack != null) {
                int idx;
                UIComponent currentComp = stack == null || stack.isEmpty() ? (compositeComponent == null ? UIComponent.getCurrentComponent((FacesContext)CompositeComponentStackManager.this.ctx) : compositeComponent) : stack.peek();
                if (currentComp != null && (idx = tstack.indexOf(currentComp)) > 0) {
                    ccp = (UIComponent)tstack.get(idx - 1);
                }
            } else {
                stack = this.getStack(false);
                ccp = stack != null && !stack.isEmpty() ? this.getCompositeParent(stack.peek()) : this.getCompositeParent(compositeComponent == null ? UIComponent.getCurrentCompositeComponent((FacesContext)CompositeComponentStackManager.this.ctx) : compositeComponent);
            }
            if (ccp != null) {
                if (stack == null) {
                    stack = this.getStack(true);
                }
                stack.push(ccp);
                return true;
            }
            return false;
        }

        private UIComponent getCompositeParent(UIComponent comp) {
            return UIComponent.getCompositeComponentParent((UIComponent)comp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseStackHandler
    implements StackHandler {
        protected Stack<UIComponent> stack;

        private BaseStackHandler() {
        }

        @Override
        public void delete() {
            this.stack = null;
        }

        @Override
        public Stack<UIComponent> getStack(boolean create) {
            if (this.stack == null && create) {
                this.stack = new Stack();
            }
            return this.stack;
        }

        @Override
        public UIComponent peek() {
            if (this.stack != null && !this.stack.isEmpty()) {
                return this.stack.peek();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface StackHandler {
        public boolean push(UIComponent var1);

        public boolean push();

        public void pop();

        public UIComponent peek();

        public void delete();

        public Stack<UIComponent> getStack(boolean var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StackType {
        TreeCreation,
        Evaluation;

    }
}

