/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.el.ELText;
import com.sun.faces.facelets.el.TagMethodExpression;
import com.sun.faces.facelets.el.TagValueExpression;
import com.sun.faces.util.Util;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public final class TagAttributeImpl
extends TagAttribute {
    private final boolean literal;
    private final String localName;
    private final Location location;
    private final String namespace;
    private final String qName;
    private final String value;
    private String string;

    public TagAttributeImpl(Location location, String ns, String localName, String qName, String value) {
        this.location = location;
        this.namespace = ns;
        this.localName = localName;
        this.qName = qName;
        this.value = value;
        try {
            this.literal = ELText.isLiteral(this.value);
        }
        catch (ELException e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public boolean getBoolean(FaceletContext ctx) {
        if (this.literal) {
            return Boolean.valueOf(this.value);
        }
        return (Boolean)this.getObject(ctx, Boolean.class);
    }

    public int getInt(FaceletContext ctx) {
        if (this.literal) {
            return Integer.parseInt(this.value);
        }
        return ((Number)this.getObject(ctx, Integer.class)).intValue();
    }

    public String getLocalName() {
        return this.localName;
    }

    public Location getLocation() {
        return this.location;
    }

    public MethodExpression getMethodExpression(FaceletContext ctx, Class type, Class[] paramTypes) {
        MethodExpression result = null;
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            CompositeComponentExpressionHelper helper = new CompositeComponentExpressionHelper(this.value);
            if (helper.isValidCCExpression() && helper.isLookup()) {
                result = new AttributeLookupMethodExpression(this.getValueExpression(ctx, MethodExpression.class));
            }
            if (null == result) {
                result = new TagMethodExpression(this, f.createMethodExpression((ELContext)ctx, this.value, type, paramTypes));
            }
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        return result;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getObject(FaceletContext ctx) {
        return this.getObject(ctx, Object.class);
    }

    public String getQName() {
        return this.qName;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(FaceletContext ctx) {
        if (this.literal) {
            return this.value;
        }
        return (String)this.getObject(ctx, String.class);
    }

    public Object getObject(FaceletContext ctx, Class type) {
        if (this.literal) {
            if (String.class.equals((Object)type)) {
                return this.value;
            }
            try {
                return ctx.getExpressionFactory().coerceToType((Object)this.value, type);
            }
            catch (Exception e) {
                throw new TagAttributeException((TagAttribute)this, (Throwable)e);
            }
        }
        ValueExpression ve = this.getValueExpression(ctx, type);
        try {
            return ve.getValue((ELContext)ctx);
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public ValueExpression getValueExpression(FaceletContext ctx, Class type) {
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            return new TagValueExpression(this, f.createValueExpression((ELContext)ctx, this.value, type));
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.location + " " + this.qName + "=\"" + this.value + "\"";
        }
        return this.string;
    }

    private static class CompositeComponentExpressionHelper {
        private boolean valid;
        private boolean lookup;

        CompositeComponentExpressionHelper(String expression) {
            if (expression.startsWith("#{cc.")) {
                String[] parts = Util.split(expression, "\\.");
                int len = parts.length;
                if (len <= 2) {
                    this.valid = false;
                } else {
                    this.valid = true;
                    if ("attrs".equals(parts[len - 2])) {
                        this.lookup = true;
                    }
                }
            }
        }

        boolean isValidCCExpression() {
            return this.valid;
        }

        boolean isLookup() {
            return this.lookup;
        }
    }

    public static class AttributeLookupMethodExpression
    extends MethodExpression
    implements StateHolder {
        private ValueExpression lookupExpression;
        private boolean isTransient = false;

        public AttributeLookupMethodExpression(ValueExpression lookupExpression) {
            Util.notNull("lookupExpression", lookupExpression);
            this.lookupExpression = lookupExpression;
        }

        public AttributeLookupMethodExpression() {
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        public void restoreState(FacesContext context, Object stateObj) {
            Object[] state = (Object[])stateObj;
            this.lookupExpression = (ValueExpression)state[0];
        }

        public Object saveState(FacesContext arg0) {
            Object[] state = new Object[]{this.lookupExpression};
            return state;
        }

        public MethodInfo getMethodInfo(ELContext arg0) {
            return null;
        }

        public Object invoke(ELContext elContext, Object[] arg1) {
            Object result = this.lookupExpression.getValue(elContext);
            if (result == null) {
                throw new FacesException("Unable to resolve composite component from using page using EL expression '" + this.lookupExpression.getExpressionString() + '\'');
            }
            if (!(result instanceof MethodExpression)) {
                throw new FacesException("Successfully resolved expression '" + this.lookupExpression.getExpressionString() + "', but the value is not a MethodExpression");
            }
            return ((MethodExpression)result).invoke(elContext, arg1);
        }

        public String getExpressionString() {
            return this.lookupExpression.getExpressionString();
        }

        public boolean equals(Object otherObj) {
            boolean result = false;
            if (otherObj instanceof AttributeLookupMethodExpression) {
                AttributeLookupMethodExpression other = (AttributeLookupMethodExpression)((Object)otherObj);
                result = this.lookupExpression.getExpressionString().equals(other.lookupExpression.getExpressionString());
            }
            return result;
        }

        public boolean isLiteralText() {
            return this.lookupExpression.isLiteralText();
        }

        public int hashCode() {
            return this.lookupExpression.hashCode();
        }
    }
}

