/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class ScriptStyleBaseRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static final String COMP_KEY = ScriptStyleBaseRenderer.class.getName() + "_COMPOSITE_COMPONENT";
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        String target = this.verifyTarget((String)component.getAttributes().get("target"));
        if (target != null) {
            UIComponent cc = UIComponent.getCurrentCompositeComponent((FacesContext)context);
            if (cc != null) {
                component.getAttributes().put(COMP_KEY, cc);
            }
            context.getViewRoot().addComponentResource(context, component, target);
        }
    }

    public final void decode(FacesContext context, UIComponent component) {
    }

    public final boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UIComponent cc = (UIComponent)component.getAttributes().remove(COMP_KEY);
        if (cc != null) {
            component.popComponentFromEL(context);
            component.popComponentFromEL(context);
            component.pushComponentToEL(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent cc = (UIComponent)component.getAttributes().get(COMP_KEY);
        if (cc != null) {
            component.popComponentFromEL(context);
            component.pushComponentToEL(context, cc);
            component.pushComponentToEL(context, component);
        }
    }

    public final void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        boolean renderChildren;
        Map attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        int childCount = component.getChildCount();
        boolean bl = renderChildren = 0 < childCount;
        if (null == name) {
            if (0 == childCount) {
                if (context.isProjectStage(ProjectStage.Development)) {
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_WARN, "outputScript with no library, no name, and no body content", "Is body content intended?");
                    context.addMessage(component.getClientId(context), message);
                }
                renderChildren = false;
            }
        } else if (0 < childCount) {
            logger.info("outputScript with \"name\" attribute and nested content.  Ignoring nested content.");
            renderChildren = false;
        }
        if (renderChildren) {
            ResponseWriter writer = context.getResponseWriter();
            this.startElement(writer, component);
            super.encodeChildren(context, component);
            this.endElement(writer);
        }
    }

    protected abstract void startElement(ResponseWriter var1, UIComponent var2) throws IOException;

    protected abstract void endElement(ResponseWriter var1) throws IOException;

    protected String verifyTarget(String toVerify) {
        return toVerify;
    }
}

