/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class RecordingResponseWriter
extends ResponseWriter {
    private List<Command> record = new ArrayList<Command>();

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public void startDocument() {
        this.record.add(new Command(CommandType.START_DOC));
    }

    public void endDocument() {
        this.record.add(new Command(CommandType.END_DOC));
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.record.add(new Command(CommandType.START_ELE, name, component));
    }

    public void endElement(String name) {
        this.record.add(new Command(CommandType.END_ELE, name));
    }

    public void writeAttribute(String name, Object value, String property) {
        this.record.add(new Command(CommandType.WRITE_ATTR, name, value, property));
    }

    public void writeURIAttribute(String name, Object value, String property) {
        this.record.add(new Command(CommandType.WRITE_URI, name, value, property));
    }

    public void startCDATA() {
        this.record.add(new Command(CommandType.START_CDATA));
    }

    public void endCDATA() {
        this.record.add(new Command(CommandType.END_CDATA));
    }

    public void writeComment(Object comment) {
        this.record.add(new Command(CommandType.WRITE_COMMENT, comment));
    }

    public void writeText(Object text, String property) throws IOException {
        this.record.add(new Command(CommandType.WRITE_TEXT, text, property));
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        this.writeText(text, property);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.record.add(new Command(CommandType.WRITE_TEXT_ARR, text, off, len));
    }

    public void write(char[] text, int off, int len) {
        this.record.add(new Command(CommandType.WRITE, text, off, len));
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        throw new UnsupportedOperationException();
    }

    public void replay(ResponseWriter writer) throws IOException {
        for (Command command : this.record) {
            switch (command.getCommandType()) {
                case START_DOC: {
                    writer.startDocument();
                    break;
                }
                case END_DOC: {
                    writer.endDocument();
                    break;
                }
                case START_ELE: {
                    writer.startElement((String)command.getOne(), (UIComponent)command.getTwo());
                    break;
                }
                case END_ELE: {
                    writer.endElement((String)command.getOne());
                    break;
                }
                case START_CDATA: {
                    writer.startCDATA();
                    break;
                }
                case END_CDATA: {
                    writer.endCDATA();
                    break;
                }
                case WRITE_ATTR: {
                    writer.writeAttribute((String)command.getOne(), command.getTwo(), (String)command.getThree());
                    break;
                }
                case WRITE_URI: {
                    writer.writeURIAttribute((String)command.getOne(), command.getTwo(), (String)command.getThree());
                    break;
                }
                case WRITE_COMMENT: {
                    writer.writeComment(command.getOne());
                    break;
                }
                case WRITE_TEXT: {
                    writer.writeText(command.getOne(), (String)command.getTwo());
                    break;
                }
                case WRITE_TEXT_ARR: {
                    writer.writeText((char[])command.getOne(), ((Integer)command.getTwo()).intValue(), ((Integer)command.getThree()).intValue());
                    break;
                }
                case WRITE: {
                    writer.write((char[])command.getOne(), ((Integer)command.getTwo()).intValue(), ((Integer)command.getThree()).intValue());
                }
            }
        }
    }

    class Command {
        CommandType com;
        Object one = null;
        Object two = null;
        Object three = null;

        Command(CommandType com) {
            this.com = com;
        }

        Command(CommandType com, Object one) {
            this.com = com;
            this.one = one;
        }

        Command(CommandType com, Object one, Object two) {
            this.com = com;
            this.one = one;
            this.two = two;
        }

        Command(CommandType com, Object one, Object two, Object three) {
            this.com = com;
            this.one = one;
            this.two = two;
            this.three = three;
        }

        CommandType getCommandType() {
            return this.com;
        }

        Object getOne() {
            return this.one;
        }

        Object getTwo() {
            return this.two;
        }

        Object getThree() {
            return this.three;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CommandType {
        START_DOC,
        END_DOC,
        START_ELE,
        END_ELE,
        WRITE_ATTR,
        WRITE_URI,
        START_CDATA,
        END_CDATA,
        WRITE_COMMENT,
        WRITE_TEXT,
        WRITE_TEXT_ARR,
        WRITE;

    }
}

