/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FacesConfigExtensionProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACES_CONFIG_EXTENSION = "faces-config-extension";
    private static final String FACELETS_PROCESSING = "facelets-processing";
    private static final String FILE_EXTENSION = "file-extension";
    private static final String PROCESS_AS = "process-as";

    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing faces-config-extension elements for document: ''{0}''", documentInfos[i].getSourceURL()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList facesConfigExtensions = document.getDocumentElement().getElementsByTagNameNS(namespace, FACES_CONFIG_EXTENSION);
            if (facesConfigExtensions == null || facesConfigExtensions.getLength() <= 0) continue;
            this.processFacesConfigExtensions(facesConfigExtensions, namespace, documentInfos[i]);
        }
        this.invokeNext(sc, documentInfos);
    }

    private void processFacesConfigExtensions(NodeList facesConfigExtensions, String namespace, DocumentInfo info) {
        WebConfiguration config = null;
        int size = facesConfigExtensions.getLength();
        for (int i = 0; i < size; ++i) {
            Node facesConfigExtension = facesConfigExtensions.item(i);
            NodeList children = ((Element)facesConfigExtension).getElementsByTagNameNS(namespace, "*");
            int csize = children.getLength();
            for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                if (!FACELETS_PROCESSING.equals(n.getLocalName())) continue;
                Node faceletsProcessing = n;
                NodeList faceletsProcessingChildren = ((Element)faceletsProcessing).getElementsByTagNameNS(namespace, "*");
                String fileExtension = null;
                String processAs = null;
                int fpsize = faceletsProcessingChildren.getLength();
                for (int fp = 0; fp < fpsize; ++fp) {
                    Node childOfInterset = faceletsProcessingChildren.item(fp);
                    if (null == fileExtension && FILE_EXTENSION.equals(childOfInterset.getLocalName())) {
                        fileExtension = this.getNodeText(childOfInterset);
                        continue;
                    }
                    if (null == processAs && PROCESS_AS.equals(childOfInterset.getLocalName())) {
                        processAs = this.getNodeText(childOfInterset);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, MessageFormat.format("Processing faces-config-extension elements for document: ''{0}'', encountered unexpected configuration ''{1}'', ignoring and continuing", info.getSourceURL(), this.getNodeText(childOfInterset)));
                }
                if (null != fileExtension && null != processAs) {
                    if (null == config) {
                        config = WebConfiguration.getInstance();
                    }
                    Map<String, String> faceletsProcessingMappings = config.getFacesConfigOptionValue(WebConfiguration.WebContextInitParameter.FaceletsProcessingFileExtensionProcessAs, true);
                    faceletsProcessingMappings.put(fileExtension, processAs);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, MessageFormat.format("Processing faces-config-extension elements for document: ''{0}'', encountered <facelets-processing> elemnet without expected children", info.getSourceURL()));
            }
        }
    }
}

