/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationFactoryImpl;
import com.sun.faces.application.ApplicationImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesWrapper;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionApplicationFactory
extends ApplicationFactory
implements FacesWrapper<ApplicationFactory> {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String APPLICATION_FACTORY = "com.sun.faces.APPLICATION_FACTORY";
    private static String APPLICATION_FACTORY_CLASS = "com.sun.faces.APPLICATION_FACTORY_CLASS";

    public InjectionApplicationFactory(ApplicationFactory delegate) {
        Util.notNull("applicationFactory", delegate);
        APPLICATION_FACTORY_CLASS = delegate.getClass().getName();
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(APPLICATION_FACTORY, delegate);
    }

    private ApplicationFactory getDelegate() {
        ApplicationFactory delegate = (ApplicationFactory)FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().get(APPLICATION_FACTORY);
        if (delegate == null) {
            String className = APPLICATION_FACTORY_CLASS;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> cl = loader.loadClass(className);
                Constructor<?> constructor = cl.getConstructor(ApplicationFactory.class);
                if (constructor != null) {
                    Object[] arglist = new Object[]{new ApplicationFactoryImpl()};
                    delegate = (ApplicationFactory)constructor.newInstance(arglist);
                } else {
                    constructor = cl.getConstructor(new Class[0]);
                    delegate = (ApplicationFactory)constructor.newInstance(new Object[0]);
                }
                FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(APPLICATION_FACTORY, delegate);
            }
            catch (ClassNotFoundException ce) {
                String message = "ClassNotFoundException occurred : " + ce.getMessage();
                throw new IllegalStateException(message);
            }
            catch (InstantiationException ie) {
                String message = "InstantiationException occurred : " + ie.getMessage();
                throw new IllegalStateException(message);
            }
            catch (InvocationTargetException le) {
                String message = "InvocationTargetException occurred : " + le.getMessage();
                throw new IllegalStateException(message);
            }
            catch (IllegalAccessException e) {
                String message = "IllegalAccessException occurred : " + e.getMessage();
                throw new IllegalStateException(message);
            }
            catch (NoSuchMethodException se) {
                String message = "IllegalAccessException occurred : " + se.getMessage();
                throw new IllegalStateException(message);
            }
        }
        return delegate;
    }

    public static void clearInstance(ExternalContext externalContext) {
        Map applicationMap = externalContext.getApplicationMap();
        applicationMap.remove(APPLICATION_FACTORY);
    }

    public Application getApplication() {
        Application application = this.getDelegate().getApplication();
        if (application == null) {
            String message = MessageFormat.format("Delegate ApplicationContextFactory, {0}, returned null when calling getApplication().", this.getDelegate().getClass().getName());
            throw new IllegalStateException(message);
        }
        this.injectDefaultApplication(application);
        return application;
    }

    public synchronized void setApplication(Application application) {
        this.getDelegate().setApplication(application);
        this.injectDefaultApplication(application);
    }

    public ApplicationFactory getWrapped() {
        return this.getDelegate();
    }

    private void injectDefaultApplication(Application application) {
        block5: {
            FacesContext ctx = FacesContext.getCurrentInstance();
            String attrName = ApplicationImpl.class.getName();
            Application defaultApplication = (Application)ctx.getExternalContext().getApplicationMap().get(attrName);
            if (defaultApplication != null) {
                try {
                    Field defaultApplicationField = Application.class.getDeclaredField("defaultApplication");
                    defaultApplicationField.setAccessible(true);
                    defaultApplicationField.set(application, defaultApplication);
                }
                catch (NoSuchFieldException nsfe) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Unable to find private field named 'defaultApplication' in javax.faces.application.Application.");
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }
}

