/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;

public class ApplicationFactoryImpl
extends ApplicationFactory {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();

    public ApplicationFactoryImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created ApplicationFactory ");
        }
    }

    public Application getApplication() {
        Application application = (Application)FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().get(ApplicationImpl.class.getName());
        if (application == null) {
            application = new ApplicationImpl();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MessageFormat.format("Created Application instance ''{0}''", application));
            }
        }
        return application;
    }

    public synchronized void setApplication(Application application) {
        if (application == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "application");
            throw new NullPointerException(message);
        }
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(ApplicationImpl.class.getName(), application);
        if (application instanceof ApplicationImpl) {
            FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put("com.sun.faces.ApplicationAssociate", ((ApplicationImpl)application).getApplicationAssociate());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("set Application Instance to ''{0}''", application.getClass().getName()));
        }
    }
}

