/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationFactoryImpl;
import com.sun.faces.application.ServletContextSensitiveSingletonStore;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesWrapper;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionApplicationFactory
extends ApplicationFactory
implements FacesWrapper<ApplicationFactory> {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String APPLICATION_KEY = InjectionApplicationFactory.class.getName();
    private static final String DEFAULT_APPLICATION_KEY = InjectionApplicationFactory.class.getPackage().getName() + ".DefaultApplication";
    private ApplicationFactory delegate;
    private Field defaultApplicationField;
    private ServletContext backupServletContext;

    public InjectionApplicationFactory(ApplicationFactory delegate) {
        Util.notNull("applicationFactory", delegate);
        this.delegate = delegate;
    }

    public Application getApplication() {
        InitFacesContext initFacesContext = null;
        if (null == FacesContext.getCurrentInstance() && null != this.backupServletContext) {
            initFacesContext = new InitFacesContext(this.backupServletContext);
        } else if (null == this.backupServletContext) {
            this.backupServletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
        }
        ServletContextSensitiveSingletonStore<Application> appStore = new ServletContextSensitiveSingletonStore<Application>(APPLICATION_KEY);
        Application application = (Application)appStore.getReferenceToSingleton();
        if (application == null) {
            appStore.removeSingletonOnContextDestroyed();
            application = this.delegate.getApplication();
            appStore.putSingletonReference(application);
            if (application == null) {
                String message = MessageFormat.format("Delegate ApplicationContextFactory, {0}, returned null when calling getApplication().", this.delegate.getClass().getName());
                throw new IllegalStateException(message);
            }
            this.injectDefaultApplication(application);
        }
        if (null != initFacesContext) {
            initFacesContext.release();
        }
        return application;
    }

    public synchronized void setApplication(Application application) {
        ServletContextSensitiveSingletonStore<Application> appStore = new ServletContextSensitiveSingletonStore<Application>(APPLICATION_KEY);
        this.delegate.setApplication(application);
        appStore.removeSingletonReference();
        appStore.putSingletonReference(application);
        this.injectDefaultApplication(application);
    }

    public ApplicationFactory getWrapped() {
        return this.delegate;
    }

    private void injectDefaultApplication(Application toInject) {
        block8: {
            if (!this.isInjectionNecessary(toInject)) {
                return;
            }
            ServletContextSensitiveSingletonStore<Application> defaultApplicationAppStore = new ServletContextSensitiveSingletonStore<Application>(DEFAULT_APPLICATION_KEY);
            Application defaultApplication = (Application)defaultApplicationAppStore.getReferenceToSingleton();
            if (defaultApplication == null) {
                defaultApplicationAppStore.removeSingletonOnContextDestroyed();
                ApplicationFactoryImpl defaultAppFactory = new ApplicationFactoryImpl();
                defaultApplication = defaultAppFactory.getApplication();
                defaultApplicationAppStore.putSingletonReference(toInject);
                defaultAppFactory = null;
            }
            if (defaultApplication != null) {
                try {
                    if (this.defaultApplicationField == null) {
                        this.defaultApplicationField = Application.class.getDeclaredField("defaultApplication");
                        this.defaultApplicationField.setAccessible(true);
                    }
                    this.defaultApplicationField.set(toInject, defaultApplication);
                }
                catch (NoSuchFieldException nsfe) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Unable to find private field named 'defaultApplication' in javax.faces.application.Application.");
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    private boolean isInjectionNecessary(Application toInject) {
        boolean result = false;
        ApplicationFactoryImpl defaultFactory = this.delegate instanceof ApplicationFactoryImpl ? (ApplicationFactoryImpl)this.delegate : new ApplicationFactoryImpl();
        result = !defaultFactory.getApplicationInstanceClass().equals(toInject.getClass());
        return result;
    }
}

