/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.TransactionAdminBean;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.transaction.spi.JavaEETransactionManagerDelegate;
import com.sun.enterprise.transaction.spi.TransactionInternal;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JavaEETransactionManagerSimplifiedDelegate
implements JavaEETransactionManagerDelegate,
PostConstruct {
    private JavaEETransactionManager tm;
    private static StringManager sm = StringManager.getManager(JavaEETransactionManagerSimplified.class);
    private Logger _logger;
    private boolean lao = false;
    private static final ReentrantReadWriteLock.ReadLock readLock = new ReentrantReadWriteLock().readLock();
    private final Semaphore writeLock = new Semaphore(1, true);

    public void postConstruct() {
    }

    public boolean useLAO() {
        return this.lao;
    }

    public void setUseLAO(boolean b) {
        this.lao = b;
    }

    public void commitDistributedTransaction() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_notactive"));
    }

    public void rollbackDistributedTransaction() throws IllegalStateException, SecurityException, SystemException {
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_notactive"));
    }

    public int getStatus() throws SystemException {
        JavaEETransaction tx = this.tm.getCurrentTransaction();
        if (tx != null && tx.isLocalTx()) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        return this.tm.getCurrentTransaction();
    }

    public boolean enlistDistributedNonXAResource(Transaction tran, TransactionalResource h) throws RollbackException, IllegalStateException, SystemException {
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
    }

    public boolean enlistLAOResource(Transaction tran, TransactionalResource h) throws RollbackException, IllegalStateException, SystemException {
        return false;
    }

    public void setRollbackOnlyDistributedTransaction() throws IllegalStateException, SystemException {
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_notactive"));
    }

    public Transaction suspend(JavaEETransaction tx) throws SystemException {
        if (tx != null) {
            this.tm.setCurrentTransaction(null);
            return tx;
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_notactive"));
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
    }

    public void removeTransaction(Transaction tx) {
    }

    public int getOrder() {
        return 1;
    }

    public void setTransactionManager(JavaEETransactionManager tm) {
        this.tm = (JavaEETransactionManagerSimplified)tm;
        this._logger = ((JavaEETransactionManagerSimplified)tm).getLogger();
    }

    public TransactionInternal startJTSTx(JavaEETransaction t, boolean isAssociatedTimeout) throws RollbackException, IllegalStateException, SystemException {
        throw new UnsupportedOperationException("startJTSTx");
    }

    public boolean supportsXAResource() {
        return false;
    }

    public void recover(XAResource[] resourceList) {
        throw new UnsupportedOperationException("recover");
    }

    public XATerminator getXATerminator() {
        throw new UnsupportedOperationException("getXATerminator");
    }

    public void release(Xid xid) throws WorkException {
        throw new UnsupportedOperationException("release");
    }

    public void recreate(Xid xid, long timeout) throws WorkException {
        throw new UnsupportedOperationException("recreate");
    }

    public boolean recoverIncompleteTx(boolean delegated, String logPath, XAResource[] xaresArray) throws Exception {
        throw new UnsupportedOperationException("recoverIncompleteTx");
    }

    public XAResourceWrapper getXAResourceWrapper(String clName) {
        return null;
    }

    public void handlePropertyUpdate(String name, Object value) {
    }

    public Lock getReadLock() {
        return readLock;
    }

    public boolean isWriteLocked() {
        return this.writeLock.availablePermits() == 0;
    }

    public void acquireWriteLock() {
        try {
            this.writeLock.acquire();
        }
        catch (InterruptedException ie) {
            this._logger.log(Level.FINE, "Error in acquireReadLock", ie);
        }
    }

    public void releaseWriteLock() {
        this.writeLock.release();
    }

    public boolean isNullTransaction() {
        return false;
    }

    public TransactionAdminBean getTransactionAdminBean(Transaction tran) throws SystemException {
        TransactionAdminBean tBean = null;
        if (tran instanceof JavaEETransaction) {
            JavaEETransactionImpl tran1 = (JavaEETransactionImpl)tran;
            String id = tran1.getTransactionId();
            long startTime = tran1.getStartTime();
            String componentName = tran1.getComponentName();
            ArrayList<String> resourceNames = tran1.getResourceNames();
            long elapsedTime = System.currentTimeMillis() - startTime;
            String status = JavaEETransactionManagerSimplified.getStatusAsString(tran.getStatus());
            tBean = new TransactionAdminBean((Object)tran, id, status, elapsedTime, componentName, resourceNames);
        }
        return tBean;
    }
}

