/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jta.admin.cli;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.i18n.StringManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="rollback-transaction")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@Cluster(value={RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@I18n(value="rollback.transaction")
public class RollbackTransaction
implements AdminCommand {
    private static StringManager localStrings = StringManager.getManager(RollbackTransaction.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="transaction_id")
    String txnId;
    @Inject
    JavaEETransactionManager transactionMgr;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.transactionMgr.forceRollback(this.txnId);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getString("rollback.transaction.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

