/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jta.admin.cli;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="unfreeze-transaction-service")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Cluster(value={RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@I18n(value="unfreeze.transaction.service")
public class UnFreezeTransactionService
implements AdminCommand {
    private static StringManager localStrings = StringManager.getManager(UnFreezeTransactionService.class);
    private static final Logger logger = LogDomains.getLogger(UnFreezeTransactionService.class, (String)"javax.enterprise.resource.jta");
    @Param(optional=true)
    String target = "server";
    @Inject
    JavaEETransactionManager transactionMgr;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (!this.transactionMgr.isFrozen()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("There is no frozen transaction.");
                }
                return;
            }
            this.transactionMgr.unfreeze();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getString("unfreeze.transaction.service.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

