/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.startup;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class TransactionRecoveryWrapper
implements Startup,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    Events events;
    @Inject
    Applications applications;
    private static Logger _logger = LogDomains.getLogger(TransactionRecoveryWrapper.class, (String)"javax.enterprise.resource.jta");

    public void postConstruct() {
        EventListener glassfishEventListener = new EventListener(){

            public void event(EventListener.Event event) {
                if (event.is(EventTypes.SERVER_READY)) {
                    _logger.fine("ON READY");
                    TransactionRecoveryWrapper.this.onReady();
                } else if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
                    _logger.fine("ON SHUTDOWN");
                    TransactionRecoveryWrapper.this.onShutdown();
                }
            }
        };
        this.events.register(glassfishEventListener);
    }

    public void onReady() {
        List apps = this.applications.getApplications();
        if (apps != null && apps.size() > 0) {
            JavaEETransactionManager tm = (JavaEETransactionManager)this.habitat.getByContract(JavaEETransactionManager.class);
            tm.initRecovery(false);
        }
    }

    public void onShutdown() {
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }
}

