/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.iiop;

import com.sun.corba.ee.impl.txpoa.TSIdentificationImpl;
import com.sun.corba.ee.spi.costransactions.TransactionService;
import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.corba.ee.spi.orbutil.closure.ClosureFactory;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.transaction.jts.iiop.TxIORInterceptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.config.Property;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TSIdentification;
import org.omg.CosTransactions.Current;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Service(name="TransactionIIOPInterceptorFactory")
public class TransactionIIOPInterceptorFactory
implements IIOPInterceptorFactory {
    private static Logger _logger = LogDomains.getLogger(InterceptorImpl.class, (String)"javax.enterprise.system.core.transaction");
    private static StringManager localStrings = StringManager.getManager(InterceptorImpl.class);
    private static final String JTS_XA_SERVER_NAME = "com.sun.jts.xa-servername";
    private static final String J2EE_SERVER_ID_PROP = "com.sun.enterprise.J2EEServerId";
    private static final String JTS_SERVER_ID = "com.sun.jts.persistentServerId";
    private static final int DEFAULT_SERVER_ID = 100;
    private static String jtsClassName = "com.sun.jts.CosTransactions.DefaultTransactionService";
    private static Properties jtsProperties = new Properties();
    private static TSIdentificationImpl tsIdent = new TSIdentificationImpl();
    private static boolean txServiceInitialized = false;
    private InterceptorImpl interceptor = null;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerContext ctx;
    @Inject
    private ProcessEnvironment processEnv;

    public ClientRequestInterceptor createClientRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (!txServiceInitialized) {
            this.createInterceptor(info, codec);
        }
        return this.interceptor;
    }

    public ServerRequestInterceptor createServerRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (!txServiceInitialized) {
            this.createInterceptor(info, codec);
        }
        return this.interceptor;
    }

    private void createInterceptor(ORBInitInfo info, Codec codec) {
        if (this.processEnv.getProcessType() == ProcessEnvironment.ProcessType.Server) {
            try {
                System.setProperty("com.sun.jts.pi.CLIENT_POLICY_CHECKING", String.valueOf(false));
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "iiop.readproperty_exception", ex);
            }
            this.initJTSProperties(true);
        }
        try {
            block10: {
                org.omg.PortableInterceptor.Current pic = (org.omg.PortableInterceptor.Current)info.resolve_initial_references("PICurrent");
                int[] slotIds = new int[]{info.allocate_slot_id(), info.allocate_slot_id()};
                this.interceptor = new InterceptorImpl(pic, codec, slotIds, null);
                com.sun.corba.ee.spi.orb.ORB theORB = ((ORBInitInfoExt)info).getORB();
                InterceptorImpl.setOrb((ORB)theORB);
                try {
                    Class<?> theJTSClass = Class.forName(jtsClassName);
                    if (theJTSClass == null) break block10;
                    try {
                        TransactionService jts = (TransactionService)theJTSClass.newInstance();
                        jts.identify_ORB((ORB)theORB, (TSIdentification)tsIdent, jtsProperties);
                        this.interceptor.setTSIdentification((TSIdentification)tsIdent);
                        Current transactionCurrent = jts.get_current();
                        theORB.getLocalResolver().register("TransactionCurrent", ClosureFactory.makeConstant((Object)transactionCurrent));
                        theORB.getLocalResolver().register("TSIdentification", ClosureFactory.makeConstant((Object)tsIdent));
                        txServiceInitialized = true;
                    }
                    catch (Exception ex) {
                        throw new INITIALIZE("JTS Exception: " + ex, 1398080489, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    _logger.log(Level.SEVERE, "iiop.inittransactionservice_exception", cnfe);
                }
            }
            TxIORInterceptor iorInterceptor = new TxIORInterceptor(codec, this.habitat);
            info.add_ior_interceptor((IORInterceptor)iorInterceptor);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception registering JTS interceptors", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    private void initJTSProperties(boolean lateRegistration) {
        if (this.habitat != null) {
            com.sun.enterprise.config.serverbeans.TransactionService txnService = (com.sun.enterprise.config.serverbeans.TransactionService)this.habitat.getComponent(com.sun.enterprise.config.serverbeans.TransactionService.class);
            if (txnService != null) {
                int jtsServerId;
                boolean isAutomaticRecovery;
                jtsProperties.put("com.sun.jts.heuristicDirection", txnService.getHeuristicDecision());
                jtsProperties.put("com.sun.jts.keypointCount", txnService.getKeypointInterval());
                String automaticRecovery = txnService.getAutomaticRecovery();
                boolean bl = isAutomaticRecovery = this.isValueSet(automaticRecovery) && "true".equals(automaticRecovery);
                if (isAutomaticRecovery) {
                    _logger.log(Level.FINE, "Recoverable J2EE Server");
                    jtsProperties.put("com.sun.jts.ManualRecovery", "true");
                }
                boolean disable_distributed_transaction_logging = false;
                String dbLoggingResource = null;
                for (Property prop : txnService.getProperty()) {
                    String name = prop.getName();
                    String value = prop.getValue();
                    if (name.equals("disable-distributed-transaction-logging")) {
                        if (!this.isValueSet(value) || !"true".equals(value)) continue;
                        disable_distributed_transaction_logging = true;
                        continue;
                    }
                    if (name.equals("xaresource-txn-timeout")) {
                        if (!this.isValueSet(value)) continue;
                        _logger.log(Level.FINE, "XAResource transaction timeout is" + value);
                        TransactionManagerImpl.setXAResourceTimeOut(Integer.parseInt(value));
                        continue;
                    }
                    if (name.equals("db-logging-resource")) {
                        dbLoggingResource = value;
                        _logger.log(Level.FINE, "Transaction DB Logging Resource Name" + dbLoggingResource);
                        if (dbLoggingResource == null || !" ".equals(dbLoggingResource) && !"".equals(dbLoggingResource)) continue;
                        dbLoggingResource = "jdbc/TxnDS";
                        continue;
                    }
                    if (!name.equals("xa-servername") || !this.isValueSet(value)) continue;
                    jtsProperties.put(JTS_XA_SERVER_NAME, value);
                }
                if (dbLoggingResource != null) {
                    disable_distributed_transaction_logging = true;
                    jtsProperties.put("com.sun.jts.logResource", dbLoggingResource);
                }
                if ((jtsServerId = ((GlassFishORBHelper)this.habitat.getComponent(GlassFishORBHelper.class)).getORBInitialPort()) == 0) {
                    jtsServerId = 100;
                }
                jtsProperties.put(JTS_SERVER_ID, String.valueOf(jtsServerId));
                String serverId = String.valueOf(100);
                System.setProperty(J2EE_SERVER_ID_PROP, serverId);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "++++ Server id: " + jtsProperties.getProperty("org.omg.CORBA.ORBServerId"));
                }
                if (!isAutomaticRecovery && disable_distributed_transaction_logging) {
                    Configuration.disableFileLogging();
                }
                String instanceName = this.ctx.getInstanceName();
                if (dbLoggingResource == null) {
                    String logdir = txnService.getTxLogDir();
                    if (logdir == null) {
                        Domain domain = (Domain)this.habitat.getComponent(Domain.class);
                        logdir = domain.getLogRoot();
                        if (logdir == null) {
                            logdir = ".." + File.separator + "logs";
                        }
                    } else if (!new File(logdir).isAbsolute()) {
                        Domain domain;
                        String logroot;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Relative pathname specified for transaction log directory : " + logdir);
                        }
                        logdir = (logroot = (domain = (Domain)this.habitat.getComponent(Domain.class)).getLogRoot()) != null ? logroot + File.separator + logdir : ".." + File.separator + "logs" + File.separator + logdir;
                    }
                    logdir = logdir + File.separator + instanceName + File.separator + "tx";
                    _logger.log(Level.FINE, "JTS log directory: " + logdir);
                    _logger.log(Level.FINE, "JTS Server id " + jtsServerId);
                    new File(logdir).mkdirs();
                    jtsProperties.put("com.sun.jts.logDirectory", logdir);
                }
                jtsProperties.put("com.sun.jts.commitRetry", txnService.getRetryTimeoutInSeconds());
                jtsProperties.put("com.sun.jts.instancename", instanceName);
            }
            Configuration.setProperties(jtsProperties);
        }
    }

    private boolean isValueSet(String value) {
        return value != null && !value.equals("") && !value.equals(" ");
    }
}

