/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.enterprise.transaction.jts.api.TransactionRecovery;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.EventSemaphore;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.Log;
import com.sun.jts.CosTransactions.LogControl;
import com.sun.jts.CosTransactions.LogDBHelper;
import com.sun.jts.CosTransactions.LogFile;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.ResyncThread;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.codegen.jtsxa.OTSResource;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Status;

public class RecoveryManager {
    private static Enumeration uniqueRMSet = null;
    private static boolean initialised = false;
    private static int resyncCoords = 0;
    private static ResyncThread resyncThread = null;
    private static volatile EventSemaphore resyncInProgress = new EventSemaphore();
    private static volatile EventSemaphore recoveryInProgress = new EventSemaphore();
    private static volatile EventSemaphore uniqueRMSetReady = new EventSemaphore();
    private static Hashtable coordsByGlobalTID = new Hashtable();
    private static Hashtable coordsByLocalTID = new Hashtable();
    private static Hashtable transactionIds = new Hashtable();
    private static Hashtable inCompleteTxMap = new Hashtable();
    private static TransactionRecovery txRecovery;
    private static Object lockObject;
    static Logger _logger;

    static void initialise() {
        if (initialised) {
            return;
        }
        initialised = true;
        if (Configuration.isRecoverable()) {
            resyncThread = new ResyncThread();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.logp(Level.FINE, "RecoveryManager", "initialise()", "Before starting ResyncThread ");
            }
            resyncThread.start();
        } else {
            String serverName;
            if (!Configuration.isAppClientContainer() && (serverName = Configuration.getServerName()) != null && Log.checkFileExists(serverName)) {
                _logger.log(Level.INFO, "jts.log_file_transient_server", serverName);
            }
            try {
                recoveryInProgress.post();
                RecoveryManager.resyncComplete(false, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static boolean addCoordinator(GlobalTID globalTID, Long localTID, CoordinatorImpl coord, int timeout) {
        boolean result = true;
        coordsByGlobalTID.put(globalTID, coord);
        coordsByLocalTID.put(localTID, coord);
        if (timeout != 0) {
            TimeoutManager.setTimeout(localTID, 1, timeout);
        }
        return result;
    }

    static boolean removeCoordinator(GlobalTID globalTID, Long localTID, boolean aborted) {
        boolean result = false;
        CoordinatorImpl coord = null;
        boolean bl = result = coordsByGlobalTID.remove(globalTID) != null;
        if (result) {
            coord = (CoordinatorImpl)coordsByLocalTID.remove(localTID);
            boolean bl2 = result = coord != null;
        }
        if (coord != null) {
            try {
                if (coord.is_top_level_transaction()) {
                    if (inCompleteTxMap.get(coord) == null) {
                        if (Configuration.isDBLoggingEnabled()) {
                            LogDBHelper.getInstance().deleteRecord(localTID);
                        } else {
                            CoordinatorLog.removeLog(localTID);
                        }
                    } else if (_logger.isLoggable(Level.FINE)) {
                        _logger.logp(Level.FINE, "RecoveryManager", "removeCoordinator()", "Transaction hasn't completed, let it stay in active logs");
                    }
                }
            }
            catch (SystemException exc) {
                result = false;
            }
        }
        TimeoutManager.setTimeout(localTID, 0, 0);
        if (resyncCoords > 0 && --resyncCoords == 0) {
            try {
                RecoveryManager.resyncComplete(true, true);
            }
            catch (Throwable exc) {
                // empty catch block
            }
        }
        return result;
    }

    static CoordinatorImpl getCoordinator(GlobalTID globalTID) {
        CoordinatorImpl result = (CoordinatorImpl)coordsByGlobalTID.get(globalTID);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean readAndUpdateTxMap(GlobalTID tid) {
        Hashtable hashtable = transactionIds;
        synchronized (hashtable) {
            Thread thread = (Thread)transactionIds.get(tid);
            if (thread != null) {
                return false;
            }
            transactionIds.put(tid, Thread.currentThread());
            return true;
        }
    }

    static Thread getThreadFromTxMap(GlobalTID tid) {
        return (Thread)transactionIds.get(tid);
    }

    static Thread removeFromTxMap(GlobalTID tid) {
        return (Thread)transactionIds.remove(tid);
    }

    static boolean recover() {
        boolean result = false;
        boolean keypointRequired = false;
        Enumeration logRecords = CoordinatorLog.getLogged();
        while (logRecords.hasMoreElements()) {
            keypointRequired = true;
            try {
                new TopCoordinator().reconstruct((CoordinatorLog)logRecords.nextElement());
            }
            catch (Exception exc) {
                _logger.log(Level.SEVERE, "jts.recovery_in_doubt_exception", exc);
                _logger.log(Level.SEVERE, "jts.recovery_in_doubt", exc.toString());
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.recovery_in_doubt", new Object[]{exc.toString()});
                throw new INTERNAL(msg);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.logp(Level.FINE, "RecoveryManager", "recover()", "Before invoking proceedWithXARecovery()");
        }
        RecoveryManager.proceedWithXARecovery();
        recoveryInProgress.post();
        boolean bl = result = coordsByGlobalTID.size() > 0;
        if (!result) {
            try {
                RecoveryManager.resyncComplete(false, keypointRequired);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resync() {
        resyncCoords = coordsByGlobalTID.size();
        Enumeration resyncList = ((Hashtable)coordsByGlobalTID.clone()).elements();
        boolean[] isRoot = new boolean[1];
        while (resyncList.hasMoreElements()) {
            TopCoordinator coord = (TopCoordinator)resyncList.nextElement();
            try {
                TopCoordinator topCoordinator = coord;
                synchronized (topCoordinator) {
                    Status state = coord.recover(isRoot);
                    if (state == Status.StatusUnknown) {
                        TimeoutManager.setTimeout(new Long(coord.getLocalTID()), 2, 60);
                    } else if (state == Status.StatusCommitted) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "RecoveryManager", "resync()", "Before invoking commit on the reconstructed coordinatorGTID is: " + coord.superInfo.globalTID.toString());
                        }
                        try {
                            coord.commit();
                        }
                        catch (Throwable exc) {
                            _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "commit"});
                        }
                        if (isRoot[0]) {
                            try {
                                coord.afterCompletion(state);
                            }
                            catch (Throwable exc) {
                                _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "after_completion"});
                            }
                        }
                    } else {
                        try {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.logp(Level.FINE, "RecoveryManager", "resync()", "Before invoking rollback on thereconstructed coordinator :GTID is : " + coord.superInfo.globalTID.toString());
                            }
                            coord.rollback(true);
                        }
                        catch (Throwable exc) {
                            _logger.log(Level.WARNING, "jts.resync_failed", new Object[]{exc.toString(), "rollback"});
                        }
                        if (isRoot[0]) {
                            try {
                                coord.afterCompletion(Status.StatusRolledBack);
                            }
                            catch (Throwable exc) {
                                _logger.log(Level.WARNING, "jts.resync_failed", new Object[]{exc.toString(), "after_completion"});
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    static void resyncComplete(boolean resynced, boolean keypointRequired) throws LogicErrorException {
        if (keypointRequired) {
            CoordinatorLog.keypoint();
        }
        if (resyncInProgress != null) {
            resyncInProgress.post();
            resyncInProgress = null;
        }
    }

    static CoordinatorImpl getLocalCoordinator(Long localTID) {
        CoordinatorImpl result = (CoordinatorImpl)coordsByLocalTID.get(localTID);
        return result;
    }

    static boolean validLocalTID(Long localTID) {
        boolean result = coordsByLocalTID.containsKey(localTID);
        return result;
    }

    static void shutdown(boolean immediate) {
        if (resyncInProgress != null) {
            try {
                resyncInProgress.waitEvent();
                if (resyncThread != null) {
                    resyncThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!immediate && Configuration.isRecoverable()) {
            CoordinatorLog.keypoint();
            CoordinatorLog.finalizeAll();
        }
    }

    private static String stringifyXid(Xid xid) {
        int glen = xid.getGlobalTransactionId().length;
        int blen = xid.getBranchQualifier().length;
        byte[] xidRep = new byte[glen + 1 + blen];
        System.arraycopy(xid.getGlobalTransactionId(), 0, xidRep, 0, glen);
        xidRep[glen] = 44;
        System.arraycopy(xid.getBranchQualifier(), 0, xidRep, glen + 1, blen);
        return new String(xidRep);
    }

    private static Enumeration getUniqueRMSet(Enumeration xaResourceList) {
        Vector<XAResource> uniqueRMList = new Vector<XAResource>();
        while (xaResourceList.hasMoreElements()) {
            XAResource xaRes = (XAResource)xaResourceList.nextElement();
            int size = uniqueRMList.size();
            boolean match = false;
            for (int i = 0; i < size; ++i) {
                XAResource uniqueXaRes = (XAResource)uniqueRMList.elementAt(i);
                try {
                    if (!xaRes.isSameRM(uniqueXaRes)) continue;
                    match = true;
                    break;
                }
                catch (XAException xe) {
                    // empty catch block
                }
            }
            if (match) continue;
            uniqueRMList.add(xaRes);
        }
        return uniqueRMList.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverXAResources(Enumeration xaResources) {
        String manualRecovery = Configuration.getPropertyValue("com.sun.jts.ManualRecovery");
        if (manualRecovery == null || !manualRecovery.equalsIgnoreCase("true")) {
            return;
        }
        Object object = lockObject;
        synchronized (object) {
            if (!uniqueRMSetReady.isPosted()) {
                uniqueRMSet = RecoveryManager.getUniqueRMSet(xaResources);
                uniqueRMSetReady.post();
                RecoveryManager.waitForResync();
                return;
            }
            RecoveryManager.waitForResync();
            uniqueRMSet = RecoveryManager.getUniqueRMSet(xaResources);
            RecoveryManager.proceedWithXARecovery();
        }
    }

    static Xid[] getInDoubtXids(XAResource xaResource) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.logp(Level.FINE, "RecoveryManager", "getInDoubtXids()", "Before receiving inDoubtXids from xaresource = " + xaResource);
        }
        Xid[] inDoubtXids = null;
        ArrayList<Xid> inDoubtXidList = null;
        String recoveryScanFlags = System.getProperty("RECOVERSCANFLAGS");
        int flags = recoveryScanFlags != null && recoveryScanFlags.equals("TMNOFLAGS") ? 0x1000000 : 0x1800000;
        boolean continueLoop = true;
        while (continueLoop) {
            try {
                inDoubtXids = xaResource.recover(flags);
                if (inDoubtXids == null || inDoubtXids.length == 0 || flags != 0x1000000 && flags != 0) break;
                flags = 0;
                if (inDoubtXidList == null) {
                    inDoubtXidList = new ArrayList<Xid>();
                }
                for (int i = 0; i < inDoubtXids.length; ++i) {
                    inDoubtXidList.add(inDoubtXids[i]);
                }
            }
            catch (XAException e) {
                _logger.log(Level.WARNING, "jts.xaexception_in_recovery", e.errorCode);
                _logger.log(Level.WARNING, "", e);
                break;
            }
        }
        if (inDoubtXidList != null) {
            inDoubtXids = inDoubtXidList.toArray(new Xid[0]);
        }
        if (_logger.isLoggable(Level.FINE) && inDoubtXids != null) {
            String xidList = LogFormatter.convertXidArrayToString(inDoubtXids);
            _logger.logp(Level.FINE, "RecoveryManager", "getInDoubtXid()", "InDoubtXids returned from xaresource = " + xaResource + "are: " + xidList);
        }
        return inDoubtXids;
    }

    private static void proceedWithXARecovery() {
        Enumeration xaResources = uniqueRMSet;
        String manualRecovery = Configuration.getPropertyValue("com.sun.jts.ManualRecovery");
        if (manualRecovery == null || !manualRecovery.equalsIgnoreCase("true")) {
            return;
        }
        if (Thread.currentThread().getName().equals("JTS Resync Thread") && uniqueRMSetReady != null) {
            try {
                uniqueRMSetReady.waitEvent();
                txRecovery.start();
                txRecovery.raiseFence();
                xaResources = uniqueRMSet;
            }
            catch (InterruptedException exc) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(msg);
            }
        }
        if (xaResources == null) {
            return;
        }
        Vector<OTSResource> otsResources = new Vector<OTSResource>();
        HashSet<Xid> uniqueXids = new HashSet<Xid>();
        while (xaResources.hasMoreElements()) {
            XAResource xaResource = (XAResource)xaResources.nextElement();
            Xid[] inDoubtXids = RecoveryManager.getInDoubtXids(xaResource);
            if (inDoubtXids == null || inDoubtXids.length == 0) continue;
            for (int i = 0; i < inDoubtXids.length; ++i) {
                String serverName;
                String branchQualifier = new String(inDoubtXids[i].getBranchQualifier());
                if (branchQualifier.startsWith(serverName = Configuration.getServerName())) {
                    String xidStr = RecoveryManager.stringifyXid(inDoubtXids[i]);
                    if (!uniqueXids.contains(inDoubtXids[i])) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery", " This xid is UNIQUE " + inDoubtXids[i]);
                        }
                        uniqueXids.add(inDoubtXids[i]);
                        otsResources.addElement(new OTSResourceImpl(inDoubtXids[i], xaResource, null).getCORBAObjReference());
                        continue;
                    }
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery", " This xid is NOTUNIQUE " + inDoubtXids[i]);
                    continue;
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery", " This xid doesn't belong to me " + inDoubtXids[i]);
            }
        }
        for (int i = 0; i < otsResources.size(); ++i) {
            OTSResource otsResource = (OTSResource)otsResources.elementAt(i);
            GlobalTID globalTID = new GlobalTID(otsResource.getGlobalTID());
            TopCoordinator coord = (TopCoordinator)coordsByGlobalTID.get(globalTID);
            if (coord == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery()", "Could  not recognize OTSResource: " + otsResource + " with tid: " + LogFormatter.convertToString(globalTID.realTID.tid) + ";Hence rolling this resource back...");
                }
                boolean infiniteRetry = true;
                int commitRetries = Configuration.getRetries();
                if (commitRetries >= 0) {
                    infiniteRetry = false;
                }
                int commitRetriesLeft = commitRetries;
                boolean exceptionisThrown = true;
                while (exceptionisThrown) {
                    try {
                        otsResource.rollback();
                        exceptionisThrown = false;
                    }
                    catch (Throwable exc) {
                        if (exc instanceof COMM_FAILURE || exc instanceof TRANSIENT) {
                            if (commitRetriesLeft > 0 || infiniteRetry) {
                                if (!infiniteRetry) {
                                    --commitRetriesLeft;
                                }
                                try {
                                    Thread.sleep(60000L);
                                }
                                catch (Throwable e) {}
                                continue;
                            }
                            _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "OTSResource rollback"});
                            exceptionisThrown = false;
                            continue;
                        }
                        _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "OTSResource rollback"});
                        exceptionisThrown = false;
                    }
                }
                continue;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery()", "Recognized OTSResource: " + otsResource + " with tid: " + LogFormatter.convertToString(globalTID.realTID.tid) + ";Hence registering this resource with coordinator...");
            }
            coord.directRegisterResource(otsResource);
        }
    }

    static void dbXARecovery() {
        Enumeration xaResources = uniqueRMSet;
        String manualRecovery = Configuration.getPropertyValue("com.sun.jts.ManualRecovery");
        if (manualRecovery == null || !manualRecovery.equalsIgnoreCase("true")) {
            try {
                RecoveryManager.resyncComplete(false, false);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            return;
        }
        if (Thread.currentThread().getName().equals("JTS Resync Thread") && uniqueRMSetReady != null) {
            try {
                uniqueRMSetReady.waitEvent();
                xaResources = uniqueRMSet;
            }
            catch (InterruptedException exc) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(msg);
            }
        }
        if (xaResources == null) {
            try {
                RecoveryManager.resyncComplete(false, false);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            return;
        }
        Map gtidMap = LogDBHelper.getInstance().getGlobalTIDMap();
        HashSet<Xid> uniqueXids = new HashSet<Xid>();
        while (xaResources.hasMoreElements()) {
            XAResource xaResource = (XAResource)xaResources.nextElement();
            Xid[] inDoubtXids = RecoveryManager.getInDoubtXids(xaResource);
            if (inDoubtXids == null || inDoubtXids.length == 0) continue;
            for (int i = 0; i < inDoubtXids.length; ++i) {
                String serverName;
                String branchQualifier = new String(inDoubtXids[i].getBranchQualifier());
                if (branchQualifier.startsWith(serverName = Configuration.getServerName())) {
                    String xidStr = RecoveryManager.stringifyXid(inDoubtXids[i]);
                    if (!uniqueXids.contains(inDoubtXids[i])) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "RecoveryManager", "dbXARecovery", " This xid is UNIQUE " + inDoubtXids[i]);
                        }
                        uniqueXids.add(inDoubtXids[i]);
                        try {
                            byte[] gtrid = inDoubtXids[i].getGlobalTransactionId();
                            GlobalTID gtid = GlobalTID.fromTIDBytes(gtrid);
                            Long localTID = (Long)gtidMap.get(gtid);
                            if (localTID == null) {
                                xaResource.rollback(inDoubtXids[i]);
                                continue;
                            }
                            xaResource.commit(inDoubtXids[i], true);
                            LogDBHelper.getInstance().deleteRecord(localTID);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.logp(Level.FINE, "RecoveryManager", "dbXARecovery", " This xid is NOTUNIQUE " + inDoubtXids[i]);
                    continue;
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.logp(Level.FINE, "RecoveryManager", "dbXARecovery", " This xid doesn't belong to me " + inDoubtXids[i]);
            }
        }
        try {
            RecoveryManager.resyncComplete(false, false);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static CoordinatorImpl[] getCoordinators() {
        int size = coordsByGlobalTID.size();
        CoordinatorImpl[] result = new CoordinatorImpl[size];
        Enumeration coords = coordsByGlobalTID.elements();
        int pos = 0;
        while (pos < size) {
            result[pos++] = (CoordinatorImpl)coords.nextElement();
        }
        return result;
    }

    static Hashtable getCoordsByGlobalTID() {
        return coordsByGlobalTID;
    }

    public static byte[] getRestart() {
        byte[] result = null;
        LogFile logFile = Configuration.getLogFile();
        if (logFile != null) {
            result = logFile.readRestart();
        }
        return result;
    }

    public static void setRestart(byte[] bytes) {
        LogFile logFile = Configuration.getLogFile();
        if (logFile != null && !logFile.writeRestart(bytes)) {
            _logger.log(Level.WARNING, "jts.restart_write_failed");
        }
    }

    public static void waitForRecovery() {
        if (recoveryInProgress != null) {
            try {
                recoveryInProgress.waitEvent();
            }
            catch (InterruptedException exc) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(msg);
            }
        }
    }

    public static void waitForResync() {
        if (resyncInProgress != null) {
            try {
                resyncInProgress.waitEvent();
            }
            catch (InterruptedException exc) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(msg);
            }
        }
    }

    static void addToIncompleTx(CoordinatorImpl coord, boolean commit) {
        inCompleteTxMap.put(coord, new Boolean(commit));
    }

    public static Boolean isIncompleteTxRecoveryRequired() {
        if (inCompleteTxMap.isEmpty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static int sizeOfInCompleTx() {
        return inCompleteTxMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverIncompleteTx(XAResource[] xaresArray) {
        if (xaresArray == null || xaresArray.length == 0) {
            return;
        }
        int size = xaresArray.length;
        Vector<XAResource> v = new Vector<XAResource>();
        for (int i = 0; i < size; ++i) {
            v.addElement(xaresArray[i]);
        }
        Enumeration resourceList = RecoveryManager.getUniqueRMSet(v.elements());
        HashSet<Xid> uniqueXids = new HashSet<Xid>();
        Vector<OTSResourceImpl> otsResources = new Vector<OTSResourceImpl>();
        while (resourceList.hasMoreElements()) {
            XAResource xaResource = (XAResource)resourceList.nextElement();
            Xid[] inDoubtXids = RecoveryManager.getInDoubtXids(xaResource);
            if (inDoubtXids == null || inDoubtXids.length == 0) continue;
            for (int i = 0; i < inDoubtXids.length; ++i) {
                String serverName;
                String branchQualifier = new String(inDoubtXids[i].getBranchQualifier());
                if (branchQualifier.startsWith(serverName = Configuration.getServerName())) {
                    String xidStr = RecoveryManager.stringifyXid(inDoubtXids[i]);
                    if (!uniqueXids.contains(inDoubtXids[i])) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "RecoveryManager", "recoverIncompleteTx", " This xid is UNIQUE " + inDoubtXids[i]);
                        }
                        uniqueXids.add(inDoubtXids[i]);
                        otsResources.addElement(new OTSResourceImpl(inDoubtXids[i], xaResource, null));
                        continue;
                    }
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.logp(Level.FINE, "RecoveryManager", "recoverIncompleteTx", " This xid is NOTUNIQUE " + inDoubtXids[i]);
                    continue;
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.logp(Level.FINE, "RecoveryManager", "recoverIncompleteTx", " This xid doesn't belong to me " + inDoubtXids[i]);
            }
        }
        for (int i = 0; i < otsResources.size(); ++i) {
            OTSResourceImpl otsResource = (OTSResourceImpl)otsResources.elementAt(i);
            GlobalTID globalTID = new GlobalTID(otsResource.getGlobalTID());
            Hashtable hashtable = inCompleteTxMap;
            synchronized (hashtable) {
                Enumeration e = inCompleteTxMap.keys();
                while (e.hasMoreElements()) {
                    CoordinatorImpl cImpl = (CoordinatorImpl)e.nextElement();
                    GlobalTID gTID = new GlobalTID(cImpl.getGlobalTID());
                    if (!gTID.equals(globalTID)) continue;
                    Boolean commit = (Boolean)inCompleteTxMap.get(cImpl);
                    boolean infiniteRetry = true;
                    int commitRetries = Configuration.getRetries();
                    if (commitRetries >= 0) {
                        infiniteRetry = false;
                    }
                    int commitRetriesLeft = commitRetries;
                    boolean exceptionisThrown = true;
                    while (exceptionisThrown) {
                        try {
                            if (commit.booleanValue()) {
                                otsResource.commit_one_phase();
                                if (_logger.isLoggable(Level.FINE)) {
                                    _logger.logp(Level.FINE, "RecoveryManager", "recoverIncompleteTx", " committed  " + otsResource);
                                }
                            } else {
                                otsResource.rollback();
                                if (_logger.isLoggable(Level.FINE)) {
                                    _logger.logp(Level.FINE, "RecoveryManager", "recoverIncompleteTx", " rolled back  " + otsResource);
                                }
                            }
                            exceptionisThrown = false;
                        }
                        catch (Throwable exc) {
                            if (exc instanceof COMM_FAILURE || exc instanceof TRANSIENT) {
                                if (commitRetriesLeft > 0 || infiniteRetry) {
                                    if (!infiniteRetry) {
                                        --commitRetriesLeft;
                                    }
                                    try {
                                        Thread.sleep(60000L);
                                    }
                                    catch (Throwable iex) {}
                                    continue;
                                }
                                _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "OTSResource " + (commit != false ? "commit" : "rollback")});
                                exceptionisThrown = false;
                                continue;
                            }
                            _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "OTSResource " + (commit != false ? "commit" : "rollback")});
                            exceptionisThrown = false;
                        }
                    }
                }
                continue;
            }
        }
    }

    static void createRecoveryFile(String serverName) {
        try {
            int[] result = new int[1];
            String logPath = Configuration.getDirectory("com.sun.jts.logDirectory", "jts", result);
            if ((result[0] == 1 || result[0] == 2) && result[0] == 2) {
                logPath = ".";
            }
            File recoveryFile = LogControl.recoveryIdentifierFile(serverName, logPath);
            RandomAccessFile raf = new RandomAccessFile(recoveryFile, "rw");
            raf.writeBytes(serverName);
            raf.setLength(serverName.length());
            raf.close();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex);
        }
    }

    public static void registerTransactionRecoveryService(TransactionRecovery txRecoveryService) {
        txRecovery = txRecoveryService;
    }

    static TransactionRecovery getTransactionRecovery() {
        return txRecovery;
    }

    static {
        lockObject = new Object();
        _logger = LogDomains.getLogger(RecoveryManager.class, (String)"javax.enterprise.system.core.transaction");
    }
}

