/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jts.admin.cli;

import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="recover-transactions")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@Cluster(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
@I18n(value="recover.transactions")
public class RecoverTransactions
implements AdminCommand {
    private static StringManager localStrings = StringManager.getManager(RecoverTransactions.class);
    private static Logger _logger = LogDomains.getLogger(RecoverTransactions.class, (String)"javax.enterprise.system.core.transaction");
    @Param(name="transactionlogdir", optional=true)
    String transactionLogDir;
    @Param(name="target", alias="destination", optional=true)
    String destinationServer;
    @Param(name="server_name", primary=true)
    String serverToRecover;
    @Inject
    Servers servers;
    @Inject
    InstanceState state;
    @Inject
    CommandRunner runner;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("==> original target: " + this.destinationServer + " ... server: " + this.serverToRecover);
        }
        if (this.servers.getServer(this.serverToRecover) == null) {
            report.setMessage(localStrings.getString("recover.transactions.serverBeRecoveredIsNotKnown", (Object)this.serverToRecover));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.isServerRunning(this.serverToRecover)) {
            if (this.destinationServer != null && !this.serverToRecover.equals(this.destinationServer)) {
                report.setMessage(localStrings.getString("recover.transactions.runningServerBeRecoveredFromAnotherServer", (Object)this.serverToRecover, (Object)this.destinationServer));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.transactionLogDir != null) {
                report.setMessage(localStrings.getString("recover.transactions.logDirShouldNotBeSpecifiedForSelfRecovery"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        } else {
            if (this.destinationServer == null) {
                report.setMessage(localStrings.getString("recover.transactions.noDestinationServer"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.servers.getServer(this.destinationServer) == null) {
                report.setMessage(localStrings.getString("recover.transactions.DestinationServerIsNotKnown"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!this.isServerRunning(this.destinationServer)) {
                report.setMessage(localStrings.getString("recover.transactions.destinationServerIsNotAlive", (Object)this.destinationServer));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.transactionLogDir == null) {
                report.setMessage(localStrings.getString("recover.transactions.logDirNotSpecifiedForDelegatedRecovery"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.destinationServer == null) {
            this.destinationServer = this.serverToRecover;
        }
        try {
            CommandRunner.CommandInvocation inv = this.runner.getCommandInvocation("_recover-transactions-internal", report);
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"target", (Object)this.destinationServer);
            parameters.add((Object)"DEFAULT", (Object)this.serverToRecover);
            parameters.add((Object)"transactionlogdir", (Object)this.transactionLogDir);
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("==> calling _recover-transactions-internal with params: " + parameters);
            }
            inv.parameters(parameters).execute();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("==> _recover-transactions-internal returned with: " + report.getActionExitCode());
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getString("recover.transactions.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean isServerRunning(String serverName) {
        return "server".equals(serverName) || this.state.getState(serverName) == InstanceState.StateType.RUNNING;
    }
}

