/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jts.admin.cli;

import com.sun.enterprise.transaction.api.ResourceRecoveryManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.jts.admin.cli.RecoverTransactions;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_recover-transactions-internal")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@Cluster(value={RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
public class RecoverTransactionsInternal
implements AdminCommand {
    private static StringManager localStrings = StringManager.getManager(RecoverTransactions.class);
    private static Logger _logger = LogDomains.getLogger(RecoverTransactionsInternal.class, (String)"javax.enterprise.system.core.transaction");
    @Param(name="transactionlogdir", optional=true)
    String transactionLogDir;
    @Param(name="target", optional=false)
    String destinationServer;
    @Param(name="server_name", primary=true)
    String serverToRecover;
    @Inject
    ResourceRecoveryManager recoveryManager;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("==> internal target: " + this.destinationServer + " ... server: " + this.serverToRecover);
        }
        try {
            boolean result = !this.serverToRecover.equals(this.destinationServer) ? this.recoveryManager.recoverIncompleteTx(true, this.transactionLogDir) : this.recoveryManager.recoverIncompleteTx(false, null);
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("==> recovery completed successfuly: " + result);
            }
            if (!result) {
                throw new IllegalStateException();
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, localStrings.getString("recover.transactions.failed"), e);
            report.setMessage(localStrings.getString("recover.transactions.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

