/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResyncThread
extends Thread {
    static Logger _logger = LogDomains.getLogger(ResyncThread.class, (String)"javax.enterprise.system.core.transaction");

    ResyncThread() {
        this.setName("JTS Resync Thread");
        this.setDaemon(true);
    }

    public void run() {
        ResyncThread.yield();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.logp(Level.FINE, "ResyncThread", "run()", "Before invoking RecoveryManager.recover()");
        }
        try {
            if (Configuration.isDBLoggingEnabled()) {
                RecoveryManager.dbXARecovery();
            } else if (RecoveryManager.recover()) {
                RecoveryManager.resync();
            }
            RecoveryManager.resyncComplete(false, false);
        }
        catch (Throwable ex) {
            try {
                RecoveryManager.resyncComplete(false, false);
            }
            catch (Throwable tex) {
                tex.printStackTrace();
            }
            _logger.log(Level.SEVERE, "jts.log_exception_at_recovery", ex);
        }
        if (RecoveryManager.getTransactionRecovery() != null) {
            RecoveryManager.getTransactionRecovery().lowerFence();
        }
    }
}

