/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.recovery;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.transaction.api.RecoveryResourceRegistry;
import com.sun.enterprise.transaction.api.ResourceRecoveryManager;
import com.sun.enterprise.transaction.spi.RecoveryEventListener;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.DefaultTransactionService;
import com.sun.jts.jta.TransactionServiceProperties;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.jvnet.hk2.component.Habitat;

public class GMSCallBack
implements CallBack {
    private static final String component = "TRANSACTION-RECOVERY-SERVICE";
    private static final String TXLOGLOCATION = "TX_LOG_DIR";
    static Logger _logger = LogDomains.getLogger(TransactionServiceProperties.class, (String)"javax.enterprise.system.core.transaction");
    private RecoveryResourceRegistry recoveryListenersRegistry;
    private ResourceRecoveryManager recoveryManager;
    private Servers servers;
    private int waitTime;

    public GMSCallBack(int waitTime, Habitat habitat) {
        GMSAdapter gmsAdapter;
        GMSAdapterService gmsAdapterService = (GMSAdapterService)habitat.getComponent(GMSAdapterService.class);
        if (gmsAdapterService != null && (gmsAdapter = gmsAdapterService.getGMSAdapter()) != null) {
            gmsAdapter.registerFailureRecoveryListener(component, (CallBack)this);
            this.recoveryListenersRegistry = (RecoveryResourceRegistry)habitat.getComponent(RecoveryResourceRegistry.class);
            this.recoveryManager = (ResourceRecoveryManager)habitat.getComponent(ResourceRecoveryManager.class);
            this.servers = (Servers)habitat.getComponent(Servers.class);
            this.waitTime = waitTime;
            Properties props = TransactionServiceProperties.getJTSProperties(habitat, false);
            String instanceName = props.getProperty("com.sun.jts.instancename");
            String logdir = props.getProperty("com.sun.jts.logDirectory");
            if (Configuration.getORB() == null) {
                DefaultTransactionService.setServerName(props);
            }
            GroupManagementService gms = gmsAdapter.getModule();
            try {
                gms.updateMemberDetails(instanceName, (Serializable)((Object)TXLOGLOCATION), (Serializable)((Object)logdir));
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "jts.error_updating_gms", e);
            }
        }
    }

    public void processNotification(Signal signal) {
        if (signal instanceof FailureRecoverySignal) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "[GMSCallBack] failure recovery signal: " + signal);
            }
            try {
                Thread.sleep(this.waitTime * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String instance = signal.getMemberToken();
            if (this.isInstanceRunning(instance)) {
                return;
            }
            String logdir = null;
            Map failedMemberDetails = signal.getMemberDetails();
            if (failedMemberDetails != null) {
                logdir = (String)failedMemberDetails.get(TXLOGLOCATION);
            }
            if (logdir == null) {
                _logger.log(Level.WARNING, "jts.error_getting_member_details", instance);
                return;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Transaction log directory for " + instance + " is " + logdir);
                _logger.log(Level.FINE, "Starting transaction recovery of " + instance);
            }
            Set listeners = this.recoveryListenersRegistry.getEventListeners();
            for (RecoveryEventListener erl : listeners) {
                try {
                    erl.beforeRecovery(instance);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "", e);
                    _logger.log(Level.WARNING, "jts.before_recovery_excep", erl);
                }
            }
            _logger.log(Level.WARNING, "[GMSCallBack] Automatic delegated transaction recovery is not fully supported");
            boolean result = false;
            try {
                result = this.recoveryManager.recoverIncompleteTx(true, logdir);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Transaction recovery of " + instance + " is completed");
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "jts.recovery_error", e);
            }
            for (RecoveryEventListener erl : listeners) {
                try {
                    erl.afterRecovery(result, instance);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "", e);
                    _logger.log(Level.WARNING, "jts.after_recovery_excep", erl);
                }
            }
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[GMSCallBack] ignoring signal: " + signal);
        }
    }

    private boolean isInstanceRunning(String instance) {
        boolean rs = false;
        for (Server server : this.servers.getServer()) {
            if (!instance.equals(server.getName())) continue;
            rs = server.isRunning();
            break;
        }
        return rs;
    }
}

